/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.ui.internal;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyModel;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.bundle.Activator;
import org.eclipse.swt.graphics.Image;

class BundleTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private IBundleDependencyModel model;

    BundleTableLabelProvider(IBundleDependencyModel model) {
        this.setModel(model);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        IBundleDependencyModel model = this.getModel();
        Activator activator = Activator.getDefault();
        String name = (String)element;
        int state = model.getState(name);
        String imageName = "bundle-active";
        if (state == 32) {
            boolean exporter = model.isExportingServices(name);
            boolean importer = model.isImportingServices(name);
            if (exporter && importer) {
                imageName = "bundle-importer-exporter";
            } else if (exporter) {
                imageName = "bundle-exporter";
            } else if (importer) {
                imageName = "bundle-importer";
            }
        } else if (state == 4) {
            imageName = "bundle-resolved";
        } else if (state == 2) {
            imageName = "bundle-installed";
        }
        Image image = activator.getImage(imageName);
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.getText(element);
    }

    private IBundleDependencyModel getModel() {
        return this.model;
    }

    private void setModel(IBundleDependencyModel model) {
        this.model = model;
    }
}

