/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.ui.internal;

import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyPreferences;
import org.eclipse.soda.sat.plugin.dependency.bundle.Activator;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.nls.Messages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BundleDependencyCompositeBuilder {
    private static final String HOST_KEY = "BundleDependencyCompositeBuilder.Host";
    private static final String HOST_TEXT_TOOL_TIP_KEY = "BundleDependencyCompositeBuilder.HostTextToolTip";
    private static final String INVALID_HOST_FIELD_ERROR_KEY = "BundleDependencyCompositeBuilder.InvalidHostField";
    private static final String INVALID_POLL_FREQUENCY_ERROR_KEY = "BundleDependencyCompositeBuilder.InvalidPollFrequencyField";
    private static final String INVALID_PORT_FIELD_ERROR_KEY = "BundleDependencyCompositeBuilder.InvalidPortField";
    private static final String INVALID_SERVLET_ALIAS_FIELD_ERROR_KEY = "BundleDependencyCompositeBuilder.InvalidServletAliasField";
    private static final String POLL_FREQUENCY_KEY = "BundleDependencyCompositeBuilder.PollFrequency";
    private static final String POLL_FREQUENCY_TEXT_TOOL_TIP_KEY = "BundleDependencyCompositeBuilder.PollFrequencyTextToolTip";
    private static final String PORT_KEY = "BundleDependencyCompositeBuilder.Port";
    private static final String PORT_TEXT_TOOL_TIP_KEY = "BundleDependencyCompositeBuilder.PortTextToolTip";
    private static final String SERVLET_ALIAS_KEY = "BundleDependencyCompositeBuilder.ServletAlias";
    private static final String SERVLET_ALIAS_TEXT_TOOL_TIP_KEY = "BundleDependencyCompositeBuilder.ServletAliasTextToolTip";
    private static final char COLON_CHARACTER = ':';
    private String errorMessage;
    private Text hostText;
    private Text pollFrequencyText;
    private Text portText;
    private Text servletAliasText;

    public void addModifyListener(ModifyListener listener) {
        Text text = this.getHostText();
        text.addModifyListener(listener);
        text = this.getServletAliasText();
        text.addModifyListener(listener);
        text = this.getPollFrequencyText();
        text.addModifyListener(listener);
        text = this.getPortText();
        text.addModifyListener(listener);
    }

    public Composite build(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.buildHostControls(composite);
        this.buildPortControls(composite);
        this.buildServletAliasControls(composite);
        this.buildPollFrequencyControls(composite);
        return composite;
    }

    private void buildHostControls(Composite parent) {
        String value = String.valueOf(Messages.getString(HOST_KEY)) + ':';
        this.buildLabel(parent, value);
        String toolTip = Messages.getString(HOST_TEXT_TOOL_TIP_KEY);
        Text text = this.buildText(parent, 0, toolTip);
        this.setHostText(text);
    }

    private void buildLabel(Composite parent, String value) {
        Label label = new Label(parent, 16384);
        label.setText(value);
    }

    private void buildPollFrequencyControls(Composite parent) {
        String value = String.valueOf(Messages.getString(POLL_FREQUENCY_KEY)) + ':';
        this.buildLabel(parent, value);
        String toolTip = Messages.getString(POLL_FREQUENCY_TEXT_TOOL_TIP_KEY);
        Text text = this.buildText(parent, 3, toolTip);
        this.setPollFrequencyText(text);
    }

    private void buildPortControls(Composite parent) {
        String value = String.valueOf(Messages.getString(PORT_KEY)) + ':';
        this.buildLabel(parent, value);
        String toolTip = Messages.getString(PORT_TEXT_TOOL_TIP_KEY);
        Text text = this.buildText(parent, 5, toolTip);
        this.setPortText(text);
    }

    private void buildServletAliasControls(Composite parent) {
        String value = String.valueOf(Messages.getString(SERVLET_ALIAS_KEY)) + ':';
        this.buildLabel(parent, value);
        String toolTip = Messages.getString(SERVLET_ALIAS_TEXT_TOOL_TIP_KEY);
        Text text = this.buildText(parent, 0, toolTip);
        this.setServletAliasText(text);
        KeyListener listener = this.createNoWhitespaceKeyListener();
        text.addKeyListener(listener);
    }

    private Text buildText(Composite parent, int size, String toolTip) {
        Text text = new Text(parent, 2048);
        int limit = size > 0 ? size : Text.LIMIT;
        text.setTextLimit(limit);
        text.setToolTipText(toolTip);
        KeyListener listener = this.createNoWhitespaceKeyListener();
        text.addKeyListener(listener);
        GridData data = new GridData(768);
        text.setLayoutData((Object)data);
        return text;
    }

    private KeyListener createNoWhitespaceKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean valid;
                char ch = e.character;
                e.doit = valid = ch != ' ';
            }
        };
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getHost() {
        Text text = this.getHostText();
        String value = text.getText();
        return value;
    }

    private Text getHostText() {
        return this.hostText;
    }

    public String getPollFrequency() {
        Text text = this.getPollFrequencyText();
        String pollFrequency = text.getText();
        return pollFrequency;
    }

    private Text getPollFrequencyText() {
        return this.pollFrequencyText;
    }

    public String getPort() {
        Text text = this.getPortText();
        String value = text.getText();
        return value;
    }

    private Text getPortText() {
        return this.portText;
    }

    private IBundleDependencyPreferences getPreferences() {
        Activator activator = Activator.getDefault();
        IBundleDependencyPreferences preferences = activator.getPreferences();
        return preferences;
    }

    public String getServletAlias() {
        Text text = this.getServletAliasText();
        String value = text.getText();
        return value;
    }

    private Text getServletAliasText() {
        return this.servletAliasText;
    }

    public boolean isValid() {
        String message = null;
        boolean valid = true;
        valid = valid && this.isValidHost();
        valid = valid && this.isValidPort();
        valid = valid && this.isValidServletAlias();
        boolean bl = valid = valid && this.isValidPollFrequency();
        if (!valid) {
            message = this.getErrorMessage();
        }
        this.setErrorMessage(message);
        return valid;
    }

    private boolean isValidHost() {
        Text text = this.getHostText();
        String value = text.getText();
        IBundleDependencyPreferences preferences = this.getPreferences();
        boolean valid = preferences.isValidHost(value);
        if (!valid) {
            String message = Messages.getString(INVALID_HOST_FIELD_ERROR_KEY);
            this.setErrorMessage(message);
        }
        return valid;
    }

    private boolean isValidPollFrequency() {
        Text text = this.getPollFrequencyText();
        String value = text.getText();
        IBundleDependencyPreferences preferences = this.getPreferences();
        boolean valid = preferences.isValidPollFrequency(value);
        if (!valid) {
            String message = Messages.getString(INVALID_POLL_FREQUENCY_ERROR_KEY);
            this.setErrorMessage(message);
        }
        return valid;
    }

    private boolean isValidPort() {
        Text text = this.getPortText();
        String value = text.getText();
        IBundleDependencyPreferences preferences = this.getPreferences();
        boolean valid = preferences.isValidPort(value);
        if (!valid) {
            String message = Messages.getString(INVALID_PORT_FIELD_ERROR_KEY);
            this.setErrorMessage(message);
        }
        return valid;
    }

    private boolean isValidServletAlias() {
        Text text = this.getServletAliasText();
        String value = text.getText();
        IBundleDependencyPreferences preferences = this.getPreferences();
        boolean valid = preferences.isValidServletAlias(value);
        if (!valid) {
            String message = Messages.getString(INVALID_SERVLET_ALIAS_FIELD_ERROR_KEY);
            this.setErrorMessage(message);
        }
        return valid;
    }

    public void removeModifyListener(ModifyListener listener) {
        Text text = this.getHostText();
        text.removeModifyListener(listener);
        text = this.getPortText();
        text.removeModifyListener(listener);
        text = this.getServletAliasText();
        text.removeModifyListener(listener);
        text = this.getPollFrequencyText();
        text.removeModifyListener(listener);
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setHost(String host) {
        Text text = this.getHostText();
        this.setText(text, host);
    }

    private void setHostText(Text hostText) {
        this.hostText = hostText;
    }

    public void setPollFrequency(String pollFrequency) {
        Text text = this.getPollFrequencyText();
        this.setText(text, pollFrequency);
    }

    private void setPollFrequencyText(Text pollFrequencyText) {
        this.pollFrequencyText = pollFrequencyText;
    }

    public void setPort(String port) {
        Text text = this.getPortText();
        this.setText(text, port);
    }

    private void setPortText(Text portText) {
        this.portText = portText;
    }

    public void setServletAlias(String servletAlias) {
        Text text = this.getServletAliasText();
        this.setText(text, servletAlias);
    }

    private void setServletAliasText(Text servletAliasText) {
        this.servletAliasText = servletAliasText;
    }

    private void setText(Text text, String value) {
        text.setText(value);
        int end = text.getCharCount();
        text.setSelection(end);
    }
}

