/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.soda.sat.plugin.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.IHandyDialog;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

abstract class HandyDialog
extends Dialog
implements IHandyDialog {
    protected static final String HELP_KEY = "Common.Help";
    private String title;
    private String helpContextId;
    private Point size;

    protected HandyDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.configureShellTitle(shell);
    }

    private void configureShellTitle(Shell shell) {
        String title = this.getTitle();
        if (title == null) {
            return;
        }
        shell.setText(title);
    }

    protected abstract void createArea(Composite var1);

    protected final Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.hookHelpToComposite(composite);
        this.createArea(composite);
        this.postCreateArea(composite);
        return composite;
    }

    protected final Button createHelpButtonForButtonBar(Composite parent) {
        boolean valid;
        boolean bl = valid = this.getHelpSystem() != null;
        if (!valid) {
            return null;
        }
        String id = this.getHelpContextId();
        if (id == null) {
            return null;
        }
        String label = Messages.getString(HELP_KEY);
        Button button = this.createButton(parent, 17, label, false);
        return button;
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        Display display = shell != null ? shell.getDisplay() : Display.getDefault();
        return display;
    }

    private String getHelpContextId() {
        return this.helpContextId;
    }

    private IWorkbenchHelpSystem getHelpSystem() {
        UiUtility utility = UiUtility.getInstance();
        IWorkbenchHelpSystem helpSystem = utility.getHelpSystem();
        return helpSystem;
    }

    protected Point getInitialSize() {
        Point initialSize;
        Point result = initialSize = super.getInitialSize();
        Point size = this.getSize();
        if (size != null) {
            if (size.x >= initialSize.x) {
                result.x = size.x;
            }
            if (size.y >= initialSize.y) {
                result.y = size.y;
            }
        }
        return result;
    }

    private Point getSize() {
        return this.size;
    }

    protected final Image getSystemImage(int id) {
        Display display = this.getDisplay();
        Image image = display.getSystemImage(id);
        return image;
    }

    private String getTitle() {
        return this.title;
    }

    protected final void helpPressed() {
        String id = this.getHelpContextId();
        IWorkbenchHelpSystem helpSystem = this.getHelpSystem();
        if (helpSystem == null) {
            return;
        }
        helpSystem.displayHelp(id);
    }

    private void hookHelpToComposite(Composite parent) {
        String id = this.getHelpContextId();
        if (id == null) {
            return;
        }
        IWorkbenchHelpSystem helpSystem = this.getHelpSystem();
        if (helpSystem == null) {
            return;
        }
        helpSystem.setHelp((Control)parent, id);
    }

    protected void postCreateArea(Composite composite) {
        Dialog.applyDialogFont((Control)composite);
    }

    public void setHelpContextId(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    public void setSize(int width, int height) {
        Point point = new Point(width, height);
        this.setSize(point);
    }

    private void setSize(Point size) {
        this.size = size;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

