/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.soda.sat.plugin.ui.internal.HandyDialog;
import org.eclipse.soda.sat.plugin.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.IHandyPromptDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HandyPromptDialog
extends HandyDialog
implements IHandyPromptDialog {
    private static final String PROMPT_KEY = "HandyPromptDialog.Prompt";
    private static final String UNKNOWN_BUTTON_ID_KEY = "HandyPromptDialog.UnknownButtonId";
    private String cancelButtonText;
    private List checkboxButtons;
    private String checkboxGroupText;
    private int defaultButtonId;
    private Image image;
    private String noButtonText;
    private String prompt;
    private List radioButtons;
    private String radioButtonGroupText;
    private String yesButtonText;

    public HandyPromptDialog(Shell parentShell, String prompt) {
        super(parentShell);
        this.setTitle(Messages.getString(PROMPT_KEY));
        this.setPrompt(prompt);
        this.initializeCheckboxButtons();
        this.initializeRadioButtons();
        this.initializePushButtons();
        this.defaultButtonIsCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addButton(List list, String text, boolean selected) {
        List list2 = list;
        synchronized (list2) {
            int size = list.size();
            ButtonDetails details = new ButtonDetails();
            details.text = text;
            details.selected = selected;
            list.add(details);
            return size;
        }
    }

    public int addCheckbox(String text, boolean selected) {
        List list = this.getCheckboxButtons();
        int id = this.addButton(list, text, selected);
        return id;
    }

    public int addRadioButton(String text, boolean selected) {
        List list = this.getRadioButtons();
        int id = this.addButton(list, text, selected);
        return id;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buttonPressed(int buttonId) {
        if (17 == buttonId) {
            this.helpPressed();
            return;
        }
        try {
            this.updateButtonSelections();
            this.setReturnCode(buttonId);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.close();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.close();
    }

    private void checkButtonId(List list, int id) {
        int size = list.size();
        if (id < size) {
            return;
        }
        String pattern = Messages.getString(UNKNOWN_BUTTON_ID_KEY);
        Object[] values = new Object[]{new Integer(id)};
        String message = MessageFormat.format(pattern, values);
        throw new IllegalArgumentException(message);
    }

    private void confirmDefaultButtonId() {
        int defaultButtonId = this.getDefaultButtonId();
        if (defaultButtonId != 1) {
            return;
        }
        String cancelButtonText = this.getCancelButtonText();
        if (cancelButtonText != null) {
            return;
        }
        if (defaultButtonId == 1) {
            if (this.getNoButtonText() != null) {
                defaultButtonId = 3;
            } else if (this.getYesButtonText() != null) {
                defaultButtonId = 2;
            }
            this.setDefaultButtonId(defaultButtonId);
        }
    }

    protected void createArea(Composite composite) {
        this.createPromptControls(composite);
    }

    private Button createButton(Composite parent, int id, String label) {
        int defaultButtonId = this.getDefaultButtonId();
        boolean isDefault = defaultButtonId == id;
        Button button = this.createButton(parent, id, label, isDefault);
        return button;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createButtons(List list, Composite parent, boolean grabExcessSpace, String groupText, int style) {
        List list2 = list;
        synchronized (list2) {
            Composite composite;
            boolean empty = list.isEmpty();
            if (empty) {
                return;
            }
            RowLayout layout = new RowLayout(512);
            if (groupText == null) {
                composite = new Composite(parent, 0);
                layout.marginLeft = 0;
                layout.marginRight = 0;
                layout.marginTop = 0;
                layout.marginBottom = 0;
            } else {
                Group group = new Group(parent, 0);
                group.setText(groupText);
                composite = group;
            }
            composite.setLayout((Layout)layout);
            int alignment = grabExcessSpace ? 4 : 1;
            GridData data = new GridData(alignment, alignment, grabExcessSpace, grabExcessSpace);
            composite.setLayoutData((Object)data);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ButtonDetails details = (ButtonDetails)iterator.next();
                Button button = new Button(composite, style);
                button.setText(details.text);
                button.setSelection(details.selected);
                details.button = button;
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.confirmDefaultButtonId();
        this.createYesButtonForButtonBar(parent);
        this.createNoButtonForButtonBar(parent);
        this.createCancelButtonForButtonBar(parent);
        this.createHelpButtonForButtonBar(parent);
    }

    private Button createCancelButtonForButtonBar(Composite parent) {
        String label = this.getCancelButtonText();
        if (label == null) {
            return null;
        }
        int id = 1;
        Button button = this.createButton(parent, id, label);
        return button;
    }

    private Button createNoButtonForButtonBar(Composite parent) {
        String label = this.getNoButtonText();
        if (label == null) {
            return null;
        }
        int id = 3;
        Button button = this.createButton(parent, id, label);
        return button;
    }

    private void createPromptButtonControls(Composite parent) {
        String groupText;
        List radioButtons;
        boolean hasRadioButtons;
        boolean hasCheckboxButtons;
        int columns = 0;
        List checkboxButtons = this.getCheckboxButtons();
        boolean bl = hasCheckboxButtons = !checkboxButtons.isEmpty();
        if (hasCheckboxButtons) {
            ++columns;
        }
        boolean bl2 = hasRadioButtons = !(radioButtons = this.getRadioButtons()).isEmpty();
        if (hasRadioButtons) {
            ++columns;
        }
        if (columns == 0) {
            return;
        }
        Composite composite = this.createPromptButtonControlsComposite(parent, columns);
        if (hasCheckboxButtons) {
            groupText = this.getCheckboxGroupText();
            this.createButtons(checkboxButtons, composite, hasRadioButtons, groupText, 32);
        }
        if (hasRadioButtons) {
            groupText = this.getRadioButtonGroupText();
            this.createButtons(radioButtons, composite, hasCheckboxButtons, groupText, 16);
        }
    }

    private Composite createPromptButtonControlsComposite(Composite parent, int columns) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 20;
        layout.marginHeight = 0;
        if (columns > 1) {
            layout.horizontalSpacing = 10;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createPromptControls(Composite parent) {
        this.createPromptLabelControls(parent);
        this.createPromptButtonControls(parent);
    }

    private void createPromptLabelControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        Label icon = new Label(composite, 16384);
        Image image = this.getImage();
        icon.setImage(image);
        Label label = new Label(composite, 64);
        String prompt = this.getPrompt();
        label.setText(prompt);
        data = new GridData(4, 0x1000000, true, true);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
    }

    private Button createYesButtonForButtonBar(Composite parent) {
        String label = this.getYesButtonText();
        if (label == null) {
            return null;
        }
        int id = 2;
        Button button = this.createButton(parent, id, label);
        return button;
    }

    public void defaultButtonIsCancel() {
        this.setDefaultButtonId(1);
    }

    public void defaultButtonIsNo() {
        this.setDefaultButtonId(3);
    }

    public void defaultButtonIsYes() {
        this.setDefaultButtonId(2);
    }

    private ButtonDetails getButtonDetails(List list, int id) {
        this.checkButtonId(list, id);
        ButtonDetails details = (ButtonDetails)list.get(id);
        return details;
    }

    private String getCancelButtonText() {
        return this.cancelButtonText;
    }

    private ButtonDetails getCheckboxButtonDetails(int id) {
        List list = this.getCheckboxButtons();
        ButtonDetails details = this.getButtonDetails(list, id);
        return details;
    }

    private List getCheckboxButtons() {
        return this.checkboxButtons;
    }

    private String getCheckboxGroupText() {
        return this.checkboxGroupText;
    }

    private int getDefaultButtonId() {
        return this.defaultButtonId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImage() {
        HandyPromptDialog handyPromptDialog = this;
        synchronized (handyPromptDialog) {
            if (this.image == null) {
                this.useInformationIcon();
            }
        }
        return this.image;
    }

    private String getNoButtonText() {
        return this.noButtonText;
    }

    private String getPrompt() {
        return this.prompt;
    }

    private ButtonDetails getRadioButtonDetails(int id) {
        List list = this.getRadioButtons();
        ButtonDetails details = this.getButtonDetails(list, id);
        return details;
    }

    private String getRadioButtonGroupText() {
        return this.radioButtonGroupText;
    }

    private List getRadioButtons() {
        return this.radioButtons;
    }

    private String getYesButtonText() {
        return this.yesButtonText;
    }

    private void initializeCheckboxButtons() {
        this.setCheckboxButtons(new ArrayList(3));
    }

    private void initializePushButtons() {
        this.setYesButtonText(IDialogConstants.YES_LABEL);
        this.setNoButtonText(IDialogConstants.NO_LABEL);
        this.setCancelButtonText(String.valueOf('&') + IDialogConstants.CANCEL_LABEL);
    }

    private void initializeRadioButtons() {
        this.setRadioButtons(new ArrayList(3));
    }

    public boolean isCheckboxSelected(int id) {
        ButtonDetails details = this.getCheckboxButtonDetails(id);
        return details.selected;
    }

    public boolean isRadioButtonSelected(int id) {
        ButtonDetails details = this.getRadioButtonDetails(id);
        return details.selected;
    }

    public void removeAllCheckboxes() {
        this.initializeCheckboxButtons();
    }

    public void removeAllRadioButtons() {
        this.initializeRadioButtons();
    }

    public void setCancelButtonText(String cancelButtonText) {
        this.cancelButtonText = cancelButtonText;
    }

    private void setCheckboxButtons(List checkboxButtons) {
        this.checkboxButtons = checkboxButtons;
    }

    public void setCheckboxGroupText(String checkboxGroupText) {
        this.checkboxGroupText = checkboxGroupText;
    }

    public void setCheckboxSelected(int id, boolean selected) {
        ButtonDetails details = this.getCheckboxButtonDetails(id);
        details.selected = selected;
    }

    private void setDefaultButtonId(int defaultButtonId) {
        this.defaultButtonId = defaultButtonId;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    private void setImage(int id) {
        Image image = this.getSystemImage(id);
        this.setImage(image);
    }

    public void setNoButtonText(String noButtonText) {
        this.noButtonText = noButtonText;
    }

    private void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setRadioButtonGroupText(String radioButtonGroupText) {
        this.radioButtonGroupText = radioButtonGroupText;
    }

    private void setRadioButtons(List radioButtons) {
        this.radioButtons = radioButtons;
    }

    public void setRadioButtonSelected(int id, boolean selected) {
        ButtonDetails details = this.getRadioButtonDetails(id);
        details.selected = selected;
    }

    public void setYesButtonText(String yesButtonText) {
        this.yesButtonText = yesButtonText;
    }

    private void updateButtonSelections() {
        this.updateCheckboxButtonSelections();
        this.updateRadioButtonSelections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtonSelections(List list) {
        List list2 = list;
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ButtonDetails details = (ButtonDetails)iterator.next();
                details.selected = details.button.getSelection();
            }
        }
    }

    private void updateCheckboxButtonSelections() {
        List list = this.getCheckboxButtons();
        this.updateButtonSelections(list);
    }

    private void updateRadioButtonSelections() {
        List list = this.getRadioButtons();
        this.updateButtonSelections(list);
    }

    public void useErrorIcon() {
        this.setImage(1);
    }

    public void useInformationIcon() {
        this.setImage(2);
    }

    public void useQuestionIcon() {
        this.setImage(4);
    }

    public void useWarningIcon() {
        this.setImage(8);
    }

    private static class ButtonDetails {
        private Button button;
        private boolean selected;
        private String text;

        private ButtonDetails() {
        }
    }
}

