/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.internal;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.soda.sat.plugin.AboutExtension;
import org.eclipse.soda.sat.plugin.ui.internal.AboutDataTableLabelProvider;
import org.eclipse.soda.sat.plugin.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class SatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ABOUT_TAB = "SatPreferencePage.AboutTab";
    private static final String ABOUT_TAB_DATE = "SatPreferencePage.AboutTab.Date";
    private static final String ABOUT_TAB_DESCRIPTION = "SatPreferencePage.AboutTab.Description";
    private static final String ABOUT_TAB_TITLE = "SatPreferencePage.AboutTab.Title";
    private static final String DESCRIPTION = "SatPreferencePage.Description";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.ui.preferences";
    private static final String PLUGINS_TAB = "SatPreferencePage.PluginsTab";
    private static final String PLUGINS_TAB_DESCRIPTION = "SatPreferencePage.PluginsTab.Description";
    private static final String PLUGINS_TAB_TABLE_COLUMN_ID = "SatPreferencePage.PluginsTab.Table.Column.Id";
    private static final String PLUGINS_TAB_TABLE_COLUMN_NAME = "SatPreferencePage.PluginsTab.Table.Column.Name";
    private static final String PLUGINS_TAB_TABLE_COLUMN_PROVIDER = "SatPreferencePage.PluginsTab.Table.Column.Provider";
    private static final String PLUGINS_TAB_TABLE_COLUMN_VERSION = "SatPreferencePage.PluginsTab.Table.Column.Version";
    private static final String PLUGINS_TAB_TEXT_DESCRIPTION = "SatPreferencePage.PluginsTab.Text.Description";
    private static final String SAT_ICON = "sat";
    private Color backgroundColor;
    private Text descriptionText;

    public SatPreferencePage() {
        String description = String.valueOf(Messages.getString(DESCRIPTION)) + ':';
        this.setDescription(description);
    }

    private void addDescriptionText(Composite parent) {
        int style = 72;
        Text text = new Text(parent, style);
        String description = Messages.getString(ABOUT_TAB_DESCRIPTION);
        text.setText(description);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        text.setLayoutData((Object)gridData);
    }

    private Label addLabel(Composite parent, String value) {
        Label label = new Label(parent, 0);
        label.setText(value);
        return label;
    }

    private void addPluginDescription(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.addSeparator(composite);
        Label label = new Label(composite, 0);
        String description = String.valueOf(Messages.getString(PLUGINS_TAB_TEXT_DESCRIPTION)) + ':';
        label.setText(description);
        int style = 2634;
        Text text = new Text(composite, style);
        GridData data = new GridData(1808);
        text.setLayoutData((Object)data);
        Color color = this.getBackgroundColor();
        text.setBackground(color);
        this.setDescriptionText(text);
    }

    private void addPluginDetailsComposite(Composite parent) {
        SashForm composite = new SashForm(parent, 512);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.addPluginTable((Composite)composite);
        this.addPluginDescription((Composite)composite);
        int[] weights = new int[]{75, 25};
        composite.setWeights(weights);
    }

    private void addPluginTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        int style = 67588;
        TableViewer viewer = new TableViewer(composite, style);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        String text = Messages.getString(PLUGINS_TAB_TABLE_COLUMN_NAME);
        column.setText(text);
        column = new TableColumn(table, 0);
        text = Messages.getString(PLUGINS_TAB_TABLE_COLUMN_PROVIDER);
        column.setText(text);
        column = new TableColumn(table, 0);
        text = Messages.getString(PLUGINS_TAB_TABLE_COLUMN_VERSION);
        column.setText(text);
        column = new TableColumn(table, 0);
        text = Messages.getString(PLUGINS_TAB_TABLE_COLUMN_ID);
        column.setText(text);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        viewer.setLabelProvider((IBaseLabelProvider)new AboutDataTableLabelProvider());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        AboutExtension[] extensions = this.getAboutExtensions();
        Comparator comparator = this.createAboutExtensionComparator();
        Arrays.sort(extensions, comparator);
        viewer.setInput((Object)extensions);
        ControlListener listener = this.createTableControlListener(table);
        composite.addControlListener(listener);
        ISelectionChangedListener selectionChangedListener = this.createTableViewerSelectionChangedListener();
        viewer.addSelectionChangedListener(selectionChangedListener);
        Color color = table.getBackground();
        this.setBackgroundColor(color);
        this.packTable(table);
    }

    private void addPluginTitle(Composite parent) {
        Label label = new Label(parent, 64);
        String title = String.valueOf(Messages.getString(PLUGINS_TAB_DESCRIPTION)) + ':';
        label.setText(title);
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 266);
        GridData data = new GridData(768);
        separator.setLayoutData((Object)data);
    }

    private void addTitleComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        Image image = this.getImage(composite, SAT_ICON);
        label.setImage(image);
        String title = this.getTabTitle();
        this.addLabel(composite, title);
    }

    private int calculateRemainingHorizontalSpace(Table table) {
        Composite parent = table.getParent();
        Rectangle area = parent.getClientArea();
        int width = area.width;
        int tableBorderWidth = table.getBorderWidth();
        width -= tableBorderWidth * 2;
        GridLayout layout = (GridLayout)parent.getLayout();
        width -= layout.marginWidth * 2;
        Rectangle bounds = table.getBounds();
        if (bounds.height > area.height) {
            ScrollBar scrollbar = table.getVerticalBar();
            Point scrollbarSize = scrollbar.getSize();
            width -= scrollbarSize.x;
        }
        TableColumn[] columns = table.getColumns();
        int count = columns.length;
        int cumulative = 0;
        int i = 0;
        while (i < count - 1) {
            TableColumn column = columns[i];
            int columnWidth = column.getWidth();
            cumulative += columnWidth;
            ++i;
        }
        int remainder = width - cumulative;
        return remainder;
    }

    private Control createAboutControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.addTitleComposite(composite);
        this.addDescriptionText(composite);
        return composite;
    }

    private Comparator createAboutExtensionComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                AboutExtension left = (AboutExtension)o1;
                String leftName = left.getPluginName();
                AboutExtension right = (AboutExtension)o2;
                String rightName = right.getPluginName();
                int compare = leftName.compareTo(rightName);
                return compare;
            }
        };
    }

    private void createAboutTab(TabFolder folder) {
        Control control = this.createAboutControl((Composite)folder);
        String label = Messages.getString(ABOUT_TAB);
        this.createTabItem(folder, label, control);
    }

    protected Control createContents(Composite parent) {
        UiUtility utility = UiUtility.getInstance();
        utility.setHelp((Control)parent, HELP_CONTEXT_ID);
        this.noDefaultAndApplyButton();
        TabFolder folder = new TabFolder(parent, 0);
        this.createAboutTab(folder);
        this.createPluginTab(folder);
        Dialog.applyDialogFont((Control)parent);
        return folder;
    }

    private Control createPluginControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        this.addPluginTitle(composite);
        this.addPluginDetailsComposite(composite);
        return composite;
    }

    private void createPluginTab(TabFolder folder) {
        Control control = this.createPluginControl((Composite)folder);
        String label = Messages.getString(PLUGINS_TAB);
        this.createTabItem(folder, label, control);
    }

    private void createTabItem(TabFolder folder, String text, Control control) {
        TabItem item = new TabItem(folder, 0);
        item.setText(text);
        item.setControl(control);
    }

    private ControlListener createTableControlListener(final Table table) {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                SatPreferencePage.this.handleTableResized(table);
            }
        };
    }

    private ISelectionChangedListener createTableViewerSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SatPreferencePage.this.handleTableViewerSelectionChanged(event);
            }
        };
    }

    private AboutExtension[] getAboutExtensions() {
        org.eclipse.soda.sat.plugin.bundle.Activator activator = org.eclipse.soda.sat.plugin.bundle.Activator.getDefault();
        AboutExtension[] extensions = activator.getAboutExtensions();
        return extensions;
    }

    private Color getBackgroundColor() {
        return this.backgroundColor;
    }

    private String getBundleVersion() {
        Activator activator = Activator.getDefault();
        Bundle bundle = activator.getBundle();
        Dictionary headers = bundle.getHeaders();
        String value = (String)headers.get("Bundle-Version");
        return value;
    }

    private Text getDescriptionText() {
        return this.descriptionText;
    }

    private Image getImage(Composite parent, String filename) {
        Activator activator = Activator.getDefault();
        Image image = activator.getImage(filename);
        return image;
    }

    private String getTabTitle() {
        StringBuffer buffer = new StringBuffer(25);
        String title = Messages.getString(ABOUT_TAB_TITLE);
        buffer.append(title);
        String value = this.getBundleVersion();
        int index = value.lastIndexOf(46);
        if (index != -1) {
            int qualifierLength;
            buffer.append(' ');
            String version = value.substring(0, index);
            buffer.append(version);
            String qualifier = value.substring(index + 1);
            if ("qualifier".equals(qualifier)) {
                qualifier = "200701220130";
            }
            if ((qualifierLength = qualifier.length()) == 12) {
                String year = qualifier.substring(0, 4);
                String month = qualifier.substring(4, 6);
                String day = qualifier.substring(6, 8);
                String pattern = Messages.getString(ABOUT_TAB_DATE);
                Object[] values = new Object[]{year, month, day};
                String date = MessageFormat.format(pattern, values);
                buffer.append(date);
            }
        }
        String result = buffer.toString();
        return result;
    }

    private void handleTableResized(Table table) {
        int width = this.calculateRemainingHorizontalSpace(table);
        TableColumn[] columns = table.getColumns();
        int count = columns.length;
        TableColumn column = columns[count - 1];
        column = columns[count - 1];
        column.setWidth(width);
    }

    private void handleTableViewerSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object item = structuredSelection.getFirstElement();
        AboutExtension data = (AboutExtension)item;
        String description = data.getDescription();
        if (description == null) {
            return;
        }
        Text text = this.getDescriptionText();
        text.setText(description);
    }

    public void init(IWorkbench workbench) {
    }

    private void packTable(Table table) {
        Dialog.applyDialogFont((Control)table);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length - 1) {
            TableColumn column = columns[i];
            column.pack();
            ++i;
        }
    }

    public boolean performOk() {
        return true;
    }

    private void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    private void setDescriptionText(Text descriptionText) {
        this.descriptionText = descriptionText;
    }
}

