/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.internal.bundle;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.sat.plugin.AboutExtension;
import org.eclipse.soda.sat.plugin.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IImageManager;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator INSTANCE;
    private static final String FAILED_TO_CREATE_URL_KEY = "Activator.Failed_to_create_URL";
    private static final String SAT_IMAGE = "sat";
    private static final String PLUGIN_IMAGE = "plugin";
    private static final String IMAGE_EXTENSION = ".gif";
    private static final String ICONS = "resources/icons/";
    private IImageManager imageManager;

    public static Activator getDefault() {
        return INSTANCE;
    }

    public Activator() {
        INSTANCE = this;
    }

    private IImageManager basicGetImageManager() {
        return this.imageManager;
    }

    private IImageManager createImageManager() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IImageManager imageManager = utility.createImageManager(101);
        return imageManager;
    }

    private void disposeAboutExtension(AboutExtension extension) {
        Image image = (Image)extension.getImage();
        this.disposeImage(image);
    }

    private void disposeAboutExtensions() {
        org.eclipse.soda.sat.plugin.bundle.Activator activator = org.eclipse.soda.sat.plugin.bundle.Activator.getDefault();
        AboutExtension[] extensions = activator.getAboutExtensions();
        int i = 0;
        while (i < extensions.length) {
            AboutExtension data = extensions[i];
            this.disposeAboutExtension(data);
            ++i;
        }
    }

    private void disposeImage(Image image) {
        if (image == null) {
            return;
        }
        if (image.isDisposed()) {
            return;
        }
        image.dispose();
    }

    private void disposeImageManager() {
        IImageManager imageManager = this.basicGetImageManager();
        if (imageManager == null) {
            return;
        }
        imageManager.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name) {
        Activator activator = this;
        synchronized (activator) {
            IImageManager imageManager = this.getImageManager();
            Image image = imageManager.getImage(name);
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDescriptor getImageDescriptor(String name) {
        Activator activator = this;
        synchronized (activator) {
            IImageManager imageManager = this.getImageManager();
            ImageDescriptor descriptor = imageManager.getImageDescriptor(name);
            return descriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImageManager getImageManager() {
        Activator activator = this;
        synchronized (activator) {
            IImageManager manager = this.basicGetImageManager();
            if (manager == null) {
                this.initializeImageManager();
            }
        }
        return this.imageManager;
    }

    private URL getInstallUrl() {
        Bundle bundle = this.getBundle();
        URL url = bundle.getEntry("/");
        return url;
    }

    public Image getPluginImage() {
        Image image = this.getImage(PLUGIN_IMAGE);
        return image;
    }

    private String getSymbolicName() {
        Bundle bundle = this.getBundle();
        String id = bundle.getSymbolicName();
        return id;
    }

    private void initializeImageManager() {
        IImageManager manager = this.createImageManager();
        this.setImageManager(manager);
        this.populateImageManager();
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable throwable) {
        String id = this.getSymbolicName();
        Status status = new Status(severity, id, 0, message, throwable);
        ILog log = this.getLog();
        log.log((IStatus)status);
    }

    private void populateImageManager() {
        IImageManager imageManager = this.getImageManager();
        URL installUrl = this.getInstallUrl();
        try {
            imageManager.add(PLUGIN_IMAGE, new URL(installUrl, "resources/icons/plugin.gif"));
            imageManager.add(SAT_IMAGE, new URL(installUrl, "resources/icons/sat.gif"));
        }
        catch (MalformedURLException exception) {
            String message = Messages.getString(FAILED_TO_CREATE_URL_KEY);
            this.log(4, message, exception);
        }
    }

    private void setImageManager(IImageManager imageManager) {
        this.imageManager = imageManager;
    }

    public void stop(BundleContext context) throws Exception {
        this.disposeAboutExtensions();
        this.disposeImageManager();
        super.stop(context);
    }
}

