/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.util;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.soda.sat.plugin.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.ui.internal.nls.Messages;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.FileEditorInput;

public class UiUtility {
    private static final String FAILED_TO_OPEN_URL_KEY = "UiUtility.FailedToOpenUrl";
    private static final String ERROR_KEY = "UiUtility.Error";
    private static final String WEB_BROWSER_CAN_NOT_BE_FOUND = "UiUtility.WebBrowserCanNotBeFound";
    private static final UiUtility INSTANCE = new UiUtility();

    public static UiUtility getInstance() {
        return INSTANCE;
    }

    private UiUtility() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyToClipboard(String text) {
        Display display = Display.getCurrent();
        Clipboard clipboard = new Clipboard(display);
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{text};
        Transfer[] transfers = new Transfer[]{textTransfer};
        try {
            try {
                clipboard.setContents(data, transfers);
            }
            catch (SWTError sWTError) {}
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            clipboard.dispose();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        clipboard.dispose();
    }

    public void copyToClipboard(String[] items) {
        int size = items.length;
        StringBuffer buffer = new StringBuffer(size * 20);
        String lineSeparator = System.getProperty("line.separator");
        int i = 0;
        while (i < size) {
            String item = items[i];
            buffer.append(item);
            buffer.append(lineSeparator);
            ++i;
        }
        String text = buffer.toString();
        this.copyToClipboard(text);
    }

    public IViewPart findView(String id) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        IViewPart view = workbenchPage.findView(id);
        return view;
    }

    private IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        IWorkbenchPage page = null;
        int i = 0;
        while (page == null && i < windows.length) {
            IWorkbenchWindow window = windows[i];
            page = window.getActivePage();
            ++i;
        }
        return page;
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = this.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window;
    }

    public Color getBackgroundColor() {
        Color color = this.getSystemColor(25);
        return color;
    }

    private Control getControlWithFocus(Composite parent) {
        Control result = null;
        Control[] children = parent.getChildren();
        int length = children.length;
        int index = 0;
        while (result == null && index < length) {
            result = children[index];
            result = this.getControlWithFocus(result);
            ++index;
        }
        return result;
    }

    public Control getControlWithFocus(Control parent) {
        Control result;
        boolean focus = parent.isFocusControl();
        Object object = result = focus ? parent : null;
        if (result == null && parent instanceof Composite) {
            Composite composite = (Composite)parent;
            result = this.getControlWithFocus(composite);
        }
        return result;
    }

    public IWorkbenchHelpSystem getHelpSystem() {
        boolean valid = PlatformUI.isWorkbenchRunning();
        if (!valid) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchHelpSystem helpSystem = workbench.getHelpSystem();
        return helpSystem;
    }

    public Shell getShell() {
        Display display = Display.getCurrent();
        Shell shell = display.getActiveShell();
        return shell;
    }

    public Color getSystemColor(int id) {
        Display device = Display.getDefault();
        Color color = device.getSystemColor(id);
        return color;
    }

    public String getTextFromClipboard() {
        Display display = Display.getCurrent();
        Clipboard clipboard = new Clipboard(display);
        TextTransfer textTransfer = TextTransfer.getInstance();
        String value = (String)clipboard.getContents((Transfer)textTransfer);
        clipboard.dispose();
        return value;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window = this.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        return page;
    }

    public IWorkbenchWindow[] getWorkbenchWindows() {
        IWorkbench workbench = this.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        return windows;
    }

    public boolean isOnUserInterfaceThread() {
        Display display = Display.getCurrent();
        boolean result = display != null;
        return result;
    }

    private void log(int severity, String message, Throwable exception) {
        Activator activator = Activator.getDefault();
        activator.log(severity, message, exception);
    }

    public void openBrowser(String address) {
        IWorkbench workbench = this.getWorkbench();
        IWorkbenchBrowserSupport support = workbench.getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            URL url = new URL(address);
            browser.openURL(url);
        }
        catch (Exception exception) {
            String message = this.openUnableToOpenBrowserErrorMessageDialog(address);
            this.log(4, message, exception);
        }
    }

    public void openEditor(IFile file, String editorId) throws PartInitException {
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        FileEditorInput editorInput = new FileEditorInput(file);
        page.openEditor((IEditorInput)editorInput, editorId);
    }

    public void openErrorDialog(String id, String message, String reason, Throwable throwable) {
        Shell shell = this.getShell();
        String title = Messages.getString(ERROR_KEY);
        Status status = new Status(4, id, 4, reason, throwable);
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status, (int)4);
    }

    public void openMessageDialog(String title, String message, int style) {
        Shell shell = this.getShell();
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        messageBox.open();
    }

    private String openUnableToOpenBrowserErrorMessageDialog(String url) {
        String title = Messages.getString(ERROR_KEY);
        String error = Messages.getString(WEB_BROWSER_CAN_NOT_BE_FOUND);
        String separator = System.getProperty("line.separator");
        String pattern = Messages.getString(FAILED_TO_OPEN_URL_KEY);
        Object[] values = new Object[]{url};
        String consequence = MessageFormat.format(pattern, values);
        int length = error.length() + separator.length() + consequence.length();
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(error);
        buffer.append(separator);
        buffer.append(consequence);
        String message = buffer.toString();
        int style = 65569;
        this.openMessageDialog(title, message, style);
        return message;
    }

    public void setHelp(Control control, String contextId) {
        IWorkbenchHelpSystem helpSystem = this.getHelpSystem();
        helpSystem.setHelp(control, contextId);
    }
}

