/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.framework;

import java.util.Dictionary;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.osgi.service.cm.ConfigurationException;

public abstract class BaseManagedServiceFactoryAdvisor
implements IManagedServiceFactoryAdvisor {
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private static final String SHOULD_HAVE_OVERRIDDEN_METHOD_KEY = "Common.ShouldHaveOverriddenMethod";
    protected static final String[] NO_SERVICES = new String[0];

    public void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
    }

    public void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
    }

    public String[] getImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        return NO_SERVICES;
    }

    public String[] getOptionalImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        return NO_SERVICES;
    }

    public void handleAcquiredOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        this.warnShouldHaveOverriddenMethod("handleAcquiredOptionalImportedService(String, Object, String, Object, IBundleActivationManager)");
    }

    public void handleReleasedOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        this.warnShouldHaveOverriddenMethod("handleReleasedOptionalImportedService(String, Object, String, Object, IBundleActivationManager)");
    }

    public void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
    }

    private void warnShouldHaveOverriddenMethod(String method) {
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        boolean warn = utility.isOn();
        if (!warn) {
            return;
        }
        String component = Messages.getString(SAT_CORE_KEY);
        BaseManagedServiceFactoryAdvisor source = this;
        String pattern = Messages.getString(SHOULD_HAVE_OVERRIDDEN_METHOD_KEY);
        String warning = MessageFormatter.format(pattern, method);
        utility.warn(component, source, warning, null, null);
    }
}

