/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.framework;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.ProxyServiceHandlerAdapter;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public abstract class ManagedServiceFactoryBundleActivator
extends BaseBundleActivator
implements ManagedServiceFactory {
    private static final String CHECK_METADATA_EXISTS_PROPERTY = "org.eclipse.soda.sat.core.framework.check.metadata.exists";
    private static final String CREATE_MANAGED_SERVICE_FACTORY_PROXY_PROPERTY = "org.eclipse.soda.sat.core.framework.create.msf.proxy";
    private static final String DEFAULT_CHECK_METADATA_EXISTS = "false";
    private static final String DEFAULT_CREATE_MANAGED_SERVICE_FACTORY_PROXY = "false";
    private static final boolean CHECK_METADATA_EXISTS = Boolean.valueOf(System.getProperty("org.eclipse.soda.sat.core.framework.check.metadata.exists", "false"));
    private static final boolean CREATE_MANAGED_SERVICE_FACTORY_PROXY = Boolean.valueOf(System.getProperty("org.eclipse.soda.sat.core.framework.create.msf.proxy", "false"));
    private static final String FAILED_TO_FIND_METADATA_RESOURCE_KEY = "ManagedServiceFactoryBundleActivator.FailedToFindMetaDataResource";
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private IManagedServiceFactoryActivationManager managedServiceFactoryActivationManager;
    private String pid;
    static /* synthetic */ Class class$0;

    protected void activate() {
        this.registerManagedServiceFactory();
    }

    private void addExportedManagedServiceFactoryProxyService() {
        ProxyServiceHandlerAdapter handler = new ProxyServiceHandlerAdapter(){

            public Object createService() {
                return ManagedServiceFactoryBundleActivator.this.createManagedServiceFactory();
            }
        };
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        Dictionary properties = this.createManagedServiceFactoryProperties();
        this.addExportedProxyService(clazz2, handler, properties);
    }

    private void checkMetaDataResourceExists() {
        if (!CHECK_METADATA_EXISTS) {
            return;
        }
        Bundle bundle = this.getBundle();
        URL url = bundle.getResource("META-INF/METADATA.XML");
        if (url != null) {
            return;
        }
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        String component = Messages.getString(SAT_CORE_KEY);
        String source = bundle.getSymbolicName();
        String warning = Messages.getString(FAILED_TO_FIND_METADATA_RESOURCE_KEY);
        utility.warn(component, source, warning, null, null);
    }

    protected abstract IManagedServiceFactoryAdvisor createAdvisor();

    protected final String createDefaultPid() {
        Class<?> clazz = this.getClass();
        String name = clazz.getName();
        return name;
    }

    private ManagedServiceFactory createManagedServiceFactory() {
        this.checkMetaDataResourceExists();
        this.startManagedServiceFactoryActivationManager();
        ManagedServiceFactory service = this.getManagedServiceFactory();
        return service;
    }

    private IManagedServiceFactoryActivationManager createManagedServiceFactoryActivationManager() {
        String name = this.getName();
        IManagedServiceFactoryAdvisor advisor = this.createAdvisor();
        FactoryUtility utility = FactoryUtility.getInstance();
        IManagedServiceFactoryActivationManager manager = utility.createManagedServiceFactoryActivationManager(name, advisor);
        return manager;
    }

    private Dictionary createManagedServiceFactoryProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(11);
        String pid = this.getPid();
        ((Dictionary)properties).put("service.pid", pid);
        return properties;
    }

    protected String createPid() {
        String pid = this.createDefaultPid();
        return pid;
    }

    protected void deactivate() {
        this.stopManagedServiceFactoryActivationManager();
    }

    public final void deleted(String pid) {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.deleted(pid);
    }

    public Map getAllObjects() {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        Map map = manager.getAllObjects();
        return map;
    }

    public Iterator getAllPids() {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        Iterator iterator = manager.getAllPids();
        return iterator;
    }

    public Map getAllProperties() {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        Map map = manager.getAllProperties();
        return map;
    }

    private ManagedServiceFactory getManagedServiceFactory() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IManagedServiceFactoryActivationManager getManagedServiceFactoryActivationManager() {
        ManagedServiceFactoryBundleActivator managedServiceFactoryBundleActivator = this;
        synchronized (managedServiceFactoryBundleActivator) {
            if (this.managedServiceFactoryActivationManager == null) {
                IManagedServiceFactoryActivationManager manager = this.createManagedServiceFactoryActivationManager();
                this.setManagedServiceFactoryActivationManager(manager);
            }
        }
        return this.managedServiceFactoryActivationManager;
    }

    protected final String getManagedServiceFactoryServiceName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    public String getName() {
        String name = this.getPid();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getPid() {
        ManagedServiceFactoryBundleActivator managedServiceFactoryBundleActivator = this;
        synchronized (managedServiceFactoryBundleActivator) {
            if (this.pid == null) {
                String pid = this.createPid();
                this.setPid(pid);
            }
        }
        return this.pid;
    }

    protected boolean isProxyService() {
        return CREATE_MANAGED_SERVICE_FACTORY_PROXY;
    }

    public void printFactoryConfigurationsOn(StringBuffer buffer) {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.printFactoryConfigurationsOn(buffer);
    }

    private void registerManagedServiceFactory() {
        boolean proxy = this.isProxyService();
        if (proxy) {
            this.addExportedManagedServiceFactoryProxyService();
        } else {
            String exportedServiceName = this.getManagedServiceFactoryServiceName();
            ManagedServiceFactory service = this.createManagedServiceFactory();
            Dictionary properties = this.createManagedServiceFactoryProperties();
            this.addExportedService(exportedServiceName, service, properties);
        }
    }

    private void setManagedServiceFactoryActivationManager(IManagedServiceFactoryActivationManager managedServiceFactoryActivationManager) {
        this.managedServiceFactoryActivationManager = managedServiceFactoryActivationManager;
    }

    private void setPid(String pid) {
        this.pid = pid;
    }

    private void startManagedServiceFactoryActivationManager() {
        BundleContext context = this.getBundleContext();
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.start(context);
    }

    private void stopManagedServiceFactoryActivationManager() {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.stop();
        this.setManagedServiceFactoryActivationManager(null);
    }

    public final void updated(String pid, Dictionary properties) throws ConfigurationException {
        IManagedServiceFactoryActivationManager manager = this.getManagedServiceFactoryActivationManager();
        manager.updated(pid, properties);
    }
}

