/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManagerOwner;
import org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleDependencyManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleUninstallManager;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.eclipse.soda.sat.core.record.container.interfaces.IExportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerLenientOwner;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerOwner;
import org.eclipse.soda.sat.core.record.interfaces.IExportProxyServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.startlevel.StartLevel;

public class BundleActivationManager
implements IBundleActivationManager {
    private static final String ASYNC_START_UP_KEY = "BundleActivationManager.AsyncStartUp";
    private static final String ASYNC_START_UP_THREAD_HAS_STOPPED_KEY = "BundleActivationManager.AsyncStartUpThreadHasStopped";
    private static final String BUNDLES_SHOULD_BE_TRANSIENT_OR_UNINSTALLABLE_NOT_BOTH_KEY = "BundleActivationManager.BundleShouldBeTransientOrUninstallableNotBoth";
    private static final String CLASS_KEY = "BundleActivationManager.Class";
    private static final String FAILED_TO_GET_IMPORTED_SERVICE_KEY = "BundleActivationManager.FailedToGetImportedService";
    private static final String FAILED_TO_GET_PROPERTIES_KEY = "BundleActivationManager.FailedToGetProperties";
    private static final String FRAMEWORK_RESTARTED_BY_KEY = "BundleActivationManager.FrameworkRestartedBy";
    private static final String FRAMEWORK_SHUTDOWN_BY_KEY = "BundleActivationManager.FrameworkShutdownBy";
    private static final String ILLEGAL_BUNDLE_CONTEXT_KEY = "BundleActivationManager.IllegalBundleContext";
    private static final String INVALID_LDAP_FILTER_KEY = "BundleActivationManager.InvalidLdapFilter";
    private static final String IMPORTED_SERVICE_FILTER_FOR_SERVICE_IS_NULL_KEY = "BundleActivationManager.ImportedServiceFilterForServiceIsNull";
    private static final String LDAP_FILTER_CONTAINS_QUESTIONABLE_WHITESPACE_KEY = "BundleActivationManager.LdapFilterContainsQuestionableWhitespace";
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private static final String SERVICE_KEY = "Common.Service";
    private static final String WAITING_FOR_ASYNC_START_UP_THREAD_TO_STOP_KEY = "BundleActivationManager.WaitingForAsyncStartUpThreadToStop";
    private boolean activated;
    private Thread asyncStartThread;
    private BundleContext bundleContext;
    private IExportServiceRecordContainer exportServiceRecords;
    private Map importedServiceFilters;
    private Map optionalImportedServiceFilters;
    private IImportServiceRecordContainer importServiceRecords;
    private IImportServiceRecordContainer optionalImportServiceRecords;
    private IBundleActivationManagerOwner owner;
    private Properties properties;
    private final Object activationLock = new Object();
    private final Object startLock = new Object();
    static /* synthetic */ Class class$0;

    public BundleActivationManager() {
        this.setActivated(false);
    }

    public void acquireImportedServices() {
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        IImportServiceRecordContainerOwner owner = this.createImportServiceRecordContainerOwner();
        container.acquire(owner);
    }

    public void acquireOptionalImportedServices() {
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        IImportServiceRecordContainerOwner owner = this.createOptionalImportServiceRecordContainerOwner();
        container.acquire(owner);
    }

    protected void activate() {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.activate();
    }

    public void addExportedProxyService(Class interfaceType, IProxyServiceHandler creator, Dictionary properties) {
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        Class[] interfaceTypes = new Class[]{interfaceType};
        IExportProxyServiceRecord record = factory.createExportProxyServiceRecord(bundleContext, interfaceTypes, creator, properties);
        this.addExportedService(record);
    }

    public void addExportedProxyServices(Class[] interfaceTypes, IProxyServiceHandler creator, Dictionary properties) {
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IExportProxyServiceRecord record = factory.createExportProxyServiceRecord(bundleContext, interfaceTypes, creator, properties);
        this.addExportedService(record);
    }

    private void addExportedService(IExportServiceRecord record) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        records.add(record);
        boolean register = this.isActivated();
        if (register) {
            record.register();
        }
    }

    public void addExportedService(String name, Object service, Dictionary properties) {
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        String[] names = new String[]{name};
        IExportServiceRecord record = factory.createExportServiceRecord(bundleContext, names, service, properties);
        this.addExportedService(record);
    }

    public void addExportedServices(String[] names, Object service, Dictionary properties) {
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IExportServiceRecord record = factory.createExportServiceRecord(bundleContext, names, service, properties);
        this.addExportedService(record);
    }

    public void addImportedServiceFilter(String name, String filterString) {
        Map filters = this.getImportedServiceFilters();
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        this.addImportedServiceFilter(name, filterString, filters, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImportedServiceFilter(String name, String filterString, Map filters, IImportServiceRecordContainer container) {
        this.checkFilterIsNotNull(name, filterString);
        this.checkIsValidFilter(name, filterString);
        BundleContext bundleContext = this.getBundleContext();
        try {
            Filter filter = bundleContext.createFilter(filterString);
            Map map = filters;
            synchronized (map) {
                filters.put(name, filter);
            }
            IImportServiceRecord record = (IImportServiceRecord)container.get(name);
            if (record == null) {
                return;
            }
            record.setFilter(filter);
        }
        catch (InvalidSyntaxException exception) {
            String pattern = Messages.getString(INVALID_LDAP_FILTER_KEY);
            String message = MessageFormatter.format(pattern, filterString);
            LogUtility.logError(this, message, exception);
        }
    }

    public void addOptionalImportedServiceFilter(String name, String filterString) {
        Map filters = this.getOptionalImportedServiceFilters();
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        this.addImportedServiceFilter(name, filterString, filters, container);
    }

    private void checkBundleContext(BundleContext bundleContext) {
        BundleContext context = this.getBundleContext();
        boolean equal = context.equals(bundleContext);
        if (equal) {
            return;
        }
        String message = Messages.getString(ILLEGAL_BUNDLE_CONTEXT_KEY);
        throw new IllegalArgumentException(message);
    }

    private void checkFilterIsNotNull(String name, String filterString) {
        if (filterString != null) {
            return;
        }
        String pattern = Messages.getString(IMPORTED_SERVICE_FILTER_FOR_SERVICE_IS_NULL_KEY);
        String message = MessageFormatter.format(pattern, name);
        throw new IllegalArgumentException(message);
    }

    private void checkImportedServiceIsNotNull(String name, Object service) {
        if (service != null) {
            return;
        }
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        String component = Messages.getString(SAT_CORE_KEY);
        String source = this.getBundleSymbolicName();
        String label = Messages.getString(SERVICE_KEY);
        String warning = Messages.getString(FAILED_TO_GET_IMPORTED_SERVICE_KEY);
        utility.warn(component, source, warning, label, name);
    }

    private void checkIsValidFilter(String name, String filterString) {
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        boolean warn = utility.isOn();
        if (!warn) {
            return;
        }
        boolean valid = true;
        int index = 0;
        while (valid && (index = filterString.indexOf(61, index)) != -1) {
            valid = index < filterString.length();
            valid = valid && !Character.isWhitespace(filterString.charAt(index + 1));
            ++index;
        }
        index = 0;
        while (valid && (index = filterString.indexOf(41, index)) != -1) {
            valid = index > 0;
            valid = valid && !Character.isWhitespace(filterString.charAt(index - 1));
            ++index;
        }
        if (valid) {
            return;
        }
        String component = Messages.getString(SAT_CORE_KEY);
        Bundle bundle = this.getBundle();
        String source = bundle.getSymbolicName();
        String pattern = Messages.getString(LDAP_FILTER_CONTAINS_QUESTIONABLE_WHITESPACE_KEY);
        String warning = MessageFormatter.format(pattern, filterString);
        String label = Messages.getString(SERVICE_KEY);
        utility.warn(component, source, warning, label, name);
    }

    private void checkUninstallPolicy() {
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        boolean warn = utility.isOn();
        if (!warn) {
            return;
        }
        boolean uninstallable = this.isUninstallable();
        boolean transientFlag = this.isTransient();
        if (!uninstallable || !transientFlag) {
            return;
        }
        String component = Messages.getString(SAT_CORE_KEY);
        Bundle bundle = this.getBundle();
        String source = bundle.getSymbolicName();
        Class<?> clazz = this.getClass();
        String className = clazz.getName();
        String message = Messages.getString(BUNDLES_SHOULD_BE_TRANSIENT_OR_UNINSTALLABLE_NOT_BOTH_KEY);
        String label = Messages.getString(CLASS_KEY);
        utility.warn(component, source, message, label, className);
    }

    private Object[] collectServices(IServiceRecord[] records) {
        int length = records.length;
        Object[] services = new Object[length];
        int i = 0;
        while (i < length) {
            Object service;
            IServiceRecord record = records[i];
            services[i] = service = record.getService();
            ++i;
        }
        return services;
    }

    private IExportServiceRecordContainer createExportServiceRecordContainer() {
        FactoryUtility factory = FactoryUtility.getInstance();
        IExportServiceRecordContainer container = factory.createExportServiceRecordContainer();
        return container;
    }

    private IImportServiceRecordContainer createImportServiceRecordContainer() {
        FactoryUtility factory = FactoryUtility.getInstance();
        IImportServiceRecordContainer container = factory.createImportServiceRecordContainer();
        return container;
    }

    private IImportServiceRecordContainerOwner createImportServiceRecordContainerOwner() {
        return new IImportServiceRecordContainerOwner(){

            public void acquired(IImportServiceRecordContainer container) {
                BundleActivationManager.this.performActivation();
            }

            public void released(IImportServiceRecordContainer container) {
                BundleActivationManager.this.performDeactivation();
            }
        };
    }

    private void createImportServiceRecords() {
        String[] names = this.getImportedServiceNames();
        if (names == null || names.length == 0) {
            return;
        }
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            Filter filter = this.getImportedServiceFilter(name);
            IImportServiceRecord record = factory.createImportServiceRecord(bundleContext, name, filter);
            container.add(record);
            ++i;
        }
    }

    private IImportServiceRecordContainerOwner createOptionalImportServiceRecordContainerOwner() {
        return new IImportServiceRecordContainerLenientOwner(){

            public void acquired(IImportServiceRecordContainer container) {
            }

            public void released(IImportServiceRecordContainer container) {
            }

            public void serviceAcquired(IImportServiceRecordContainer container, IImportServiceRecord record) {
                BundleActivationManager.this.handleAcquiredOptionalImportedService(record);
            }

            public void serviceReleased(IImportServiceRecordContainer container, IImportServiceRecord record) {
                BundleActivationManager.this.handleReleasedOptionalImportedService(record);
            }
        };
    }

    private void createOptionalImportServiceRecords() {
        String[] names = this.getOptionalImportedServiceNames();
        if (names == null || names.length == 0) {
            return;
        }
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            Filter filter = this.getOptionalImportedServiceFilter(name);
            IImportServiceRecord record = factory.createImportServiceRecord(bundleContext, name, filter);
            container.add(record);
            ++i;
        }
    }

    private Runnable createStartAsyncRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        BundleActivationManager.this.startSync();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    BundleActivationManager.this.setAsyncStartThread(null);
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                BundleActivationManager.this.setAsyncStartThread(null);
            }
        };
    }

    private void deactivate() {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.deactivate();
    }

    private void destroyExportServiceRecords() {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        records.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyImportServiceFilters() {
        Map map;
        Map map2 = map = this.getImportedServiceFilters();
        synchronized (map2) {
            map.clear();
        }
    }

    private void destroyImportServiceRecords() {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        records.empty();
    }

    private void destroyOptionalImportedServiceRecords() {
        IImportServiceRecordContainer records = this.getOptionalImportServiceRecords();
        records.empty();
    }

    private Object getActivationLock() {
        return this.activationLock;
    }

    private int getAsyncStartPriority() {
        IBundleActivationManagerOwner owner = this.getOwner();
        int priority = owner.getAsyncStartPriority();
        return priority;
    }

    private Thread getAsyncStartThread() {
        return this.asyncStartThread;
    }

    public Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        return bundle;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getBundleSymbolicName() {
        Bundle bundle = this.getBundle();
        String symbolicName = bundle.getSymbolicName();
        return symbolicName;
    }

    public File getDataDirectory() {
        String name = new String();
        File file = this.getDataFile(name);
        return file;
    }

    public File getDataFile(String filename) {
        BundleContext bundleContext = this.getBundleContext();
        File file = bundleContext.getDataFile(filename);
        return file;
    }

    private String getDefaultPropertiesFilename() {
        String symbolicName = this.getBundleSymbolicName();
        int length = symbolicName.length() + 11;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(symbolicName);
        buffer.append(".properties");
        String filename = buffer.toString();
        return filename;
    }

    private Object getExportedService(IExportServiceRecord record) {
        Object service = null;
        if (record.isProxy()) {
            IExportProxyServiceRecord proxyRecord = (IExportProxyServiceRecord)record;
            service = this.getProxyService(proxyRecord);
        } else {
            service = record.getService();
        }
        return service;
    }

    public Object getExportedService(String name) {
        Object service = null;
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name);
        if (record != null) {
            service = this.getExportedService(record);
        }
        return service;
    }

    public String[] getExportedServiceNamesFromManifest() {
        Bundle bundle = this.getBundle();
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String[] names = utility.getExportServices(bundle);
        return names;
    }

    public Dictionary getExportedServiceProperties(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name);
        Dictionary properties = record.getProperties();
        return properties;
    }

    public Dictionary getExportedServiceProperties(String name, Object service) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name, service);
        Dictionary properties = record.getProperties();
        return properties;
    }

    public Object[] getExportedServices(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IServiceRecord[] matches = records.getAll(name);
        Object[] services = this.collectServices(matches);
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExportServiceRecordContainer getExportServiceRecords() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.exportServiceRecords == null) {
                this.exportServiceRecords = this.createExportServiceRecordContainer();
                this.setExportServiceRecords(this.exportServiceRecords);
            }
        }
        return this.exportServiceRecords;
    }

    public InputStream getFilePropertiesInputStream() throws IOException {
        String filename = this.getDefaultPropertiesFilename();
        InputStream stream = this.getFilePropertiesInputStream(filename);
        return stream;
    }

    public InputStream getFilePropertiesInputStream(String filename) throws IOException {
        File file = new File(filename);
        boolean exists = file.exists();
        InputStream stream = null;
        if (exists) {
            stream = new FileInputStream(file);
            stream = new BufferedInputStream(stream);
        } else {
            this.handleFailedToFindProperties(filename);
        }
        return stream;
    }

    private String getFrameworkVendor() {
        BundleContext context = this.getBundleContext();
        String vendor = context.getProperty("org.osgi.framework.vendor");
        return vendor;
    }

    public Object getImportedService(String name) {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        IServiceRecord record = records.get(name);
        Object service = record != null ? record.getService() : null;
        this.checkImportedServiceIsNotNull(name, service);
        return service;
    }

    public Filter getImportedServiceFilter(String name) {
        Map map = this.getImportedServiceFilters();
        Filter filter = (Filter)map.get(name);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getImportedServiceFilters() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.importedServiceFilters == null) {
                Hashtable map = new Hashtable(17);
                this.setImportedServiceFilters(map);
            }
        }
        return this.importedServiceFilters;
    }

    private String[] getImportedServiceNames() {
        IBundleActivationManagerOwner owner = this.getOwner();
        String[] names = owner.getImportedServiceNames();
        return names;
    }

    public String[] getImportedServiceNamesFromManifest() {
        Bundle bundle = this.getBundle();
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String[] names = utility.getImportServices(bundle);
        return names;
    }

    public Object getImportedServiceProperty(String name, String key) {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        IServiceRecord record = records.get(name);
        Object value = record.getProperty(key);
        return value;
    }

    public String[] getImportedServicePropertyKeys(String name) {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        IServiceRecord record = records.get(name);
        String[] keys = record.getPropertyKeys();
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImportServiceRecordContainer getImportServiceRecords() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.importServiceRecords == null) {
                IImportServiceRecordContainer container = this.createImportServiceRecordContainer();
                this.setImportServiceRecords(container);
            }
        }
        return this.importServiceRecords;
    }

    public Object getOptionalImportedService(String name) {
        IImportServiceRecordContainer records = this.getOptionalImportServiceRecords();
        IServiceRecord record = records.get(name);
        Object service = record != null ? record.getService() : null;
        return service;
    }

    public Filter getOptionalImportedServiceFilter(String name) {
        Map map = this.getOptionalImportedServiceFilters();
        Filter filter = (Filter)map.get(name);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getOptionalImportedServiceFilters() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.optionalImportedServiceFilters == null) {
                Hashtable map = new Hashtable(7);
                this.setOptionalImportedServiceFilters(map);
            }
        }
        return this.optionalImportedServiceFilters;
    }

    private String[] getOptionalImportedServiceNames() {
        IBundleActivationManagerOwner owner = this.getOwner();
        String[] names = owner.getOptionalImportedServiceNames();
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImportServiceRecordContainer getOptionalImportServiceRecords() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.optionalImportServiceRecords == null) {
                IImportServiceRecordContainer container = this.createImportServiceRecordContainer();
                this.setOptionalImportServiceRecords(container);
            }
        }
        return this.optionalImportServiceRecords;
    }

    private IBundleActivationManagerOwner getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.properties == null) {
                Properties properties = this.loadProperties();
                this.setProperties(properties);
            }
        }
        return this.properties;
    }

    private InputStream getPropertiesInputStream() throws IOException {
        IBundleActivationManagerOwner owner = this.getOwner();
        InputStream stream = owner.getPropertiesInputStream();
        return stream;
    }

    public String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null) {
            Properties properties = this.getProperties();
            value = properties.getProperty(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private Object getProxyService(IExportProxyServiceRecord record) {
        Object service = null;
        boolean created = record.isServiceCreated();
        if (created) {
            service = record.getService();
        }
        return service;
    }

    private String getStartAsynchThreadName() {
        String pattern = Messages.getString(ASYNC_START_UP_KEY);
        String symbolicName = this.getBundleSymbolicName();
        String name = MessageFormatter.format(pattern, symbolicName);
        return name;
    }

    private Object getStartLock() {
        return this.startLock;
    }

    private Bundle getSystemBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle(0L);
        return bundle;
    }

    private void handleAcquiredOptionalImportedService(IImportServiceRecord record) {
        String name = record.getName();
        Object service = record.getService();
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.handleAcquiredOptionalImportedService(name, service);
    }

    private boolean handleException(Exception exception) {
        boolean result = true;
        IBundleActivationManagerOwner owner = this.getOwner();
        if (owner == null) {
            String message = exception.getMessage();
            LogUtility.logError(this, message, exception);
        } else {
            result = owner.handleException(exception);
        }
        return result;
    }

    private void handleFailedToFindProperties(String filename) {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.handleFailedToFindProperties(filename);
    }

    private void handleReleasedOptionalImportedService(IImportServiceRecord record) {
        String name = record.getName();
        Object service = record.getService();
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.handleReleasedOptionalImportedService(name, service);
    }

    private void interruptAndJoinWithAsyncThread() {
        boolean async = this.isStartAsync();
        if (!async) {
            return;
        }
        Thread thread = this.getAsyncStartThread();
        if (thread == null) {
            return;
        }
        String name = thread.getName();
        String pattern = Messages.getString(WAITING_FOR_ASYNC_START_UP_THREAD_TO_STOP_KEY);
        String waitingForThreadToStop = MessageFormatter.format(pattern, name);
        pattern = Messages.getString(ASYNC_START_UP_THREAD_HAS_STOPPED_KEY);
        String threadHasStopped = MessageFormatter.format(pattern, name);
        LogUtility.logInfo(this, waitingForThreadToStop);
        thread.interrupt();
        try {
            thread.join();
            LogUtility.logInfo(this, threadHasStopped);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isActivated() {
        return this.activated;
    }

    private boolean isStartAsync() {
        IBundleActivationManagerOwner owner = this.getOwner();
        boolean startAsynchronously = owner.isStartAsync();
        return startAsynchronously;
    }

    private boolean isStarted() {
        boolean started = this.getBundleContext() != null;
        return started;
    }

    private boolean isTransient() {
        IBundleActivationManagerOwner owner = this.getOwner();
        boolean result = owner.isTransient();
        return result;
    }

    private boolean isUninstallable() {
        IBundleActivationManagerOwner owner = this.getOwner();
        boolean result = owner.isUninstallable();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties() {
        Properties properties = new Properties();
        try {
            InputStream stream = this.getPropertiesInputStream();
            if (stream == null) return properties;
            try {
                properties.load(stream);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                stream.close();
                return properties;
            }
        }
        catch (IOException exception) {
            String message = Messages.getString(FAILED_TO_GET_PROPERTIES_KEY);
            LogUtility.logWarning(message, exception);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performActivation() {
        Object startLock;
        Object object = startLock = this.getStartLock();
        synchronized (object) {
            Object activationLock;
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            Object object2 = activationLock = this.getActivationLock();
            synchronized (object2) {
                boolean activated = this.isActivated();
                if (activated) {
                    return;
                }
                this.setActivated(true);
                this.activate();
                activated = this.isActivated();
                if (!activated) {
                    return;
                }
                this.registerExportedServices();
                this.registerWithBundleUninstallManager();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDeactivation() {
        Object startLock;
        Object object = startLock = this.getStartLock();
        synchronized (object) {
            Object activationLock;
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            Object object2 = activationLock = this.getActivationLock();
            synchronized (object2) {
                boolean activated = this.isActivated();
                if (!activated) {
                    return;
                }
                this.setActivated(false);
                this.unregisterExportServices();
                this.deactivate();
                this.destroyExportServiceRecords();
            }
        }
    }

    private void registerExportedServices() {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        records.register();
    }

    private void registerWithBundleDependencyManager() {
        boolean uninstallable = this.isUninstallable();
        if (!uninstallable) {
            return;
        }
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        Bundle bundle = this.getBundle();
        manager.addUninstallableBundle(bundle);
    }

    private void registerWithBundleUninstallManager() {
        boolean transientFlag = this.isTransient();
        if (!transientFlag) {
            return;
        }
        BundleUninstallManager uninstaller = BundleUninstallManager.getInstance();
        Bundle bundle = this.getBundle();
        uninstaller.uninstall(bundle);
    }

    public void releaseImportedServices() {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        records.release();
    }

    public void releaseOptionalImportedServices() {
        IImportServiceRecordContainer records = this.getOptionalImportServiceRecords();
        records.release();
    }

    public void removeExportedService(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name);
        if (record == null) {
            return;
        }
        this.removeExportService(record);
    }

    public void removeExportedService(String name, Object service) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name, service);
        if (record == null) {
            return;
        }
        this.removeExportService(record);
    }

    public void removeExportedServices(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IServiceRecord[] matches = records.getAll(name);
        if (matches == null) {
            return;
        }
        int count = matches.length;
        int i = 0;
        while (i < count) {
            IExportServiceRecord record = (IExportServiceRecord)matches[i];
            records.remove(record);
            ++i;
        }
    }

    private void removeExportService(IExportServiceRecord record) {
        boolean activated = this.isActivated();
        if (activated) {
            record.unregister();
        }
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        records.remove(record);
    }

    public void removeImportedServiceFilter(String name) {
        Map filters = this.getImportedServiceFilters();
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        this.removeImportedServiceFilter(name, filters, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImportedServiceFilter(String name, Map filters, IImportServiceRecordContainer container) {
        Object value = null;
        Map map = filters;
        synchronized (map) {
            value = filters.remove(name);
        }
        if (value == null) {
            return;
        }
        IImportServiceRecord record = (IImportServiceRecord)container.get(name);
        if (record == null) {
            return;
        }
        record.setFilter(null);
    }

    public void removeOptionalImportedServiceFilter(String name) {
        Map filters = this.getOptionalImportedServiceFilters();
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        this.removeImportedServiceFilter(name, filters, container);
    }

    public void restartFramework() throws BundleException {
        String pattern = Messages.getString(FRAMEWORK_RESTARTED_BY_KEY);
        String symbolicName = this.getBundleSymbolicName();
        String message = MessageFormatter.format(pattern, symbolicName);
        LogUtility.logInfo(message);
        boolean broken = this.getFrameworkVendor().equals("Eclipse");
        if (broken) {
            FactoryUtility utility = FactoryUtility.getInstance();
            BundleContext context = this.getBundleContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.startlevel.StartLevel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String name = clazz.getName();
            IImportServiceRecord record = utility.createImportServiceRecord(context, name, null);
            record.acquire(null);
            StartLevel startLevel = (StartLevel)record.getService();
            int current = startLevel != null ? startLevel.getStartLevel() : 6;
            record.release();
            String value = String.valueOf(current);
            Properties properties = System.getProperties();
            properties.put("osgi.framework.beginningstartlevel", value);
        }
        Bundle bundle = this.getSystemBundle();
        bundle.update();
    }

    private void setActivated(boolean activated) {
        this.activated = activated;
    }

    private void setAsyncStartThread(Thread asyncStartThread) {
        this.asyncStartThread = asyncStartThread;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setExportedServiceProperties(String name, Dictionary properties) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name);
        if (record == null) {
            return;
        }
        record.setProperties(properties);
    }

    public void setExportedServiceProperties(String name, Object service, Dictionary properties) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name, service);
        if (record == null) {
            return;
        }
        record.setProperties(properties);
    }

    private void setExportServiceRecords(IExportServiceRecordContainer exportServiceRecords) {
        this.exportServiceRecords = exportServiceRecords;
    }

    private void setImportedServiceFilters(Map importedServiceFilters) {
        this.importedServiceFilters = importedServiceFilters;
    }

    private void setImportServiceRecords(IImportServiceRecordContainer importServiceRecords) {
        this.importServiceRecords = importServiceRecords;
    }

    private void setOptionalImportedServiceFilters(Map optionalImportedServiceFilters) {
        this.optionalImportedServiceFilters = optionalImportedServiceFilters;
    }

    private void setOptionalImportServiceRecords(IImportServiceRecordContainer optionalImportServiceRecords) {
        this.optionalImportServiceRecords = optionalImportServiceRecords;
    }

    private void setOwner(IBundleActivationManagerOwner owner) {
        this.owner = owner;
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void shutdownFramework() throws BundleException {
        String pattern = Messages.getString(FRAMEWORK_SHUTDOWN_BY_KEY);
        String symbolicName = this.getBundleSymbolicName();
        String message = MessageFormatter.format(pattern, symbolicName);
        LogUtility.logInfo(message);
        Bundle bundle = this.getSystemBundle();
        bundle.stop();
    }

    private void start() throws Exception {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context, IBundleActivationManagerOwner owner) throws Exception {
        Object lock;
        Object object = lock = this.getStartLock();
        synchronized (object) {
            if (this.isStarted()) {
                return;
            }
            this.setBundleContext(context);
            this.setOwner(owner);
            this.checkUninstallPolicy();
            this.registerWithBundleDependencyManager();
            boolean async = this.isStartAsync();
            if (async) {
                this.startAsync();
            } else {
                this.startSync();
            }
        }
    }

    private void startAsync() {
        Runnable runnable = this.createStartAsyncRunnable();
        String name = this.getStartAsynchThreadName();
        Thread thread = new Thread(runnable, name);
        this.setAsyncStartThread(thread);
        int priority = this.getAsyncStartPriority();
        thread.setPriority(priority);
        thread.start();
    }

    private void startSync() throws Exception {
        try {
            this.start();
            this.createOptionalImportServiceRecords();
            this.acquireOptionalImportedServices();
            this.createImportServiceRecords();
            this.acquireImportedServices();
        }
        catch (Exception exception) {
            boolean handled = this.handleException(exception);
            if (handled) {
                return;
            }
            throw exception;
        }
    }

    private void stop() throws Exception {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext bundleContext) throws Exception {
        this.checkBundleContext(bundleContext);
        Object lock = this.getStartLock();
        try {
            Object object = lock;
            synchronized (object) {
                if (!this.isStarted()) {
                    return;
                }
                try {
                    this.interruptAndJoinWithAsyncThread();
                    this.releaseImportedServices();
                    this.destroyImportServiceFilters();
                    this.destroyImportServiceRecords();
                    this.releaseOptionalImportedServices();
                    this.destroyOptionalImportedServiceRecords();
                    this.unregisterWithBundleDependencyManager();
                    this.stop();
                    Object var4_7 = null;
                    this.setOwner(null);
                    this.setBundleContext(null);
                    return;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.setOwner(null);
                    this.setBundleContext(null);
                    throw throwable;
                }
            }
        }
        catch (Exception exception) {
            boolean handled = this.handleException(exception);
            if (!handled) throw exception;
            return;
        }
    }

    private void unregisterExportServices() {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        records.unregister();
    }

    private void unregisterWithBundleDependencyManager() {
        boolean uninstallable = this.isUninstallable();
        if (!uninstallable) {
            return;
        }
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        Bundle bundle = this.getBundle();
        manager.removeUninstallableBundle(bundle);
    }
}

