/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.interfaces.IQueue;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleManager;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.service.BundleUninstallService;
import org.eclipse.soda.sat.core.util.BundleUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleUninstallManager
extends BundleManager
implements BundleUninstallService {
    private static final String BUNDLE_CANNOT_BE_ADDED_KEY = "BundleUninstallManager.BundleCannotBeAdded";
    private static final String BUNDLE_MUST_BE_STARTING_KEY = "BundleUninstallManager.BundleMustBeStarting";
    private static final String FAILED_TO_UNINSTALL_BUNDLE_KEY = "BundleUninstallManager.FailedToUninstallBundle";
    private static final String OBJECT_IDENTITY_FAILURE_KEY = "BundleUninstallManager.ObjectIdentityFailure";
    private static final String THREAD_IDLE_TIMEOUT_PROPERTY_KEY = "org.eclipse.soda.sat.core.bundle.uninstaller.thread.idle.timeout";
    private static final String DEFAULT_THREAD_IDLE_TIMEOUT = "10000";
    private static final long THREAD_IDLE_TIMEOUT = Long.valueOf(System.getProperty("org.eclipse.soda.sat.core.bundle.uninstaller.thread.idle.timeout", "10000"), 10);
    private static final BundleUninstallManager INSTANCE = new BundleUninstallManager();
    private Thread thread;
    private int threadId;
    private Map pendingBundles;
    private IQueue uninstallableBundles;

    static BundleUninstallManager getInstance() {
        return INSTANCE;
    }

    private BundleUninstallManager() {
        this.setUninstallableBundles(this.createQueue(25));
        this.setPendingBundles(new Hashtable(101));
        this.setThreadId(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPendingBundles(Bundle bundle) {
        this.checkBundleIsStarting(bundle);
        Map map = this.getPendingBundles();
        String key = bundle.getSymbolicName();
        Map map2 = map;
        synchronized (map2) {
            map.put(key, bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUninstallableBundles(Bundle bundle) {
        IQueue queue;
        IQueue iQueue = queue = this.getUninstallableBundles();
        synchronized (iQueue) {
            boolean exists = queue.contains(bundle);
            if (exists) {
                return;
            }
            queue.add(bundle);
        }
        this.startThreadIfNecessary();
    }

    private void checkBundleIdentity(Bundle bundle) {
        this.checkIsNotSystemBundle(bundle);
        this.checkIsNotOwner(bundle);
    }

    private void checkBundleIsStarting(Bundle bundle) {
        boolean starting = this.isBundleState(bundle, 8);
        if (starting) {
            return;
        }
        String message = Messages.getString(BUNDLE_MUST_BE_STARTING_KEY);
        throw new IllegalArgumentException(message);
    }

    private void checkIsNotOwner(Bundle bundle) {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            return;
        }
        Bundle owner = bundleContext.getBundle();
        boolean illegal = owner.equals(bundle);
        if (!illegal) {
            return;
        }
        String location = bundle.getLocation();
        String pattern = Messages.getString(BUNDLE_CANNOT_BE_ADDED_KEY);
        String message = MessageFormatter.format(pattern, location);
        throw new IllegalArgumentException(message);
    }

    private void checkIsNotSystemBundle(Bundle bundle) {
        long id = bundle.getBundleId();
        if (id == 0L) {
            return;
        }
    }

    private void checkObjectIdentities(Object object1, Object object2) {
        boolean identical;
        boolean bl = identical = object1 == object2;
        if (identical) {
            return;
        }
        String message = Messages.getString(OBJECT_IDENTITY_FAILURE_KEY);
        throw new RuntimeException(message);
    }

    private IQueue createQueue(int capacity) {
        FactoryUtility utility = FactoryUtility.getInstance();
        IQueue queue = utility.createQueue(capacity);
        return queue;
    }

    private Runnable createRunnable() {
        return new Runnable(){

            public void run() {
                BundleUninstallManager.this.process();
            }
        };
    }

    private Map getPendingBundles() {
        return this.pendingBundles;
    }

    private Thread getThread() {
        return this.thread;
    }

    private int getThreadId() {
        return this.threadId;
    }

    private IQueue getUninstallableBundles() {
        return this.uninstallableBundles;
    }

    protected void handleBundleStarted(Bundle bundle) {
        super.handleBundleInstalled(bundle);
        this.uninstallPendingBundle(bundle);
    }

    protected void handleManagerShutdown() {
        this.stopThreadIfNecessary();
        super.handleManagerShutdown();
    }

    protected void handleManagerStarted() {
        super.handleManagerStarted();
        this.uninstallActivePendingBundles();
        this.startThreadIfNecessary();
    }

    private boolean isBundleState(Bundle bundle, int state) {
        BundleUtility utility = BundleUtility.getInstance();
        boolean result = utility.isBundleState(bundle, state);
        return result;
    }

    private void process() {
        while (this.isStarted()) {
            Bundle bundle = this.removeFromQueue(THREAD_IDLE_TIMEOUT);
            if (bundle == null) break;
            this.uninstallBundle(bundle);
        }
        this.setThread(null);
    }

    private Bundle removeFromQueue(long timeout) {
        IQueue queue = this.getUninstallableBundles();
        Bundle bundle = null;
        try {
            bundle = (Bundle)queue.remove(timeout);
        }
        catch (InterruptedException interruptedException) {}
        return bundle;
    }

    private void setPendingBundles(Map pendingBundles) {
        this.pendingBundles = pendingBundles;
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }

    private void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    private void setUninstallableBundles(IQueue queue) {
        this.uninstallableBundles = queue;
    }

    private void startThread() {
        Runnable runnable = this.createRunnable();
        int id = this.getThreadId() + 1;
        this.setThreadId(id);
        String name = "SAT-BundleUninstallManager-" + id;
        Thread thread = new Thread(runnable, name);
        this.setThread(thread);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreadIfNecessary() {
        IQueue queue = this.getUninstallableBundles();
        boolean empty = queue.isEmpty();
        if (empty) {
            return;
        }
        BundleUninstallManager bundleUninstallManager = this;
        synchronized (bundleUninstallManager) {
            Thread thread = this.getThread();
            if (thread != null) {
                return;
            }
            this.startThread();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopThread() {
        Thread thread = this.getThread();
        thread.interrupt();
        try {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setThread(null);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.setThread(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreadIfNecessary() {
        BundleUninstallManager bundleUninstallManager = this;
        synchronized (bundleUninstallManager) {
            Thread thread = this.getThread();
            if (thread == null) {
                return;
            }
            this.stopThread();
        }
    }

    public void uninstall(Bundle bundle) {
        this.checkBundleIdentity(bundle);
        boolean active = this.isBundleState(bundle, 32);
        if (active) {
            this.addToUninstallableBundles(bundle);
        } else {
            this.addToPendingBundles(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallActivePendingBundles() {
        Hashtable map;
        Hashtable hashtable = map = (Hashtable)this.getPendingBundles();
        synchronized (hashtable) {
            Map clone = (Map)map.clone();
            Set keys = clone.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Bundle bundle = (Bundle)map.get(key);
                boolean active = this.isBundleState(bundle, 32);
                if (!active) continue;
                this.uninstallBundle(bundle);
                map.remove(key);
            }
        }
    }

    private void uninstallBundle(Bundle bundle) {
        try {
            bundle.uninstall();
        }
        catch (BundleException exception) {
            Thread thread = Thread.currentThread();
            String id = thread.getName();
            String message = Messages.getString(FAILED_TO_UNINSTALL_BUNDLE_KEY);
            LogUtility.logError(id, message, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallPendingBundle(Bundle bundle) {
        Map map = this.getPendingBundles();
        String key = bundle.getSymbolicName();
        Map map2 = map;
        synchronized (map2) {
            Object value = map.remove(key);
            if (value == null) {
                return;
            }
            this.checkObjectIdentities(bundle, value);
            this.uninstallBundle(bundle);
        }
    }
}

