/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import org.eclipse.soda.sat.core.internal.framework.bundle.BundleDependencyManager;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.record.ServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecordOwner;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.ServiceReferenceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public final class ImportServiceRecord
extends ServiceRecord
implements IImportServiceRecord {
    private static final String FAILED_TO_ACQUIRE_SERVICE_MATCHING_FILTER_KEY = "ImportServiceRecord.FailedToAcquireServiceMatchingFilter";
    private static final String OWNER_ALREADY_EXISTS_KEY = "ImportServiceRecord.OwnerAlreadyExists";
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private static final String UNKNOWN_SERVICE_EVENT_KEY = "ImportServiceRecord.UnknownServiceEvent";
    private static final ServiceReference[] NO_SERVICE_REFERENCES = new ServiceReference[0];
    private Filter filter;
    private String name;
    private IImportServiceRecordOwner owner;
    private ServiceListener serviceListener;
    private ServiceReference serviceReference;

    public ImportServiceRecord(BundleContext bundleContext, String name, Filter filter) {
        super(bundleContext);
        this.setName(name);
        this.basicSetFilter(filter);
    }

    private void acquire() {
        boolean acquired;
        this.registerAsServiceListener();
        ServiceReference reference = this.getServiceReference();
        BundleContext bundleContext = this.getBundleContext();
        if (reference == null) {
            boolean filtered = this.hasFilter();
            if (filtered) {
                reference = this.acquireFilteredServiceFromFramework();
            } else {
                String name = this.getName();
                reference = bundleContext.getServiceReference(name);
            }
        }
        Object service = null;
        if (reference != null) {
            this.setServiceReference(reference);
            service = bundleContext.getService(reference);
        }
        boolean bl = acquired = service != null;
        if (!acquired) {
            return;
        }
        this.setService(service);
        IImportServiceRecordOwner owner = this.getOwner();
        if (owner == null) {
            return;
        }
        owner.serviceAcquired(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(IImportServiceRecordOwner owner) {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            this.setOwner(owner);
            this.acquire();
        }
    }

    private ServiceReference acquireFilteredServiceFromFramework() {
        ServiceReference reference = null;
        ServiceReference[] references = this.getFilteredServiceReferences();
        int length = references.length;
        if (length == 0) {
            this.warnFailedToAcquireFilteredService();
        } else if (length == 1) {
            reference = references[0];
        } else {
            ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
            reference = utility.select(references);
        }
        return reference;
    }

    private void applyFilter() {
        boolean acquired = this.isAcquired();
        if (acquired) {
            Filter filter = this.getFilter();
            if (filter == null) {
                return;
            }
            ServiceReference reference = this.getServiceReference();
            boolean match = filter.match(reference);
            if (match) {
                return;
            }
            this.release(false);
        }
        this.acquire();
    }

    private void basicSetFilter(Filter filter) {
        this.filter = filter;
    }

    private String createServiceFilter() {
        int size = 15;
        String name = this.getName();
        StringBuffer buffer = new StringBuffer(size += name.length());
        buffer.append('(');
        buffer.append("objectClass");
        buffer.append('=');
        buffer.append(name);
        buffer.append(')');
        String result = buffer.toString();
        return result;
    }

    private ServiceListener createServiceListener() {
        return new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                ImportServiceRecord.this.serviceChanged(event);
            }
        };
    }

    protected int createToStringBufferSize() {
        return super.createToStringBufferSize() + 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter() {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            return this.filter;
        }
    }

    private ServiceReference[] getFilteredServiceReferences() {
        BundleContext bundleContext = this.getBundleContext();
        String name = this.getName();
        Filter filter = this.getFilter();
        String filterString = filter.toString();
        ServiceReference[] references = null;
        try {
            references = bundleContext.getServiceReferences(name, filterString);
        }
        catch (InvalidSyntaxException exception) {
            this.handleInvalidSyntaxException(exception);
        }
        if (references == null) {
            references = NO_SERVICE_REFERENCES;
        }
        return references;
    }

    public String getName() {
        return this.name;
    }

    private IImportServiceRecordOwner getOwner() {
        return this.owner;
    }

    private ServiceListener getServiceListener() {
        return this.serviceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference getServiceReference() {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            return this.serviceReference;
        }
    }

    private void handleInvalidSyntaxException(InvalidSyntaxException exception) {
        exception.printStackTrace();
        String message = exception.getMessage();
        LogUtility.logError(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleModifiedService(ServiceReference serviceReference) {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            boolean filtered = this.hasFilter();
            if (!filtered) {
                return;
            }
            this.applyFilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegisteredService(ServiceReference serviceReference) {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            boolean acquired = this.isAcquired();
            if (acquired) {
                return;
            }
            this.acquire();
        }
    }

    private void handleUnknownServiceEvent(ServiceEvent event) {
        String pattern = Messages.getString(UNKNOWN_SERVICE_EVENT_KEY);
        String message = MessageFormatter.format(pattern, event);
        LogUtility.logError(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnregisteringService(ServiceReference serviceReference) {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            ServiceReference reference = this.getServiceReference();
            boolean equal = serviceReference.equals(reference);
            if (!equal) {
                return;
            }
            this.release(false);
            this.acquire();
        }
    }

    private boolean hasFilter() {
        Filter filter = this.getFilter();
        boolean result = filter != null;
        return result;
    }

    public boolean isAcquired() {
        ServiceReference reference = this.getServiceReference();
        boolean acquired = reference != null;
        return acquired;
    }

    private boolean isRegisteredForServiceEvents() {
        ServiceListener listener = this.getServiceListener();
        boolean registered = listener != null;
        return registered;
    }

    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        String name = this.getName();
        buffer.append(", name=");
        buffer.append((Object)name);
        Filter filter = this.getFilter();
        if (filter != null) {
            buffer.append(", filter=");
            buffer.append(filter);
        }
    }

    private void registerAsServiceListener() {
        boolean registered = this.isRegisteredForServiceEvents();
        if (registered) {
            return;
        }
        ServiceListener listener = this.createServiceListener();
        this.setServiceListener(listener);
        BundleContext bundleContext = this.getBundleContext();
        String filter = this.createServiceFilter();
        try {
            bundleContext.addServiceListener(listener, filter);
        }
        catch (InvalidSyntaxException exception) {
            this.handleInvalidSyntaxException(exception);
        }
    }

    private void registerBundleRelationship() {
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        Bundle importer = this.getBundle();
        ServiceReference reference = this.getServiceReference();
        Bundle exporter = reference.getBundle();
        manager.register(importer, exporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            this.release(true);
            this.setOwner(null);
        }
    }

    private void release(boolean unregister) {
        IImportServiceRecordOwner owner;
        ServiceReference reference;
        boolean acquired;
        if (unregister) {
            this.unregisterAsServiceListener();
        }
        if (!(acquired = this.isAcquired())) {
            return;
        }
        BundleContext bundleContext = this.getBundleContext();
        boolean released = bundleContext.ungetService(reference = this.getServiceReference());
        if (released) {
            this.setServiceReference(null);
        }
        if ((owner = this.getOwner()) != null) {
            owner.serviceReleased(this);
        }
        if (acquired = this.isAcquired()) {
            return;
        }
        this.setService(null);
    }

    private void serviceChanged(ServiceEvent event) {
        ServiceReference reference = event.getServiceReference();
        int type = event.getType();
        switch (type) {
            case 2: {
                this.handleModifiedService(reference);
                break;
            }
            case 1: {
                this.handleRegisteredService(reference);
                break;
            }
            case 4: {
                this.handleUnregisteringService(reference);
                break;
            }
            default: {
                this.handleUnknownServiceEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Filter filter) {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            if (this.filter != null && this.filter.equals((Object)filter)) {
                return;
            }
            this.basicSetFilter(filter);
            IImportServiceRecordOwner owner = this.getOwner();
            if (owner == null) {
                return;
            }
            this.applyFilter();
        }
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setOwner(IImportServiceRecordOwner owner) {
        if (this.owner != null && owner != null) {
            String message = Messages.getString(OWNER_ALREADY_EXISTS_KEY);
            throw new RuntimeException(message);
        }
        this.owner = owner;
    }

    private void setServiceListener(ServiceListener serviceListener) {
        this.serviceListener = serviceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServiceReference(ServiceReference serviceReference) {
        ImportServiceRecord importServiceRecord = this;
        synchronized (importServiceRecord) {
            if (this.serviceReference != null) {
                this.unregisterBundleRelationship();
            }
            this.serviceReference = serviceReference;
            if (this.serviceReference != null) {
                this.registerBundleRelationship();
            }
        }
    }

    private void unregisterAsServiceListener() {
        boolean registered = this.isRegisteredForServiceEvents();
        if (!registered) {
            return;
        }
        BundleContext bundleContext = this.getBundleContext();
        ServiceListener listener = this.getServiceListener();
        bundleContext.removeServiceListener(listener);
        this.setServiceListener(null);
    }

    private void unregisterBundleRelationship() {
        ServiceReference reference = this.getServiceReference();
        Bundle exporter = reference.getBundle();
        BundleDependencyManager bdm = BundleDependencyManager.getInstance();
        boolean uninstallable = bdm.isRegisteredAsUninstallable(exporter);
        if (!uninstallable) {
            Bundle importer = this.getBundle();
            bdm.unregister(importer, exporter);
        }
    }

    private void warnFailedToAcquireFilteredService() {
        String component = Messages.getString(SAT_CORE_KEY);
        String pattern = Messages.getString(FAILED_TO_ACQUIRE_SERVICE_MATCHING_FILTER_KEY);
        Bundle bundle = this.getBundle();
        String source = bundle.getSymbolicName();
        String name = this.getName();
        Filter filter = this.getFilter();
        Object[] values = new Object[]{source, name, filter};
        String message = MessageFormatter.format(pattern, values);
        LogUtility.logWarning((Object)component, message);
    }
}

