/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.eclipse.soda.sat.core.record.container.interfaces.IServiceRecordAction;
import org.eclipse.soda.sat.core.record.container.interfaces.IServiceRecordContainer;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;

abstract class ServiceRecordContainer
implements IServiceRecordContainer {
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private static final String RECORD_ALREADY_EXISTS_IN_CONTAINER_KEY = "ServiceRecordContainer.RecordAlreadyExistsInContainer";
    private static final IServiceRecord[] NO_SERVICE_RECORDS = new IServiceRecord[0];
    private static IServiceRecordAction collectAction;
    private static IServiceRecordAction findAction;
    private Map table;
    static /* synthetic */ Class class$0;

    ServiceRecordContainer() {
    }

    private static IServiceRecordAction createCollectAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                Collection records = (Collection)parameter;
                records.add(record);
                return true;
            }
        };
    }

    private static IServiceRecordAction createFindAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                boolean found = record.equals(parameter);
                return !found;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getCollectAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (collectAction == null) {
                ServiceRecordContainer.setCollectAction(ServiceRecordContainer.createCollectAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return collectAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getFindAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (findAction == null) {
                ServiceRecordContainer.setFindAction(ServiceRecordContainer.createFindAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return findAction;
        }
    }

    private static void setCollectAction(IServiceRecordAction collectAction) {
        ServiceRecordContainer.collectAction = collectAction;
    }

    private static void setFindAction(IServiceRecordAction findAction) {
        ServiceRecordContainer.findAction = findAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean add(String key, IServiceRecord record) {
        boolean added = false;
        ServiceRecordContainer serviceRecordContainer = this;
        synchronized (serviceRecordContainer) {
            Object value = this.basicGet(key);
            if (value == null) {
                this.basicAdd(key, record);
                added = true;
            } else {
                boolean exists;
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    exists = collection.contains(record);
                    if (!exists) {
                        added = collection.add(record);
                    }
                } else {
                    boolean bl = exists = value == record;
                    if (!exists) {
                        this.basicRemove(key);
                        ArrayList<Object> composite = new ArrayList<Object>(2);
                        composite.add(value);
                        composite.add(record);
                        this.basicAdd(key, composite);
                        added = true;
                    }
                }
                if (exists) {
                    this.warnRecordAlreadyExists(key, record);
                }
            }
        }
        return added;
    }

    protected final void basicAdd(String key, Object value) {
        Map table = this.getTable();
        table.put(key, value);
    }

    protected final Object basicGet(String key) {
        Map table = this.getTable();
        Object value = table.get(key);
        return value;
    }

    protected final boolean basicRemove(String key) {
        Map table = this.getTable();
        Object value = table.remove(key);
        boolean removed = value != null;
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void basicRemoveAll() {
        ServiceRecordContainer serviceRecordContainer = this;
        synchronized (serviceRecordContainer) {
            this.setTable(null);
        }
    }

    protected final int basicSize() {
        Map table = this.getTable();
        int size = table.size();
        return size;
    }

    public final boolean contains(IServiceRecord record) {
        IServiceRecordAction action = ServiceRecordContainer.getFindAction();
        boolean result = this.doForEach(action, record);
        boolean found = !result;
        return found;
    }

    protected int createStringBufferSize() {
        return 75;
    }

    private Map createTable() {
        int capacity = this.createTableCapacity();
        int capacityIncrement = this.createTableCapacityIncrement();
        Hashtable table = new Hashtable(capacity, capacityIncrement);
        return table;
    }

    protected abstract int createTableCapacity();

    protected int createTableCapacityIncrement() {
        int capacity = this.createTableCapacity() * 2;
        return capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doForEach(IServiceRecordAction action, Object parameter) {
        boolean result = true;
        Map table = this.getTable();
        ServiceRecordContainer serviceRecordContainer = this;
        synchronized (serviceRecordContainer) {
            Set keys = table.keySet();
            Iterator iterator = keys.iterator();
            while (result && iterator.hasNext()) {
                String name = (String)iterator.next();
                result = this.doForService(name, action, parameter);
            }
        }
        return result;
    }

    private boolean doForService(String name, IServiceRecordAction action, Object parameter) {
        Object value = this.basicGet(name);
        if (value == null) {
            return true;
        }
        boolean result = true;
        if (value instanceof Collection) {
            Collection composite = (Collection)value;
            Iterator iterator = composite.iterator();
            while (result && iterator.hasNext()) {
                IServiceRecord record = (IServiceRecord)iterator.next();
                result = action.execute(record, parameter);
            }
        } else {
            IServiceRecord record = (IServiceRecord)value;
            result = action.execute(record, parameter);
        }
        return result;
    }

    public final void empty() {
        this.basicRemoveAll();
    }

    public IServiceRecord get(String name) {
        IServiceRecord[] records = this.getAll(name);
        int length = records.length;
        if (length == 0) {
            return null;
        }
        IServiceRecord record = records[0];
        return record;
    }

    public IServiceRecord get(String name, Object service) {
        if (service == null) {
            return null;
        }
        Object value = this.basicGet(name);
        if (value == null) {
            return null;
        }
        IServiceRecord record = null;
        if (value instanceof Collection) {
            Collection composite = (Collection)value;
            boolean found = false;
            Iterator iterator = composite.iterator();
            while (!found && iterator.hasNext()) {
                record = (IServiceRecord)iterator.next();
                Object recordService = record.getService();
                found = service.equals(recordService);
            }
            if (!found) {
                record = null;
            }
        } else {
            record = (IServiceRecord)value;
        }
        return record;
    }

    public IServiceRecord[] getAll() {
        IServiceRecordAction action = ServiceRecordContainer.getCollectAction();
        ArrayList collection = new ArrayList(10);
        this.doForEach(action, collection);
        int length = collection.size();
        IServiceRecord[] records = new IServiceRecord[length];
        collection.toArray(records);
        return records;
    }

    public IServiceRecord[] getAll(String name) {
        Object value = this.basicGet(name);
        if (value == null) {
            return NO_SERVICE_RECORDS;
        }
        IServiceRecord[] records = null;
        if (value instanceof List) {
            List composite = (List)value;
            int size = composite.size();
            records = new IServiceRecord[size];
            composite.toArray(records);
        } else {
            IServiceRecord record = (IServiceRecord)value;
            records = new IServiceRecord[]{record};
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getTable() {
        ServiceRecordContainer serviceRecordContainer = this;
        synchronized (serviceRecordContainer) {
            if (this.table == null) {
                this.setTable(this.createTable());
            }
        }
        return this.table;
    }

    public final boolean isEmpty() {
        int size = this.size();
        boolean empty = size == 0;
        return empty;
    }

    protected void printOn(StringBuffer buffer) {
        int size = this.size();
        buffer.append(", size=");
        buffer.append(size);
    }

    protected final boolean remove(String key, Object object) {
        Object value = this.basicGet(key);
        if (value == null) {
            return false;
        }
        boolean removed = false;
        if (value instanceof List) {
            List composite = (List)value;
            removed = composite.remove(object);
            if (!removed) {
                return false;
            }
            int size = composite.size();
            if (size < 2) {
                this.basicRemove(key);
                if (size == 1) {
                    Object single = composite.get(0);
                    this.basicAdd(key, single);
                }
            }
        } else if (value == object) {
            removed = this.basicRemove(key);
        }
        return removed;
    }

    private void setTable(Map table) {
        this.table = table;
    }

    public int size() {
        int size = this.basicSize();
        ArrayList records = new ArrayList(size * 2);
        IServiceRecordAction action = ServiceRecordContainer.getCollectAction();
        this.doForEach(action, records);
        size = records.size();
        return size;
    }

    public final String toString() {
        int size = this.createStringBufferSize();
        StringBuffer buffer = new StringBuffer(size);
        buffer.append(super.toString());
        this.printOn(buffer);
        String description = buffer.toString();
        return description;
    }

    private void warnRecordAlreadyExists(String key, IServiceRecord record) {
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        String component = Messages.getString(SAT_CORE_KEY);
        String warning = Messages.getString(RECORD_ALREADY_EXISTS_IN_CONTAINER_KEY);
        String label = "IServiceRecord";
        String message = record.toString();
        utility.warn(component, this, warning, label, message);
    }
}

