/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.soda.sat.core.framework.interfaces.IFileLog;
import org.eclipse.soda.sat.core.framework.interfaces.ILineWriter;
import org.eclipse.soda.sat.core.framework.interfaces.IThreadLocal;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;

public class FileLog
implements IFileLog {
    private static final String ARGUMENT_MUST_NOT_BE_NULL_KEY = "Common.ArgumentMustNotBeNull";
    private static final String CREATED_LOG_FILE_KEY = "FileLog.CreatedLogFile";
    private static final String FILE_IS_NOT_OPEN_KEY = "FileLog.FileIsNotOpen";
    private static final Long DEFAULT_TIME_WRAPPER = new Long(0L);
    private File file;
    private ILineWriter writer;
    private IThreadLocal threadLocal;
    private final Object lock = new Object();

    public FileLog(File file) {
        this.setFile(file);
    }

    private void checkArgumentIsNotNull(String name, Object value) {
        if (value != null) {
            return;
        }
        String pattern = Messages.getString(ARGUMENT_MUST_NOT_BE_NULL_KEY);
        String message = MessageFormatter.format(pattern, name);
        throw new IllegalArgumentException(message);
    }

    private void checkIsOpen() throws IOException {
        boolean open = this.isOpen();
        if (open) {
            return;
        }
        String path = this.getAbsolutePath();
        String pattern = Messages.getString(FILE_IS_NOT_OPEN_KEY);
        String message = MessageFormatter.format(pattern, path);
        throw new IOException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean open = this.isOpen();
            if (!open) {
                return;
            }
            ILineWriter writer = this.getWriter();
            writer.close();
            this.setWriter(null);
        }
    }

    private ILineWriter createLineWriter() throws FileNotFoundException {
        File file = this.getFile();
        String path = file.getAbsolutePath();
        FileOutputStream outputStream = new FileOutputStream(path, false);
        String pattern = Messages.getString(CREATED_LOG_FILE_KEY);
        String message = MessageFormatter.format(pattern, path);
        LogUtility.logInfo(message);
        FactoryUtility utility = FactoryUtility.getInstance();
        ILineWriter writer = utility.createLineWriter(outputStream);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() throws IOException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            File file;
            block4: {
                this.close();
                file = this.getFile();
                boolean exists = file.exists();
                if (exists) break block4;
                return true;
            }
            boolean deleted = file.delete();
            return deleted;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private String formatId(Object id) {
        Class<?> clazz;
        String qualifiedClassName;
        String value = id.toString();
        boolean match = value.startsWith(qualifiedClassName = (clazz = id.getClass()).getName());
        if (match) {
            int index = value.lastIndexOf(46) + 1;
            value = value.substring(index);
        }
        return value;
    }

    private File getFile() {
        return this.file;
    }

    public String getFilename() {
        File file = this.getFile();
        String name = file.getName();
        return name;
    }

    public String getAbsolutePath() {
        File file = this.getFile();
        String path = file.getAbsolutePath();
        return path;
    }

    private Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IThreadLocal getThreadLocal() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            if (this.threadLocal == null) {
                FactoryUtility utility = FactoryUtility.getInstance();
                IThreadLocal threadLocal = utility.createThreadLocal();
                this.setThreadLocal(threadLocal);
            }
        }
        return this.threadLocal;
    }

    private Long getTime() {
        IThreadLocal threadLocal = this.getThreadLocal();
        Long timeWrapper = (Long)threadLocal.get();
        if (timeWrapper == null) {
            timeWrapper = DEFAULT_TIME_WRAPPER;
            this.setTime(timeWrapper);
        }
        return timeWrapper;
    }

    private ILineWriter getWriter() {
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpen() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            ILineWriter writer = this.getWriter();
            boolean open = writer != null;
            return open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Object id, String message) throws IOException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.checkIsOpen();
            this.logMessage(id, message);
        }
    }

    private void logMessage(Object id, String message) throws IOException {
        long now = System.currentTimeMillis();
        Long nowWrapper = new Long(now);
        String nowValue = Long.toString(now);
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        String formattedId = this.formatId(id);
        String delimiter = ", ";
        Long timeWrapper = this.getTime();
        long time = timeWrapper;
        this.setTime(nowWrapper);
        long duration = time == 0L ? 0L : now - time;
        String durationValue = Long.toString(duration);
        ILineWriter writer = this.getWriter();
        writer.write(nowValue);
        writer.write(delimiter);
        writer.write(durationValue);
        writer.write(delimiter);
        writer.write(threadName);
        writer.write(delimiter);
        writer.write(formattedId);
        writer.write(delimiter);
        writer.write(message);
        writer.newLine();
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws FileNotFoundException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean open = this.isOpen();
            if (open) {
                return;
            }
            ILineWriter writer = this.createLineWriter();
            this.setWriter(writer);
        }
    }

    private void setFile(File file) {
        this.checkArgumentIsNotNull("file", file);
        this.file = file;
    }

    private void setThreadLocal(IThreadLocal threadLocal) {
        this.threadLocal = threadLocal;
    }

    private void setTime(Long timeWrapper) {
        IThreadLocal threadLocal = this.getThreadLocal();
        threadLocal.set(timeWrapper);
    }

    private void setWriter(ILineWriter writer) {
        this.writer = writer;
    }

    public String toString() {
        File file = this.getFile();
        String path = file.getAbsolutePath();
        return path;
    }
}

