/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.soda.sat.core.framework.interfaces.IFileLog;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.LogProxy;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.service.log.LogService;

public class LogUtility {
    private static final String LOG_FILENAME_PROPERTY = "org.eclipse.soda.sat.core.util.log.filename";
    private static final String LOG_LEVEL_PROPERTY = "org.eclipse.soda.sat.core.util.logLevel";
    private static final String TRACE_PROPERTY = "org.eclipse.soda.sat.core.util.trace";
    private static final String FAILED_TO_LOG_MESSAGE_TO_FILE_KEY = "LogUtility.FailedToLogMessageToFile";
    private static final String LOG_LEVEL_DEBUG_KEY = "Common.LogLevelDebug";
    private static final String LOG_LEVEL_ERROR_KEY = "Common.LogLevelError";
    private static final String LOG_LEVEL_INFO_KEY = "Common.LogLevelInfo";
    private static final String LOG_LEVEL_WARNING_KEY = "Common.LogLevelWarning";
    private static final String LOG_LEVEL_ERROR_VALUE = Messages.getString("Common.LogLevelError");
    private static final String LOG_LEVEL_WARNING_VALUE = Messages.getString("Common.LogLevelWarning");
    private static final String LOG_LEVEL_INFO_VALUE = Messages.getString("Common.LogLevelInfo");
    private static final String LOG_LEVEL_DEBUG_VALUE;
    private static final String DEFAULT_LOG_FILENAME = "LogUtility.log";
    private static final String DEFAULT_LOG_LEVEL;
    private static final String DEFAULT_TRACE = "false";
    private static final String LOG_FILENAME;
    private static final String LOG_LEVEL;
    private static final boolean TRACE;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final LogUtility INSTANCE;
    private StringBuffer buffer;
    private IFileLog fileLog;
    private LogProxy proxy;
    static /* synthetic */ Class class$0;

    static {
        DEFAULT_LOG_LEVEL = LOG_LEVEL_DEBUG_VALUE = Messages.getString(LOG_LEVEL_DEBUG_KEY);
        LOG_FILENAME = System.getProperty(LOG_FILENAME_PROPERTY, DEFAULT_LOG_FILENAME);
        LOG_LEVEL = System.getProperty(LOG_LEVEL_PROPERTY, DEFAULT_LOG_LEVEL);
        TRACE = Boolean.valueOf(System.getProperty(TRACE_PROPERTY, DEFAULT_TRACE));
        INSTANCE = new LogUtility();
    }

    private static int getInitialLogLevelValue() {
        if (LOG_LEVEL.equalsIgnoreCase(LOG_LEVEL_ERROR_VALUE)) {
            return 1;
        }
        if (LOG_LEVEL.equalsIgnoreCase(LOG_LEVEL_WARNING_VALUE)) {
            return 2;
        }
        if (LOG_LEVEL.equalsIgnoreCase(LOG_LEVEL_INFO_VALUE)) {
            return 3;
        }
        if (LOG_LEVEL.equalsIgnoreCase(LOG_LEVEL_DEBUG_VALUE)) {
            return 4;
        }
        return 4;
    }

    public static LogUtility getInstance() {
        return INSTANCE;
    }

    public static int getLoggingLevel() {
        LogUtility instance = LogUtility.getInstance();
        int level = instance.getLogLevel();
        return level;
    }

    private static boolean isLogging(int level) {
        LogUtility instance = LogUtility.getInstance();
        int threshold = instance.getLogLevel();
        boolean logging = threshold >= level;
        return logging;
    }

    public static boolean isLoggingDebug() {
        return LogUtility.isLogging(4);
    }

    public static boolean isLoggingError() {
        return LogUtility.isLogging(1);
    }

    public static boolean isLoggingInfo() {
        return LogUtility.isLogging(3);
    }

    public static boolean isLoggingWarning() {
        return LogUtility.isLogging(2);
    }

    private static void log(int level, Object id, String message, Throwable throwable) {
        boolean logging = LogUtility.isLogging(level);
        if (!logging) {
            return;
        }
        LogUtility utility = LogUtility.getInstance();
        LogService log = utility.getLog();
        String formattedMessage = utility.formatMessage(id, message);
        log.log(level, formattedMessage, throwable);
    }

    public static void logDebug(Object id, String message) {
        LogUtility.logDebug(id, message, null);
    }

    public static void logDebug(Object id, String message, Throwable throwable) {
        LogUtility.log(4, id, message, throwable);
    }

    public static void logDebug(String message) {
        LogUtility.logDebug(null, message, null);
    }

    public static void logDebug(String message, Throwable throwable) {
        LogUtility.logDebug(null, message, throwable);
    }

    public static void logError(Object id, String message) {
        LogUtility.logError(id, message, null);
    }

    public static void logError(Object id, String message, Throwable throwable) {
        LogUtility.log(1, id, message, throwable);
    }

    public static void logError(String message) {
        LogUtility.logError(null, message, null);
    }

    public static void logError(String message, Throwable throwable) {
        LogUtility.logError(null, message, throwable);
    }

    public static void logInfo(Object id, String message) {
        LogUtility.logInfo(id, message, null);
    }

    public static void logInfo(Object id, String message, Throwable throwable) {
        LogUtility.log(3, id, message, throwable);
    }

    public static void logInfo(String message) {
        LogUtility.logInfo(null, message, null);
    }

    public static void logInfo(String message, Throwable throwable) {
        LogUtility.logInfo(null, message, throwable);
    }

    public static void logTrace(Object id, String message) {
        LogUtility.logTrace(id, message, null);
    }

    public static void logTrace(Object id, String message, Throwable throwable) {
        if (!TRACE) {
            return;
        }
        LogUtility.log(4, id, message, throwable);
    }

    public static void logTrace(String message) {
        LogUtility.logTrace(null, message, null);
    }

    public static void logTrace(String message, Throwable throwable) {
        LogUtility.logTrace(null, message, throwable);
    }

    public static void logWarning(Object id, String message) {
        LogUtility.logWarning(id, message, null);
    }

    public static void logWarning(Object id, String message, Throwable throwable) {
        LogUtility.log(2, id, message, throwable);
    }

    public static void logWarning(String message) {
        LogUtility.logWarning(null, message, null);
    }

    public static void logWarning(String message, Throwable throwable) {
        LogUtility.logWarning(null, message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoggingLevel(int level) {
        LogUtility instance = LogUtility.getInstance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.LogUtility");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            instance.setLogLevel(level);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private LogUtility() {
        this.setProxy(new LogProxy());
        this.setLogLevel(LogUtility.getInitialLogLevelValue());
        this.setBuffer(new StringBuffer(1024));
    }

    private IFileLog createFileLog() {
        FactoryUtility utility = FactoryUtility.getInstance();
        File file = new File(LOG_FILENAME);
        IFileLog fileLog = utility.createFileLog(file);
        return fileLog;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            IFileLog fileLog = this.getFileLog();
            fileLog.close();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.finalize();
    }

    private String formatId(Object id) {
        Class<?> clazz;
        String qualifiedClassName;
        String value = id.toString();
        boolean match = value.startsWith(qualifiedClassName = (clazz = id.getClass()).getName());
        if (match) {
            int index = value.lastIndexOf(46) + 1;
            value = value.substring(index);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatMessage(Object id, String message) {
        String formattedMessage = message;
        if (id != null) {
            StringBuffer buffer;
            String formattedId = this.formatId(id);
            StringBuffer stringBuffer = buffer = this.getBuffer();
            synchronized (stringBuffer) {
                int count = buffer.length();
                buffer.delete(0, count);
                buffer.append(formattedId);
                buffer.append(": ");
                buffer.append(message);
                formattedMessage = buffer.toString();
            }
        }
        return formattedMessage;
    }

    private StringBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFileLog getFileLog() throws FileNotFoundException {
        LogUtility logUtility = this;
        synchronized (logUtility) {
            if (this.fileLog == null) {
                IFileLog fileLog = this.createFileLog();
                this.setFileLog(fileLog);
                fileLog.open();
            }
        }
        return this.fileLog;
    }

    public LogService getLog() {
        LogProxy log = this.getProxy();
        return log;
    }

    private int getLogLevel() {
        LogProxy proxy = this.getProxy();
        int logLevel = proxy.getLogLevel();
        return logLevel;
    }

    private LogProxy getProxy() {
        return this.proxy;
    }

    public void logToFile(Object id, String message) {
        try {
            IFileLog fileLog = this.getFileLog();
            fileLog.log(id, message);
        }
        catch (IOException exception) {
            String pattern = Messages.getString(FAILED_TO_LOG_MESSAGE_TO_FILE_KEY);
            String errorMessage = MessageFormatter.format(pattern, LOG_FILENAME);
            LogUtility.logError(errorMessage, exception);
        }
    }

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    private void setFileLog(IFileLog fileLog) {
        this.fileLog = fileLog;
    }

    public void setLog(LogService log) {
        LogProxy proxy = this.getProxy();
        proxy.setLog(log);
    }

    private void setLogLevel(int logLevel) {
        LogProxy proxy = this.getProxy();
        proxy.setLogLevel(logLevel);
    }

    private void setProxy(LogProxy proxy) {
        this.proxy = proxy;
    }

    public void traceToFile(Object id, String message) {
        if (!TRACE) {
            return;
        }
        this.logToFile(id, message);
    }
}

