/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.IThreadLocal;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.junit.util.ValueHolder;

public class ThreadLocalTestCase
extends AbstractSatTestCase {
    private IThreadLocal threadLocal;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.ThreadLocalTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ThreadLocalTestCase(String name) {
        super(name);
    }

    private Runnable createRunnable(final int value) {
        return new Runnable(){

            public void run() {
                try {
                    ThreadLocalTestCase.this.process(value);
                }
                catch (InterruptedException interruptedException) {
                    Assert.fail((String)"Test interrupted");
                }
            }
        };
    }

    private void process(int value) throws InterruptedException {
        Thread thread = Thread.currentThread();
        ThreadLocalValueHolder object = ThreadLocalValueHolder.valueOf(thread, value);
        this.threadLocal.set((Object)object);
        Thread.yield();
        ThreadLocalValueHolder holder = (ThreadLocalValueHolder)((Object)this.threadLocal.get());
        Thread expectedThread = thread;
        Thread actualThread = holder.getThread();
        Assert.assertSame((Object)expectedThread, (Object)actualThread);
        int expectedInt = value;
        int actualInt = holder.getInt();
        Assert.assertEquals((int)expectedInt, (int)actualInt);
        Thread.yield();
        object = ThreadLocalValueHolder.valueOf(thread, value * value);
        this.threadLocal.set((Object)object);
        Thread.yield();
        holder = (ThreadLocalValueHolder)((Object)this.threadLocal.get());
        expectedThread = thread;
        actualThread = holder.getThread();
        Assert.assertSame((Object)expectedThread, (Object)actualThread);
        expectedInt = value * value;
        actualInt = holder.getInt();
        Assert.assertEquals((int)expectedInt, (int)actualInt);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.threadLocal = AbstractSatTestCase.FACTORY.createThreadLocal();
    }

    private Thread startThread(int value) {
        Runnable runnable = this.createRunnable(value);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.ThreadLocalTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String name = String.valueOf(clazz.getName()) + '-' + String.valueOf(value);
        Thread thread = new Thread(runnable, name);
        thread.start();
        return thread;
    }

    protected void tearDown() throws Exception {
        this.threadLocal = null;
        super.tearDown();
    }

    public void test() throws InterruptedException {
        Thread thread;
        int count = 25;
        ArrayList<Thread> threads = new ArrayList<Thread>(count);
        int i = 0;
        while (i < count) {
            thread = this.startThread(i);
            threads.add(thread);
            ++i;
        }
        Iterator iterator = threads.iterator();
        while (iterator.hasNext()) {
            thread = (Thread)iterator.next();
            thread.join();
        }
    }

    private static class ThreadLocalValueHolder
    extends ValueHolder {
        private int intValue;

        static ThreadLocalValueHolder valueOf(Thread thread, int intValue) {
            return new ThreadLocalValueHolder(thread, intValue);
        }

        private ThreadLocalValueHolder(Thread thread, int intValue) {
            super((Object)thread);
            this.setIntValue(intValue);
        }

        int getInt() {
            return this.intValue;
        }

        Thread getThread() {
            return (Thread)this.getValue();
        }

        private void setIntValue(int intValue) {
            this.intValue = intValue;
        }
    }
}

