/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.record.ServiceRecordDelegate;
import org.eclipse.soda.sat.core.record.interfaces.IExportProxyServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ExportProxyServiceRecord
extends ServiceRecordDelegate
implements IExportProxyServiceRecord {
    private static final String RECORD_MUST_NOT_BE_REGISTERED_KEY = "ExportProxyServiceRecord.RecordMustNotBeRegistered";
    private static final String RECORD_MUST_NOT_HAVE_SERVICE_OBJECT_KEY = "ExportProxyServiceRecord.RecordMustNotHaveServiceObject";
    private static final String RECORD_MUST_NOT_REPRESENT_PROXY_SERVICE_KEY = "ExportProxyServiceRecord.RecordMustNotRepresentProxyService";
    private IProxyServiceHandler handler;
    private Object proxyService;

    public ExportProxyServiceRecord(BundleContext bundleContext, Class[] interfaceTypes, IProxyServiceHandler handler, Dictionary properties) {
        this(null, handler);
        IExportServiceRecord record = this.createExportServiceRecord(bundleContext, interfaceTypes, properties);
        this.setServiceRecord(record);
    }

    public ExportProxyServiceRecord(IExportServiceRecord record, Class[] interfaceTypes, IProxyServiceHandler handler) {
        this(record, handler);
        Object service = this.createService(interfaceTypes);
        record.setService(service);
    }

    private ExportProxyServiceRecord(IExportServiceRecord record, IProxyServiceHandler handler) {
        super(record);
        this.setHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object basicGetProxyService() {
        ExportProxyServiceRecord exportProxyServiceRecord = this;
        synchronized (exportProxyServiceRecord) {
            return this.proxyService;
        }
    }

    protected void checkIsValidServiceRecord() {
        IExportServiceRecord record = this.getExportServiceRecord();
        if (record == null) {
            return;
        }
        super.checkIsValidServiceRecord();
        boolean hasService = record.hasService();
        if (hasService) {
            String message = Messages.getString(RECORD_MUST_NOT_HAVE_SERVICE_OBJECT_KEY);
            throw new IllegalArgumentException(message);
        }
        boolean registered = record.isRegistered();
        if (registered) {
            String message = Messages.getString(RECORD_MUST_NOT_BE_REGISTERED_KEY);
            throw new IllegalArgumentException(message);
        }
        boolean proxy = record.isProxy();
        if (proxy) {
            String message = Messages.getString(RECORD_MUST_NOT_REPRESENT_PROXY_SERVICE_KEY);
            throw new IllegalArgumentException(message);
        }
    }

    private InvocationHandler createExportedProxyServiceHandler() {
        return new InvocationHandler(){

            public Object invoke(Object service, Method method, Object[] args) throws Throwable {
                Object result = ExportProxyServiceRecord.this.handleExportedProxyServiceMethod(method, args);
                return result;
            }
        };
    }

    private IExportServiceRecord createExportServiceRecord(BundleContext bundleContext, Class[] interfaceTypes, Dictionary properties) {
        String[] names = this.getServiceInterfaceNames(interfaceTypes);
        Object service = this.createService(interfaceTypes);
        IExportServiceRecord record = this.createExportServiceRecord(bundleContext, names, service, properties);
        return record;
    }

    private IExportServiceRecord createExportServiceRecord(BundleContext bundleContext, String[] names, Object service, Dictionary properties) {
        FactoryUtility utility = FactoryUtility.getInstance();
        IExportServiceRecord record = utility.createExportServiceRecord(bundleContext, names, service, properties);
        return record;
    }

    private Object createProxyService() {
        IProxyServiceHandler handler = this.getHandler();
        Object service = handler.createService();
        return service;
    }

    private Object createService(Class[] interfaceTypes) {
        Class interfaceType = interfaceTypes[0];
        ClassLoader loader = interfaceType.getClassLoader();
        InvocationHandler handler = this.createExportedProxyServiceHandler();
        Object service = Proxy.newProxyInstance(loader, interfaceTypes, handler);
        return service;
    }

    protected int createToStringBufferSize() {
        return super.createToStringBufferSize() + 100;
    }

    private IExportServiceRecord getExportServiceRecord() {
        IServiceRecord record = this.getServiceRecord();
        IExportServiceRecord exportServiceRecord = (IExportServiceRecord)record;
        return exportServiceRecord;
    }

    private IProxyServiceHandler getHandler() {
        return this.handler;
    }

    public String[] getNames() {
        IExportServiceRecord record = this.getExportServiceRecord();
        String[] names = record.getNames();
        return names;
    }

    public Dictionary getProperties() {
        IExportServiceRecord record = this.getExportServiceRecord();
        Dictionary properties = record.getProperties();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getProxyService() {
        ExportProxyServiceRecord exportProxyServiceRecord = this;
        synchronized (exportProxyServiceRecord) {
            Object service = this.basicGetProxyService();
            if (service == null) {
                service = this.createProxyService();
                this.setProxyService(service);
            }
        }
        return this.proxyService;
    }

    public Object getService() {
        Object service = this.getProxyService();
        return service;
    }

    private String[] getServiceInterfaceNames(Class[] interfaceTypes) {
        int count = interfaceTypes.length;
        String[] names = new String[count];
        int i = 0;
        while (i < count) {
            String name;
            Class interfaceType = interfaceTypes[i];
            names[i] = name = interfaceType.getName();
            ++i;
        }
        return names;
    }

    public ServiceReference getServiceReference() {
        IExportServiceRecord record = this.getExportServiceRecord();
        ServiceReference reference = record.getServiceReference();
        return reference;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object handleExportedProxyServiceMethod(Method method, Object[] args) throws Throwable {
        Object result;
        IProxyServiceHandler handler = this.getHandler();
        Object service = this.getProxyService();
        handler.preInvoke(service, method, args);
        try {
            try {
                result = method.invoke(service, args);
            }
            catch (InvocationTargetException exception) {
                Throwable target = exception.getTargetException();
                throw target;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            handler.postInvoke(service, method, args);
            throw throwable;
        }
        {
            Object var8_10 = null;
            handler.postInvoke(service, method, args);
            return result;
        }
    }

    public boolean isProxy() {
        return true;
    }

    public boolean isRegistered() {
        IExportServiceRecord record = this.getExportServiceRecord();
        boolean registered = record.isRegistered();
        return registered;
    }

    public boolean isServiceCreated() {
        Object service = this.basicGetProxyService();
        boolean created = service != null;
        return created;
    }

    protected void printOn(StringBuffer buffer) {
        IProxyServiceHandler handler = this.getHandler();
        buffer.append(", handler=");
        buffer.append(handler);
        Object serviceDelegate = null;
        buffer.append(", proxyService=");
        boolean created = this.isServiceCreated();
        if (created) {
            serviceDelegate = this.getProxyService();
        }
        buffer.append(serviceDelegate);
    }

    public void register() {
        IExportServiceRecord record = this.getExportServiceRecord();
        record.register();
    }

    private void setHandler(IProxyServiceHandler handler) {
        this.handler = handler;
    }

    public void setProperties(Dictionary properties) {
        IExportServiceRecord record = this.getExportServiceRecord();
        record.setProperties(properties);
    }

    private void setProxyService(Object proxyService) {
        this.proxyService = proxyService;
    }

    public void setService(Object service) {
        throw new UnsupportedOperationException();
    }

    public void unregister() {
        IExportServiceRecord record = this.getExportServiceRecord();
        record.unregister();
    }
}

