/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleDependencyManager;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.record.interfaces.ServiceDetecterListener;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ServiceDetecter
implements IServiceDetecter {
    private boolean acquired;
    private BundleContext bundleContext;
    private Filter filter;
    private List listeners;
    private String name;
    private ServiceListener serviceListener;
    private Map servicesMap;
    private final Object acquireLock = new Object();

    public ServiceDetecter(BundleContext bundleContext, String name) {
        this.setAcquired(false);
        this.setBundleContext(bundleContext);
        this.setListeners(new ArrayList(3));
        this.setName(name);
        this.setServicesMap(new Hashtable(101));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        Object lock;
        Object object = lock = this.getAcquireLock();
        synchronized (object) {
            boolean acquired = this.isAcquired();
            if (acquired) {
                return;
            }
            this.setAcquired(true);
            this.registerServiceListener();
            this.loadServiceMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceDetecterListener(ServiceDetecterListener listener) {
        List listeners;
        List list = listeners = this.getListeners();
        synchronized (list) {
            boolean exists = listeners.contains(listener);
            if (exists) {
                return;
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceReference(ServiceReference reference) {
        Map map;
        BundleContext bundleContext = this.getBundleContext();
        Object service = bundleContext.getService(reference);
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            map.put(reference, service);
        }
        this.registerBundleRelationship(reference);
        this.notifyListenersOfServiceAdded(reference, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilter() {
        Map lock;
        boolean acquired = this.isAcquired();
        if (!acquired) {
            return;
        }
        Map map = lock = this.getServicesMap();
        synchronized (map) {
            Iterator iterator = this.getServicesMapKeyIterator();
            while (iterator.hasNext()) {
                ServiceReference reference = (ServiceReference)iterator.next();
                this.handleServiceModified(reference);
            }
        }
        this.loadServiceMap();
    }

    private String createServiceFilter() {
        String result = null;
        String name = this.getName();
        if (name != null) {
            int size = 15;
            StringBuffer buffer = new StringBuffer(size += name.length());
            buffer.append('(');
            buffer.append("objectClass");
            buffer.append('=');
            buffer.append(name);
            buffer.append(')');
            result = buffer.toString();
        }
        return result;
    }

    private ServiceListener createServiceListener() {
        return new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                int type = event.getType();
                ServiceReference reference = event.getServiceReference();
                ServiceDetecter.this.serviceChanged(type, reference);
            }
        };
    }

    private Object getAcquireLock() {
        return this.acquireLock;
    }

    private Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        return bundle;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private Filter getFilter() {
        return this.filter;
    }

    private List getListeners() {
        return this.listeners;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceListener getServiceListener() {
        ServiceDetecter serviceDetecter = this;
        synchronized (serviceDetecter) {
            if (this.serviceListener == null) {
                this.setServiceListener(this.createServiceListener());
            }
        }
        return this.serviceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServiceReferences() {
        Map map;
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            Set references = map.keySet();
            ArrayList list = new ArrayList(references);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getServiceReferences(Filter filter) {
        Map map;
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            int size = map.size();
            ArrayList<ServiceReference> list = new ArrayList<ServiceReference>(size);
            Iterator iterator = this.getServicesMapKeyIterator();
            while (iterator.hasNext()) {
                ServiceReference reference = (ServiceReference)iterator.next();
                boolean match = filter.match(reference);
                if (!match) continue;
                list.add(reference);
            }
            list.trimToSize();
            return list;
        }
    }

    public List getServiceReferences(String filter) throws InvalidSyntaxException {
        BundleContext bundleContext = this.getBundleContext();
        Filter serviceReferenceFilter = bundleContext.createFilter(filter);
        List list = this.getServiceReferences(serviceReferenceFilter);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServices() {
        Map map;
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            Collection values = map.values();
            ArrayList services = new ArrayList(values);
            return services;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServices(String filter) throws InvalidSyntaxException {
        Map map;
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            List references = this.getServiceReferences(filter);
            int size = references.size();
            ArrayList services = new ArrayList(size);
            Iterator iterator = references.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Object service = map.get(key);
                services.add(service);
            }
            return services;
        }
    }

    private Map getServicesMap() {
        return this.servicesMap;
    }

    private Iterator getServicesMapKeyIterator() {
        Hashtable map = (Hashtable)this.getServicesMap();
        Map clone = (Map)map.clone();
        Set set = clone.keySet();
        Iterator iterator = set.iterator();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceModified(ServiceReference reference) {
        Object service;
        Map map;
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            service = map.get(reference);
        }
        if (service == null) {
            this.handleServiceRegistered(reference);
        } else {
            boolean match = this.isMatchingService(reference);
            if (match) {
                return;
            }
            this.handleServiceUnregistering(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceRegistered(ServiceReference reference) {
        Map map;
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            boolean exists = map.containsKey(reference);
            if (exists) {
                return;
            }
            boolean match = this.isMatchingService(reference);
            if (!match) {
                return;
            }
            this.addServiceReference(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceUnregistering(ServiceReference reference) {
        Map map;
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            boolean exists = map.containsKey(reference);
            if (!exists) {
                return;
            }
            this.removeServiceReference(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcquired() {
        Object lock;
        Object object = lock = this.getAcquireLock();
        synchronized (object) {
            return this.acquired;
        }
    }

    private boolean isMatchingService(ServiceReference reference) {
        boolean match = reference != null;
        Filter filter = this.getFilter();
        if (filter != null) {
            match = filter.match(reference);
        }
        return match;
    }

    private void loadServiceMap() {
        BundleContext bundleContext = this.getBundleContext();
        try {
            String name = this.getName();
            ServiceReference[] references = bundleContext.getServiceReferences(name, null);
            if (references == null) {
                return;
            }
            int i = 0;
            while (i < references.length) {
                ServiceReference reference = references[i];
                this.serviceChanged(1, reference);
                ++i;
            }
        }
        catch (InvalidSyntaxException exception) {
            String message = exception.getMessage();
            LogUtility.logError(this, message, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfServiceAdded(ServiceReference reference, Object service) {
        List listeners;
        List list = listeners = this.getListeners();
        synchronized (list) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ServiceDetecterListener listener = (ServiceDetecterListener)iterator.next();
                listener.serviceAdded(this, reference, service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfServiceRemoved(ServiceReference reference, Object service) {
        List listeners;
        List list = listeners = this.getListeners();
        synchronized (list) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ServiceDetecterListener listener = (ServiceDetecterListener)iterator.next();
                listener.serviceRemoved(this, reference, service);
            }
        }
    }

    private void registerBundleRelationship(ServiceReference reference) {
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        Bundle importer = this.getBundle();
        Bundle exporter = reference.getBundle();
        manager.register(importer, exporter);
    }

    private void registerServiceListener() {
        BundleContext bundleContext = this.getBundleContext();
        ServiceListener listener = this.getServiceListener();
        String serviceFilter = this.createServiceFilter();
        try {
            bundleContext.addServiceListener(listener, serviceFilter);
        }
        catch (InvalidSyntaxException exception) {
            String message = exception.getMessage();
            LogUtility.logError(this, message, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object lock;
        Object object = lock = this.getAcquireLock();
        synchronized (object) {
            boolean acquired = this.isAcquired();
            if (!acquired) {
                return;
            }
            this.unloadServiceMap();
            this.unregisterServiceListener();
            this.setAcquired(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceDetecterListener(ServiceDetecterListener listener) {
        List listeners;
        List list = listeners = this.getListeners();
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServiceReference(ServiceReference reference) {
        Object service;
        Map map;
        BundleContext bundleContext = this.getBundleContext();
        bundleContext.ungetService(reference);
        Map map2 = map = this.getServicesMap();
        synchronized (map2) {
            service = map.remove(reference);
        }
        this.unregisterBundleRelationship(reference);
        this.notifyListenersOfServiceRemoved(reference, service);
    }

    private void serviceChanged(int type, ServiceReference reference) {
        boolean acquired = this.isAcquired();
        if (!acquired) {
            return;
        }
        switch (type) {
            case 1: {
                this.handleServiceRegistered(reference);
                break;
            }
            case 4: {
                this.handleServiceUnregistering(reference);
                break;
            }
            case 2: {
                this.handleServiceModified(reference);
                break;
            }
        }
    }

    private void setAcquired(boolean acquired) {
        this.acquired = acquired;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFilter(Filter filter) {
        ServiceDetecter serviceDetecter = this;
        synchronized (serviceDetecter) {
            if (this.filter != null && this.filter.equals((Object)filter)) {
                return;
            }
            this.filter = filter;
            this.applyFilter();
        }
    }

    public void setFilter(String filter) throws InvalidSyntaxException {
        BundleContext bundleContext = this.getBundleContext();
        Filter importFilter = null;
        if (filter != null) {
            importFilter = bundleContext.createFilter(filter);
        }
        this.setFilter(importFilter);
    }

    private void setListeners(List listeners) {
        this.listeners = listeners;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setServiceListener(ServiceListener serviceListener) {
        this.serviceListener = serviceListener;
    }

    private void setServicesMap(Map servicesMap) {
        this.servicesMap = servicesMap;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        String name = this.getName();
        buffer.append(", name = ");
        buffer.append(name);
        Filter filter = this.getFilter();
        buffer.append(", filter = ");
        buffer.append(filter);
        String description = buffer.toString();
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadServiceMap() {
        Map lock;
        Map map = lock = this.getServicesMap();
        synchronized (map) {
            Iterator iterator = this.getServicesMapKeyIterator();
            while (iterator.hasNext()) {
                ServiceReference serviceReference = (ServiceReference)iterator.next();
                this.serviceChanged(4, serviceReference);
            }
        }
    }

    private void unregisterBundleRelationship(ServiceReference reference) {
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        Bundle exporter = reference.getBundle();
        Bundle importer = this.getBundle();
        manager.unregister(importer, exporter);
    }

    private void unregisterServiceListener() {
        BundleContext bundleContext = this.getBundleContext();
        ServiceListener listener = this.getServiceListener();
        bundleContext.removeServiceListener(listener);
    }
}

