/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.framework.interfaces.IQueue;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;

public class Queue
implements IQueue {
    private static final String ARGUMENT_MUST_NOT_BE_NULL = "Common.ArgumentMustNotBeNull";
    private static final String TIMEOUT_MUST_BE_GREATER_THAN_OR_EQUAL_TO_ZERO_KEY = "Queue.TimeoutMustBeGreaterThanOrEqualToZero";
    private List items;

    public Queue(int capacity) {
        this.setItems(new ArrayList(capacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object item) {
        this.checkArgumentIsNotNull("item", item);
        List items = this.getItems();
        Queue queue = this;
        synchronized (queue) {
            items.add(item);
            this.notifyAll();
        }
    }

    private void checkArgumentIsNotNull(String name, Object value) {
        if (value != null) {
            return;
        }
        String pattern = Messages.getString(ARGUMENT_MUST_NOT_BE_NULL);
        String message = MessageFormatter.format(pattern, name);
        throw new IllegalArgumentException(message);
    }

    private void checkTimeout(long timeout) {
        if (timeout >= 0L) {
            return;
        }
        String message = Messages.getString(TIMEOUT_MUST_BE_GREATER_THAN_OR_EQUAL_TO_ZERO_KEY);
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object item) {
        this.checkArgumentIsNotNull("item", item);
        List items = this.getItems();
        Iterator iterator = items.iterator();
        boolean exists = false;
        Queue queue = this;
        synchronized (queue) {
            while (!exists && iterator.hasNext()) {
                Object object = iterator.next();
                boolean bl = exists = object == item;
            }
        }
        return exists;
    }

    private List getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        List items = this.getItems();
        boolean empty = items.isEmpty();
        return empty;
    }

    public Object remove() throws InterruptedException {
        long timeout = 0L;
        Object item = this.remove(timeout);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long timeout) throws InterruptedException {
        List items = this.getItems();
        Object item = null;
        Queue queue = this;
        synchronized (queue) {
            boolean notEmpty = this.waitUntilNotEmpty(timeout);
            if (notEmpty) {
                item = items.get(0);
                items.remove(0);
            }
        }
        return item;
    }

    private void setItems(List items) {
        this.items = items;
    }

    public int size() {
        List items = this.getItems();
        int size = items.size();
        return size;
    }

    private boolean waitUntilNotEmpty(long timeout) throws InterruptedException {
        this.checkTimeout(timeout);
        long startTime = System.currentTimeMillis();
        long duration = 0L;
        while (this.isEmpty()) {
            if (timeout == 0L) {
                this.wait();
                continue;
            }
            if (duration >= timeout) {
                return false;
            }
            this.wait(timeout);
            long wakeTime = System.currentTimeMillis();
            duration = wakeTime - startTime;
        }
        return true;
    }
}

