/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.dependency.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.sat.core.framework.interfaces.BundleDependencyListener;
import org.eclipse.soda.sat.core.service.BundleDependencyService;
import org.eclipse.soda.sat.core.util.BundleUtility;
import org.eclipse.soda.sat.core.util.ServiceReferenceUtility;
import org.eclipse.soda.sat.dependency.internal.model.interfaces.BundleDependencyModelListener;
import org.eclipse.soda.sat.dependency.internal.model.interfaces.IBundleDependencyModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;

public class BundleDependencyModel
implements IBundleDependencyModel {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char OPEN_SQUARE_BRACKED = '[';
    private static final char UNINSTALLABLE_DECORATOR = '*';
    private BundleContext bundleContext;
    private Comparator bundleIdComparator;
    private BundleListener bundleListener;
    private BundleDependencyService dependency;
    private BundleDependencyListener dependencyListener;
    private Map installedBundlesTable;
    private List listeners;

    public BundleDependencyModel(BundleContext context) {
        this.setBundleContext(context);
        this.setListeners(new ArrayList(5));
        this.setBundleListener(this.createBundleListener());
        this.setInstalledBundlesTable(new Hashtable(50));
        this.setDependencyListener(this.createDependencyListener());
    }

    public void addBundleDependencyModelListener(BundleDependencyModelListener listener) {
        List listeners = this.getListeners();
        listeners.add(listener);
    }

    private void addToInstalledBundlesTable(Bundle bundle) {
        Map bundles = this.getInstalledBundlesTable();
        String key = bundle.getSymbolicName();
        bundles.put(key, bundle);
    }

    public void bind(BundleDependencyService dependency) {
        this.setDependency(dependency);
        this.registerAsBundleListener();
        this.buildBundleTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBundleTable() {
        BundleContext context = this.getBundleContext();
        Bundle[] bundles = context.getBundles();
        int count = bundles.length;
        int size = count * 2;
        size = Math.max(size, 75);
        Hashtable table = new Hashtable(size);
        this.setInstalledBundlesTable(table);
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            int i = 0;
            while (i < count) {
                Bundle bundle = bundles[i];
                this.addToInstalledBundlesTable(bundle);
                ++i;
            }
        }
    }

    private void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Bundle bundle = event.getBundle();
        switch (type) {
            case 1: {
                this.handleInstall(bundle);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                this.handleUninstall(bundle);
                break;
            }
        }
    }

    private Comparator createBundleIdComparator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                long id2;
                int result = 0;
                Bundle bundle1 = (Bundle)object1;
                Bundle bundle2 = (Bundle)object2;
                long id1 = bundle1.getBundleId();
                long diff = id1 - (id2 = bundle2.getBundleId());
                if (diff > 0L) {
                    result = 1;
                } else if (diff < 0L) {
                    result = -1;
                }
                return result;
            }
        };
    }

    private BundleListener createBundleListener() {
        return new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                BundleDependencyModel.this.bundleChanged(event);
            }
        };
    }

    private BundleDependencyListener createDependencyListener() {
        return new BundleDependencyListener(){

            public void registered(Bundle importer, Bundle exporter) {
                BundleDependencyModel.this.handleRegistered(importer, exporter);
            }

            public void unregistered(Bundle importer, Bundle exporter) {
                BundleDependencyModel.this.handleUnregistered(importer, exporter);
            }
        };
    }

    private void destroyBundleTable() {
        Map table = this.getInstalledBundlesTable();
        table.clear();
    }

    public List getAllDependentsOf(String bundleSymbolicName) {
        List names;
        BundleDependencyService dependency = this.getDependency();
        Bundle bundle = this.getBundle(bundleSymbolicName);
        if (bundle == null) {
            names = new ArrayList(0);
        } else {
            List bundles = dependency.getAllDependentOf(bundle);
            names = this.getBundleSymbolicNames(bundles, true, true);
        }
        return names;
    }

    public List getAllPrerequisitesOf(String bundleSymbolicName) {
        List names;
        BundleDependencyService dependency = this.getDependency();
        Bundle bundle = this.getBundle(bundleSymbolicName);
        if (bundle == null) {
            names = new ArrayList(0);
        } else {
            List bundles = dependency.getAllPrerequisitesOf(bundle);
            names = this.getBundleSymbolicNames(bundles, true, true);
        }
        return names;
    }

    private Bundle getBundle(String bundleSymbolicName) {
        Bundle bundle = null;
        if (bundleSymbolicName != null) {
            String key = this.removeSuffixFrom(bundleSymbolicName);
            Map bundles = this.getInstalledBundlesTable();
            bundle = (Bundle)bundles.get(key);
        }
        return bundle;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparator getBundleIdComparator() {
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            if (this.bundleIdComparator == null) {
                this.setBundleIdComparator(this.createBundleIdComparator());
            }
        }
        return this.bundleIdComparator;
    }

    private BundleListener getBundleListener() {
        return this.bundleListener;
    }

    public List getBundles() {
        Map bundlesTable = this.getInstalledBundlesTable();
        Collection values = bundlesTable.values();
        ArrayList list = new ArrayList(values);
        this.sortByBundleId(list);
        List names = this.getBundleSymbolicNames(list, false, false);
        return names;
    }

    private List getBundleSymbolicNames(Collection bundles, boolean sorted, boolean uninstallableFlag) {
        int count = bundles.size();
        ArrayList<String> result = new ArrayList<String>(count);
        Iterator iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = (Bundle)iterator.next();
            String bundleSymbolicName = this.toString(bundle, uninstallableFlag);
            result.add(bundleSymbolicName);
        }
        if (sorted) {
            Collections.sort(result);
        }
        return result;
    }

    private BundleDependencyService getDependency() {
        return this.dependency;
    }

    private BundleDependencyListener getDependencyListener() {
        return this.dependencyListener;
    }

    public List getDependentsOf(String bundleSymbolicName) {
        List names;
        BundleDependencyService dependency = this.getDependency();
        Bundle bundle = this.getBundle(bundleSymbolicName);
        if (bundle == null) {
            names = new ArrayList(0);
        } else {
            List bundles = dependency.getDependentOf(bundle);
            names = this.getSymbolicNames(bundles);
        }
        return names;
    }

    private Map getInstalledBundlesTable() {
        return this.installedBundlesTable;
    }

    private List getListeners() {
        return this.listeners;
    }

    public List getPrerequisitesOf(String bundleSymbolicName) {
        List names;
        BundleDependencyService dependency = this.getDependency();
        Bundle bundle = this.getBundle(bundleSymbolicName);
        if (bundle == null) {
            names = new ArrayList(0);
        } else {
            List bundles = dependency.getPrerequisitesOf(bundle);
            names = this.getSymbolicNames(bundles);
        }
        return names;
    }

    private ServiceReference[] getRegisteredServicesOf(String bundleSymbolicName) {
        Bundle bundle = this.getBundle(bundleSymbolicName);
        ServiceReference[] serviceReferences = bundle.getRegisteredServices();
        return serviceReferences;
    }

    private long[] getServiceIds(ServiceReference[] serviceReferences) {
        if (serviceReferences == null) {
            return new long[0];
        }
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        long[] ids = utility.getServiceIds(serviceReferences);
        return ids;
    }

    public long[] getServiceIdsExportedBy(String bundleSymbolicName) {
        ServiceReference[] serviceReferences = this.getRegisteredServicesOf(bundleSymbolicName);
        long[] ids = this.getServiceIds(serviceReferences);
        return ids;
    }

    public long[] getServiceIdsImportedBy(String bundleSymbolicName) {
        ServiceReference[] serviceReferences = this.getServicesInUseBy(bundleSymbolicName);
        long[] ids = this.getServiceIds(serviceReferences);
        return ids;
    }

    private List getServiceNames(ServiceReference[] serviceReferences) {
        if (serviceReferences == null) {
            return new ArrayList(0);
        }
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        ArrayList list = new ArrayList(serviceReferences.length * 4);
        int i = 0;
        while (i < serviceReferences.length) {
            ServiceReference serviceReference = serviceReferences[i];
            List names = utility.getServiceNames(serviceReference);
            list.addAll(names);
            ++i;
        }
        list.trimToSize();
        return list;
    }

    public List getServiceNamesExportedBy(String bundleSymbolicName) {
        ServiceReference[] serviceReferences = this.getRegisteredServicesOf(bundleSymbolicName);
        List names = this.getServiceNames(serviceReferences);
        return names;
    }

    public List getServiceNamesImportedBy(String bundleSymbolicName) {
        ServiceReference[] serviceReferences = this.getServicesInUseBy(bundleSymbolicName);
        List names = this.getServiceNames(serviceReferences);
        return names;
    }

    private ServiceReference[] getServicesInUseBy(String bundleSymbolicName) {
        Bundle bundle = this.getBundle(bundleSymbolicName);
        ServiceReference[] serviceReferences = bundle.getServicesInUse();
        return serviceReferences;
    }

    private List getSymbolicNames(List bundles) {
        List names = this.getBundleSymbolicNames(bundles, true, true);
        return names;
    }

    private void handleInstall(Bundle bundle) {
        this.addToInstalledBundlesTable(bundle);
        this.informListenersOfInstalledBundle(bundle);
    }

    private void handleRegistered(Bundle importer, Bundle exporter) {
        this.informListenersOfRegistration(importer, exporter);
    }

    private void handleUninstall(Bundle bundle) {
        this.removeFromInstalledBundlesTable(bundle);
        this.informListenersOfUninstalledBundle(bundle);
    }

    private void handleUnregistered(Bundle importer, Bundle exporter) {
        this.informListenersOfUnregistration(importer, exporter);
    }

    private void informListenersOfInstalledBundle(Bundle bundle) {
        ArrayList listeners = (ArrayList)this.getListeners();
        Collection clone = (Collection)listeners.clone();
        Iterator iterator = clone.iterator();
        String bundleSymbolicName = this.toString(bundle, false);
        while (iterator.hasNext()) {
            BundleDependencyModelListener listener = (BundleDependencyModelListener)iterator.next();
            listener.addedBundle(bundleSymbolicName);
        }
    }

    private void informListenersOfRegistration(Bundle importer, Bundle exporter) {
        String importerSymbolicName = this.toString(importer, false);
        String exporterSymbolicName = this.toString(exporter, false);
        ArrayList listeners = (ArrayList)this.getListeners();
        Collection clone = (Collection)listeners.clone();
        Iterator iterator = clone.iterator();
        while (iterator.hasNext()) {
            BundleDependencyModelListener listener = (BundleDependencyModelListener)iterator.next();
            listener.registered(importerSymbolicName, exporterSymbolicName);
        }
    }

    private void informListenersOfUninstalledBundle(Bundle bundle) {
        ArrayList listeners = (ArrayList)this.getListeners();
        Collection clone = (Collection)listeners.clone();
        Iterator iterator = clone.iterator();
        String bundleSymbolicName = this.toString(bundle, false);
        while (iterator.hasNext()) {
            BundleDependencyModelListener listener = (BundleDependencyModelListener)iterator.next();
            listener.removedBundle(bundleSymbolicName);
        }
    }

    private void informListenersOfUnregistration(Bundle importer, Bundle exporter) {
        String importerSymbolicName = this.toString(importer, false);
        String exporterSymbolicName = this.toString(exporter, false);
        ArrayList listeners = (ArrayList)this.getListeners();
        Collection clone = (Collection)listeners.clone();
        Iterator iterator = clone.iterator();
        while (iterator.hasNext()) {
            BundleDependencyModelListener listener = (BundleDependencyModelListener)iterator.next();
            listener.unregistered(importerSymbolicName, exporterSymbolicName);
        }
    }

    public boolean isActive(String bundleSymbolicName) {
        Bundle bundle = this.getBundle(bundleSymbolicName);
        BundleUtility utility = BundleUtility.getInstance();
        boolean result = utility.isBundleState(bundle, 32);
        return result;
    }

    public boolean isBundle(String bundleSymbolicName) {
        Map bundleTable = this.getInstalledBundlesTable();
        String key = this.removeSuffixFrom(bundleSymbolicName);
        boolean result = bundleTable.containsKey(key);
        return result;
    }

    public boolean isExportingServices(String bundleSymbolicName) {
        ServiceReference[] services = this.getRegisteredServicesOf(bundleSymbolicName);
        boolean result = services != null;
        return result;
    }

    public boolean isImportingServices(String bundleSymbolicName) {
        ServiceReference[] services = this.getServicesInUseBy(bundleSymbolicName);
        boolean result = services != null;
        return result;
    }

    private void registerAsBundleListener() {
        BundleContext bundleContext = this.getBundleContext();
        BundleListener listener = this.getBundleListener();
        bundleContext.addBundleListener(listener);
    }

    public void removeBundleDependencyModelListener(BundleDependencyModelListener listener) {
        List listeners = this.getListeners();
        listeners.remove(listener);
    }

    private void removeFromInstalledBundlesTable(Bundle bundle) {
        Map bundles = this.getInstalledBundlesTable();
        String key = bundle.getSymbolicName();
        bundles.remove(key);
    }

    private String removeSuffixFrom(String bundleSymbolicName) {
        String value = bundleSymbolicName;
        int index = bundleSymbolicName.indexOf(91);
        if (index != -1) {
            value = bundleSymbolicName.substring(0, index - 1);
        }
        return value;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void setBundleIdComparator(Comparator bundleIdComparator) {
        this.bundleIdComparator = bundleIdComparator;
    }

    private void setBundleListener(BundleListener bundleListener) {
        this.bundleListener = bundleListener;
    }

    private void setDependency(BundleDependencyService dependency) {
        BundleDependencyListener listener = this.getDependencyListener();
        if (this.dependency != null) {
            this.dependency.removeBundleDependencyListener(listener);
        }
        this.dependency = dependency;
        if (this.dependency != null) {
            this.dependency.addBundleDependencyListener(listener);
        }
    }

    private void setDependencyListener(BundleDependencyListener dependencyListener) {
        this.dependencyListener = dependencyListener;
    }

    private void setInstalledBundlesTable(Map installedBundlesTable) {
        this.installedBundlesTable = installedBundlesTable;
    }

    private void setListeners(List listeners) {
        this.listeners = listeners;
    }

    private void sortByBundleId(List bundles) {
        Comparator comparator = this.getBundleIdComparator();
        Collections.sort(bundles, comparator);
    }

    private String toString(Bundle bundle, boolean uninstallableFlag) {
        BundleDependencyService dependency;
        boolean uninstallable;
        String bundleSymbolicName = bundle.getSymbolicName();
        long id = bundle.getBundleId();
        StringBuffer buffer = new StringBuffer(50);
        buffer.append(bundleSymbolicName);
        buffer.append(" [");
        buffer.append(id);
        buffer.append(']');
        if (uninstallableFlag && (uninstallable = (dependency = this.getDependency()).isRegisteredAsUninstallable(bundle))) {
            buffer.append('*');
        }
        String result = buffer.toString();
        return result;
    }

    public String toXml() {
        XmlPrinter printer = new XmlPrinter();
        String xml = printer.print();
        return xml;
    }

    public void unbind() {
        this.unregisterAsBundleListener();
        this.destroyBundleTable();
        this.setDependency(null);
    }

    private void unregisterAsBundleListener() {
        BundleContext bundleContext = this.getBundleContext();
        BundleListener listener = this.getBundleListener();
        bundleContext.removeBundleListener(listener);
    }

    private class XmlPrinter {
        private XmlPrinter() {
        }

        public String print() {
            StringBuffer buffer = new StringBuffer(1000);
            buffer.append("<?xml version=\"1.0\"?>");
            buffer.append(LINE_SEPARATOR);
            buffer.append("<bundleDependencyModel>");
            buffer.append(LINE_SEPARATOR);
            this.printXmlOn(buffer, 1);
            buffer.append("</bundleDependencyModel>");
            String xml = buffer.toString();
            return xml;
        }

        protected final void printIndentOn(StringBuffer buffer, int level) {
            String indent = "  ";
            int i = 0;
            while (i < level) {
                buffer.append(indent);
                ++i;
            }
        }

        protected void printXmlBundleDependenciesOn(StringBuffer buffer, int indent) {
            BundleDependencyService dependency = BundleDependencyModel.this.getDependency();
            String dependencyXml = dependency.toXml(indent);
            buffer.append(dependencyXml);
        }

        protected void printXmlBundleOn(StringBuffer buffer, int indent, String bundleSymbolicName) {
            this.printIndentOn(buffer, indent);
            buffer.append("<bundle>");
            buffer.append(LINE_SEPARATOR);
            this.printXmlCDATAOn(buffer, indent + 1, bundleSymbolicName);
            this.printIndentOn(buffer, indent);
            buffer.append("</bundle>");
            buffer.append(LINE_SEPARATOR);
        }

        private void printXmlBundlesOn(StringBuffer buffer, int indent) {
            this.printIndentOn(buffer, indent);
            buffer.append("<bundles>");
            buffer.append(LINE_SEPARATOR);
            List bundles = BundleDependencyModel.this.getBundles();
            Iterator iterator = bundles.iterator();
            while (iterator.hasNext()) {
                String bundleSymbolicName = (String)iterator.next();
                bundleSymbolicName = BundleDependencyModel.this.removeSuffixFrom(bundleSymbolicName);
                this.printXmlBundleOn(buffer, indent + 1, bundleSymbolicName);
            }
            this.printIndentOn(buffer, indent);
            buffer.append("</bundles>");
            buffer.append(LINE_SEPARATOR);
        }

        private void printXmlCDATAOn(StringBuffer buffer, int indent, Object object) {
            this.printIndentOn(buffer, indent);
            buffer.append("<![CDATA[");
            buffer.append(object);
            buffer.append("]]>");
            buffer.append(LINE_SEPARATOR);
        }

        protected void printXmlOn(StringBuffer buffer, int i) {
            this.printXmlBundlesOn(buffer, 1);
            this.printXmlBundleDependenciesOn(buffer, 1);
        }
    }
}

