/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.dependency.internal.servlet.html;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.sat.dependency.internal.model.interfaces.IBundleDependencyModel;
import org.eclipse.soda.sat.dependency.internal.nls.Messages;
import org.eclipse.soda.sat.dependency.internal.servlet.BundleDependencyServlet;
import org.eclipse.soda.sat.dependency.internal.servlet.html.HtmlConstants;

public class WebPageGenerator
implements HtmlConstants {
    private static final String ALL_KEY = "WebPageGenerator.All";
    private static final String AN_EXCEPTION_WAS_THROWN_KEY = "WebPageGenerator.AnExceptionWasThrown";
    private static final String BACK_KEY = "WebPageGenerator.Back";
    private static final String BOTTOM_OF_PAGE_KEY = "WebPageGenerator.BottomOfPage";
    private static final String BUNDLE_DEPENDENCIES_BROWSER_KEY = "WebPageGenerator.BundleDependenciesBrowser";
    private static final String BUNDLE_DEPENDENCY_HOME_PAGE_KEY = "WebPageGenerator.BundleDependencyHomePage";
    private static final String BUNDLE_DEPENDENTS_KEY = "WebPageGenerator.BundleDependents";
    private static final String BUNDLE_PREREQUISITES_KEY = "WebPageGenerator.BundlePrerequisites";
    private static final String COPYRIGHT_NOTICE_KEY = "WebPageGenerator.CopyrightNotice";
    private static final String GENERATED_BY_KEY = "WebPageGenerator.GeneratedBy";
    private static final String INSTALLED_BUNDLES_KEY = "WebPageGenerator.InstalledBundles";
    private static final String RELOAD_PAGE_KEY = "WebPageGenerator.ReloadPage";
    private static final String SHOW_ALL_BUNDLES_KEY = "WebPageGenerator.ShowAllBundles";
    private static final String SHOW_IMMEDIATE_BUNDLES_KEY = "WebPageGenerator.ShowImmediateBundles";
    private static final String TOP_OF_PAGE_KEY = "WebPageGenerator.TopOfPage";
    private static final String ALL_VALUE = Messages.getString("WebPageGenerator.All");
    private static final String BACK_VALUE = Messages.getString("WebPageGenerator.Back");
    private static final String BOTTOM_OF_PAGE_VALUE = Messages.getString("WebPageGenerator.BottomOfPage");
    private static final String BUNDLE_DEPENDENCIES_BROWSER_VALUE = Messages.getString("WebPageGenerator.BundleDependenciesBrowser");
    private static final String BUNDLE_DEPENDENCY_HOME_PAGE_VALUE = Messages.getString("WebPageGenerator.BundleDependencyHomePage");
    private static final String BUNDLE_DEPENDENTS_VALUE = Messages.getString("WebPageGenerator.BundleDependents");
    private static final String BUNDLE_PREREQUISITES_VALUE = Messages.getString("WebPageGenerator.BundlePrerequisites");
    private static final String COPYRIGHT_NOTICE_VALUE = Messages.getString("WebPageGenerator.CopyrightNotice");
    private static final String GENERATED_BY_VALUE = Messages.getString("WebPageGenerator.GeneratedBy");
    private static final String INSTALLED_BUNDLES_VALUE = Messages.getString("WebPageGenerator.InstalledBundles");
    private static final String RELOAD_PAGE_VALUE = Messages.getString("WebPageGenerator.ReloadPage");
    private static final String SHOW_ALL_BUNDLES_VALUE = Messages.getString("WebPageGenerator.ShowAllBundles");
    private static final String SHOW_IMMEDIATE_BUNDLES_VALUE = Messages.getString("WebPageGenerator.ShowImmediateBundles");
    private static final String TOP_OF_PAGE_VALUE = Messages.getString("WebPageGenerator.TopOfPage");
    private IBundleDependencyModel model;
    private StringBuffer buffer;

    public WebPageGenerator(IBundleDependencyModel model) {
        this.setModel(model);
        this.setBuffer(new StringBuffer(15000));
    }

    private void addBreak(int level) {
        this.indent(level);
        StringBuffer buffer = this.getBuffer();
        buffer.append("<br/>");
    }

    private void addBundleDependencyTable(String bundle, boolean showAllBundles) {
        this.indent(2);
        StringBuffer buffer = this.getBuffer();
        buffer.append("<table");
        buffer.append(" border=\"1\"");
        buffer.append(" width=\"100%\"");
        buffer.append('>');
        IBundleDependencyModel model = this.getModel();
        List bundles = model.getBundles();
        List dependents = showAllBundles ? model.getAllDependentsOf(bundle) : model.getDependentsOf(bundle);
        List prerequisites = showAllBundles ? model.getAllPrerequisitesOf(bundle) : model.getPrerequisitesOf(bundle);
        this.addBundleDependencyTableHeadings(showAllBundles, prerequisites.size(), bundles.size(), dependents.size());
        this.addBundleDependencyTableRows(bundle, bundles, dependents, prerequisites);
        this.indent(2);
        buffer.append("</table>");
        this.addBreak(2);
    }

    private void addBundleDependencyTableHeadings(boolean showAllBundles, int prerequisites, int bundles, int dependents) {
        this.indent(3);
        StringBuffer buffer = this.getBuffer();
        buffer.append("<tr");
        buffer.append(" bgcolor=");
        buffer.append('\"');
        buffer.append("silver");
        buffer.append('\"');
        buffer.append('>');
        String th = "<th align=\"left\" width=\"33%\">";
        this.indent(4);
        buffer.append(th);
        if (showAllBundles) {
            buffer.append(ALL_VALUE);
            buffer.append(' ');
        }
        buffer.append(BUNDLE_PREREQUISITES_VALUE);
        buffer.append("</th>");
        this.indent(4);
        buffer.append(th);
        buffer.append(INSTALLED_BUNDLES_VALUE);
        buffer.append("</th>");
        this.indent(4);
        buffer.append(th);
        if (showAllBundles) {
            buffer.append(ALL_VALUE);
            buffer.append(' ');
        }
        buffer.append(BUNDLE_DEPENDENTS_VALUE);
        buffer.append("</th>");
        this.indent(3);
        buffer.append("</tr>");
    }

    private void addBundleDependencyTableRows(String bundle, List bundles, List dependents, List prerequisites) {
        StringBuffer buffer = this.getBuffer();
        Iterator iterator = bundles.iterator();
        String td = "<td align=\"left\">";
        int i = 0;
        while (iterator.hasNext()) {
            String symbolicName;
            this.indent(3);
            buffer.append("<tr>");
            this.indent(4);
            buffer.append(td);
            if (i < prerequisites.size()) {
                this.indent(5);
                symbolicName = (String)prerequisites.get(i);
                this.addBundleLink(symbolicName);
                this.indent(4);
            } else {
                buffer.append("&nbsp;");
            }
            buffer.append("</td>");
            this.indent(4);
            buffer.append("<td");
            buffer.append(" align=");
            buffer.append('\"');
            buffer.append("left");
            buffer.append('\"');
            symbolicName = (String)iterator.next();
            if (symbolicName.equals(bundle)) {
                buffer.append("bgcolor=");
                buffer.append('\"');
                buffer.append("yellow");
                buffer.append('\"');
            }
            buffer.append('>');
            this.indent(5);
            this.addLink(symbolicName, "browse", "bundle", symbolicName);
            this.indent(4);
            buffer.append("</td>");
            this.indent(4);
            buffer.append(td);
            if (i < dependents.size()) {
                this.indent(5);
                symbolicName = (String)dependents.get(i);
                this.addBundleLink(symbolicName);
            } else {
                buffer.append("&nbsp;");
            }
            this.indent(4);
            buffer.append("</td>");
            this.indent(3);
            buffer.append("</tr>");
            ++i;
        }
    }

    private void addBundleLink(String symbolicName) {
        String value = symbolicName;
        int index = symbolicName.indexOf(42);
        if (index != -1) {
            value = symbolicName.substring(0, index);
        }
        this.addLink(symbolicName, "browse", "bundle", value);
    }

    private void addCommonLinks(boolean topLink, boolean showAllBundles) {
        String action;
        String label;
        this.indent(2);
        StringBuffer buffer = this.getBuffer();
        buffer.append("<hr/>");
        this.indent(2);
        this.addLink(RELOAD_PAGE_VALUE, "browse");
        buffer.append(" | ");
        this.indent(2);
        buffer.append("<a");
        buffer.append(" href=");
        buffer.append('\"');
        buffer.append("/bds?action=browse");
        if (topLink) {
            buffer.append("#top");
            buffer.append('\"');
            buffer.append('>');
            buffer.append(TOP_OF_PAGE_VALUE);
        } else {
            buffer.append("#bottom");
            buffer.append('\"');
            buffer.append('>');
            buffer.append(BOTTOM_OF_PAGE_VALUE);
        }
        buffer.append("</a>");
        buffer.append(" | ");
        this.indent(2);
        if (showAllBundles) {
            label = SHOW_IMMEDIATE_BUNDLES_VALUE;
            action = "showImmediateBundles";
        } else {
            label = SHOW_ALL_BUNDLES_VALUE;
            action = "showAllBundles";
        }
        this.addLink(label, action);
        this.indent(2);
        buffer.append("<hr/>");
        this.addBreak(2);
    }

    private void addCopyrightNotice() {
        StringBuffer buffer = this.getBuffer();
        buffer.append("<!--");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("Copyright (c) 2001, 2007 IBM Corporation and others.");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("All rights reserved. This program and the accompanying materials");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("are made available under the terms of the Eclipse Public License v1.0");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("which accompanies this distribution, and is available at");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("http://www.eclipse.org/legal/epl-v10.html");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("Contributors:");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("    IBM Corporation - initial API and implementation");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("-->");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append(HtmlConstants.LINE_SEPARATOR);
    }

    private void addFooter() {
        StringBuffer buffer = this.getBuffer();
        this.indent(2);
        buffer.append("<a");
        buffer.append(" name=\"bottom\"");
        buffer.append('>');
        this.indent(3);
        buffer.append("<b>");
        buffer.append(GENERATED_BY_VALUE);
        buffer.append("</b>");
        this.indent(2);
        buffer.append("</a>");
        this.addBreak(2);
        this.indent(2);
        buffer.append("<i>");
        buffer.append(COPYRIGHT_NOTICE_VALUE);
        buffer.append("</i>");
        this.indent();
        buffer.append("</body>");
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        buffer.append("</html>");
    }

    private void addHeader() {
        this.addCopyrightNotice();
        StringBuffer buffer = this.getBuffer();
        buffer.append("<html>");
        this.indent();
        buffer.append("<head>");
        this.indent(2);
        buffer.append("<title>");
        buffer.append(BUNDLE_DEPENDENCY_HOME_PAGE_VALUE);
        buffer.append("</title>");
        this.indent();
        buffer.append("</head>");
        this.indent();
        buffer.append("<body");
        buffer.append(" vlink=");
        buffer.append('\"');
        buffer.append("blue");
        buffer.append('\"');
        buffer.append(" background=");
        buffer.append('\"');
        buffer.append("/dependency/servlet/html/resource");
        buffer.append("/background.jpg");
        buffer.append('\"');
        buffer.append(" bgproperties=");
        buffer.append('\"');
        buffer.append("fixed");
        buffer.append('\"');
        buffer.append('>');
        this.indent(2);
        buffer.append("<a");
        buffer.append(" name=");
        buffer.append('\"');
        buffer.append("top");
        buffer.append('\"');
        buffer.append('>');
        this.indent(3);
        buffer.append("<h2>");
        buffer.append(BUNDLE_DEPENDENCIES_BROWSER_VALUE);
        buffer.append("</h2>");
        this.indent(2);
        buffer.append("</a>");
    }

    private void addLink(String label, String action) {
        this.addLink(label, action, (String[])null, (String[])null);
    }

    private void addLink(String label, String action, String parameter, String value) {
        String[] parameters = new String[]{parameter};
        String[] values = new String[]{value};
        this.addLink(label, action, parameters, values);
    }

    private void addLink(String label, String action, String[] parameters, String[] values) {
        StringBuffer buffer = this.getBuffer();
        buffer.append("<a");
        buffer.append(" href=\"");
        buffer.append(BundleDependencyServlet.SERVLET_ALIAS);
        if (action != null) {
            buffer.append('?');
            buffer.append("action");
            buffer.append('=');
            buffer.append(action);
        }
        if (parameters != null) {
            int length = parameters.length;
            int i = 0;
            while (i < length) {
                String parameter = parameters[i];
                String value = values[i];
                buffer.append('&');
                buffer.append(parameter);
                buffer.append('=');
                buffer.append(value);
                ++i;
            }
        }
        buffer.append('\"');
        buffer.append('>');
        buffer.append(label);
        buffer.append("</a>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(HttpServletResponse response, Throwable exception) throws IOException {
        String text;
        PrintWriter out = response.getWriter();
        String exceptionWasThrown = Messages.getString(AN_EXCEPTION_WAS_THROWN_KEY);
        WebPageGenerator webPageGenerator = this;
        synchronized (webPageGenerator) {
            this.addHeader();
            this.indent(2);
            StringBuffer buffer = this.getBuffer();
            buffer.append("<hr/>");
            this.indent(2);
            this.addLink(BACK_VALUE, "browse");
            this.indent(2);
            buffer.append("<hr/>");
            this.indent(2);
            buffer.append("<h3>");
            buffer.append(exceptionWasThrown);
            buffer.append("</h3>");
            this.indent(2);
            buffer.append("<font");
            buffer.append(" color=");
            buffer.append('\"');
            buffer.append("red");
            buffer.append('\"');
            buffer.append('>');
            this.indent(2);
            buffer.append("<pre>");
            text = this.getBufferValue();
            out.print(text);
            exception.printStackTrace(out);
            this.indent(2);
            buffer.append("</pre>");
            this.indent(2);
            buffer.append("</font>");
            this.indent(2);
            buffer.append("<hr/>");
            this.indent(2);
            this.addLink(BACK_VALUE, "browse");
            this.indent(2);
            buffer.append("<hr/>");
            this.addFooter();
            text = this.getBufferValue();
        }
        out.print(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(String bundle, boolean showAllBundles, HttpServletResponse response) throws IOException {
        String text;
        WebPageGenerator webPageGenerator = this;
        synchronized (webPageGenerator) {
            this.addHeader();
            this.addCommonLinks(false, showAllBundles);
            this.addBundleDependencyTable(bundle, showAllBundles);
            this.addCommonLinks(true, showAllBundles);
            this.addFooter();
            text = this.getBufferValue();
        }
        PrintWriter out = response.getWriter();
        out.print(text);
    }

    private StringBuffer getBuffer() {
        return this.buffer;
    }

    private String getBufferValue() {
        StringBuffer buffer = this.getBuffer();
        String value = buffer.toString();
        buffer.setLength(0);
        return value;
    }

    private IBundleDependencyModel getModel() {
        return this.model;
    }

    private void indent() {
        this.indent(1);
    }

    private void indent(int level) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(HtmlConstants.LINE_SEPARATOR);
        int i = 0;
        while (i < level) {
            buffer.append("  ");
            ++i;
        }
    }

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    private void setModel(IBundleDependencyModel model) {
        this.model = model;
    }
}

