/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.soda.sat.plugin.dependency.BundleDependencyModelListener;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyModel;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyPreferences;
import org.eclipse.soda.sat.plugin.dependency.bundle.Activator;

public class BundleDependencyModel
implements IBundleDependencyModel {
    private StringBuffer buffer;
    private String host;
    private List listeners;
    private String pollFrequency;
    private Thread pollingThread;
    private String port;
    private String servletAlias;
    private boolean showAllBundles;

    public BundleDependencyModel() {
        this.setListeners(new ArrayList(5));
        this.applyPreferences();
    }

    public void addBundleDependencyModelListener(BundleDependencyModelListener listener) {
        List listeners = this.getListeners();
        boolean exists = listeners.contains(listener);
        if (exists) {
            return;
        }
        listeners.add(listener);
    }

    private void applyPreferences() {
        IBundleDependencyPreferences preferences = this.getPreferences();
        String host = preferences.getHost();
        this.setHost(host);
        String port = preferences.getPort();
        this.setPort(port);
        String servletAlias = preferences.getServletAlias();
        this.setServletAlias(servletAlias);
        String pollFrequency = preferences.getPollFrequency();
        this.setPollFrequency(pollFrequency);
        boolean showAllBundles = preferences.getShowAllBundles();
        this.setShowAllBundles(showAllBundles);
    }

    private Runnable createPollingRunnable() {
        return new Runnable(){

            private void delay() {
                String pollFrequency = BundleDependencyModel.this.getPollFrequency();
                long seconds = Long.parseLong(pollFrequency);
                try {
                    Thread.sleep(seconds * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }

            public void run() {
                while (BundleDependencyModel.this.isPolling()) {
                    BundleDependencyModel.this.poll();
                    this.delay();
                }
            }
        };
    }

    private Thread createPollingThread() {
        Runnable runnable = this.createPollingRunnable();
        return new Thread(runnable, "BundleDependencyModel-Polling");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createQuery(String action, String bundle) {
        String host = this.getHost();
        String port = this.getPort();
        String servletAlias = this.getServletAlias();
        StringBuffer buffer = this.getBuffer();
        String query = null;
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            buffer.append("http://");
            buffer.append(host);
            buffer.append(':');
            buffer.append(port);
            buffer.append(servletAlias);
            buffer.append("?action=");
            buffer.append(action);
            if (bundle != null) {
                buffer.append("&bundle=");
                buffer.append(bundle);
            }
            query = buffer.toString();
            buffer.setLength(0);
        }
        return query;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String drain(InputStream stream) throws IOException {
        int size = 1024;
        StringBuffer buffer = new StringBuffer(size);
        InputStreamReader reader = null;
        try {
            int length;
            reader = new InputStreamReader(stream);
            char[] chars = new char[size];
            while ((length = reader.read(chars)) != -1) {
                buffer.append(chars, 0, length);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
            if (reader == null) return buffer.toString();
        }
        reader.close();
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getBuffer() {
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            if (this.buffer == null) {
                this.setBuffer(new StringBuffer(200));
            }
        }
        return this.buffer;
    }

    public List getBundles() {
        List bundles = this.performServletListQuery("getBundles", null);
        return bundles;
    }

    public List getDependentsOf(String name) {
        boolean all = this.getShowAllBundles();
        String query = all ? "getAllDependentsOf" : "getDependentsOf";
        List bundles = this.performServletListQuery(query, name);
        return bundles;
    }

    public String getHost() {
        return this.host;
    }

    private List getListeners() {
        return this.listeners;
    }

    public String getPollFrequency() {
        return this.pollFrequency;
    }

    private Thread getPollingThread() {
        return this.pollingThread;
    }

    public String getPort() {
        return this.port;
    }

    private IBundleDependencyPreferences getPreferences() {
        Activator activator = Activator.getDefault();
        IBundleDependencyPreferences preferences = activator.getPreferences();
        return preferences;
    }

    public List getPrerequisitesOf(String name) {
        boolean all = this.getShowAllBundles();
        String query = all ? "getAllPrerequisitesOf" : "getPrerequisitesOf";
        List bundles = this.performServletListQuery(query, name);
        return bundles;
    }

    public List getServicesExportedBy(String name) {
        List services = this.performServletListQuery("getServicesExportedBy", name);
        return services;
    }

    public List getServicesImportedBy(String name) {
        List services = this.performServletListQuery("getServicesImportedBy", name);
        return services;
    }

    public String getServletAlias() {
        return this.servletAlias;
    }

    public boolean getShowAllBundles() {
        return this.showAllBundles;
    }

    public boolean isActive(String name) {
        boolean result = this.performServletBooleanQuery("isActive", name);
        return result;
    }

    public boolean isBundle(String name) {
        boolean result = this.performServletBooleanQuery("isBundle", name);
        return result;
    }

    public boolean isExportingServices(String name) {
        boolean result = this.performServletBooleanQuery("isExportingServices", name);
        return result;
    }

    public boolean isImportingServices(String name) {
        boolean result = this.performServletBooleanQuery("isImportingServices", name);
        return result;
    }

    public boolean isPolling() {
        Thread pollingThread = this.getPollingThread();
        boolean polling = pollingThread != null;
        return polling;
    }

    private boolean performServletBooleanQuery(String action, String bundle) {
        String text = this.performServletQuery(action, bundle);
        Boolean wrapper = Boolean.valueOf(text);
        boolean result = wrapper;
        return result;
    }

    private List performServletListQuery(String action, String bundle) {
        String text = this.performServletQuery(action, bundle);
        List bundles = this.tokenize(text);
        return bundles;
    }

    private String performServletQuery(String action, String bundle) {
        String query = this.createQuery(action, bundle);
        String line = null;
        try {
            URL url = new URL(query);
            InputStream stream = url.openStream();
            line = this.drain(stream);
        }
        catch (IOException iOException) {}
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll() {
        List listeners = this.getListeners();
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                BundleDependencyModelListener listener = (BundleDependencyModelListener)iterator.next();
                listener.bundleDependenciesChanged();
            }
        }
    }

    public void removeBundleDependencyModelListener(BundleDependencyModelListener listener) {
        List listeners = this.getListeners();
        boolean exists = listeners.contains(listener);
        if (!exists) {
            return;
        }
        listeners.remove(listener);
    }

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void setHost(String host) {
        this.host = host;
    }

    private void setListeners(List listeners) {
        this.listeners = listeners;
    }

    public void setPollFrequency(String pollingFrequency) {
        this.pollFrequency = pollingFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPollingThread(Thread pollingThread) {
        if (this.pollingThread == pollingThread) {
            return;
        }
        this.pollingThread = pollingThread;
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                BundleDependencyModelListener listener = (BundleDependencyModelListener)iterator.next();
                listener.pollingChanged();
            }
        }
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setServletAlias(String servletAlias) {
        this.servletAlias = servletAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowAllBundles(boolean showAllBundles) {
        if (this.showAllBundles == showAllBundles) {
            return;
        }
        this.showAllBundles = showAllBundles;
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                BundleDependencyModelListener listener = (BundleDependencyModelListener)iterator.next();
                listener.showAllBundlesChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPolling() {
        Thread thread = null;
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            boolean polling = this.isPolling();
            if (polling) {
                return;
            }
            thread = this.createPollingThread();
            this.setPollingThread(thread);
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPolling() {
        Thread thread = null;
        BundleDependencyModel bundleDependencyModel = this;
        synchronized (bundleDependencyModel) {
            boolean polling = this.isPolling();
            if (!polling) {
                return;
            }
            thread = this.getPollingThread();
            this.setPollingThread(null);
        }
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void toggleAllBundles() {
        boolean allBundles = this.getShowAllBundles();
        this.setShowAllBundles(!allBundles);
    }

    public void togglePolling() {
        boolean polling = this.isPolling();
        if (!polling) {
            this.startPolling();
        } else {
            this.stopPolling();
        }
    }

    private List tokenize(String value) {
        ArrayList<String> tokens = new ArrayList<String>(20);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                token = token.trim();
                tokens.add(token);
            }
        }
        tokens.trimToSize();
        return tokens;
    }
}

