/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.bundle;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IImageManager;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator INSTANCE;
    private static final String FAILED_TO_CREATE_URL_KEY = "Activator.FailedToCreateUrl";
    public static final String ACTIVATOR_IMAGE = "activator";
    public static final String BUNDLE_EXPORTER_IMAGE = "bundle-exporter";
    public static final String BUNDLE_IMPORTER_IMAGE = "bundle-importer";
    public static final String CHECKBOX_CHECKED_IMAGE = "checkbox-checked";
    public static final String CHECKBOX_UNCHECKED_IMAGE = "checkbox-unchecked";
    public static final String TYPE_CLASS_IMAGE = "type-class";
    public static final String TYPE_INTERFACE_IMAGE = "type-interface";
    public static final String TYPE_UNKNOWN_IMAGE = "type-unknown";
    public static final String WIZARD_BANNER_IMAGE = "wizard-banner";
    public static final String WIZARD_IMAGE = "wizard";
    private static final String ICONS = "resources/icons/";
    private static final String IMAGE_EXTENSION = ".gif";
    private IImageManager imageManager;

    public static Activator getDefault() {
        return INSTANCE;
    }

    public Activator() {
        INSTANCE = this;
    }

    private IImageManager basicGetImageManager() {
        return this.imageManager;
    }

    private IImageManager createImageManager() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IImageManager imageManager = utility.createImageManager(101);
        return imageManager;
    }

    private void disposeImageManager() {
        IImageManager imageManager = this.basicGetImageManager();
        if (imageManager == null) {
            return;
        }
        imageManager.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name) {
        Activator activator = this;
        synchronized (activator) {
            IImageManager imageManager = this.getImageManager();
            Image image = imageManager.getImage(name);
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDescriptor getImageDescriptor(String name) {
        Activator activator = this;
        synchronized (activator) {
            IImageManager imageManager = this.getImageManager();
            ImageDescriptor descriptor = imageManager.getImageDescriptor(name);
            return descriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImageManager getImageManager() {
        Activator activator = this;
        synchronized (activator) {
            IImageManager manager = this.basicGetImageManager();
            if (manager == null) {
                this.initializeImageManager();
            }
        }
        return this.imageManager;
    }

    public URL getInstallUrl() {
        Bundle bundle = this.getBundle();
        URL url = bundle.getEntry("/");
        return url;
    }

    private String getSymbolicName() {
        Bundle bundle = this.getBundle();
        String name = bundle.getSymbolicName();
        return name;
    }

    private void initializeImageManager() {
        IImageManager manager = this.createImageManager();
        this.setImageManager(manager);
        this.populateImageManager();
    }

    public void log(int severity, String message, Throwable throwable) {
        String id = this.getSymbolicName();
        Status status = new Status(severity, id, 0, message, throwable);
        ILog log = this.getLog();
        log.log((IStatus)status);
    }

    public void log(int severity, Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.toString();
        }
        this.log(severity, message, throwable);
    }

    private void populateImageManager() {
        IImageManager imageManager = this.getImageManager();
        URL installUrl = this.getInstallUrl();
        try {
            imageManager.add(ACTIVATOR_IMAGE, new URL(installUrl, "resources/icons/activator.gif"));
            imageManager.add(BUNDLE_EXPORTER_IMAGE, new URL(installUrl, "resources/icons/bundle-exporter.gif"));
            imageManager.add(BUNDLE_IMPORTER_IMAGE, new URL(installUrl, "resources/icons/bundle-importer.gif"));
            imageManager.add(CHECKBOX_CHECKED_IMAGE, new URL(installUrl, "resources/icons/checkbox-checked.gif"));
            imageManager.add(CHECKBOX_UNCHECKED_IMAGE, new URL(installUrl, "resources/icons/checkbox-unchecked.gif"));
            imageManager.add(TYPE_CLASS_IMAGE, new URL(installUrl, "resources/icons/type-class.gif"));
            imageManager.add(TYPE_INTERFACE_IMAGE, new URL(installUrl, "resources/icons/type-interface.gif"));
            imageManager.add(TYPE_UNKNOWN_IMAGE, new URL(installUrl, "resources/icons/type-unknown.gif"));
            imageManager.add(WIZARD_IMAGE, new URL(installUrl, "resources/icons/wizard.gif"));
            imageManager.add(WIZARD_BANNER_IMAGE, new URL(installUrl, "resources/icons/wizard-banner.gif"));
        }
        catch (MalformedURLException exception) {
            String message = Messages.getString(FAILED_TO_CREATE_URL_KEY);
            this.log(4, message, exception);
        }
    }

    private void setImageManager(IImageManager imageManager) {
        this.imageManager = imageManager;
    }

    public void stop(BundleContext context) throws Exception {
        this.disposeImageManager();
        super.stop(context);
    }
}

