/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.text.MessageFormat;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.AbstractActivatorWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MiscellaneousActivatorWizardPage
extends AbstractActivatorWizardPage {
    private static final String CUSTOM_START_AND_STOP_KEY = "MiscellaneousActivatorWizardPage.CustomStartAndStop";
    private static final String DESCRIPTION_KEY = "MiscellaneousActivatorWizardPage.Description";
    private static final String FROM_FILE_SYSTEM_KEY = "MiscellaneousActivatorWizardPage.FromFileSystem";
    private static final String FROM_PACKAGE_RESOURCE_KEY = "MiscellaneousActivatorWizardPage.FromPackageResource";
    private static final String HAS_UNINSTALL_POLICY_KEY = "MiscellaneousActivatorWizardPage.HasUninstallPolicy";
    private static final String LOAD_PROPERTIES_KEY = "MiscellaneousActivatorWizardPage.LoadProperties";
    private static final String UNRECOGNIZED_LOAD_PROPERTIES_POLICY = "MiscellaneousActivatorWizardPage.UnrecognizedLoadPropertiesPolicy";
    private static final String UNRECOGNIZED_START_ASYNCHRONOUSLY_PRIORITY_DELTA = "MiscellaneousActivatorWizardPage.UnrecognizedStartAsynchronouslyPriorityDelta";
    private static final String UNRECOGNIZED_UNINSTALL_POLICY = "MiscellaneousActivatorWizardPage.UnrecognizedUninstallPolicy";
    private static final String NORMAL_PRIORITY_PLUS_ONE_KEY = "MiscellaneousActivatorWizardPage.NormalPriorityPlusOne";
    private static final String NORMAL_PRIORITY_KEY = "MiscellaneousActivatorWizardPage.NormalPriority";
    private static final String NORMAL_PRIORITY_MINUS_ONE_KEY = "MiscellaneousActivatorWizardPage.NormalPriorityMinusOne";
    private static final String NO_SELECTED_LOAD_PROPERTIES_POLICY_BUTTON_KEY = "MiscellaneousActivatorWizardPage.NoSelectedLoadPropertiesPolicyButton";
    private static final String NO_SELECTED_UNINSTALL_POLICY_BUTTON_KEY = "MiscellaneousActivatorWizardPage.NoSelectedUninstallPolicyButton";
    private static final String PROPERTIES_FILENAME_KEY = "MiscellaneousActivatorWizardPage.PropertiesFilename";
    private static final String START_ASYNCHRONOUSLY_KEY = "MiscellaneousActivatorWizardPage.StartAsynchronously";
    private static final String TRANSIENT_KEY = "MiscellaneousActivatorWizardPage.Transient";
    private static final String UNINSTALLABLE_KEY = "MiscellaneousActivatorWizardPage.Uninstallable";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.activator.ui.miscellaneousActivatorWizardPage";
    public static final String PAGE_NAME;
    private Button customStartAndStopButton;
    private Button fromFileSystemButton;
    private Button fromPackageResourceButton;
    private Button hasUninstallPolicyButton;
    private Button loadPropertiesButton;
    private Button normalPriorityButton;
    private Button normalPriorityMinusOneButton;
    private Button normalPriorityPlusOneButton;
    private Button transientButton;
    private Button startAsynchronouslyButton;
    private Button uninstallableButton;
    private Label propertiesFilenameLabel;
    private Text propertiesFilenameText;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.plugin.activator.ui.internal.pages.MiscellaneousActivatorWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public MiscellaneousActivatorWizardPage(IActivatorWizard parent) {
        super(PAGE_NAME, parent);
    }

    private void buildCustomStartAndStopRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleCustomStartAndStopCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, CUSTOM_START_AND_STOP_KEY, (SelectionListener)listener);
        this.setCustomStartAndStopButton(button);
        IActivatorWizardModel model = this.getModel();
        boolean state = model.getCustomStartAndStop();
        button.setSelection(state);
    }

    private void buildFromFileSystemRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, FROM_FILE_SYSTEM_KEY, listener);
        this.setFromFileSystemButton(button);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getLoadPropertiesPolicy();
        boolean enabled = policy != 0;
        button.setEnabled(enabled);
        Integer data = new Integer(2);
        button.setData((Object)data);
    }

    private void buildFromPackageResourceRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, FROM_PACKAGE_RESOURCE_KEY, listener);
        this.setFromPackageResourceButton(button);
        button.setSelection(true);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getLoadPropertiesPolicy();
        boolean enabled = policy != 0;
        button.setEnabled(enabled);
        Integer data = new Integer(1);
        button.setData((Object)data);
    }

    private void buildHasUninstallPolicyRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleHasUninstallPolicyCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, HAS_UNINSTALL_POLICY_KEY, (SelectionListener)listener);
        this.setHasUninstallPolicyButton(button);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getUninstallPolicy();
        boolean state = policy != 0;
        button.setSelection(state);
        this.buildUninstallPolicyRow(parent);
    }

    private void buildLoadPropertiesFileRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleLoadPropertiesFileCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, LOAD_PROPERTIES_KEY, (SelectionListener)listener);
        this.setLoadPropertiesButton(button);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getLoadPropertiesPolicy();
        boolean state = policy != 0;
        button.setSelection(state);
        this.buildLoadPropertiesOptionsRow(parent);
    }

    private void buildLoadPropertiesOptionsRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.setMarginWidth(composite, 5);
        this.buildPropertiesFilenameRow(composite);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                MiscellaneousActivatorWizardPage.this.handleLoadPropertiesButtonClicked(button);
            }
        };
        this.buildFromPackageResourceRow(composite, (SelectionListener)listener);
        this.buildFromFileSystemRow(composite, (SelectionListener)listener);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getLoadPropertiesPolicy();
        this.setLoadPropertiesButtonSelection(policy);
    }

    private void buildNormalPriorityMinusOneRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, NORMAL_PRIORITY_MINUS_ONE_KEY, listener);
        this.setNormalPriorityMinusOneButton(button);
        Integer data = new Integer(-1);
        button.setData((Object)data);
        IActivatorWizardModel model = this.getModel();
        boolean enabled = model.getStartAsynchronously();
        button.setEnabled(enabled);
    }

    private void buildNormalPriorityPlusOneRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, NORMAL_PRIORITY_PLUS_ONE_KEY, listener);
        this.setNormalPriorityPlusOneButton(button);
        Integer data = new Integer(1);
        button.setData((Object)data);
        IActivatorWizardModel model = this.getModel();
        boolean enabled = model.getStartAsynchronously();
        button.setEnabled(enabled);
    }

    private void buildNormalPriorityRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, NORMAL_PRIORITY_KEY, listener);
        this.setNormalPriorityButton(button);
        Integer data = new Integer(0);
        button.setData((Object)data);
        IActivatorWizardModel model = this.getModel();
        boolean enabled = model.getStartAsynchronously();
        button.setEnabled(enabled);
    }

    protected void buildPage(Composite parent) {
        this.buildCustomStartAndStopRow(parent);
        this.buildSeparator(parent);
        this.buildStartAsynchronouslyRow(parent);
        this.buildSeparator(parent);
        this.buildLoadPropertiesFileRow(parent);
        this.buildSeparator(parent);
        this.buildHasUninstallPolicyRow(parent);
    }

    private void buildPropertiesFilenameRow(Composite parent) {
        Composite composite = this.createComposite(parent, 2, true, false);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getLoadPropertiesPolicy();
        boolean enabled = policy != 0;
        Label label = this.createLabel(composite, PROPERTIES_FILENAME_KEY);
        this.setPropertiesFilenameLabel(label);
        label.setEnabled(enabled);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MiscellaneousActivatorWizardPage.this.handlePropertiesFilenameTextChanged();
            }
        };
        Text text = this.createText(composite, listener, "The bundle properties filename", enabled);
        this.setPropertiesFilenameText(text);
        String value = model.getPropertiesFilename();
        text.setText(value);
    }

    private void buildStartAsynchronouslyPriorityRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.setMarginWidth(composite, 5);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                MiscellaneousActivatorWizardPage.this.handleStartAsynchronouslyPriorityButtonClicked(button);
            }
        };
        this.buildNormalPriorityPlusOneRow(composite, (SelectionListener)listener);
        this.buildNormalPriorityRow(composite, (SelectionListener)listener);
        this.buildNormalPriorityMinusOneRow(composite, (SelectionListener)listener);
        IActivatorWizardModel model = this.getModel();
        int delta = model.getStartAsynchronouslyNormalPriorityDelta();
        this.setStartAsynchronouslyPriorityButtonSelection(delta);
    }

    private void buildStartAsynchronouslyRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleStartAsynchronouslyCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, START_ASYNCHRONOUSLY_KEY, (SelectionListener)listener);
        this.setStartAsynchronouslyButton(button);
        IActivatorWizardModel model = this.getModel();
        boolean state = model.getStartAsynchronously();
        button.setSelection(state);
        this.buildStartAsynchronouslyPriorityRow(parent);
    }

    private void buildTransientRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, TRANSIENT_KEY, listener);
        this.setTransientButton(button);
        Integer data = new Integer(2);
        button.setData((Object)data);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getUninstallPolicy();
        boolean enabled = policy != 0;
        button.setEnabled(enabled);
    }

    private void buildUninstallableRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, UNINSTALLABLE_KEY, listener);
        this.setUninstallableButton(button);
        button.setSelection(true);
        Integer data = new Integer(1);
        button.setData((Object)data);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getUninstallPolicy();
        boolean enabled = policy != 0;
        button.setEnabled(enabled);
    }

    private void buildUninstallPolicyRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.setMarginWidth(composite, 5);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                MiscellaneousActivatorWizardPage.this.handleUninstallPolicyButtonClicked(button);
            }
        };
        this.buildUninstallableRow(composite, (SelectionListener)listener);
        this.buildTransientRow(composite, (SelectionListener)listener);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getUninstallPolicy();
        this.setUninstallPolicyButtonSelection(policy);
    }

    private Button getCustomStartAndStopButton() {
        return this.customStartAndStopButton;
    }

    private Button getFromFileSystemButton() {
        return this.fromFileSystemButton;
    }

    private Button getFromPackageResourceButton() {
        return this.fromPackageResourceButton;
    }

    private Button getHasUninstallPolicyButton() {
        return this.hasUninstallPolicyButton;
    }

    protected String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    private Button getLoadPropertiesButton() {
        return this.loadPropertiesButton;
    }

    protected String getMessageString() {
        return Messages.getString(DESCRIPTION_KEY);
    }

    private Button getNormalPriorityButton() {
        return this.normalPriorityButton;
    }

    private Button getNormalPriorityMinusOneButton() {
        return this.normalPriorityMinusOneButton;
    }

    private Button getNormalPriorityPlusOneButton() {
        return this.normalPriorityPlusOneButton;
    }

    private String getPropertiesFilename() {
        Text text = this.getPropertiesFilenameText();
        String value = text.getText();
        return value;
    }

    private Label getPropertiesFilenameLabel() {
        return this.propertiesFilenameLabel;
    }

    private Text getPropertiesFilenameText() {
        return this.propertiesFilenameText;
    }

    private Button getStartAsynchronouslyButton() {
        return this.startAsynchronouslyButton;
    }

    private Button getTransientButton() {
        return this.transientButton;
    }

    private Button getUninstallableButton() {
        return this.uninstallableButton;
    }

    protected void handleBundleSymbolicNameChanged(String bundleSymbolicName) {
        super.handleBundleSymbolicNameChanged(bundleSymbolicName);
        IActivatorWizardModel model = this.getModel();
        String filename = model.getPropertiesFilename();
        Text text = this.getPropertiesFilenameText();
        text.setText(filename);
    }

    protected void handleCustomStartAndStopChanged(boolean customStartAndStop) {
        Button button = this.getCustomStartAndStopButton();
        button.setSelection(customStartAndStop);
    }

    private void handleCustomStartAndStopCheckboxButtonClicked() {
        Button button = this.getCustomStartAndStopButton();
        boolean state = button.getSelection();
        IActivatorWizardModel model = this.getModel();
        model.setCustomStartAndStop(state);
    }

    private void handleHasUninstallPolicyCheckboxButtonClicked() {
        Button hasUninstallPolicyButton = this.getHasUninstallPolicyButton();
        Button uninstallableButton = this.getUninstallableButton();
        Button transientButton = this.getTransientButton();
        boolean selected = hasUninstallPolicyButton.getSelection();
        uninstallableButton.setEnabled(selected);
        transientButton.setEnabled(selected);
        IActivatorWizardModel model = this.getModel();
        if (!selected) {
            model.setUninstallPolicy(0);
        } else {
            selected = uninstallableButton.getSelection();
            if (selected) {
                model.setUninstallPolicy(1);
                return;
            }
            selected = transientButton.getSelection();
            if (selected) {
                model.setUninstallPolicy(2);
                return;
            }
            this.logErrorNoSelectedUninstallPolicyButton();
        }
    }

    private void handleLoadPropertiesButtonClicked(Button button) {
        Integer data = (Integer)button.getData();
        int value = data;
        IActivatorWizardModel model = this.getModel();
        model.setLoadPropertiesPolicy(value);
    }

    private void handleLoadPropertiesFileCheckboxButtonClicked() {
        Button button = this.getLoadPropertiesButton();
        Button fromFileSystemButton = this.getFromFileSystemButton();
        Button fromPackageResourceButton = this.getFromPackageResourceButton();
        Label label = this.getPropertiesFilenameLabel();
        Text text = this.getPropertiesFilenameText();
        boolean selected = button.getSelection();
        fromFileSystemButton.setEnabled(selected);
        fromPackageResourceButton.setEnabled(selected);
        label.setEnabled(selected);
        text.setEnabled(selected);
        IActivatorWizardModel model = this.getModel();
        if (!selected) {
            model.setLoadPropertiesPolicy(0);
        } else {
            selected = fromFileSystemButton.getSelection();
            if (selected) {
                model.setLoadPropertiesPolicy(2);
                return;
            }
            selected = fromPackageResourceButton.getSelection();
            if (selected) {
                model.setLoadPropertiesPolicy(1);
                return;
            }
            this.logErrorNoSelectedLoadPropertiesFilePolicyButton();
        }
    }

    protected void handleLoadPropertiesPolicyChanged(int policy) {
        this.setLoadPropertiesButtonSelection(policy);
    }

    protected void handlePropertiesFilenameChanged(String propertiesFilename) {
        String value = this.getPropertiesFilename();
        boolean equal = value.equals(propertiesFilename);
        if (equal) {
            return;
        }
        Text text = this.getPropertiesFilenameText();
        text.setText(propertiesFilename);
    }

    private void handlePropertiesFilenameTextChanged() {
        Text text = this.getPropertiesFilenameText();
        String value = text.getText();
        IActivatorWizardModel model = this.getModel();
        model.setPropertiesFilename(value);
    }

    protected void handleStartAsynchronouslyChanged(boolean startAsynchronously) {
        Button button = this.getStartAsynchronouslyButton();
        button.setSelection(startAsynchronously);
        Button control = this.getNormalPriorityPlusOneButton();
        control.setEnabled(startAsynchronously);
        control = this.getNormalPriorityButton();
        control.setEnabled(startAsynchronously);
        control = this.getNormalPriorityMinusOneButton();
        control.setEnabled(startAsynchronously);
    }

    private void handleStartAsynchronouslyCheckboxButtonClicked() {
        Button button = this.getStartAsynchronouslyButton();
        boolean state = button.getSelection();
        IActivatorWizardModel model = this.getModel();
        model.setStartAsynchronously(state);
    }

    protected void handleStartAsynchronouslyNormalPriorityDeltaChanged(int startAsynchronouslyNormalPriorityDelta) {
        this.setStartAsynchronouslyPriorityButtonSelection(startAsynchronouslyNormalPriorityDelta);
    }

    private void handleStartAsynchronouslyPriorityButtonClicked(Button button) {
        Integer data = (Integer)button.getData();
        int value = data;
        IActivatorWizardModel model = this.getModel();
        model.setStartAsynchronouslyNormalPriorityDelta(value);
    }

    private void handleUninstallPolicyButtonClicked(Button button) {
        Integer data = (Integer)button.getData();
        int value = data;
        IActivatorWizardModel model = this.getModel();
        model.setUninstallPolicy(value);
    }

    protected void handleUninstallPolicyChanged(int uninstallPolicy) {
        this.setUninstallPolicyButtonSelection(uninstallPolicy);
    }

    private void logError(String message) {
        this.logError(message, null);
    }

    private void logError(String message, Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, message, throwable);
    }

    private void logErrorNoSelectedLoadPropertiesFilePolicyButton() {
        String message = Messages.getString(NO_SELECTED_LOAD_PROPERTIES_POLICY_BUTTON_KEY);
        this.logError(message);
    }

    private void logErrorNoSelectedUninstallPolicyButton() {
        String message = Messages.getString(NO_SELECTED_UNINSTALL_POLICY_BUTTON_KEY);
        this.logError(message);
    }

    private void logErrorUnrecognizedLoadPropertiesPolicy(int policy) {
        String pattern = Messages.getString(UNRECOGNIZED_LOAD_PROPERTIES_POLICY);
        Object[] values = new Object[]{new Integer(policy)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private void logErrorUnrecognizedStartAsynchronouslyPriorityDelta(int priority) {
        String pattern = Messages.getString(UNRECOGNIZED_START_ASYNCHRONOUSLY_PRIORITY_DELTA);
        Object[] values = new Object[]{new Integer(priority)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private void logErrorUnrecognizedUninstallPolicy(int policy) {
        String pattern = Messages.getString(UNRECOGNIZED_UNINSTALL_POLICY);
        Object[] values = new Object[]{new Integer(policy)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private void setCustomStartAndStopButton(Button customStartAndStopButton) {
        this.customStartAndStopButton = customStartAndStopButton;
    }

    private void setFromFileSystemButton(Button fromFileSystemButton) {
        this.fromFileSystemButton = fromFileSystemButton;
    }

    private void setFromPackageResourceButton(Button fromPackageResourceButton) {
        this.fromPackageResourceButton = fromPackageResourceButton;
    }

    private void setHasUninstallPolicyButton(Button hasUninstallPolicyButton) {
        this.hasUninstallPolicyButton = hasUninstallPolicyButton;
    }

    private void setLoadPropertiesButton(Button loadPropertiesFileButton) {
        this.loadPropertiesButton = loadPropertiesFileButton;
    }

    private void setLoadPropertiesButtonSelection(int policy) {
        Button fromPackageResourceButton = this.getFromPackageResourceButton();
        Button fromFileSystemButton = this.getFromFileSystemButton();
        boolean state = policy != 0;
        fromPackageResourceButton.setEnabled(state);
        fromFileSystemButton.setEnabled(state);
        if (!state) {
            return;
        }
        if (policy == 1) {
            fromPackageResourceButton.setSelection(true);
            fromFileSystemButton.setSelection(false);
        } else if (policy == 2) {
            fromPackageResourceButton.setSelection(false);
            fromFileSystemButton.setSelection(true);
        } else {
            this.logErrorUnrecognizedLoadPropertiesPolicy(policy);
            return;
        }
    }

    private void setNormalPriorityButton(Button normalPriorityButton) {
        this.normalPriorityButton = normalPriorityButton;
    }

    private void setNormalPriorityMinusOneButton(Button normalPriorityMinusOneButton) {
        this.normalPriorityMinusOneButton = normalPriorityMinusOneButton;
    }

    private void setNormalPriorityPlusOneButton(Button normalPriorityPlusOneButton) {
        this.normalPriorityPlusOneButton = normalPriorityPlusOneButton;
    }

    private void setPropertiesFilenameLabel(Label propertiesFilenameLabel) {
        this.propertiesFilenameLabel = propertiesFilenameLabel;
    }

    private void setPropertiesFilenameText(Text propertiesFilenameText) {
        this.propertiesFilenameText = propertiesFilenameText;
    }

    private void setStartAsynchronouslyButton(Button startAsynchronouslyButton) {
        this.startAsynchronouslyButton = startAsynchronouslyButton;
    }

    private void setStartAsynchronouslyPriorityButtonSelection(int priority) {
        Button button;
        if (priority == -1) {
            button = this.getNormalPriorityMinusOneButton();
        } else if (priority == 0) {
            button = this.getNormalPriorityButton();
        } else if (priority == 1) {
            button = this.getNormalPriorityPlusOneButton();
        } else {
            this.logErrorUnrecognizedStartAsynchronouslyPriorityDelta(priority);
            return;
        }
        button.setSelection(true);
    }

    private void setTransientButton(Button transientButton) {
        this.transientButton = transientButton;
    }

    private void setUninstallableButton(Button uninstallableButton) {
        this.uninstallableButton = uninstallableButton;
    }

    private void setUninstallPolicyButtonSelection(int policy) {
        Button uninstallableButton = this.getUninstallableButton();
        Button transientButton = this.getTransientButton();
        boolean state = policy != 0;
        uninstallableButton.setEnabled(state);
        transientButton.setEnabled(state);
        if (!state) {
            return;
        }
        if (policy == 1) {
            uninstallableButton.setSelection(true);
            transientButton.setSelection(false);
        } else if (policy == 2) {
            uninstallableButton.setSelection(false);
            transientButton.setSelection(true);
        } else {
            this.logErrorUnrecognizedUninstallPolicy(policy);
            return;
        }
    }
}

