/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.AbstractActivatorWizardPage;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PreviewActivatorWizardPage
extends AbstractActivatorWizardPage {
    private static final String DESCRIPTION_KEY = "PreviewActivatorWizardPage.Description";
    private static final String TITLE_KEY = "PreviewActivatorWizardPage.Title";
    private static final String DO_NOT_SHOW_THIS_PAGE_NEXT_TIME_KEY = "PreviewActivatorWizardPage.DoNotShowThisPageNextTime";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.activator.ui.previewActivatorWizardPage";
    public static final String PAGE_NAME;
    private Text previewText;
    private Button doNotShowPageNextTimeButton;
    private boolean doNotShowPageNextTime;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.plugin.activator.ui.internal.pages.PreviewActivatorWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public PreviewActivatorWizardPage(IActivatorWizard parent) {
        super(PAGE_NAME, parent);
    }

    private void buildDoNotShowPageRow(Composite parent) {
        SelectionAdapter listener = this.createDoNotShowPageNextTimeSelectionListener();
        Button button = this.createButton(parent, 32, DO_NOT_SHOW_THIS_PAGE_NEXT_TIME_KEY, (SelectionListener)listener);
        this.setDoNotShowPageNextTimeButton(button);
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean state = preferences.getDoNotShowPreviewPage();
        button.setSelection(state);
    }

    protected void buildPage(Composite parent) {
        this.buildTextPreviewRow(parent);
        this.buildDoNotShowPageRow(parent);
    }

    private void buildTextPreviewRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        int style = 2826;
        Text text = new Text(composite, style);
        this.setPreviewText(text);
        Color color = this.getPreviewTextBackgroundColor();
        text.setBackground(color);
        GridData data = new GridData(4, 4, true, true);
        text.setLayoutData((Object)data);
    }

    private SelectionAdapter createDoNotShowPageNextTimeSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreviewActivatorWizardPage.this.handleDoNotShowPageNextTimeButtonClicked();
            }
        };
    }

    public void finish() {
        this.updatePreferences();
        super.finish();
    }

    private boolean getDoNotShowPageNextTime() {
        return this.doNotShowPageNextTime;
    }

    private Button getDoNotShowPageNextTimeButton() {
        return this.doNotShowPageNextTimeButton;
    }

    protected String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    protected String getMessageString() {
        return Messages.getString(DESCRIPTION_KEY);
    }

    private Text getPreviewText() {
        return this.previewText;
    }

    private Color getPreviewTextBackgroundColor() {
        UiUtility utility = UiUtility.getInstance();
        Color color = utility.getBackgroundColor();
        return color;
    }

    protected String getTitleString() {
        return Messages.getString(TITLE_KEY);
    }

    private void handleDoNotShowPageNextTimeButtonClicked() {
        Button button = this.getDoNotShowPageNextTimeButton();
        boolean state = button.getSelection();
        this.setDoNotShowPageNextTime(state);
    }

    private void setDoNotShowPageNextTime(boolean doNotShowPageNextTime) {
        this.doNotShowPageNextTime = doNotShowPageNextTime;
    }

    private void setDoNotShowPageNextTimeButton(Button doNotDisplayPageNextTimeButton) {
        this.doNotShowPageNextTimeButton = doNotDisplayPageNextTimeButton;
    }

    private void setPreviewText(Text previewText) {
        this.previewText = previewText;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        this.updateTextPreview();
    }

    private void updatePreferences() {
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean state = this.getDoNotShowPageNextTime();
        preferences.setDoNotShowPreviewPage(state);
    }

    private void updateTextPreview() {
        IActivatorWizardModel model = this.getModel();
        String value = model.generate();
        Text text = this.getPreviewText();
        text.setText(value);
    }
}

