/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

abstract class FileManager {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private IFile file;
    private boolean dirty;
    private final Object lock = new Object();

    protected FileManager(IFile file) {
        this.setFile(file);
        this.setDirty(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void applyChanges(String contents) throws CoreException, IOException {
        block4: {
            byte[] bytes = contents.getBytes();
            IFile file = this.getFile();
            ByteArrayInputStream stream = null;
            try {
                stream = new ByteArrayInputStream(bytes);
                file.setContents((InputStream)stream, true, true, null);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (stream != null) {
                    ((InputStream)stream).close();
                }
                this.setDirty(false);
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (stream == null) break block4;
            }
            ((InputStream)stream).close();
        }
        this.setDirty(false);
    }

    protected abstract String getContents() throws CoreException, IOException;

    protected IFile getFile() {
        return this.file;
    }

    protected final Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDirty() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            return this.dirty;
        }
    }

    protected void postApplyChanges() throws CoreException, IOException {
    }

    protected void preApplyChanges() throws CoreException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws CoreException, IOException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean dirty = this.isDirty();
            if (!dirty) {
                return;
            }
            this.preApplyChanges();
            String contents = this.getContents();
            this.applyChanges(contents);
            this.postApplyChanges();
        }
    }

    protected final void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    private void setFile(IFile file) {
        this.file = file;
    }
}

