/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JavaUtility {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void addClassPathEntry(IJavaProject javaProject, IClasspathEntry classpathEntry, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
        System.arraycopy(entries, 0, newEntries, 0, entries.length);
        newEntries[entries.length] = classpathEntry;
        if (monitor != null) {
            IPath path = classpathEntry.getPath();
            monitor.setTaskName("Updating classpath: " + path);
        }
        javaProject.setRawClasspath(newEntries, monitor);
    }

    public static IJavaProject createJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    public static IJavaElement getActiveEditorInput() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart part = page.getActiveEditor();
        if (part == null) {
            return null;
        }
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJavaElement javaElement = (IJavaElement)editorInput.getAdapter((Class)clazz);
        return javaElement;
    }

    public static IFile getFile(IPackageFragmentRoot root, String filename) {
        return JavaUtility.getFile(root, null, filename);
    }

    public static IFile getFile(IPackageFragmentRoot root, String filepath, String filename) {
        Path path;
        IJavaElement javaProject = root.getAncestor(2);
        if (javaProject == null) {
            return null;
        }
        boolean exists = javaProject.exists();
        if (!exists) {
            return null;
        }
        IResource resource = null;
        try {
            resource = javaProject.getCorrespondingResource();
        }
        catch (JavaModelException exception) {
            JavaUtility.logError(exception);
        }
        if (resource == null) {
            return null;
        }
        if (!(resource instanceof IContainer)) {
            return null;
        }
        IContainer container = (IContainer)resource;
        if (filepath != null && (container = container.getFolder((IPath)(path = new Path(filepath)))) == null) {
            return null;
        }
        exists = container.exists();
        if (!exists) {
            return null;
        }
        path = new Path(filename);
        IFile file = container.getFile((IPath)path);
        return file;
    }

    public static IPackageFragmentRoot getFirstRoot(IJavaProject javaProject) {
        try {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                int kind = root.getKind();
                if (kind == 1) {
                    return root;
                }
                ++i;
            }
        }
        catch (JavaModelException exception) {
            JavaUtility.logError(exception);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IJavaElement getJavaElementFromAdaptable(Object object) {
        IResource resource;
        IJavaElement javaElement;
        if (!(object instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)object;
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((javaElement = (IJavaElement)adaptable.getAdapter((Class)clazz)) != null) {
            return javaElement;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz3 = class$1 = clazz4;
        }
        if ((resource = (IResource)adaptable.getAdapter((Class)clazz3)) == null) {
            return null;
        }
        int type = resource.getType();
        if (type == 8) {
            return null;
        }
        while (true) {
            if (javaElement != null || resource.getType() == 4) {
                if (javaElement == null) return JavaCore.create((IResource)resource);
                return javaElement;
            }
            resource = resource.getParent();
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            javaElement = (IJavaElement)resource.getAdapter((Class)clazz5);
        }
    }

    public static IJavaProject getJavaProject(String projectName) {
        IWorkspaceRoot root = JavaUtility.getWorkspaceRoot();
        IProject project = root.getProject(projectName);
        if (project == null) {
            return null;
        }
        if (!project.exists()) {
            return null;
        }
        IJavaProject javaProject = JavaUtility.createJavaProject(project);
        return javaProject;
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root;
    }

    private static void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    private JavaUtility() {
    }
}

