/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.bundle;

import java.util.ArrayList;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.soda.sat.plugin.AboutExtension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator INSTANCE;
    private static final String ABOUT_EXTENSION_POINT = "org.eclipse.soda.sat.plugin.about";
    private AboutExtension[] aboutExtensions;

    public static Activator getDefault() {
        return INSTANCE;
    }

    public Activator() {
        INSTANCE = this;
    }

    private AboutExtension[] createAboutData() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ABOUT_EXTENSION_POINT);
        IExtension[] extensions = point.getExtensions();
        AboutExtension[] data = this.processAboutExtensions(extensions);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AboutExtension[] getAboutExtensions() {
        Activator activator = this;
        synchronized (activator) {
            if (this.aboutExtensions == null) {
                AboutExtension[] aboutExtentions = this.createAboutData();
                this.setAboutExtensions(aboutExtentions);
            }
        }
        return this.aboutExtensions;
    }

    private String getUniqueIdentifier() {
        Bundle bundle = this.getBundle();
        String id = bundle.getSymbolicName();
        return id;
    }

    public void logError(String message, Throwable throwable) {
        String id = this.getUniqueIdentifier();
        Status status = new Status(4, id, 4, message, throwable);
        ILog log = this.getLog();
        log.log((IStatus)status);
    }

    private AboutExtension[] processAboutExtensions(IExtension[] extensions) {
        int size = extensions.length;
        ArrayList<AboutExtension> items = new ArrayList<AboutExtension>(size);
        int i = 0;
        while (i < size) {
            IExtension extension = extensions[i];
            AboutExtension data = new AboutExtension(extension);
            items.add(data);
            ++i;
        }
        AboutExtension[] results = new AboutExtension[size];
        items.toArray(results);
        return results;
    }

    private void setAboutExtensions(AboutExtension[] aboutExtensions) {
        this.aboutExtensions = aboutExtensions;
    }

    public void stop(BundleContext context) throws Exception {
        this.setAboutExtensions(null);
        super.stop(context);
    }
}

