/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.soda.devicekit.editor.dkml.ConfigurationPage;
import org.eclipse.soda.devicekit.editor.dkml.DependPage;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitContentOutlinePage;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitEditorEnvironment;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormPage;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitSourcePage;
import org.eclipse.soda.devicekit.editor.dkml.DkmlDocumentProvider;
import org.eclipse.soda.devicekit.editor.dkml.DkmlModel;
import org.eclipse.soda.devicekit.editor.dkml.ExternalPage;
import org.eclipse.soda.devicekit.editor.dkml.OverviewPage;
import org.eclipse.soda.devicekit.editor.dkml.ProtocolPage;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedCenter;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedEvent;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedListener;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.ui.agent.wizard.AgentMessages;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.ui.wizard.WizardMessages;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class DeviceKitFormEditor
extends FormEditor
implements DkmlResourceChangedListener {
    public Map icons = new HashMap();
    protected DeviceKitContentOutlinePage outlinePage;
    protected IWizardMessages uiMessages = AgentMessages.getInstance();
    protected Object[] pageArray = new Object[0];
    private IFile file;
    private DkmlDocumentProvider documentProvider;
    private DkmlModel dkmlModel;
    private DeviceKitTagModel tagModel;
    private TagElement mainElement;
    protected DeviceKitSourcePage sourcePage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DeviceKitFormEditor() {
        this.setupIcons();
    }

    protected void addPages() {
        DeviceKitSourcePage sourcePage = this.createSourcePage();
        this.setSourcePage(sourcePage);
        try {
            if (!this.isSourceOnly()) {
                OverviewPage overviewPage = this.createOverviewPage();
                DeviceKitFormPage externalPage = this.createExternalPage();
                ConfigurationPage configurationPage = this.createConfigurationPage();
                ProtocolPage protocolPage = this.createProtocolPage();
                DependPage dependPage = this.createDependPage();
                if (overviewPage != null) {
                    this.addPage((IFormPage)overviewPage);
                }
                if (externalPage != null) {
                    this.addPage((IFormPage)externalPage);
                }
                if (configurationPage != null) {
                    this.addPage((IFormPage)configurationPage);
                }
                if (protocolPage != null) {
                    this.addPage((IFormPage)protocolPage);
                }
                if (dependPage != null) {
                    this.addPage((IFormPage)dependPage);
                }
            }
            if (sourcePage != null) {
                int sourceIndex = this.addPage((IEditorPart)sourcePage, this.getEditorInput());
                this.setPageText(sourceIndex, "Source");
            }
        }
        catch (PartInitException exception) {
            exception.printStackTrace();
        }
    }

    public ConfigurationPage createConfigurationPage() {
        return new ConfigurationPage(this, "configuration", "Configuration");
    }

    public DependPage createDependPage() {
        return new DependPage(this, "depend", "Dependencies");
    }

    public DeviceKitFormPage createExternalPage() {
        return new ExternalPage(this, "external", "External");
    }

    public OverviewPage createOverviewPage() {
        return new OverviewPage(this, "overview", "Overview");
    }

    public ProtocolPage createProtocolPage() {
        return new ProtocolPage(this, "protocol", "Protocol");
    }

    public DeviceKitSourcePage createSourcePage() {
        return null;
    }

    public void dispose() {
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        DeviceKitSourcePage sourcePage = this.getSourcePage();
        if (sourcePage != null) {
            sourcePage.doSave(monitor);
        }
    }

    public void doSaveAs() {
        DeviceKitSourcePage sourcePage = this.getSourcePage();
        if (sourcePage != null) {
            sourcePage.doSaveAs();
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    public IDocument getDocument() {
        return this.getDocumentProvider().getDocument(this.getEditorInput());
    }

    public DkmlDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = new DkmlDocumentProvider();
        }
        return this.documentProvider;
    }

    public IFile getFile() {
        return this.file;
    }

    public Image getIcon(String iconName) {
        ImageDescriptor imageDescriptorXml;
        String lookupNameXml;
        ImageDescriptor imageDescriptor;
        Image image;
        Object object = this.getIcons().get(iconName);
        if (object instanceof Image) {
            return (Image)object;
        }
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("icons/");
        buffer.append(iconName);
        buffer.append(".gif");
        String lookupName = buffer.toString();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.devicekit.editor.DeviceKitEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((image = (imageDescriptor = ImageDescriptor.createFromFile((Class)clazz, (String)lookupName)).createImage(false)) == null) {
            buffer = new StringBuffer(32);
            buffer.append("icons/");
            buffer.append(iconName);
            buffer.append("_xml.gif");
            lookupNameXml = buffer.toString();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.soda.devicekit.editor.DeviceKitEditorPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            imageDescriptorXml = ImageDescriptor.createFromFile((Class)clazz2, (String)lookupNameXml);
            image = imageDescriptorXml.createImage(false);
        }
        Iterator iterator = this.icons.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = String.valueOf(entry.getKey());
            if (!iconName.endsWith(key)) continue;
            image = (Image)entry.getValue();
        }
        if (image == null) {
            buffer = new StringBuffer(32);
            buffer.append("icons/");
            buffer.append("unknowntag");
            buffer.append(".gif");
            lookupNameXml = buffer.toString();
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.soda.devicekit.editor.DeviceKitEditorPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            imageDescriptorXml = ImageDescriptor.createFromFile((Class)clazz3, (String)lookupNameXml);
            image = imageDescriptorXml.createImage(false);
        }
        if (image != null) {
            this.getIcons().put(iconName, image);
        }
        return image;
    }

    public Map getIcons() {
        return this.icons;
    }

    public TagElement getMainElement() {
        return this.mainElement;
    }

    public DkmlModel getModel() {
        return this.dkmlModel;
    }

    public DeviceKitContentOutlinePage getOutlinePage() {
        return this.outlinePage;
    }

    public Object[] getPageArray() {
        int length = this.pageArray.length;
        int size = this.pages.size();
        if (length == size - 1) {
            return this.pageArray;
        }
        Object[] newList = new Object[size - 1];
        int i = 0;
        while (i < size - 1) {
            newList[i] = this.pages.get(i);
            ++i;
        }
        this.pageArray = newList;
        return this.pageArray;
    }

    protected List getReferencedFiles(IFile file) throws Exception {
        DkmlReferenceResolver resolver = new DkmlReferenceResolver(file);
        return resolver.getReferences();
    }

    public DeviceKitSourcePage getSourcePage() {
        return this.sourcePage;
    }

    public String getString(String key) {
        try {
            return WizardMessages.getInstance().getString(key);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return key;
        }
    }

    public String getString(String key, String defaultValue) {
        try {
            return WizardMessages.getInstance().getString(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public DeviceKitTagModel getTagModel() {
        return this.tagModel;
    }

    public IWizardMessages getUiMessages() {
        return this.uiMessages;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setInput(input);
        this.initEditor();
        try {
            this.initModel();
        }
        catch (CoreException e) {
            throw new PartInitException(e.getMessage());
        }
    }

    public void initEditor() {
        IEditorInput input = this.getEditorInput();
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        this.initXml();
    }

    private void initModel() throws CoreException {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            DkmlDocumentProvider documentProvider = this.getDocumentProvider();
            documentProvider.connect(editorInput);
            IAnnotationModel amodel = documentProvider.getAnnotationModel(editorInput);
            if (amodel != null) {
                amodel.connect(documentProvider.getDocument(editorInput));
            }
            this.dkmlModel = new DkmlModel(this.getFile(), (IDocumentProvider)documentProvider, editorInput);
            IFile file = this.dkmlModel.getFile();
            try {
                DeviceKitContentOutlinePage outputPage;
                this.tagModel = new DeviceKitTagModel(file.getContents(true), this.getReferencedFiles(file), null);
                this.tagModel.build(false);
                MainTagElement mainElement = this.tagModel.getMainElement();
                this.setMainElement((TagElement)mainElement);
                if (mainElement != null) {
                    String id = mainElement.getAnyId();
                    this.setPartName(id);
                }
                if (this.outlinePage == null) {
                    this.outlinePage = new DeviceKitContentOutlinePage(this);
                }
                if ((outputPage = this.getOutlinePage()) != null) {
                    outputPage.setTagModel(this.tagModel);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void initXml() {
        IEditorSite site = this.getEditorSite();
        DeviceKitEditorEnvironment.connect(this);
        this.setDocumentProvider(this.getDocumentProvider());
        DkmlResourceChangedCenter.getInstance().addResouceChangeListener(this);
        site.setSelectionProvider(site.getSelectionProvider());
    }

    public boolean isSaveAsAllowed() {
        DeviceKitSourcePage sourcePage = this.getSourcePage();
        if (sourcePage != null) {
            sourcePage.isSaveAsAllowed();
        }
        return false;
    }

    protected boolean isSourceOnly() {
        return false;
    }

    public void resourceChanged(DkmlResourceChangedEvent event) {
        this.update();
    }

    public void setDocumentProvider(DkmlDocumentProvider documentProvider) {
        this.documentProvider = documentProvider;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public void setIcons(Map icons) {
        this.icons = icons;
    }

    public void setMainElement(TagElement mainElement) {
        this.mainElement = mainElement;
    }

    public void setModel(DkmlModel dkmlModel) {
        this.dkmlModel = dkmlModel;
    }

    public void setOutlinePage(DeviceKitContentOutlinePage outlinePage) {
        this.outlinePage = outlinePage;
    }

    public void setSourcePage(DeviceKitSourcePage sourcePage) {
        this.sourcePage = sourcePage;
        if (sourcePage != null) {
            sourcePage.setEditor(this);
        }
    }

    public void setTagModel(DeviceKitTagModel tagModel) {
        this.tagModel = tagModel;
    }

    public void setUiMessages(IWizardMessages uiMessages) {
        this.uiMessages = uiMessages;
    }

    private void setupIcons() {
        this.getIcon("block");
        this.getIcon("parameter");
        this.getIcon("segment");
        this.getIcon("command");
        this.getIcon("measurement");
        this.getIcon("signal");
        this.getIcon("transport");
        this.getIcon("device");
        this.getIcon("profile");
        this.getIcon("adapter");
        this.getIcon("receiver");
        this.getIcon("concrete");
    }

    public void update() {
        String newContents = null;
        DkmlModel model = this.getModel();
        String o = model.getTagContents();
        if (o == null) {
            return;
        }
        newContents = o;
        IDocument doc = this.getDocumentProvider().getDocument(this.getEditorInput());
        doc.set(newContents);
    }

    public void updateContents() {
        this.updateTagModel();
        DeviceKitContentOutlinePage deviceKitContentOutlinePage = this.getOutlinePage();
        if (deviceKitContentOutlinePage != null) {
            deviceKitContentOutlinePage.updateContents();
        }
        int count = this.getPageCount();
        int pageIndex = 0;
        while (pageIndex < count) {
            Object page = this.pages.get(pageIndex);
            if (page instanceof DeviceKitFormPage) {
                DeviceKitFormPage deviceKitFormPage = (DeviceKitFormPage)page;
                deviceKitFormPage.updateContents();
            }
            ++pageIndex;
        }
    }

    public void updateTagModel() {
        if (this.tagModel != null) {
            try {
                IFile file = this.dkmlModel.getFile();
                DeviceKitTagModel tagModelNew = new DeviceKitTagModel(file.getContents(true), this.getReferencedFiles(file), null);
                tagModelNew.build();
                this.tagModel.build();
                this.tagModel = tagModelNew;
                MainTagElement mainElement = tagModelNew.getMainElement();
                this.setMainElement((TagElement)mainElement);
                if (mainElement != null) {
                    String id = mainElement.getAnyId();
                    this.setPartName(id);
                }
            }
            catch (Exception exception) {
                this.setPartName("error");
                exception.printStackTrace();
            }
        }
    }
}

