/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormEditor;
import org.eclipse.soda.devicekit.editor.dkml.DkmlModel;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DeviceKitFormPage
extends FormPage
implements Comparator {
    private Map ids = new HashMap();
    private Map idrefs = new HashMap();
    private FormToolkit toolkit;

    public DeviceKitFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public DeviceKitFormPage(String id, String title) {
        super(id, title);
    }

    public void addId(TagElement element, Section section) {
        String rawId = element.getIdRaw();
        if (rawId != null && rawId.length() > 0) {
            this.getIds().put(rawId, section);
        } else {
            String idref = element.getIdRef();
            if (idref != null && idref.length() > 0) {
                this.getIds().put(idref, section);
            }
        }
    }

    public int compare(Object o1, Object o2) {
        String e1;
        String e0 = ((TagElement)o1).getExternalId();
        if (e0 == null) {
            e0 = ((TagElement)o1).getAnyId();
        }
        if ((e1 = ((TagElement)o2).getExternalId()) == null) {
            e1 = ((TagElement)o2).getAnyId();
        }
        if (e0 != null && e1 != null) {
            String s0 = CodeUtilities.betterName((String)e0, (boolean)false);
            String s1 = CodeUtilities.betterName((String)e1, (boolean)false);
            StringTokenizer st0 = new StringTokenizer(s0, " ");
            StringTokenizer st1 = new StringTokenizer(s1, " ");
            int st0Count = st0.countTokens();
            int st1Count = st1.countTokens();
            int min = Math.min(st0Count, st1Count);
            int i = 0;
            while (i < min) {
                String token1;
                String token0 = st0.nextToken();
                int result = token0.compareTo(token1 = st1.nextToken());
                if (result != 0) {
                    try {
                        long i0 = Long.parseLong(token0);
                        long i1 = Long.parseLong(token1);
                        return (int)(i0 - i1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return result;
                    }
                }
                ++i;
            }
            return st0Count - st1Count;
        }
        return 0;
    }

    public Button createCheckbox(FormToolkit toolkit, Composite container, String id, boolean value, boolean enable) {
        String text = this.getString(id);
        Button button = toolkit.createButton(container, text, 32);
        button.setData((Object)id);
        String hint = this.getString(String.valueOf(id) + ".hint");
        if (hint != null && hint.length() > 0) {
            button.setToolTipText(hint);
        }
        TableWrapData data = new TableWrapData(256);
        data.colspan = 3;
        data.rowspan = 1;
        data.grabHorizontal = true;
        data.grabVertical = false;
        button.setLayoutData((Object)data);
        button.setSelection(value);
        button.setEnabled(enable);
        return button;
    }

    public Button createCheckboxAndText(FormToolkit toolkit, Composite container, String id, boolean value, String string, boolean enable) {
        String textValue = this.getString(id);
        Button button = toolkit.createButton(container, textValue, 32);
        button.setData((Object)id);
        String hint = this.getString(String.valueOf(id) + ".hint");
        if (hint != null && hint.length() > 0) {
            button.setToolTipText(hint);
        }
        TableWrapData data = new TableWrapData(256);
        data.colspan = 1;
        data.rowspan = 1;
        data.grabHorizontal = false;
        data.grabVertical = false;
        button.setLayoutData((Object)data);
        button.setSelection(value);
        button.setEnabled(enable);
        Text text = toolkit.createText(container, string, 2114);
        text.setData((Object)id);
        if (hint != null && hint.length() > 0) {
            text.setToolTipText(hint);
        }
        TableWrapData dataLayout = new TableWrapData(256);
        dataLayout.colspan = 2;
        dataLayout.rowspan = 1;
        dataLayout.grabHorizontal = true;
        dataLayout.grabVertical = false;
        text.setLayoutData((Object)dataLayout);
        text.setEnabled(enable);
        return button;
    }

    public Section createSection(FormToolkit toolkit, Composite parent, String id, int columnCount, boolean expand) {
        return this.createSection(toolkit, parent, id, columnCount, expand, null);
    }

    public Section createSection(FormToolkit toolkit, Composite parent, String id, int columnCount, boolean expand, Object extended) {
        String text = this.getString(id);
        String description = this.getString(String.valueOf(id) + ".description");
        boolean descriptionNeeded = description != null && description.length() > 0;
        int style = descriptionNeeded ? 384 : 258;
        Section section = toolkit.createSection(parent, style);
        TableWrapData data = new TableWrapData(256);
        data.colspan = 1;
        data.rowspan = 1;
        data.grabHorizontal = true;
        data.grabVertical = false;
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = columnCount;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        if (descriptionNeeded) {
            section.setDescription(description);
        }
        section.setText(text);
        if (extended != null) {
            Label textClient = toolkit.createLabel((Composite)section, String.valueOf(extended));
            section.setTextClient((Control)textClient);
        }
        if (expand) {
            section.setExpanded(expand);
        }
        return section;
    }

    public Section createTagSection(Composite elementsContainer, TagElement element) {
        String id = element.getAnyId();
        String betterName = CodeUtilities.betterName((String)id, (int)2);
        String name = element.getTagName();
        Section elementSection = this.createTreeTagSection(this.getToolkit(), elementsContainer, betterName, 3, name);
        elementSection.setData((Object)element);
        this.addId(element, elementSection);
        elementSection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledForm scrolledPageContent;
                Section section = (Section)e.getSource();
                boolean remove = DeviceKitFormPage.this.expandTagSection(section);
                if (remove) {
                    section.removeExpansionListener((IExpansionListener)this);
                }
                if ((scrolledPageContent = DeviceKitFormPage.this.getScrolledForm((Control)section)) != null) {
                    scrolledPageContent.reflow(true);
                }
                section.removeExpansionListener((IExpansionListener)this);
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        return elementSection;
    }

    public Section createTagsSection(Composite parent, final List elementList, String type) {
        final int elementSize = elementList.size();
        final Section elementsSection = this.createSection(this.getToolkit(), parent, type, 1, false, new Integer(elementSize));
        elementsSection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                Object source = e.getSource();
                if (source instanceof Section) {
                    Section section = (Section)e.getSource();
                    Composite elementsContainer = (Composite)elementsSection.getClient();
                    if (elementsContainer != null && !elementsContainer.isDisposed() && elementsContainer.getChildren().length == 0 && section.isExpanded()) {
                        TagElement[] elements = new TagElement[elementSize];
                        elements = elementList.toArray(elements);
                        Arrays.sort(elements, DeviceKitFormPage.this);
                        int i = 0;
                        while (i < elements.length) {
                            TagElement element = elements[i];
                            String id = element.getAnyId();
                            if (id != null) {
                                DeviceKitFormPage.this.createTagSection(elementsContainer, element);
                            }
                            ++i;
                        }
                        ScrolledForm scrolledPageContent = DeviceKitFormPage.this.getScrolledForm((Control)section);
                        if (scrolledPageContent != null) {
                            scrolledPageContent.reflow(true);
                        }
                        section.removeExpansionListener((IExpansionListener)this);
                    }
                }
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        return elementsSection;
    }

    public Text createText(FormToolkit toolkit, Composite container, String id, String value, boolean enable) {
        String labelText = this.getString(id, id);
        Label label = toolkit.createLabel(container, labelText);
        Color color = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        label.setForeground(color);
        TableWrapData layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        layoutData.rowspan = 1;
        layoutData.grabHorizontal = false;
        layoutData.grabVertical = false;
        label.setLayoutData((Object)layoutData);
        TableWrapData data = new TableWrapData(256);
        data.colspan = 2;
        data.rowspan = 1;
        data.grabHorizontal = true;
        data.grabVertical = false;
        data.maxWidth = 200;
        Text text = toolkit.createText(container, value, 2114);
        text.setData((Object)id);
        String hint = this.getString(String.valueOf(id) + ".hint", "");
        if (hint != null && hint.length() > 0) {
            text.setToolTipText(hint);
            label.setToolTipText(hint);
        }
        text.setLayoutData((Object)data);
        text.setEnabled(enable);
        return text;
    }

    public Section createTreeSection(FormToolkit toolkit, Composite parent, String text, int columnCount) {
        DeviceKitFormEditor deviceKitFormEditor;
        Image image;
        Section section = toolkit.createSection(parent, 292);
        TableWrapData data = new TableWrapData(256);
        data.colspan = 1;
        data.rowspan = 1;
        data.grabHorizontal = true;
        data.grabVertical = false;
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = columnCount;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        section.setLayout((Layout)layout);
        section.setText(text);
        FormEditor editor = this.getEditor();
        if (editor instanceof DeviceKitFormEditor && (image = (deviceKitFormEditor = (DeviceKitFormEditor)editor).getIcon("sort")) != null) {
            Label label = toolkit.createLabel((Composite)section, "");
            label.setImage(image);
            section.setTextClient((Control)label);
        }
        return section;
    }

    public Section createTreeTagSection(FormToolkit toolkit, Composite parent, String text, int columnCount, String type) {
        DeviceKitFormEditor deviceKitFormEditor;
        Image image;
        Section section = toolkit.createSection(parent, 292);
        TableWrapData data = new TableWrapData(256);
        data.colspan = 1;
        data.rowspan = 1;
        data.grabHorizontal = true;
        data.grabVertical = false;
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = columnCount;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        section.setLayout((Layout)layout);
        section.setText(text);
        FormEditor editor = this.getEditor();
        if (editor instanceof DeviceKitFormEditor && (image = (deviceKitFormEditor = (DeviceKitFormEditor)editor).getIcon(type)) != null) {
            Label label = toolkit.createLabel((Composite)section, "");
            label.setImage(image);
            section.setTextClient((Control)label);
        }
        return section;
    }

    public boolean expandTagSection(Section section) {
        if (section.isExpanded()) {
            Composite elementContainer = (Composite)section.getClient();
            if (elementContainer.getChildren().length == 0) {
                ScrolledForm scrolledPageContent;
                TagElement element = (TagElement)section.getData();
                String id = element.getAnyId();
                if (id != null) {
                    String description;
                    String externalId = element.getExternalId();
                    if (externalId != null && !id.equals(externalId)) {
                        this.createText(this.getToolkit(), elementContainer, "externalId", externalId, true);
                    }
                    if ((description = element.getDescription()) != null && description.length() > 0) {
                        this.createText(this.getToolkit(), elementContainer, "description", description, true);
                    }
                }
                NamedNodeMap attributes = element.getNode().getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    Node attribute = attributes.item(i);
                    String name = attribute.getNodeName();
                    String value = attribute.getNodeValue();
                    this.createText(this.getToolkit(), elementContainer, name, value, true);
                    ++i;
                }
                List children = element.getOutlineChildren();
                if (children.size() > 0) {
                    int i2 = 0;
                    while (i2 < children.size()) {
                        TagElement child = (TagElement)children.get(i2);
                        Section childSection = this.createTagSection(elementContainer, child);
                        TableWrapData layoutData = new TableWrapData(256);
                        layoutData.colspan = 3;
                        layoutData.rowspan = 1;
                        layoutData.grabHorizontal = true;
                        layoutData.grabVertical = false;
                        childSection.setLayoutData((Object)layoutData);
                        ++i2;
                    }
                }
                if ((scrolledPageContent = this.getScrolledForm((Control)section)) != null) {
                    scrolledPageContent.reflow(true);
                }
            }
            return true;
        }
        return false;
    }

    public Map getIdrefs() {
        return this.idrefs;
    }

    public Map getIds() {
        return this.ids;
    }

    public Image getImage() {
        return this.getEditor().getTitleImage();
    }

    public Image getMeasurementImage() {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(this.getClass(), (String)"measurement.gif");
        return imageDescriptor.createImage(true);
    }

    public DkmlModel getModel() {
        FormEditor editor = this.getEditor();
        if (editor instanceof DeviceKitFormEditor) {
            DeviceKitFormEditor dkEditor = (DeviceKitFormEditor)editor;
            return dkEditor.getModel();
        }
        return null;
    }

    protected List getReferencedFiles(IFile file) throws Exception {
        DkmlReferenceResolver resolver = new DkmlReferenceResolver(file);
        return resolver.getReferences();
    }

    public ScrolledForm getScrolledForm(Control control) {
        Composite parent = control.getParent();
        while (parent != null) {
            if (parent instanceof ScrolledForm) {
                return (ScrolledForm)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public String getString(String key) {
        FormEditor editor = this.getEditor();
        if (editor instanceof DeviceKitFormEditor) {
            DeviceKitFormEditor devicekitEditor = (DeviceKitFormEditor)editor;
            return devicekitEditor.getString(key);
        }
        return key;
    }

    public String getString(String key, String defaultValue) {
        FormEditor editor = this.getEditor();
        if (editor instanceof DeviceKitFormEditor) {
            DeviceKitFormEditor devicekitEditor = (DeviceKitFormEditor)editor;
            return devicekitEditor.getString(key, defaultValue);
        }
        return key;
    }

    public DeviceKitTagModel getTagModel() {
        FormEditor editor = this.getEditor();
        if (editor instanceof DeviceKitFormEditor) {
            DeviceKitFormEditor dkEditor = (DeviceKitFormEditor)editor;
            return dkEditor.getTagModel();
        }
        return null;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public void select(TagElement element) {
        String rawId = element.getIdRaw();
        Object value = null;
        if (rawId != null && rawId.length() > 0) {
            value = this.getIds().get(rawId);
        } else {
            String idref = element.getIdRef();
            if (idref != null && idref.length() > 0) {
                value = this.getIds().get(idref);
            }
        }
        if (value instanceof Section) {
            Section section = value;
            if (!section.isExpanded()) {
                section.setExpanded(true);
                this.expandTagSection(section);
                section.redraw();
            } else {
                section.setFocus();
            }
        }
    }

    public void setIdrefs(Map idrefs) {
        this.idrefs = idrefs;
    }

    public void setIds(Map ids) {
        this.ids = ids;
    }

    public void setToolkit(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public Composite setup(IManagedForm managedForm, int numberColumns) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.setToolkit(toolkit);
        Composite parent = form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numberColumns;
        layout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)layout);
        DeviceKitTagModel dkFileModel = this.getTagModel();
        String id = this.getId();
        if (dkFileModel != null) {
            MainTagElement mainElement = dkFileModel.getMainElement();
            String pattern = this.getString(String.valueOf(id) + ".section");
            String betterTitle = CodeUtilities.betterName((String)mainElement.getAnyId(), (int)2);
            String title = Nls.format((String)pattern, (Object)betterTitle);
            form.setText(title);
        } else {
            form.setText(this.getTitle());
        }
        Image image = this.getImage();
        if (image != null) {
            form.setImage(image);
        }
        return parent;
    }

    public void update() {
    }

    public void updateContents() {
        IManagedForm form = this.getManagedForm();
        if (form != null) {
            form.refresh();
        }
    }
}

