/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGeneratorMessages;
import org.eclipse.soda.devicekit.generator.model.GenXmlErrorHandler;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.RootElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DeviceKitTagModel {
    private String schema;
    private Document fMainDoc;
    private RootElement fRoot;
    private InputStream stream;
    private List references;
    private boolean followReferences = true;

    public DeviceKitTagModel(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public DeviceKitTagModel(File file, List references) throws FileNotFoundException {
        this(new FileInputStream(file), references);
    }

    public DeviceKitTagModel(InputStream stream) {
        this(stream, new ArrayList());
    }

    public DeviceKitTagModel(InputStream stream, List references) {
        this.stream = stream;
        this.references = references;
    }

    public DeviceKitTagModel(InputStream stream, List references, String schema) {
        this.stream = stream;
        this.references = references;
        this.schema = schema;
    }

    public DeviceKitTagModel(InputStream stream, List references, String schema, boolean followReferences) {
        this.stream = stream;
        this.references = references;
        this.schema = schema;
        this.followReferences = followReferences;
    }

    public void build() throws Exception {
        this.build(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(boolean validate) throws Exception {
        try {
            try {
                this.fMainDoc = this.doDomParse(validate);
                Node root = ParserUtilities.findChildNode("dkml", this.fMainDoc);
                if (root == null) throw new Exception(DeviceKitGeneratorMessages.getString("DkTagModel.error.dkml.tag.required"));
                RootElement rootElement = new RootElement(root, this.references, this.followReferences);
                this.setRoot(rootElement);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.stream.close();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.stream.close();
    }

    private Document doDomParse(boolean validate) throws Exception {
        return ParserUtilities.parseDeviceKit(this.stream, new GenXmlErrorHandler());
    }

    public String getIncubation() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getIncubation();
        }
        return "";
    }

    public MainTagElement getMainElement() {
        List children = this.getRoot().getChildren();
        int i = 0;
        while (i < children.size()) {
            Object object = children.get(i);
            if (object instanceof MainTagElement) {
                return (MainTagElement)object;
            }
            ++i;
        }
        return null;
    }

    public String getProvider() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getProvider();
        }
        return this.getRoot().getVersion();
    }

    public List getReferences() {
        return this.references;
    }

    public RootElement getRoot() {
        return this.fRoot;
    }

    public String getSchema() {
        return this.schema;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getVendor() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getVendor();
        }
        return this.getRoot().getVendor();
    }

    public String getVendors() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getVendors();
        }
        return this.getRoot().getVendor();
    }

    public String getVersion() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getVersion();
        }
        return this.getRoot().getVersion();
    }

    public Node getXmlDocument() {
        return this.fMainDoc;
    }

    public void setReferences(List references) {
        this.references = references;
    }

    private void setRoot(RootElement root) {
        this.fRoot = root;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }
}

