/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.Nls;

public class DkAdapterGenerator
extends DkDeviceGenerator {
    protected TagElement targetDevice;

    public DkAdapterGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap(), 0);
    }

    public DkAdapterGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map properties, int bundleType) {
        super(model, generatedInfo, properties, bundleType);
    }

    protected void codeDefaultTransport(IType device) {
        boolean needed;
        String deviceServiceName = DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE;
        String returnType = DeviceKitUtilities.stripPackage(deviceServiceName);
        String comment = Nls.format(DeviceKitGenerator.getResource("DkDeviceGenerator.get.default.device.comment1"), DeviceKitUtilities.stripPackage(deviceServiceName));
        this.fDeviceModel.addImport(deviceServiceName);
        List list = this.getMainElement().getDeviceChildren();
        String contents = this.getDefaultDeviceContents(deviceServiceName);
        this.codeMethod(device, "getDefaultDevice", comment, returnType, 1L, contents);
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("return ");
        boolean bl = needed = list.size() == 0;
        if (needed) {
            buffer.append("false;");
        } else {
            buffer.append("true;");
        }
        if (needed || !this.isAbstract()) {
            this.codeMethod(device, "isDeviceNeeded", "", "boolean", 1L, buffer.toString());
        }
    }

    protected AdapterElement getAdapterElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (72 == ((TagElement)children.get(i)).getTagCode()) {
                return (AdapterElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_ADAPTER_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_ADAPTER_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_ADAPTER_BUNDLE_ACTIVATOR;
    }

    protected String getDefaultDeviceContents(String transportServiceName) {
        StringBuffer buffer = new StringBuffer(64);
        List list = this.getMainElement().getDeviceChildren();
        if (list.size() > 0) {
            TagElement te = (TagElement)list.get(0);
            if (transportServiceName == null) {
                buffer.append("return null;");
            } else {
                String implementation = te.getClassNameFull();
                buffer.append("return (");
                buffer.append(DeviceKitUtilities.stripPackage(transportServiceName));
                buffer.append(") loadService(");
                buffer.append(DeviceKitUtilities.stripPackage(transportServiceName));
                buffer.append(".SERVICE_NAME, \"");
                buffer.append(implementation);
                this.buildModel.addAdditionalBundles(DeviceKitUtilities.extractPackage(implementation));
                buffer.append("\");");
            }
        } else {
            buffer.append("return null;");
        }
        return buffer.toString();
    }

    public String getServiceClassParent() {
        return DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE;
    }

    public TagElement getTargetDevice() {
        return this.targetDevice;
    }

    protected void initialize() {
        List adapters = this.getRootElement().getAllChildrenWithTagCode(72);
        AdapterElement adapter = (AdapterElement)adapters.get(0);
        this.setDevice(adapter);
        List devices = adapter.getAllChildrenWithTagCode(8);
        if (devices.size() > 0) {
            TagElement device = (TagElement)devices.get(0);
            this.setTargetDevice(device);
        }
        this.setTransport(adapter.getTransportElement());
        this.setMainTagElement(adapter);
        String className = DeviceKitUtilities.getClassNameFromTagElement(adapter);
        this.setMainClassName(className);
        this.setPackageBase(adapter.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        if (adapter.getAttribute("lazy") == null || "false".equals(adapter.getAttribute("lazy"))) {
            this.setLazy(false);
        } else {
            this.setLazy(true);
        }
        if (adapter.hasChildWithTagCode(45)) {
            this.setInitializeMeasurements(true);
        } else {
            this.setInitializeMeasurements(false);
        }
        String initWithMethod = adapter.getAttribute("createmethod");
        if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
            this.setInitializeWithMethod(true);
        } else {
            this.setInitializeWithMethod(false);
        }
        this.setupExportedPackages();
        this.initializeGet();
    }

    public void setTargetDevice(TagElement targetDevice) {
        this.targetDevice = targetDevice;
    }
}

