/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.List;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationElement;
import org.eclipse.soda.devicekit.generator.model.elements.FieldElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessagesElement;
import org.eclipse.soda.devicekit.generator.model.elements.MethodElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public abstract class ControlItem
extends TagElement {
    private String fRate;
    private String field;

    protected ControlItem(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getCodeKey() {
        String key = this.getKey();
        int index = key.lastIndexOf(47);
        if (index < 0) {
            return key;
        }
        return key.substring(index + 1);
    }

    public String getField() {
        return this.field;
    }

    public String[] getFieldComment() {
        if (this.hasMethodChild()) {
            String[] comment = super.getFieldComment();
            String[] newComment = new String[comment.length + 1];
            System.arraycopy(comment, 0, newComment, 0, comment.length);
            newComment[comment.length] = "@see #" + this.getHandleString() + this.getCodeKey();
            return newComment;
        }
        return super.getFieldComment();
    }

    public String getHandleString() {
        return "handleMethod";
    }

    public String getId() {
        if (this.getAttribute("id") != null) {
            return this.getAttribute("id");
        }
        if (this.getKey(true) != null) {
            return this.getKey(true);
        }
        return null;
    }

    public String getRate() {
        return this.fRate;
    }

    public String[] getServiceFieldComment() {
        return super.getFieldComment();
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("rate".equals(childNodeName)) {
            this.setRate(ParserUtilities.extractData(childNode));
        } else if ("message".equals(childNodeName)) {
            this.handleMessage(childNode);
        } else if ("messages".equals(childNodeName)) {
            this.handleMessages(childNode);
        } else if ("configuration".equals(childNodeName)) {
            this.handleConfiguration(childNode);
        } else if ("method".equals(childNodeName)) {
            this.handleMethod(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleConfiguration(Node node) {
        ConfigurationElement element = new ConfigurationElement(node, this);
        if (element.isOn()) {
            this.addChild(element);
        }
    }

    protected void handleField(Node node) {
        this.setField(ParserUtilities.extractData(node));
        this.addChild(new FieldElement(node, this));
    }

    protected void handleMessage(Node node) {
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            TagElement element = TagElement.collection.getMessage(idref);
            if (element == null) {
                throw new RuntimeException("missing message idref=" + idref);
            }
            this.addChild(element);
        } else {
            String messageId;
            MessageElement me = new MessageElement(node, this);
            this.addChild(me);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    TagElement.collection.addMessage(me.getId(), me);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
            if (this.getId() != null && (messageId = this.getIdForMessage(this.getId(), me)) != null) {
                me.setAttribute("id", messageId);
                try {
                    TagElement.collection.addMessage(me.getId(), me);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    protected void handleMessages(Node node) {
        MessagesElement me = new MessagesElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleMethod(Node node) {
        this.addChild(new MethodElement(node, this));
    }

    protected boolean hasMethodChild() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof MethodElement) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isError() {
        String value = this.getAttribute("error");
        if (value == null) {
            return true;
        }
        return value.equals("1") || value.toLowerCase().equals("true");
    }

    public void setField(String field) {
        this.field = field;
    }

    protected void setRate(String rate) {
        this.fRate = rate;
    }
}

