/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.io.IOException;
import java.util.List;
import org.eclipse.soda.devicekit.generator.model.BytesGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.ArrayParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.AsciiElement;
import org.eclipse.soda.devicekit.generator.model.elements.BitsParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.BooleanParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ByteParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.BytesElement;
import org.eclipse.soda.devicekit.generator.model.elements.BytesItem;
import org.eclipse.soda.devicekit.generator.model.elements.BytesParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ChoiceSegmentElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConstantBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.CountBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.DoubleParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.FilterElement;
import org.eclipse.soda.devicekit.generator.model.elements.FloatParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.GeneralParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.IdentifierBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.IntegerParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.LengthBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.ListParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.LongParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MapParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageLengthBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageSizeBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.NibblesElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParameterSegmentElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParametersElement;
import org.eclipse.soda.devicekit.generator.model.elements.ReserveBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.SegmentLengthBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.SegmentSizeBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.SentMessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.ShortParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.SingleParameterSegmentElement;
import org.eclipse.soda.devicekit.generator.model.elements.SizeBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.StringParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TypeBlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnsignedByteParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnsignedIntegerParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnsignedLongParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnsignedShortParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.Utf8Element;
import org.eclipse.soda.devicekit.generator.model.elements.Utf8StringParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.VariableLengthParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.VersionBlockElement;
import org.eclipse.soda.devicekit.generator.util.BinaryOuputStream;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public abstract class MessageClassItem
extends TagElement {
    protected static final byte[] lenmasks = new byte[]{-1, -128, -64, -32, -16, -8, -4, -2};
    protected static final byte[] masks = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};

    protected MessageClassItem(Node node, TagElement parent) {
        super(node, parent);
    }

    public byte[] getBytes() {
        List list = this.getByteChildren();
        switch (list.size()) {
            case 0: {
                List parameters = this.getParameterChildren();
                int parameterSize = parameters.size();
                int newCode = 0;
                BytesGenerator byteGenerator = new BytesGenerator();
                if (parameterSize > 0) {
                    int i = 0;
                    while (i < parameterSize) {
                        TagElement tagElement = (TagElement)parameters.get(i);
                        if (tagElement instanceof GeneralParameterElement) {
                            ++newCode;
                        }
                        tagElement.updateBytes(byteGenerator);
                        ++i;
                    }
                }
                if (newCode > 0) {
                    return byteGenerator.getBytes();
                }
                int length = this.getBitLengthValue(this.getLengthDefault());
                int offset = this.getBitOffsetValue(this.getOffsetDefault());
                int total = offset + length + 7 >> 3;
                if (total > 0) {
                    byte[] bytes = new byte[total];
                    int i = 0;
                    while (i < total) {
                        bytes[i] = i * 8 >= offset && i < total ? -1 : 0;
                        ++i;
                    }
                    bytes[offset >> 3] = masks[offset % 8];
                    bytes[total - 1] = total - 1 == offset >> 3 ? (byte)(bytes[total - 1] & lenmasks[(offset + length) % 8]) : lenmasks[(offset + length) % 8];
                    return bytes;
                }
                return null;
            }
        }
        BinaryOuputStream byteArrayOutputStream = new BinaryOuputStream(100);
        int i = 0;
        while (i < list.size()) {
            BytesItem bytesItem = (BytesItem)list.get(i);
            try {
                bytesItem.append(byteArrayOutputStream);
            }
            catch (IOException exception) {
                throw this.error(exception.getMessage());
            }
            ++i;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getOffsetDefault() {
        return 0;
    }

    protected void handleArrayParameter(Node node) {
        ArrayParameterElement pe = new ArrayParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleAscii(Node node) {
        AsciiElement element = new AsciiElement(node, this);
        this.addChild(element);
    }

    protected void handleBitsParameter(Node node) {
        BitsParameterElement pe = new BitsParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleBooleanParameter(Node node) {
        BooleanParameterElement pe = new BooleanParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleByteParameter(Node node) {
        ByteParameterElement pe = new ByteParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleBytes(Node node) {
        BytesElement element = new BytesElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.add(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleBytesParameter(Node node) {
        BytesParameterElement pe = new BytesParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleChoiceSegment(Node node) {
        ChoiceSegmentElement pe = new ChoiceSegmentElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleConstantBlock(Node node) {
        ConstantBlockElement pe = new ConstantBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleCountBlock(Node node) {
        CountBlockElement pe = new CountBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleDoubleParameter(Node node) {
        DoubleParameterElement pe = new DoubleParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleFilter(Node node) {
        FilterElement fe = new FilterElement(node, this);
        this.addChild(fe);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addFilter(fe.getId(), fe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleFloatParameter(Node node) {
        FloatParameterElement pe = new FloatParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleIdentifierBlock(Node node) {
        IdentifierBlockElement pe = new IdentifierBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleIntegerParameter(Node node) {
        IntegerParameterElement pe = new IntegerParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleLengthBlock(Node node) {
        LengthBlockElement pe = new LengthBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleListParameter(Node node) {
        ListParameterElement pe = new ListParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleLongParameter(Node node) {
        LongParameterElement pe = new LongParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleMapParameter(Node node) {
        MapParameterElement pe = new MapParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleMessage(Node node) {
        MessageElement me = new MessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleMessageLengthBlock(Node node) {
        MessageLengthBlockElement pe = new MessageLengthBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleMessageSizeBlock(Node node) {
        MessageSizeBlockElement pe = new MessageSizeBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleNibbles(Node node) {
        NibblesElement element = new NibblesElement(node, this);
        this.addChild(element);
    }

    protected void handleParameter(Node node) {
        ParameterElement pe = new ParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleParameters(Node node) {
        ParametersElement element = new ParametersElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addParameter(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleParameterSegment(Node node) {
        ParameterSegmentElement pe = new ParameterSegmentElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleReserveBlock(Node node) {
        ReserveBlockElement pe = new ReserveBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleSegmentLengthBlock(Node node) {
        SegmentLengthBlockElement pe = new SegmentLengthBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleSegmentSizeBlock(Node node) {
        SegmentSizeBlockElement pe = new SegmentSizeBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleSentMessage(Node node) {
        SentMessageElement element = new SentMessageElement(node, this);
        this.addChild(element);
    }

    protected void handleShortParameter(Node node) {
        ShortParameterElement pe = new ShortParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleSingleParameterSegment(Node node) {
        SingleParameterSegmentElement pe = new SingleParameterSegmentElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleSizeBlock(Node node) {
        SizeBlockElement pe = new SizeBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    public void handleSpecificBlock(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("lengthblock".equals(childNodeName)) {
            this.handleLengthBlock(childNode);
        } else if ("sizeblock".equals(childNodeName)) {
            this.handleSizeBlock(childNode);
        } else if ("messagesizeblock".equals(childNodeName)) {
            this.handleMessageSizeBlock(childNode);
        } else if ("segmentsizeblock".equals(childNodeName)) {
            this.handleSegmentSizeBlock(childNode);
        } else if ("messagelengthblock".equals(childNodeName)) {
            this.handleMessageLengthBlock(childNode);
        } else if ("segmentlengthblock".equals(childNodeName)) {
            this.handleSegmentLengthBlock(childNode);
        } else if ("typeblock".equals(childNodeName)) {
            this.handleTypeBlock(childNode);
        } else if ("versionblock".equals(childNodeName)) {
            this.handleVersionBlock(childNode);
        } else if ("countblock".equals(childNodeName)) {
            this.handleCountBlock(childNode);
        } else if ("reserveblock".equals(childNodeName)) {
            this.handleReserveBlock(childNode);
        } else if ("identifierblock".equals(childNodeName)) {
            this.handleIdentifierBlock(childNode);
        } else if ("constantblock".equals(childNodeName)) {
            this.handleConstantBlock(childNode);
        } else if ("block".equals(childNodeName)) {
            this.handleConstantBlock(childNode);
        } else if ("idblock".equals(childNodeName)) {
            this.handleIdentifierBlock(childNode);
        }
    }

    public void handleSpecificParameter(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("integerparameter".equals(childNodeName)) {
            this.handleIntegerParameter(childNode);
        } else if ("unsignedintegerparameter".equals(childNodeName)) {
            this.handleUnsignedIntegerParameter(childNode);
        } else if ("longparameter".equals(childNodeName)) {
            this.handleLongParameter(childNode);
        } else if ("unsignedlongparameter".equals(childNodeName)) {
            this.handleUnsignedLongParameter(childNode);
        } else if ("shortparameter".equals(childNodeName)) {
            this.handleShortParameter(childNode);
        } else if ("unsignedshortparameter".equals(childNodeName)) {
            this.handleUnsignedShortParameter(childNode);
        } else if ("byteparameter".equals(childNodeName)) {
            this.handleByteParameter(childNode);
        } else if ("bitsparameter".equals(childNodeName)) {
            this.handleBitsParameter(childNode);
        } else if ("bytesparameter".equals(childNodeName)) {
            this.handleBytesParameter(childNode);
        } else if ("unsignedbyteparameter".equals(childNodeName)) {
            this.handleUnsignedByteParameter(childNode);
        } else if ("booleanparameter".equals(childNodeName)) {
            this.handleBooleanParameter(childNode);
        } else if ("doubleparameter".equals(childNodeName)) {
            this.handleDoubleParameter(childNode);
        } else if ("floatparameter".equals(childNodeName)) {
            this.handleFloatParameter(childNode);
        } else if ("variablelengthparameter".equals(childNodeName)) {
            this.handleVariableLengthParameter(childNode);
        } else if ("utf8stringparameter".equals(childNodeName)) {
            this.handleUtf8StringParameter(childNode);
        } else if ("stringparameter".equals(childNodeName)) {
            this.handleStringParameter(childNode);
        } else if ("mapparameter".equals(childNodeName)) {
            this.handleMapParameter(childNode);
        } else if ("listparameter".equals(childNodeName)) {
            this.handleListParameter(childNode);
        } else if ("arrayparameter".equals(childNodeName)) {
            this.handleArrayParameter(childNode);
        }
    }

    public void handleSpecificSegment(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("choicesegment".equals(childNodeName)) {
            this.handleChoiceSegment(childNode);
        } else if ("parametersegment".equals(childNodeName)) {
            this.handleParameterSegment(childNode);
        } else if ("singleparametersegment".equals(childNodeName)) {
            this.handleSingleParameterSegment(childNode);
        }
    }

    protected void handleStringParameter(Node node) {
        StringParameterElement pe = new StringParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleTypeBlock(Node node) {
        TypeBlockElement pe = new TypeBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleUnsignedByteParameter(Node node) {
        UnsignedByteParameterElement pe = new UnsignedByteParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleUnsignedIntegerParameter(Node node) {
        UnsignedIntegerParameterElement pe = new UnsignedIntegerParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleUnsignedLongParameter(Node node) {
        UnsignedLongParameterElement pe = new UnsignedLongParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleUnsignedShortParameter(Node node) {
        UnsignedShortParameterElement pe = new UnsignedShortParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleUtf8(Node node) {
        Utf8Element element = new Utf8Element(node, this);
        this.addChild(element);
    }

    protected void handleUtf8StringParameter(Node node) {
        Utf8StringParameterElement pe = new Utf8StringParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleVariableLengthParameter(Node childNode) {
        VariableLengthParameterElement pe = new VariableLengthParameterElement(childNode, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleVersionBlock(Node node) {
        VersionBlockElement pe = new VersionBlockElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    public boolean isMessageClassElement() {
        return true;
    }

    protected boolean isSimple() {
        byte[] bytes = this.getBytes();
        if (bytes != null) {
            int start = 0;
            start = 0;
            while (start < bytes.length) {
                if (bytes[start] != 0) break;
                ++start;
            }
            int end = 0;
            end = bytes.length - 1;
            while (end >= 0) {
                if (bytes[end] != 0) break;
                --end;
            }
            int i = start;
            while (i <= end) {
                if (bytes[i] != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

