/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.model.elements.RootElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;

public class TagCollection {
    protected List controlRefs;
    private List fCommands;
    private List fFilters;
    private List fIds = new ArrayList(256);
    private List fMeasurements;
    private List fMessages;
    private List fParameters;
    private List fPids;
    private RootElement fRoot;
    private List fSends;
    private List fSignals;
    private List fTransforms;
    private List fUnits;
    private List specs;
    private List enums;
    private List datas;
    private List specReferences;

    public TagCollection() {
        this.fCommands = new ArrayList(32);
        this.fFilters = new ArrayList(32);
        this.fMeasurements = new ArrayList(32);
        this.fMessages = new ArrayList(32);
        this.fParameters = new ArrayList(32);
        this.fPids = new ArrayList(256);
        this.fSignals = new ArrayList(32);
        this.fTransforms = new ArrayList();
        this.fUnits = new ArrayList();
        this.fSends = new ArrayList();
        this.specs = new ArrayList();
        this.specReferences = new ArrayList();
        this.enums = new ArrayList();
        this.datas = new ArrayList();
        this.controlRefs = new ArrayList(32);
    }

    public void add(String id, Object element) throws Exception {
        if (!this.idAlreadyExists(id)) {
            this.fIds.add(element);
        }
    }

    public void addCommand(String id, Object command) throws Exception {
        if (!this.fCommands.contains(command)) {
            this.fCommands.add(command);
        }
        this.add(id, command);
    }

    public void addControlRef(String id, Object command) throws Exception {
        if (!this.controlRefs.contains(command)) {
            this.controlRefs.add(command);
        }
        this.add(id, command);
    }

    public void addData(String id, Object filter) throws Exception {
        if (!this.datas.contains(filter)) {
            this.datas.add(filter);
        }
        this.add(id, filter);
    }

    public void addEnum(String id, Object filter) throws Exception {
        if (!this.enums.contains(filter)) {
            this.enums.add(filter);
        }
        this.add(id, filter);
    }

    public void addFilter(String id, Object filter) throws Exception {
        if (!this.fFilters.contains(filter)) {
            this.fFilters.add(filter);
        }
        this.add(id, filter);
    }

    public void addMeasurement(String id, Object measurement) throws Exception {
        if (!this.fMeasurements.contains(measurement)) {
            this.fMeasurements.add(measurement);
        }
        this.add(id, measurement);
    }

    public void addMessage(String id, Object message) throws Exception {
        if (!this.fMessages.contains(message)) {
            this.fMessages.add(message);
        }
        this.add(id, message);
    }

    public void addParameter(String id, Object parameter) throws Exception {
        if (!this.fParameters.contains(parameter)) {
            this.fParameters.add(parameter);
        }
        this.add(id, parameter);
    }

    public void addPid(String id, Object pid) throws Exception {
        if (!this.fPids.contains(pid)) {
            this.fPids.add(pid);
        }
        this.add(id, pid);
    }

    public void addSend(String id, Object send) throws Exception {
        if (!this.fSends.contains(send)) {
            this.fSends.add(send);
        }
        this.add(id, send);
    }

    public void addSignal(String id, Object signal) throws Exception {
        if (!this.fSignals.contains(signal)) {
            this.fSignals.add(signal);
        }
        this.add(id, signal);
    }

    public void addSpec(String id, Object spec) throws Exception {
        if (!this.specs.contains(spec)) {
            this.specs.add(spec);
        }
        this.add(id, spec);
    }

    public void addSpecReference(String id, Object ref) throws Exception {
        if (!this.specReferences.contains(ref)) {
            this.specReferences.add(ref);
        }
        this.add(id, ref);
    }

    public void addTransform(String id, Object transform) throws Exception {
        if (!this.fTransforms.contains(transform)) {
            this.fTransforms.add(transform);
        }
        this.add(id, transform);
    }

    public void addUnits(String id, Object unit) throws Exception {
        if (!this.fUnits.contains(unit)) {
            this.fUnits.add(unit);
        }
        this.add(id, unit);
    }

    public TagElement getCommand(String id) {
        int i = 0;
        while (i < this.fCommands.size()) {
            TagElement element = (TagElement)this.fCommands.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getCommands() {
        return this.fCommands;
    }

    public List getControlRefs() {
        return this.controlRefs;
    }

    public List getDatas() {
        return this.datas;
    }

    public List getEnums() {
        return this.enums;
    }

    public TagElement getFilter(String id) {
        int i = 0;
        while (i < this.fFilters.size()) {
            TagElement element = (TagElement)this.fFilters.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getFilters() {
        return this.fFilters;
    }

    public List getIds() {
        return this.fIds;
    }

    public TagElement getMeasurement(String id) {
        int i = 0;
        while (i < this.fMeasurements.size()) {
            TagElement element = (TagElement)this.fMeasurements.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getMeasurements() {
        return this.fMeasurements;
    }

    public TagElement getMessage(String id) {
        int i = 0;
        while (i < this.fMessages.size()) {
            TagElement element = (TagElement)this.fMessages.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getMessages() {
        return this.fMessages;
    }

    public TagElement getParameter(String id) {
        int i = 0;
        while (i < this.fParameters.size()) {
            TagElement element = (TagElement)this.fParameters.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getParameters() {
        return this.fParameters;
    }

    public TagElement getPid(String id) {
        int i = 0;
        while (i < this.fPids.size()) {
            TagElement element = (TagElement)this.fPids.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getPids() {
        return this.fPids;
    }

    public RootElement getRootElement() {
        return this.fRoot;
    }

    public TagElement getSend(String id) {
        int i = 0;
        while (i < this.fSends.size()) {
            TagElement element = (TagElement)this.fSends.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getSends() {
        return this.fSends;
    }

    public TagElement getSignal(String id) {
        int i = 0;
        while (i < this.fSignals.size()) {
            TagElement element = (TagElement)this.fSignals.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getSignals() {
        return this.fSignals;
    }

    public TagElement getSpec(String id) {
        int i = 0;
        while (i < this.specs.size()) {
            TagElement element = (TagElement)this.specs.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public TagElement getSpecReference(String id) {
        int i = 0;
        while (i < this.specReferences.size()) {
            TagElement element = (TagElement)this.specReferences.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getSpecs() {
        return this.specs;
    }

    public TagElement getTransform(String id) {
        int i = 0;
        while (i < this.fTransforms.size()) {
            TagElement element = (TagElement)this.fTransforms.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getTransforms() {
        return this.fTransforms;
    }

    public TagElement getUnit(String id) {
        int i = 0;
        while (i < this.fUnits.size()) {
            TagElement element = (TagElement)this.fUnits.get(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public List getUnits() {
        return this.fUnits;
    }

    public boolean idAlreadyExists(String id) {
        int i = 0;
        while (i < this.getIds().size()) {
            TagElement element = (TagElement)this.getIds().get(i);
            if (id.equals(element.getAttribute("id"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setControlRefs(List controlRefs) {
        this.controlRefs = controlRefs;
    }

    public void setDatas(List datas) {
        this.datas = datas;
    }

    public void setEnums(List enums) {
        this.enums = enums;
    }

    public void setRootElement(RootElement root) {
        this.fRoot = root;
    }
}

