/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;

public class JxeRulesEntries {
    public static final String[] TAGS = new String[]{"serial", "tcpip", "file", "url", "udp", "dkml", "device;message;concrete", "maximum;minimum;negative;not;scale;shift;translate", "most", "transport", "transportservice", "monitor", "playback;junit", "junit", "usb"};
    public static final String[] ATTRIBUTES = new String[]{"implementation", "service", "superclass"};
    public static final String[] DATA = new String[]{"exportservice"};
    public static final String[] ENTRIES = new String[]{String.valueOf(DeviceKitGenerationConstants.CLASS_CONNECTION_SERIAL) + ';' + DeviceKitGenerationConstants.CLASS_CONNECTION, DeviceKitGenerationConstants.CLASS_CONNECTION_TCPIP, DeviceKitGenerationConstants.CLASS_CONNECTION_FILE, DeviceKitGenerationConstants.CLASS_CONNECTION_URL, DeviceKitGenerationConstants.CLASS_CONNECTION_UDP, String.valueOf(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT) + ';' + DeviceKitGenerationConstants.CLASS_SAT_BUNDLE_ACTIVATOR, String.valueOf(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE) + ';' + DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE + ';' + DeviceKitGenerationConstants.CLASS_TRANSFORM_SERVICE + ';' + DeviceKitGenerationConstants.CLASS_DATA_DEGREE, DeviceKitGenerationConstants.CLASS_TRANSFORM_SERVICE, DeviceKitGenerationConstants.CLASS_CONNECTION_MOST, String.valueOf(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE) + ';' + DeviceKitGenerationConstants.CLASS_CONNECTION, String.valueOf(DeviceKitGenerationConstants.CLASS_CONNECTION) + ';' + DeviceKitGenerationConstants.CLASS_TRANSPORT, String.valueOf(DeviceKitGenerationConstants.CLASS_NODE) + ';' + DeviceKitGenerationConstants.CLASS_XERCES_DOM_PARSER + ';' + DeviceKitGenerationConstants.CLASS_CONNECTION_FILE_OUTPUT_HANDLER + ';' + DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION + ';' + DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT + ';' + DeviceKitGenerationConstants.CLASS_DEVICE_MONITOR + ';' + DeviceKitGenerationConstants.CLASS_FILE_OUTPUT_HANDLER, String.valueOf(DeviceKitGenerationConstants.CLASS_NODE) + ';' + DeviceKitGenerationConstants.CLASS_XERCES_DOM_PARSER + ';' + DeviceKitGenerationConstants.CLASS_PLAY_BACK_CONNECTION, DeviceKitGenerationConstants.CLASS_JUNIT_TEST, DeviceKitGenerationConstants.CLASS_CONNECTION_USB};
    public static final String[] NESTED_TAGS = new String[]{"devicetest;testcase"};
    public static final String[] NESTED_TAG_ENTRIES = new String[]{DeviceKitGenerationConstants.CLASS_TRANSPORT_LOCAL};
    private Map tags = new HashMap();
    private Map attributes = new HashMap();
    private Map data = new HashMap();
    private Map nestedTags = new HashMap();

    public static final String[] detokenize(String entry) {
        StringTokenizer st = new StringTokenizer(entry, ";");
        String[] result = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            result[count++] = st.nextToken();
        }
        return result;
    }

    public static JxeRulesEntries getInstance() {
        return new JxeRulesEntries();
    }

    private JxeRulesEntries() {
        this.populate();
    }

    public List getAttributes() {
        ArrayList attributes = new ArrayList();
        Iterator iterator = this.attributes.keySet().iterator();
        while (iterator.hasNext()) {
            attributes.add(iterator.next());
        }
        return attributes;
    }

    public String getNestedEntry(String key) {
        return (String)this.nestedTags.get(key);
    }

    public String[] getTag(String key) {
        Object obj = this.tags.get(key);
        if (obj == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer((String)obj, ";");
        String[] result = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            result[count++] = st.nextToken();
        }
        return result;
    }

    public List getTags() {
        ArrayList tags = new ArrayList();
        Iterator iterator = this.tags.keySet().iterator();
        while (iterator.hasNext()) {
            tags.add(iterator.next());
        }
        return tags;
    }

    private void populate() {
        int i = 0;
        while (i < TAGS.length) {
            String[] result = JxeRulesEntries.detokenize(TAGS[i]);
            int j = 0;
            while (j < result.length) {
                this.tags.put(result[j], ENTRIES[i]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ATTRIBUTES.length) {
            this.attributes.put(ATTRIBUTES[i], ATTRIBUTES[i]);
            ++i;
        }
        i = 0;
        while (i < DATA.length) {
            this.data.put(DATA[i], DATA[i]);
            ++i;
        }
        i = 0;
        while (i < NESTED_TAGS.length) {
            this.nestedTags.put(NESTED_TAGS[i], NESTED_TAG_ENTRIES[i]);
            ++i;
        }
    }
}

