/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class TransportComparer {
    private List fields = new ArrayList();
    private List methods = new ArrayList();

    private int countStrings(String string) {
        int count = 0;
        int index = string.indexOf(34);
        while (index != -1) {
            ++count;
            index = string.indexOf(34, index + 1);
        }
        return count >> 1;
    }

    public void deleteTypeMethod(ICompilationUnit cu, IType regenerated, String name, String[] args) throws JavaModelException {
        IMethod meth = regenerated.getMethod(name, args);
        if (meth.exists()) {
            ISourceRange range = meth.getSourceRange();
            int offset = range.getOffset();
            int length = range.getLength();
            cu.getBuffer().replace(offset, length, "");
            cu.save(null, true);
        }
    }

    private String get(String methodName) {
        KeyValuePair result = this.getEntry(methodName, this.methods);
        if (result != null) {
            return result.getValue();
        }
        return null;
    }

    private KeyValuePair getEntry(String key, List list) {
        int i = 0;
        while (i < list.size()) {
            KeyValuePair pair = (KeyValuePair)list.get(i);
            if (key.equals(pair.getKey())) {
                return pair;
            }
            ++i;
        }
        return null;
    }

    protected List getFields() {
        return this.fields;
    }

    private String getMethodKey(IMethod method) throws JavaModelException {
        String returnType = method.getReturnType();
        String name = method.getElementName();
        String[] params = method.getParameterTypes();
        String[] exceptions = method.getExceptionTypes();
        String key = String.valueOf(returnType) + " " + name + " " + '(';
        int i = 0;
        while (i < params.length) {
            key = String.valueOf(key) + params[i] + " ";
            ++i;
        }
        key = String.valueOf(key) + ")";
        i = 0;
        while (i < exceptions.length) {
            key = String.valueOf(key) + exceptions[i];
            ++i;
        }
        return key;
    }

    protected List getMethods() {
        return this.methods;
    }

    public List getOriginalFields(IType original) throws JavaModelException {
        IField[] f = original.getFields();
        int i = 0;
        while (i < f.length) {
            String key = f[i].getElementName();
            String source = f[i].getSource();
            StringBuffer buffer = new StringBuffer(source.length() >> 1);
            buffer.append('\t');
            buffer.append(source);
            int count = this.countStrings(source);
            int j = 0;
            while (j < count) {
                buffer.append(" //$NON-NLS-");
                buffer.append(j + 1);
                buffer.append("$");
                ++j;
            }
            buffer.append('\n');
            KeyValuePair pair = new KeyValuePair(key, buffer.toString());
            this.getFields().add(pair);
            ++i;
        }
        return this.fields;
    }

    public List getOriginalMethods(IType original) throws JavaModelException {
        IMethod[] oMethods = original.getMethods();
        int i = 0;
        while (i < oMethods.length) {
            IMethod method = oMethods[i];
            if (!method.isConstructor()) {
                String key = this.getMethodKey(method);
                String source = method.getSource();
                StringBuffer buffer = new StringBuffer(source.length() >> 1);
                buffer.append('\t');
                buffer.append(source);
                buffer.append('\n');
                KeyValuePair pair = new KeyValuePair(key, buffer.toString());
                this.getMethods().add(pair);
            }
            ++i;
        }
        return this.getMethods();
    }

    public void handleNewTransport(ICompilationUnit cu) {
        int index;
        String name = cu.getElementName();
        IType regenerated = cu.getType(name.substring(0, index = name.indexOf(46)));
        if (regenerated != null) {
            try {
                this.handleTransportMethods(cu, regenerated);
                this.handleTransportFields(cu, regenerated);
            }
            catch (JavaModelException jme) {
                jme.printStackTrace();
            }
        }
    }

    private void handleTransportFields(ICompilationUnit cu, IType regenerated) throws JavaModelException {
        KeyValuePair pair;
        IField[] rfields = regenerated.getFields();
        List fields = this.getFields();
        int i = 0;
        while (i < fields.size()) {
            pair = (KeyValuePair)fields.get(i);
            String key = pair.getKey();
            int j = 0;
            while (j < rfields.length) {
                if (key.equals(rfields[j].getElementName())) {
                    fields.remove(pair);
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.setFields(fields);
        this.setFields(fields);
        i = 0;
        while (i < fields.size()) {
            pair = (KeyValuePair)fields.get(i);
            String source = pair.getValue();
            regenerated.createField(source, null, true, null);
            ++i;
        }
    }

    private void handleTransportMethods(ICompilationUnit cu, IType regenerated) throws JavaModelException {
        KeyValuePair pair;
        String pi = this.get("I processInput ([B I )QException;");
        String write = this.get(DeviceKitGenerationConstants.CUSTOM_KEY_WRITE);
        if (pi != null) {
            this.deleteTypeMethod(cu, regenerated, "processInput", DeviceKitGenerationConstants.CUSTOM_ARGS_PROCESS_INPUT);
            regenerated.createMethod(pi, null, true, null);
        }
        if (write != null) {
            this.deleteTypeMethod(cu, regenerated, "write", DeviceKitGenerationConstants.CUSTOM_ARGS_WRITE);
            regenerated.createMethod(write, null, true, null);
        }
        IMethod[] rmethods = regenerated.getMethods();
        List methods = this.getMethods();
        int i = 0;
        while (i < methods.size()) {
            pair = (KeyValuePair)methods.get(i);
            String key = pair.getKey();
            int j = 0;
            while (j < rmethods.length) {
                if (key.equals(this.getMethodKey(rmethods[j]))) {
                    methods.remove(pair);
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < methods.size()) {
            pair = (KeyValuePair)methods.get(i);
            String source = pair.getValue();
            regenerated.createMethod(source, null, true, null);
            ++i;
        }
    }

    protected void setFields(List fields) {
        this.fields = fields;
    }

    public void setOriginals(List fields, List methods) {
        this.fields = fields;
        this.methods = methods;
    }
}

