/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.util.DeviceKitUtilityPlugin;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DkmlFileFinder
implements IResourceVisitor {
    protected HashMap map = new HashMap();

    public DkmlFileFinder() {
        this.run();
    }

    public DkmlFileFinder(IJavaProject[] javaProjects) {
        this.run(javaProjects);
    }

    private Document buildDocument(InputStream inputStream) throws Exception {
        return ParserUtilities.parse(inputStream);
    }

    public IFile findFile(String type, String name) {
        IFile[] files = this.getFiles(type);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                String id = this.findId(files[i]);
                if (name.equals(id)) {
                    return files[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected String findId(IFile file) {
        InputStream stream = null;
        try {
            stream = file.getContents(true);
            Document doc = this.buildDocument(stream);
            return this.findId(doc);
        }
        catch (Exception exception) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    private String findId(Node node) throws Exception {
        if (node != null) {
            NodeList list;
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                int i = 0;
                while (i < atts.getLength()) {
                    Node aNode = atts.item(i);
                    if ("id".equals(aNode.getNodeName())) {
                        return aNode.getNodeValue();
                    }
                    ++i;
                }
            }
            if ((list = node.getChildNodes()) != null) {
                int i = 0;
                while (i < list.getLength()) {
                    String result = this.findId(list.item(i));
                    if (result.length() > 0) {
                        return result;
                    }
                    ++i;
                }
            }
        }
        return "";
    }

    protected String findId(String source) {
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(source.getBytes());
            Document doc = this.buildDocument(stream);
            return this.findId(doc);
        }
        catch (Exception exception) {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
            return "";
        }
    }

    public String[] getExternalFiles(String type) {
        String[] results = (String[])DeviceKitPlugin.getDefault().getXmlTypes().get(String.valueOf(type) + ".xml");
        if (results != null) {
            return results;
        }
        return new String[0];
    }

    public IFile[] getFiles(String type) {
        IFile[] results = (IFile[])this.getMap().get(String.valueOf(type) + ".xml");
        if (results != null) {
            return results;
        }
        return new IFile[0];
    }

    public HashMap getMap() {
        return this.map;
    }

    public String[] getNames(String type) {
        IFile[] files = this.getFiles(type);
        String[] externalFiles = this.getExternalFiles(type);
        String[] names = new String[files.length + externalFiles.length];
        int i = 0;
        while (i < files.length) {
            names[i] = this.findId(files[i]);
            ++i;
        }
        i = 0;
        while (i < externalFiles.length) {
            names[i + files.length] = this.findId(externalFiles[i]);
            ++i;
        }
        return names;
    }

    public IProject getProject(String name) {
        return DeviceKitUtilityPlugin.getWorkspace().getRoot().getProject(name);
    }

    public void run() {
        try {
            IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            this.run(javaProjects);
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
    }

    public void run(IJavaProject[] javaProjects) {
        try {
            int i = 0;
            while (i < javaProjects.length) {
                IFolder folder;
                IJavaProject jproject = javaProjects[i];
                if (jproject.exists() && (folder = jproject.getProject().getFolder("dk")).exists()) {
                    folder.accept((IResourceVisitor)this);
                }
                ++i;
            }
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
    }

    public void setMap(HashMap map) {
        this.map = map;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            String name = resource.getName();
            if (name.endsWith(".xml")) {
                Object object = this.map.get(name);
                if (object instanceof IFile[]) {
                    IFile[] list = (IFile[])object;
                    IFile[] newList = new IFile[list.length + 1];
                    System.arraycopy(list, 0, newList, 0, list.length);
                    newList[list.length] = file;
                    this.map.put(name, newList);
                } else {
                    this.map.put(name, new IFile[]{file});
                }
            }
        }
        return true;
    }
}

