/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class ParserUtilities {
    static /* synthetic */ Class class$0;

    public static boolean containsAttribute(String attName, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.item(i).getNodeName().equals(attName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String extractData(Node node) {
        StringBuffer buffer = new StringBuffer(32);
        if (node.getNodeValue() != null) {
            return node.getNodeValue();
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String value;
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 3) {
                value = children.item(i).getNodeValue();
                if (value != null) {
                    String[] data = DeviceKitUtilities.convertStringToArray(value);
                    int j = 0;
                    while (j < data.length) {
                        if (j != 0) {
                            buffer.append(' ');
                        }
                        buffer.append(data[j].trim());
                        ++j;
                    }
                }
            } else if (childNode.getNodeType() == 4 && (value = children.item(i).getNodeValue()) != null) {
                buffer.append(value);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    public static Node findChildNode(String name, Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (name.equals(children.item(i).getNodeName())) {
                return children.item(i);
            }
            ++i;
        }
        return null;
    }

    public static String getAttribute(String name, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attNode = attributes.item(i);
                if (attNode.getNodeType() == 2 && attNode.getNodeName().equals(name)) {
                    return attNode.getNodeValue();
                }
                ++i;
            }
        }
        return null;
    }

    public static InputStream getDeviceKitSchema() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.util.ParserUtilities");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResourceAsStream("dkml.xsd");
    }

    public static final Document parse(InputStream stream) throws Exception {
        return ParserUtilities.parse(stream, null, null);
    }

    public static final Document parse(InputStream stream, ErrorHandler errorHandler, Object schemaSource) throws Exception {
        Document document;
        block6: {
            Reader reader = null;
            try {
                Document doc;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                reader = new BufferedReader(new InputStreamReader(stream));
                if (schemaSource != null) {
                    factory.setValidating(true);
                    try {
                        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSource);
                    }
                    catch (Exception exception) {
                        factory.setValidating(false);
                    }
                }
                DocumentBuilder builder = factory.newDocumentBuilder();
                if (errorHandler != null) {
                    builder.setErrorHandler(errorHandler);
                }
                document = doc = builder.parse(new InputSource(reader));
                Object var7_8 = null;
                if (reader == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_9 = null;
                    if (reader == null) break block7;
                    reader.close();
                    reader = null;
                }
                throw throwable;
            }
            reader.close();
            reader = null;
        }
        return document;
    }

    public static final Document parseDeviceKit(InputStream stream, ErrorHandler errorHandler) throws Exception {
        return ParserUtilities.parseDeviceKit(stream, errorHandler, true);
    }

    public static final Document parseDeviceKit(InputStream stream, ErrorHandler errorHandler, boolean validate) throws Exception {
        if (validate) {
            return ParserUtilities.parse(stream, errorHandler, ParserUtilities.getDeviceKitSchema());
        }
        return ParserUtilities.parse(stream, errorHandler, null);
    }
}

