/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.model.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.internal.model.java.JavaElement;
import org.eclipse.soda.devicekit.generator.internal.model.java.JgfUtilities;
import org.eclipse.soda.devicekit.generator.internal.model.java.Parameter;
import org.eclipse.soda.devicekit.generator.internal.print.java.MethodPrinter;
import org.eclipse.soda.devicekit.generator.model.java.IMethod;
import org.eclipse.soda.devicekit.generator.model.java.IParameter;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;

public class Method
extends JavaElement
implements IMethod {
    private String[] fContents;
    private boolean fConstructor = false;
    private ArrayList fParameters;
    private String fReturnType;
    private List fThrownExceptions;

    protected Method(String name) {
        this(name, null, 1L);
    }

    protected Method(String name, String returnType, long identifiers) {
        super(name);
        this.setIdentifiers(identifiers);
        this.fReturnType = returnType;
        this.fParameters = new ArrayList();
        this.fThrownExceptions = new ArrayList();
        this.setFileType(1);
    }

    protected void addParameter(IParameter param) {
        this.fParameters.add(param);
    }

    public void addParameter(String type, String name) {
        if (name != null || !JgfUtilities.paramNameExists(name, this.getParameters())) {
            this.addParameter(new Parameter(type, name));
        }
    }

    public void addThrownException(String exception) {
        if (!this.fThrownExceptions.contains(exception)) {
            this.fThrownExceptions.add(exception);
        }
    }

    public String[] getContents() {
        return this.fContents;
    }

    public IParameter[] getParameters() {
        IParameter[] params = new Parameter[this.fParameters.size()];
        this.fParameters.toArray(params);
        return params;
    }

    private String getParameterString() {
        String result = "";
        int i = 0;
        while (i < this.getParameters().length) {
            result = String.valueOf(result) + this.getParameters()[i].getType();
            ++i;
        }
        return result;
    }

    public String getReturnType() {
        return this.fReturnType;
    }

    public String[] getThrownExceptions() {
        String[] exceptions = new String[this.fThrownExceptions.size()];
        exceptions = this.fThrownExceptions.toArray(exceptions);
        return exceptions;
    }

    public boolean isConstructor() {
        return this.fConstructor;
    }

    public String print(int indentation) {
        return new MethodPrinter(this, indentation).getContents();
    }

    public void setConstructor(boolean constructor) {
        this.fConstructor = constructor;
    }

    public void setContents(String contents) {
        this.setContents(DkUtilities.convertStringToArray(contents));
    }

    public void setContents(String[] contents) {
        this.fContents = contents;
    }

    public void setReturnType(String returnType) {
        this.fReturnType = returnType;
    }

    public String toString() {
        return String.valueOf(this.getName()) + '(' + this.getParameterString() + ')';
    }
}

