/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkTestGenerator;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkDeviceTestGenerator
extends DkTestGenerator {
    private Map commands = new HashMap();
    private Map measurements = new HashMap();
    private Map signals = new HashMap();

    protected DkDeviceTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap());
    }

    protected DkDeviceTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected void cleanup() {
        TransportElement tran;
        String configKey;
        super.cleanup();
        List trans = this.getMainElement().getAllChildrenWithTagCodes(new int[]{9, 97}, new int[]{8});
        if (trans.size() > 0 && (configKey = this.getConfigurationKey(tran = (TransportElement)trans.get(0))) != null) {
            Map[] properties = tran.getTransportProperties();
            int i = 0;
            while (i < properties.length) {
                EscPropertiesModel model = EscPropertiesModel.getModel(this);
                Iterator keys = properties[i].keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = (String)properties[i].get(key);
                    model.addProperty(String.valueOf(configKey) + '.' + key, value);
                }
                ++i;
            }
        }
    }

    protected void codeBACreateService(IType ba) {
        String[] comment = new String[]{"Creates the test for the specified " + this.getTargetType() + '.', "", "@param device DeviceService", "@return Object The device test.", "@see " + this.getMainFqn()};
        KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), this.getTargetType());
        String contents = this.getBACreateServiceContents();
        this.codeMethod(ba, "createService", comment, "Object", 1L, contents, new KeyValuePair[]{parameter}, null);
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
    }

    protected void codeBADeactivate(IType ba) {
        String contents = this.getBADeactivateContents();
        this.codeMethod(ba, "deactivate", "Stop the test case and the bundle.", "void", 4L, contents);
    }

    private void codeBAExportedServiceNamesField(IType ba) {
        String bundle = this.fTest.getBundleName();
        StringBuffer fieldComment = new StringBuffer(64);
        fieldComment.append("Defines the service name(s) to be registered by the " + bundle + " bundle.\n");
        String[] services = this.fTest.getImplementedInterfaces();
        int indentation = 0;
        if (services.length > 0) {
            fieldComment.append(this.getHtmlHelper().startTable(0));
            ++indentation;
            int i = 0;
            while (i < services.length) {
                fieldComment.append(this.getHtmlHelper().getTableRow(indentation, services[i]));
                ++i;
            }
            fieldComment.append(this.getHtmlHelper().endTable(--indentation));
        }
        StringBuffer value = new StringBuffer(64);
        value.append("\n\t" + this.getServiceClass() + '.' + "SERVICE_NAME");
        this.fBundleActivatorModel.addImport(this.getServiceFqn());
        this.getManifestModel().addImportPackage(this.getServicePackage());
        int i = 0;
        while (i < services.length) {
            value.append(',');
            String curr = services[i];
            this.fBundleActivatorModel.addImport(curr);
            String currPack = DeviceKitUtilities.extractPackage(curr);
            this.getManifestModel().addImportPackage(currPack);
            if (curr.equals(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE)) {
                value.append("\n\t" + this.quote(curr));
            } else {
                value.append("\n\t" + DeviceKitUtilities.stripPackage(curr) + '.' + "SERVICE_NAME");
            }
            ++i;
        }
        this.codeBAExportedServiceNamesField(ba, value.toString(), fieldComment.toString());
    }

    protected void codeBAGetExportedServiceNames(IType ba) {
        this.codeBAExportedServiceNamesField(ba);
        String bundle = this.fTest.getBundleName();
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Return the exported service name(s) to be registered by the " + bundle + " bundle.\n");
        buffer.append("\n@return String[] The device test's service names.\n");
        this.codeBAGetExportedServiceNames(ba, buffer.toString());
    }

    protected void codeBAMethods(IType ba) {
        super.codeBAMethods(ba);
        this.codeBACreateService(ba);
        this.codeBAGetExportedServiceNames(ba);
        this.codeBAGetImportedServiceNames(ba);
        this.codeBACreateProperties(ba);
    }

    protected void codeBASetInterest(IType ba) {
        String contents = this.getBASetInterestContents();
        KeyValuePair parameter = new KeyValuePair("Object", "interest");
        this.codeMethod(ba, "setInterest", "Sets the interest object.", "void", 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeCommandExecuted(IType test) {
        String[] comment = new String[]{"The commandExecuted method is called when a command is executed."};
        String commandService = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE);
        KeyValuePair source = new KeyValuePair(commandService, "source");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE);
        KeyValuePair timeStamp = new KeyValuePair("Object", "timestamp");
        KeyValuePair data = new KeyValuePair("Object", "data");
        KeyValuePair[] parameters = new KeyValuePair[]{source, timeStamp, data};
        String contents = this.getCommandExecutedContents();
        this.codeMethod(test, "commandExecuted", comment, "void", 1L, contents, parameters, null);
    }

    protected void codeControlChanged(IType test) {
        String contents = this.getControlChangedContents();
        KeyValuePair parameter1 = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "device");
        KeyValuePair parameter2 = new KeyValuePair("Object", "timestamp");
        KeyValuePair parameter3 = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONTROL_SERVICE), "control");
        KeyValuePair parameter4 = new KeyValuePair("int", "code");
        KeyValuePair[] parameters = new KeyValuePair[]{parameter1, parameter2, parameter3, parameter4};
        this.codeMethod(test, "controlChanged", "The controlChanged method is called when a device control changes.", "void", 1L, contents, parameters, null);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONTROL_SERVICE);
    }

    protected void codeDeviceChanged(IType test) {
        String contents = this.getDeviceChangedContents();
        KeyValuePair parameter1 = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "deviceService");
        KeyValuePair parameter2 = new KeyValuePair("Object", "timestamp");
        KeyValuePair parameter3 = new KeyValuePair(DeviceKitUtilities.stripPackage("int"), "newState");
        KeyValuePair parameter4 = new KeyValuePair("int", "oldState");
        KeyValuePair[] parameters = new KeyValuePair[]{parameter1, parameter2, parameter3, parameter4};
        this.codeMethod(test, "deviceChanged", "The deviceChanged method is called when the state of the device changes.", "void", 1L, contents, parameters, null);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
    }

    protected void codeFields(IType test) {
        super.codeFields(test);
    }

    protected void codeFormatData(IType test) {
        String contents = this.getFormatDataContents();
        KeyValuePair parameter = new KeyValuePair("Object", "data");
        this.codeMethod(test, "formatData", "The formatData will format the data values to a nice string.", "String", 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeGetDefaultDevice(IType test) {
        String returnType = DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        String[] comment = new String[]{"Gets the default DeviceService to be tested.", "", "@return DeviceService The Device to be tested.", "@throws ClassNotFoundException", "@throws IllegalAccessException", "@throws InstantiationException", "@see org.eclipse.soda.dk.device.test.DeviceTest#getDefaultDevice()"};
        String contents = this.getGetDefaultDeviceContents();
        String[] exceptions = new String[]{"ClassNotFoundException", "IllegalAccessException", "InstantiationException"};
        this.codeMethod(test, "getDefaultDevice", comment, returnType, 1L, contents, null, exceptions);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
    }

    protected void codeGetDevice(IType test) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.codeMethod(test, "getDevice", "Gets the device to be tested.", returnType, 1L, "return this.device;\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
    }

    protected void codeGetTestMethod(IType test, String field, String javaDoc) {
        String upper = DeviceKitUtilities.makeFirstCharUpper(field);
        String name = "get" + upper;
        String[] comment = new String[]{"Gets the " + field + " property value.", javaDoc, "@see #set" + upper};
        String contents = "return this." + field + ";\n";
        this.codeMethod(test, name, comment, "boolean", 1L, contents);
    }

    protected void codeMeasurementChanged(IType test) {
        String contents = this.getMeasurementChangedContents();
        KeyValuePair parameter1 = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE), "source");
        KeyValuePair parameter2 = new KeyValuePair("Object", "timestamp");
        KeyValuePair parameter3 = new KeyValuePair("Object", "newValue");
        KeyValuePair parameter4 = new KeyValuePair("Object", "oldValue");
        KeyValuePair[] parameters = new KeyValuePair[]{parameter1, parameter2, parameter3, parameter4};
        this.codeMethod(test, "measurementChanged", "The measurementChanged method is called when a measurement changes value.", "void", 1L, contents, parameters, null);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE);
    }

    protected void codeMethods(IType test) {
        super.codeMethods(test);
        this.codeGetDefaultDevice(test);
        this.codeSetup(test);
    }

    protected void codeSetDevice(IType test) {
        String contents = this.getSetDeviceContents();
        KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "device");
        this.codeMethod(test, "setDevice", "Sets the device to be tested.", "void", 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeSetTestMethod(IType test, String field, String javaDoc) {
        String upper = DeviceKitUtilities.makeFirstCharUpper(field);
        String name = "set" + upper;
        String[] comment = new String[]{"Sets the " + field + " property value.", javaDoc, "@param " + field + " The boolean value for the " + field + " property.", "@see #get" + upper};
        String contents = "this." + field + " = " + field + ";\n";
        KeyValuePair parameter = new KeyValuePair("boolean", field);
        this.codeMethod(test, name, comment, "void", 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeSetup(IType test) {
        String[] comment = new String[]{"Sets user-defined variables to use in the test.", "", "@see " + this.fTest.getSuperClass() + "#setup()"};
        String contents = this.getSetupContents();
        this.codeMethod(test, "setup", comment, "void", 1L, contents);
    }

    protected void codeSignalOccurred(IType test) {
        String contents = this.getSignalOccurredContents();
        KeyValuePair parameter1 = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE), "source");
        KeyValuePair parameter2 = new KeyValuePair("Object", "timestamp");
        KeyValuePair parameter3 = new KeyValuePair("Object", "data");
        KeyValuePair[] parameters = new KeyValuePair[]{parameter1, parameter2, parameter3};
        this.codeMethod(test, "signalOccurred", "The signalOccurred method is called when a signal has been received.", "void", 1L, contents, parameters, null);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
    }

    protected void codeTestCommands(IType test) {
        Iterator keys = this.commands.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String name = "test" + key;
            String commKey = ((TagElement)this.commands.get(key)).getKey();
            String deviceService = this.getModelServiceName();
            String[] comment = new String[]{"Test the " + deviceService + '.' + commKey + " command.", "If the command is executed, then the commandExecuted method will be called.", "@see " + deviceService + '#' + key, "@see #commandExecuted", "@see #setDevice"};
            String contents = this.getTestCommandsContents(key, deviceService);
            this.codeMethod(test, name, comment, "void", 1L, contents);
        }
    }

    protected void codeTestControlMethods(IType test) {
        this.codeTestCommands(test);
        this.codeTestMeasurements(test);
        this.codeTestSignals(test);
    }

    protected void codeTestDelay(IType test) {
        boolean generate = false;
        boolean bl = generate = TagElement.collection.getCommands().size() > 0 || TagElement.collection.getSignals().size() > 0 || TagElement.collection.getMeasurements().size() > 0;
        if (generate) {
            String dValue = this.getTestElement().getTestDelay();
            if (dValue == null) {
                dValue = "0";
            }
            String value = this.getConfLong(this.getTestElement(), "testdelay", dValue);
            this.codeField(test, "testDelay", "long", 2L, "Specifies the amount of time to wait between test method calls.\n", value);
        }
    }

    protected void codeTestGetterAndSetter(IType test) {
        this.codeTestMethod(test, "testExecute", "If testExecute is true, then execute method will be invoked for all commands.");
        this.codeTestMethod(test, "testTrigger", "If testTrigger is true, then trigger method will be invoked for all signals.");
        this.codeTestMethod(test, "testExecuteRead", "If testExecuteRead is true, then the executeRead method will be invoked to all measurements.");
        this.codeTestMethod(test, "testExecuteWrite", "If testExecuteWrite is true, then executeWrite method will be invoked to all measurements.");
        this.codeTestMethod(test, "testRead", "If testRead is true, then the read method will be invoked to all measurements.");
    }

    protected void codeTestMeasurements(IType test) {
        Iterator keys = this.measurements.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String measurementKey = ((TagElement)this.measurements.get(key)).getKey();
            String deviceService = this.getModelServiceName();
            String name = "test" + key;
            String[] comment = new String[]{"Test the " + deviceService + '.' + measurementKey + " measurement.", "If the value of the measurement changes, then the measurementChanged method will be called.", "@see " + deviceService + '#' + key, "@see #measurementChanged", "@see #setDevice"};
            String contents = this.getTestMeasurmentsContents(key, deviceService);
            this.codeMethod(test, name, comment, "void", 1L, contents);
            this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE);
            this.fTestModel.addImport(deviceService);
            this.fTestModel.addImport(this.getServiceFqn());
        }
    }

    protected void codeTestMethod(IType test, String field, String javaDoc) {
        this.codeGetTestMethod(test, field, javaDoc);
        this.codeSetTestMethod(test, field, javaDoc);
    }

    protected void codeTestSignals(IType test) {
        Iterator keys = this.signals.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String signalKey = ((TagElement)this.signals.get(key)).getKey();
            String deviceService = this.getModelServiceName();
            String name = "test" + key;
            String[] comment = new String[]{"Test the " + deviceService + '.' + signalKey + " signal.", "If the value of the measurement changes, then the measurementChanged method will be called.", "@see " + deviceService + '#' + key, "@see #signalOccurred", "@see #setDevice"};
            String contents = this.getTestSignalsContents(key, deviceService);
            this.codeMethod(test, name, comment, "void", 1L, contents);
        }
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(" testCase = new ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append("();\n");
        buffer.append("testCase.setDevice(");
        buffer.append(this.getTargetType());
        buffer.append(");\n");
        buffer.append("return testCase;\n");
        return buffer.toString();
    }

    protected String getBADeactivateContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("if (this.testCase != null) {\n");
        buffer.append("\ttestCase.stop();\n");
        buffer.append("\ttestCase.setDevice(null);\n");
        buffer.append("}\n");
        buffer.append("testCase = null;\n");
        buffer.append("super.deactivate();\n");
        return buffer.toString();
    }

    protected String getBASetInterestContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("super.setInterest(interest);\n");
        buffer.append("if (this.testCase != null) {\n");
        buffer.append("\tthis.testCase.setDevice((" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE) + ")interest);\n");
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_BUNDLE_ACTIVATOR;
    }

    protected String getBundleActivatorComment() {
        StringBuffer buffer = new StringBuffer(32);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected String getCommandExecutedContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("StringBuffer buffer = new StringBuffer(256);");
        buffer.append("buffer.append(\"Command \");\n");
        buffer.append("buffer.append(source);\n");
        buffer.append("buffer.append(\" executed \");\n");
        buffer.append("if (data != null) {\n");
        buffer.append("\tbuffer.append(\"with \");\n");
        buffer.append("\tbuffer.append(formatData(data));\n");
        buffer.append("\tbuffer.append(\" data \");\n");
        buffer.append("}\n");
        buffer.append("buffer.append(\"at \");\n");
        buffer.append("buffer.append(timestamp);\n");
        buffer.append("buffer.append(\".\");\n");
        buffer.append("log(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        buffer.append(".LOG_INFO, buffer.toString());\n");
        return buffer.toString();
    }

    protected String getControlChangedContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("StringBuffer buffer = new StringBuffer(256);");
        buffer.append("buffer.append(\"Device \");\n");
        buffer.append("buffer.append(device);\n");
        buffer.append("buffer.append(\" control change at: \");\n");
        buffer.append("buffer.append(timestamp);\n");
        buffer.append("buffer.append(\".\");\n");
        buffer.append("log(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        buffer.append(".LOG_INFO, buffer.toString());\n");
        return buffer.toString();
    }

    protected String getDeviceChangedContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("StringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("buffer.append(\"Device \");\n");
        buffer.append("buffer.append(deviceService);\n");
        buffer.append("buffer.append(\"\\r\\n\\tstate: \");\n");
        buffer.append("buffer.append(stateStrings[newState]);\n");
        buffer.append("buffer.append(\" old state: \");\n");
        buffer.append("buffer.append(stateStrings[oldState]);\n");
        buffer.append("buffer.append(\" at: \");\n");
        buffer.append("buffer.append(timestamp);\n");
        buffer.append("buffer.append(\".\");\n");
        buffer.append("log(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        buffer.append(".LOG_INFO, buffer.toString());\n");
        buffer.append("if (newState >= DeviceService.ACTIVE) {\n");
        buffer.append("\ttest();\n");
        buffer.append("}\n");
        buffer.append("synchronized (this) {\n");
        buffer.append("\tnotify();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getFormatDataContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("if (data == null) {\n");
        buffer.append("\treturn \"null\";\n");
        buffer.append("} else {\n");
        buffer.append("\tStringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("\tif (data instanceof Object[]) {\n");
        buffer.append("\t\tbuffer.append(\"{\");\n");
        buffer.append("\t\tfor (int i = 0; i < ((Object[])data).length; i++) {\n");
        buffer.append("\t\t\tif (i != 0) {\n");
        buffer.append("\t\t\t\tbuffer.append(\" \");\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t\tbuffer.append(formatData(((Object[])data)[i]));\n");
        buffer.append("\t\t}\n");
        buffer.append("\t\tbuffer.append(\"}\");\n");
        buffer.append("\t\treturn buffer.toString();\n");
        buffer.append("\t} else {\n");
        buffer.append("\t\tif (data instanceof byte[]) {\n");
        buffer.append("\t\t\tbuffer.append(\"[\");\n");
        buffer.append("\t\t\tfor (int i = 0; i < ((byte[]) data).length; i++) {\n");
        buffer.append("\t\t\t\tif (i != 0)\n");
        buffer.append("\t\t\t\t\tbuffer.append(\" \");\n");
        buffer.append("\t\t\t\t\tbuffer.append(Integer.toHexString(((byte[]) data)[i] & 0xff));\n");
        buffer.append("\t\t\t\t}\n");
        buffer.append("\t\t\tbuffer.append(\"]\");\n");
        buffer.append("\t\t\treturn buffer.toString();\n");
        buffer.append("\t\t} else {\n");
        buffer.append("\t\t\treturn data.toString();\n");
        buffer.append("\t\t}\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getGetDefaultDeviceContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return new ");
        String targetClass = this.fTest.getTargetClass();
        buffer.append(targetClass);
        String targetPackage = DkUtilities.getPackageFromClassName(targetClass, this.getPackageBase());
        String targetFqn = String.valueOf(targetPackage) + '.' + targetClass;
        this.fTestModel.addImport(targetFqn);
        String bundleId = DeviceKitUtilities.extractPackage(targetFqn);
        this.addAdditionalBundles(bundleId);
        bundleId = String.valueOf(bundleId) + ".bundle";
        this.addAdditionalBundles(bundleId);
        buffer.append("();\n");
        return buffer.toString();
    }

    protected String[] getImplementedInterfaces() {
        return new String[]{this.getServiceFqn(), DeviceKitGenerationConstants.CLASS_RUNNABLE, DeviceKitGenerationConstants.CLASS_COMMAND_LISTENER, DeviceKitGenerationConstants.CLASS_SIGNAL_LISTENER, DeviceKitGenerationConstants.CLASS_MEASUREMENT_LISTENER, DeviceKitGenerationConstants.CLASS_DEVICE_LISTENER};
    }

    protected String getIsActiveContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return this.active\n");
        buffer.append("\t&& (getDevice() != null)\n");
        buffer.append("\t&& (getDevice().getState() >= DeviceService.ACTIVE);\n");
        return buffer.toString();
    }

    protected String getMainClassComment() {
        StringBuffer buffer = new StringBuffer(32);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append("The " + this.getMainClassName() + " class implements a set of " + this.getMainTagName() + " tests.\n");
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected String getMainContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("/*\n");
        buffer.append("The following will make sure that we have no references to the specific device class\n");
        buffer.append("when running as a bundle.\n");
        buffer.append("*/\n");
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(" testCase = new ");
        buffer.append(this.getMainClassName());
        buffer.append("();\n");
        buffer.append("testCase.run(args);\n");
        buffer.append("System.exit(0);\n");
        return buffer.toString();
    }

    protected String getMeasurementChangedContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("StringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("buffer.append(\"Measurement \");\n");
        buffer.append("buffer.append(source);\n");
        buffer.append("buffer.append(\" changed to \");\n");
        buffer.append("buffer.append(formatData(newValue));\n");
        buffer.append("buffer.append(\" from \");\n");
        buffer.append("buffer.append(formatData(oldValue));\n");
        buffer.append("buffer.append(\" at \");\n");
        buffer.append("buffer.append(timestamp);\n");
        buffer.append("buffer.append(\".\");\n");
        buffer.append("log(" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE) + ".LOG_INFO, buffer.toString());\n");
        return buffer.toString();
    }

    protected String getModelName() {
        List devices = this.fTest.getAllChildrenWithTagCode(8);
        TagElement device = (TagElement)devices.get(0);
        String name = null;
        String implementation = device.getImplementation();
        if (implementation != null) {
            name = implementation;
            if (name.indexOf(46) == -1) {
                String pack = DeviceKitUtilities.getPackageFromClassName(name, this.getPackageBase());
                name = String.valueOf(pack) + '.' + name;
            }
        } else {
            String idref = device.getAttribute("idref");
            if (idref != null) {
                List devs = this.getTestElement().getParent().getAllChildrenWithTagCode(8);
                int i = 0;
                while (i < devs.size()) {
                    TagElement element = (TagElement)devs.get(i);
                    if (idref.equals(element.getId())) {
                        return element.getImplementation();
                    }
                    ++i;
                }
            }
        }
        return name;
    }

    protected String getModelServiceName() {
        List devices = this.fTest.getAllChildrenWithTagCode(8);
        String service = null;
        TagElement device = (TagElement)devices.get(0);
        service = device.getAttribute("service") != null ? device.getAttribute("service") : device.getImplementation();
        if (service != null) {
            if (!service.endsWith("Service")) {
                service = String.valueOf(service) + "Service";
            }
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            return service;
        }
        return "";
    }

    protected String getRunContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("int count = 0;\n");
        buffer.append("while (!(isActive() && getDevice() != null)) {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\tsynchronized(this) {\n");
        buffer.append("\t\t\tcount++;\n");
        buffer.append("\t\t\tif ((count % 20) == 0) {\n");
        buffer.append("\t\t\t\tcount = 0;\n");
        buffer.append("\t\t\t\tlog(LOG_INFO, \"The device test is still waiting for the device to initialize.\");\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t\twait(500);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t} catch (final Exception exception) {\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("log(LOG_INFO, \"Starting execution of test methods.\");\n");
        buffer.append("for (int i = 0; i < testCount; i++) {\n");
        List elements = TagElement.collection.getIds();
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.get(i);
            switch (element.getTagCode()) {
                case 1: 
                case 19: {
                    buffer.append("\ttest" + element.getId() + "();\n");
                    buffer.append("\tsleep(testDelay);\n");
                    this.commands.put(element.getId(), element);
                    break;
                }
                case 2: {
                    buffer.append("\ttest" + element.getId() + "();\n");
                    buffer.append("\tsleep(testDelay);\n");
                    this.measurements.put(element.getId(), element);
                    break;
                }
                case 3: {
                    buffer.append("\ttest" + element.getId() + "();\n");
                    buffer.append("\tsleep(testDelay);\n");
                    this.signals.put(element.getId(), element);
                }
            }
            ++i;
        }
        buffer.append("}\n");
        buffer.append("log(LOG_INFO, \"Ended execution of test methods.\");\n");
        buffer.append("\treturn;\n");
        return buffer.toString();
    }

    protected String getSetDeviceContents() {
        StringBuffer buffer = new StringBuffer(320);
        buffer.append("if (this.device != null) {\n");
        buffer.append("\tthis.device.removeDeviceListener(this);\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_ENUMERATION);
        buffer.append("\tfor (final Enumeration enumeration = getDevice().elements();enumeration.hasNext();) {\n");
        buffer.append("\t\tObject control = enumeration.next();\n");
        buffer.append("\t\tif (control instanceof " + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE) + ") {\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE);
        buffer.append("\t\t\t((" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE) + ") control).removeMeasurementListener(this);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t\tif (control instanceof " + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE) + ") {\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE);
        buffer.append("\t\t\t((" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE) + ") control).removeSignalListener(this);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t\tif (control instanceof " + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE) + ") {\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE);
        buffer.append("\t\t\t((" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE) + ") control).removeCommandListener(this);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("this.device = device;\n");
        buffer.append("if (this.device != null) {\n");
        buffer.append("\tthis.device.addDeviceListener(this);\n");
        buffer.append("\tfor (final Enumeration enumeration = getDevice().elements();enumeration.hasNext();) {\n");
        buffer.append("\t\tObject control = enumeration.next();\n");
        buffer.append("\t\tif (control instanceof " + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE) + ") {\n");
        buffer.append("\t\t\t((" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE) + ") control).addMeasurementListener(this);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t\tif (control instanceof " + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE) + ") {\n");
        buffer.append("\t\t\t((" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE) + ") control).addSignalListener(this);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t\tif (control instanceof " + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE) + ") {\n");
        buffer.append("\t\t\t((" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE) + ") control).addCommandListener(this);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("if (isActive()) {\n");
        buffer.append("\ttest();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getSetupContents() {
        TestElement element = this.getTestElement();
        EscPropertiesModel model = EscPropertiesModel.getModel(this);
        String configKey = this.getConfigurationKey(element);
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("super.setup();\n");
        String value = null;
        value = "DEFAULT_PRIORITY";
        buffer.append("setPriority(");
        buffer.append(this.getConfInt(element, "priority", value));
        model.addProperty(String.valueOf(configKey) + ".priority", "3");
        buffer.append(");\n");
        value = element.getTestCount();
        buffer.append("setTestCount(");
        if (value == null) {
            value = "DEFAULT_TEST_COUNT";
        }
        buffer.append(this.getConfInt(element, "testcount", value));
        model.addProperty(String.valueOf(configKey) + ".testcount", "2");
        buffer.append(");\n");
        value = this.getTestElement().getTestDelay();
        buffer.append("setTestDelay(");
        if (value == null) {
            value = "DEFAULT_TEST_DELAY";
        }
        buffer.append(this.getConfLong(element, "testdelay", value));
        model.addProperty(String.valueOf(configKey) + ".testdelay", "0");
        buffer.append(");\n");
        value = this.getTestElement().getTestExecute();
        buffer.append("setTestExecute(");
        if (value == null) {
            value = "DEFAULT_TEST_EXECUTE";
        }
        buffer.append(this.getConfBoolean((TagElement)element, "testexecute", value));
        model.addProperty(String.valueOf(configKey) + ".testexecute", "false");
        buffer.append(");\n");
        value = this.getTestElement().getTestExecuteRead();
        buffer.append("setTestExecuteRead(");
        if (value == null) {
            value = "DEFAULT_TEST_EXECUTE_READ";
        }
        buffer.append(this.getConfBoolean((TagElement)element, "testexecuteread", value));
        model.addProperty(String.valueOf(configKey) + ".testexecuteread", "true");
        buffer.append(");\n");
        value = this.getTestElement().getTestExecuteWrite();
        buffer.append("setTestExecuteWrite(");
        if (value == null) {
            value = "DEFAULT_TEST_EXECUTE_WRITE";
        }
        buffer.append(this.getConfBoolean((TagElement)element, "testexecutewrite", value));
        model.addProperty(String.valueOf(configKey) + ".testexecutewrite", "false");
        buffer.append(");\n");
        value = this.getTestElement().getTestRead();
        buffer.append("setTestRead(");
        if (value == null) {
            value = "DEFAULT_TEST_READ";
        }
        buffer.append(this.getConfBoolean((TagElement)element, "testread", value));
        model.addProperty(String.valueOf(configKey) + ".testread", "false");
        buffer.append(");\n");
        value = this.getTestElement().getTestTrigger();
        buffer.append("setTestTrigger(");
        if (value == null) {
            value = "DEFAULT_TEST_TRIGGER";
        }
        buffer.append(this.getConfBoolean((TagElement)element, "testtrigger", value));
        model.addProperty(String.valueOf(configKey) + ".testtrigger", "false");
        buffer.append(");\n");
        value = "DEFAULT_TOTAL_TEST_TIME";
        buffer.append("setTotalTestTime(");
        buffer.append(this.getConfLong(element, "totaltesttime", value));
        model.addProperty(String.valueOf(configKey) + ".totaltesttime", "60000");
        buffer.append(");\n");
        return buffer.toString();
    }

    protected String getSignalOccurredContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("StringBuffer buffer = new StringBuffer(256);");
        buffer.append("buffer.append(\"Signal \");\n");
        buffer.append("buffer.append(source);\n");
        buffer.append("buffer.append(\" received \");\n");
        buffer.append("if (data != null) {\n");
        buffer.append("\tbuffer.append(\"with \");\n");
        buffer.append("\tbuffer.append(formatData(data));\n");
        buffer.append("\tif (data instanceof Object[]) {\n");
        buffer.append("\t\tbuffer.append(\" data[] \");\n");
        buffer.append("\t} else {\n");
        buffer.append("\t\tbuffer.append(\" data \");\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("buffer.append(\"at \");\n");
        buffer.append("buffer.append(timestamp);\n");
        buffer.append("buffer.append(\".\");\n");
        buffer.append("log(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE));
        buffer.append(".LOG_INFO, buffer.toString());\n");
        return buffer.toString();
    }

    protected String getStartContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("setActive(true);\n");
        buffer.append("if (getDevice() != null) {\n");
        buffer.append("\tStringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("\tbuffer.append(\"Test: ");
        buffer.append(this.getUserName(this.fTest));
        buffer.append(" start at :\");\n");
        buffer.append("\tbuffer.append(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT);
        buffer.append(".getCurrentTimestamp());\n");
        buffer.append("\tlog(" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE) + ".LOG_INFO, buffer.toString());\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        buffer.append("\ttest();\n");
        buffer.append('}');
        return buffer.toString();
    }

    protected String getStopContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("setActive(false);\n");
        buffer.append("if (getThread() != null) {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\tgetThread().join(2000);\n");
        buffer.append("\t} catch (final Exception exception) {\n");
        buffer.append("\t\tlog(" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE) + ".LOG_ERROR, \"Exception on join.\", exception);\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("setThread(null);\n");
        buffer.append("if (getDevice() != null) {\n");
        buffer.append("\tStringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("\tbuffer.append(\"Test: ");
        buffer.append(this.getUserName(this.fTest));
        buffer.append(" stop at: \");\n");
        buffer.append("\tbuffer.append(getCurrentTimestamp());\n");
        buffer.append("\tlog(LOG_INFO, buffer.toString());\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getTargetType() {
        return "device";
    }

    protected String getTestCommandsContents(String key, String deviceService) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("if (isActive()) {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\t//The device appears to be ok to run this test\n");
        buffer.append("\t\t//Get the command from the device and check if found\n");
        buffer.append("\t\t" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE) + " command" + key + " = getDevice().getCommand(" + DeviceKitUtilities.stripPackage(deviceService) + '.' + key + ");\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE);
        this.fTestModel.addImport(deviceService);
        buffer.append("\t\tif (command" + key + " == null) {\n");
        buffer.append("\t\t\tlog(LOG_ERROR, \"Unable to find " + deviceService + '.' + key + "\");\n");
        buffer.append("\t\t} else {\n");
        buffer.append("\t\t\t//The following line is not needed since the setDevice does this.\n");
        buffer.append("\t\t\t//command" + key + ".addCommandListener(this);\n");
        buffer.append("\t\t\tif (getTestExecute() && isActive()) {\n");
        buffer.append("\t\t\t\t//Execute the command without any data.\n");
        buffer.append("\t\t\t\t//Normally, this is cause the commandExecuted method to be called.\n");
        buffer.append("\t\t\t\tcommand" + key + ".execute();\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t}\n");
        buffer.append("\t} catch (final Exception exception) {\n");
        buffer.append("\t\tlog(LOG_ERROR, \"Exception testing the " + deviceService + '.' + key + " command.\", exception);\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getTestMeasurmentsContents(String key, String deviceService) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("if (isActive()) {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\t//The device appears to be ok to run this test\n");
        buffer.append("\t\t//Get the measurement from the device and check if found\n");
        buffer.append("\t\t" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE) + " measurement" + key + " = getDevice().getMeasurement(" + DeviceKitUtilities.stripPackage(deviceService) + '.' + key + ");\n");
        buffer.append("\t\tif (measurement" + key + " == null) {\n");
        buffer.append("\t\t\tlog(LOG_ERROR, \"Unable to find " + DeviceKitUtilities.stripPackage(deviceService) + '.' + key + "\");\n");
        buffer.append("\t\t} else {\n");
        buffer.append("\t\t\t//The following line is not needed since the setDevice does this.\n");
        buffer.append("\t\t\t//measurement" + key + ".addMeasurementListener(this);\n");
        buffer.append("\t\t\tif (getTestRead() && isActive()) {\n");
        buffer.append("\t\t\t\t//Invoking the read method usually causes the commandExecuted method to be called.\n");
        buffer.append("\t\t\t\t//Normally, this is cause the measurementExecuted method to be called.\n");
        buffer.append("\t\t\t\tmeasurement" + key + ".read();\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t\tif (getTestExecuteRead() && isActive()) {\n");
        buffer.append("\t\t\t\t//Invoking the executeRead method usually causes the commandExecuted method to be called.\n");
        buffer.append("\t\t\t\t//Normally, this is cause the measurementExecuted method to be called.\n");
        buffer.append("\t\t\t\tmeasurement" + key + ".executeRead();\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t\tObject value = measurement" + key + ".getValue();\n");
        buffer.append("\t\t\tStringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("\t\t\tbuffer.append(");
        buffer.append(DeviceKitUtilities.stripPackage(deviceService));
        buffer.append('.');
        buffer.append(key);
        buffer.append(");\n");
        buffer.append("\t\t\tbuffer.append(\" measurement value=\");\n");
        buffer.append("\t\t\tbuffer.append(value);\n");
        buffer.append("buffer.append('.');\n");
        buffer.append("\t\t\t//Log the current value of the measurement.\n");
        buffer.append("\t\t\tlog(LOG_INFO, buffer.toString());\n");
        buffer.append("\t\t\tif (value != null) {\n");
        buffer.append("\t\t\t\tif (getTestExecuteWrite() && isActive()) {\n");
        buffer.append("\t\t\t\t\tmeasurement" + key + ".executeWrite(value);\n");
        buffer.append("\t\t\t\t}\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t}\n");
        buffer.append("\t} catch (final Exception exception) {\n");
        buffer.append("\t\tlog(LOG_ERROR, \"Exception testing the " + deviceService + '.' + key + " measurement.\", exception);\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getTestSignalsContents(String key, String deviceService) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("if (isActive()) {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\t//The device appears to be ok to run this test\n");
        buffer.append("\t\t//Get the signal from the device and check if found.\n");
        buffer.append("\t\t" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE) + " signal" + key + " = getDevice().getSignal(" + DeviceKitUtilities.stripPackage(deviceService) + '.' + key + ");\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE);
        buffer.append("\t\tif (signal" + key + " == null) {\n");
        buffer.append("\t\t\tlog(LOG_ERROR, \"Unable to find " + DeviceKitUtilities.stripPackage(deviceService) + '.' + key + "\");\n");
        buffer.append("\t\t} else {\n");
        buffer.append("\t\t\t//The following line is not needed since the setDevice does this.\n");
        buffer.append("\t\t\t//signal" + key + ".addSignalListener(this);\n");
        buffer.append("\t\t\tif (getTestTrigger() && isActive()) {\n");
        buffer.append("\t\t\t\t//Request the signal to trigger.\n");
        buffer.append("\t\t\t\t//This should result in the signalOccurred method being called.\n");
        buffer.append("\t\t\t\tsignal" + key + ".trigger();\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t}\n");
        buffer.append("\t} catch (final Exception exception) {\n");
        buffer.append("\t\tlog(LOG_ERROR, \"Exception testing the " + deviceService + '.' + key + " signal.\", exception);\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected boolean isAbstract() {
        List devs = this.getMainElement().getAllChildrenWithTagCode(8);
        TagElement dev = (TagElement)devs.get(0);
        String abs = dev.getAttribute("abstract");
        return abs != null && abs.equals("true");
    }
}

