/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.TestFactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkTestBundleGenerator
extends DkDeviceGenerator {
    private TestElement fTest;
    private int testType;

    public DkTestBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkTestBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, int bundleType, int testType) {
        super(model, generatedInfo, new HashMap(), bundleType);
        this.testType = testType;
    }

    protected void codeBACreateService(IType ba) {
        String serviceType = this.getMainElement().getServiceType();
        this.fBundleActivatorModel.addImport(serviceType);
        String returnType = this.fTest.getServiceType();
        String[] comment = new String[]{"Creates the test for the specified " + this.getTargetType() + '.', "", "@param " + this.getTargetType() + ' ' + DeviceKitUtilities.stripPackage(serviceType), "@return " + returnType + " The " + this.getTargetType() + " test.", "@see " + this.getMainFqn()};
        KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(serviceType), this.getTargetType());
        this.fBundleActivatorModel.addImport(returnType);
        String contents = this.getBACreateServiceContents();
        this.codeMethod(ba, "createService", comment, DeviceKitUtilities.stripPackage(returnType), 1L, contents, new KeyValuePair[]{parameter}, null);
        this.fBundleActivatorModel.addImport(this.getMainFqn());
    }

    protected void codeBAGetImportedServiceNames(IType ba) {
        this.codeBAGetImportedServiceNames(this.fTest.getBundleName(), ba);
    }

    protected void codeBAGetInterestServiceName(IType ba) {
        String[] comment = new String[]{"Gets the " + this.getTargetType() + " service name to be tested.", "", "@return String The interest service name.", "@see " + this.getModelServiceName()};
        String contents = this.getBAGetInterestServiceNameContents();
        this.codeMethod(ba, "getInterestServiceName", comment, "String", 1L, contents);
    }

    public void generate() throws Exception {
        this.initialize();
        if (this.getManifestModel() != null) {
            this.getManifestModel().addImportPackage(this.getMainPackage());
            this.getBuildModel().addAdditionalBundles(this.getMainPackage());
        }
        this.generateBundleActivatorClass();
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    protected void generateOtherFiles() {
        switch (this.bundleType) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                String metaData = this.getMetaDataContents();
                if (metaData == null) break;
                this.otherManifestFiles.put("OSGI-INF/metatype/Metadata.xml", metaData);
            }
        }
        String property = this.getMetaDataProperties();
        if (property != null) {
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle.properties", property);
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle_en.properties", property);
        }
    }

    protected void generateSpecificClass() throws Exception {
    }

    protected String getBACreateServiceContents() {
        String serviceType = this.getMainElement().getServiceType();
        String serviceTypeSimple = DeviceKitUtilities.stripPackage(serviceType);
        String type = this.getTargetType();
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(" test = new ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append("();\n");
        buffer.append("test.set");
        buffer.append(serviceTypeSimple.substring(0, serviceTypeSimple.length() - 7));
        buffer.append('(');
        buffer.append(type);
        buffer.append(");\n");
        buffer.append("return test;\n");
        return buffer.toString();
    }

    protected String getBAGetInterestServiceNameContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return " + this.getModelServiceName() + ".SERVICE_NAME;\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.testType) {
            case 8: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 9: 
            case 97: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 72: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_ADAPTER_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_ADAPTER_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_ADAPTER_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 91: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_AGENT_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_AGENT_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_AGENT_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 74: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_PROFILE_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_PROFILE_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_PROFILE_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 36: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_CONNECTION_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_CONNECTION_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_CONNECTION_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
        }
        return "";
    }

    protected List getImportedServices() {
        return new ArrayList();
    }

    public JavaFileModel getMainModel() {
        return null;
    }

    protected String getManifestBundleId() {
        return this.getSourceFolderName();
    }

    protected String getManifestBundleName() {
        return this.getBundleActivatorClass();
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    protected List getManifestExportPackages() {
        ArrayList<String> result = new ArrayList<String>();
        String bap = this.getBundleActivatorPackage();
        result.add(bap);
        return result;
    }

    protected List getManifestExportServices() {
        List vector = super.getManifestExportServices();
        List list = this.getMainElement().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < list.size()) {
            String service = ((TagElement)list.get(i)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.add(service);
            }
            ++i;
        }
        vector.add(this.getServiceFqn());
        return vector;
    }

    protected List getManifestImportPackages() {
        String serviceDevicePack;
        String corePack;
        String baseBundleActivatorPack;
        List result = super.getManifestImportPackages();
        switch (this.bundleType) {
            case 2: {
                String managedDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_BA);
                if (result.contains(managedDevicePack)) break;
                result.add(managedDevicePack);
                break;
            }
            case 3: {
                String factoryDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_FACTORY_BA);
                if (result.contains(factoryDevicePack)) break;
                result.add(factoryDevicePack);
            }
        }
        String connectionBundlePack = DeviceKitGenerationConstants.PACKAGE_CONNECTION_BUNDLE;
        if (!result.contains(connectionBundlePack)) {
            result.add(connectionBundlePack);
        }
        if (!result.contains(baseBundleActivatorPack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_SAT_BUNDLE_ACTIVATOR))) {
            result.add(baseBundleActivatorPack);
        }
        if (!result.contains(corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT))) {
            result.add(corePack);
        }
        if (!result.contains(serviceDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE))) {
            result.add(serviceDevicePack);
        }
        List importedServices = this.getImportedServices();
        int i = 0;
        while (i < importedServices.size()) {
            String serviceFqn = (String)importedServices.get(i);
            String servicePackage = DeviceKitUtilities.extractPackage(serviceFqn);
            result.add(servicePackage);
            ++i;
        }
        return result;
    }

    protected List getManifestImportServices() {
        List vector = super.getManifestImportServices();
        vector.add(this.getModelServiceName());
        vector.add(DeviceKitGenerationConstants.CLASS_NOTIFICATION_SERVICE);
        return vector;
    }

    public List getManifestRequiredBundles() {
        List result = super.getManifestRequiredBundles();
        String targetId = this.getMainElement().getProjectId();
        boolean isConnection = targetId.endsWith(".connection");
        switch (this.bundleType) {
            case 1: {
                if (isConnection) break;
                result.add(String.valueOf(targetId) + ".bundle");
                break;
            }
            case 2: {
                result.add(String.valueOf(targetId) + ".managed");
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
                break;
            }
            case 3: {
                result.add(String.valueOf(targetId) + ".factory");
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
            }
        }
        List required = this.getMainElement().getRequiredBundles();
        String notificationString = DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_NOTIFICATION);
        result.add(notificationString);
        result.add(String.valueOf(notificationString) + ".bundle");
        result.add("org.eclipse.equinox.event");
        int i = 0;
        while (i < required.size()) {
            TagElement element = (TagElement)required.get(i);
            String bundleId = element.getProjectId();
            if (bundleId != null && bundleId.length() > 0) {
                String id = bundleId;
                result.add(id);
                isConnection = id.endsWith(".connection");
                switch (this.bundleType) {
                    case 1: {
                        if (isConnection) break;
                        result.add(String.valueOf(id) + ".bundle");
                        break;
                    }
                    case 2: {
                        result.add(String.valueOf(id) + ".managed");
                        break;
                    }
                    case 3: {
                        result.add(String.valueOf(id) + ".factory");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    protected String getMetaDataContents() {
        TestFactoryMetaDataBuilder builder = new TestFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataXmlContents();
    }

    protected String getMetaDataProperties() {
        TestFactoryMetaDataBuilder builder = new TestFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataPropertiesContents();
    }

    protected String getModelServiceName() {
        List devices = this.fTest.getAllChildrenWithTagCode(this.testType);
        String service = null;
        TagElement device = (TagElement)devices.get(0);
        service = device.getAttribute("service") != null ? device.getAttribute("service") : device.getImplementation();
        if (service != null) {
            if (!service.endsWith("Service")) {
                service = String.valueOf(service) + "Service";
            }
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            return service;
        }
        return "";
    }

    public String getServiceClassParent() {
        switch (this.testType) {
            case 8: {
                return DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE;
            }
            case 18: {
                return DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE;
            }
            case 9: 
            case 97: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE;
            }
            case 72: {
                return DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE;
            }
            case 91: {
                return DeviceKitGenerationConstants.CLASS_AGENT_SERVICE;
            }
            case 74: {
                return DeviceKitGenerationConstants.CLASS_PROFILE_SERVICE;
            }
            case 36: {
                return DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE;
            }
        }
        return super.getServiceClassParent();
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.getBundleActivatorPackage();
        return sfName;
    }

    protected String getTargetType() {
        switch (this.testType) {
            case 9: {
                return "transport";
            }
            case 97: {
                return "transport";
            }
            case 8: {
                return "device";
            }
            case 72: {
                return "adapter";
            }
            case 91: {
                return "agent";
            }
            case 74: {
                return "profile";
            }
            case 36: {
                return "connection";
            }
        }
        return "";
    }

    protected TestElement getTestElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (10 == ((TagElement)children.get(i)).getTagCode()) {
                return (TestElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void initialize() {
        this.fTest = this.getTestElement();
        String className = DeviceKitUtilities.getClassNameFromTagElement(this.fTest);
        this.setMainClassName(className);
        this.setPackageBase(this.fTest.getPackageBase());
        String pack = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
        this.setMainPackage(pack);
        List devices = this.fTest.getAllChildrenWithTagCode(this.testType);
        if (devices.size() > 0) {
            MainTagElement target = (MainTagElement)devices.get(0);
            this.setMainTagElement(target);
            this.setDevice(target);
        }
    }

    public List save(IProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save(progressMonitor);
            if (ba != null) {
                result.add(ba);
            }
        }
        this.saveCommon(progressMonitor);
        return result;
    }
}

