/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.FactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.model.java.JavaModelException;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public abstract class DkTestGenerator
extends AbstractDkGenerator {
    protected int bundleType = 0;
    protected TestElement fTest;
    protected JavaFileModel fTestModel;
    private String pack;

    protected DkTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap());
    }

    protected DkTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected void cleanup() {
        EscPropertiesModel.getModel(this).addProperty("esc.tracelevel", "0");
    }

    protected void codeBAActivate(IType ba) {
        String[] comment = new String[]{"Activates the bundle.", "@see " + this.getMainFqn()};
        String contents = this.getBAActivateContents();
        this.codeMethod(ba, "activate", comment, "void", 4L, contents);
    }

    protected void codeBAFields(IType ba) {
        super.codeBAFields(ba);
    }

    protected void codeBAGetImportedServiceNames(IType ba) {
        this.codeBAGetImportedServiceNames(this.fTest.getBundleName(), ba);
    }

    protected void codeBAGetInterestServiceName(IType ba) {
        String[] comment = new String[]{"Gets the " + this.getTargetType() + " service name to be tested.", "", "@return String The interest service name.", "@see " + this.getModelServiceName()};
        String contents = this.getBAGetInterestServiceNameContents();
        this.codeMethod(ba, "getInterestServiceName", comment, "String", 1L, contents);
    }

    protected void codeBAGetMatchDeviceClasses(IType ba) {
        this.codeBAMatchingDevicesField(ba, this.quote(this.getMainClassName()));
        StringBuffer comment = new StringBuffer(32);
        comment.append("Return the match strings.\n");
        comment.append("@return Array of Strings containing ");
        comment.append(this.getNonTestClass());
        comment.append('.');
        this.codeBAGetMatchingDevicesMethod(ba, comment.toString());
    }

    protected void codeBAMethods(IType ba) {
        this.codeBAGetInterestServiceName(ba);
    }

    protected void codeConstructors(IType test) {
        String name = this.getMainClassName();
        String comment = "Constructs a new instance of the " + this.getMainClassName() + " class.";
        this.codeMethod(test, name, comment, null, 1L, "super();\n");
    }

    protected void codeErrorOccurred(IType test, String header, String argument) {
        String contents = this.getErrorOccurredContents(header, argument);
        KeyValuePair parameter1 = new KeyValuePair("Object", argument);
        KeyValuePair parameter2 = new KeyValuePair("Object", "timestamp");
        KeyValuePair parameter3 = new KeyValuePair("Object", "data");
        KeyValuePair[] parameters = new KeyValuePair[]{parameter1, parameter2, parameter3};
        this.codeMethod(test, "errorOccurred", "The errorOccurred method is called when an error occurs.", "void", 1L, contents, parameters, null);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
    }

    protected void codeFields(IType test) {
        this.codeClassNameField(test, this.getMainFqn());
    }

    protected void codeGetThread(IType test) {
        this.codeMethod(test, "getThread", "Gets the thread to be used in testing.", "Thread", 1L, "return this.thread;\n");
    }

    protected void codeIsActive(IType test) {
        String contents = this.getIsActiveContents();
        this.codeMethod(test, "isActive", "Gets the active status.  If true, then tests are running.", "boolean", 1L, contents);
    }

    protected void codeMain(IType test) {
        String targetClass = this.fTest.getTargetClass();
        if (targetClass.indexOf(46) == -1) {
            String tcPack = DeviceKitUtilities.getPackageFromClassName(targetClass, this.getPackageBase());
            targetClass = String.valueOf(tcPack) + '.' + targetClass;
        }
        String[] comment = new String[]{"Main method to run tests in a stand alone mode.", "", "@param args", "@see " + targetClass};
        String contents = this.getMainContents();
        KeyValuePair parameter = new KeyValuePair("String[]", "args");
        this.codeMethod(test, "main", comment, "void", 17L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeMethods(IType test) {
        this.codeMain(test);
    }

    protected void codeRun(IType test) {
        String comment = "Run tests for the " + this.getTargetType() + '.';
        String contents = this.getRunContents();
        this.codeMethod(test, "run", comment, "void", 1L, contents);
    }

    protected void codeServiceFields(IType service) {
        super.codeServiceFields(service);
        this.codeDescriptionField(service, "SERVICE_DESCRIPTION");
    }

    protected void codeSetActive(IType test) {
        KeyValuePair parameter = new KeyValuePair("boolean", "active");
        this.codeMethod(test, "setActive", "Sets the active status.", "void", 1L, "this.active = active;\n", new KeyValuePair[]{parameter}, null);
    }

    protected void codeSetThread(IType test) {
        KeyValuePair parameter = new KeyValuePair("Thread", "thread");
        this.codeMethod(test, "setThread", "Sets the thread.", "void", 1L, "this.thread = thread;\n", new KeyValuePair[]{parameter}, null);
    }

    protected void codeStart(IType test) {
        String contents = this.getStartContents();
        this.codeMethod(test, "start", "Start the test case.", "void", 1L, contents);
    }

    protected void codeStop(IType test) {
        String contents = this.getStopContents();
        this.codeMethod(test, "stop", "Stops the test case.", "void", 1L, contents);
    }

    protected void codeTest(IType test) {
        String comment = "Tests the " + this.getTargetType() + '.';
        String contents = this.getTestContents();
        this.codeMethod(test, "test", comment, "void", 1L, contents);
    }

    protected void codeTestCount(IType test) {
        String cValue = this.getTestElement().getTestCount();
        if (cValue == null) {
            cValue = "1";
        }
        String value = this.getConfStaticInt(this.getTestElement(), "testcount", cValue);
        this.codeField(test, "testCount", "int", 2L, "Specifies the number of times to execute the test methods.\n", value);
    }

    protected IType createBundleActivatorType() throws Exception {
        String baName = this.getBundleActivatorClass();
        String baPackage = this.getBundleActivatorPackage();
        this.fBundleActivatorModel = new JavaFileModel(baName);
        this.fBundleActivatorModel.setComment(this.getCopyright());
        this.fBundleActivatorModel.setPackage(baPackage);
        IType baType = this.createClass(this.fBundleActivatorModel, baPackage, baName, this.getSourceFolderName());
        String baSuperClass = this.getBASuperClass();
        baType.setSuperClass(DeviceKitUtilities.stripPackage(baSuperClass));
        this.fBundleActivatorModel.addImport(baSuperClass);
        baType.setComment(this.getBundleActivatorComment());
        return baType;
    }

    private IType createTestType() throws Exception {
        String testName = this.getMainClassName();
        String testPack = this.getMainPackage();
        this.fTestModel = new JavaFileModel(testName);
        this.fTestModel.setComment(this.getCopyright());
        this.fTestModel.setPackage(testPack);
        this.fTestModel.addImport(this.getServiceFqn());
        IType test = this.createClass(this.fTestModel, testPack, testName, this.getSourceFolderName());
        test.setComment(this.getMainClassComment());
        String superClassFull = this.fTest.getSuperClass();
        this.fTestModel.addImport(superClassFull);
        this.buildModel.addPackage(DeviceKitUtilities.extractPackage(superClassFull));
        String superClass = DeviceKitUtilities.stripPackage(superClassFull);
        test.setSuperClass(superClass);
        String[] interfaces = this.getImplementedInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].indexOf(46) != -1) {
                this.fTestModel.addImport(interfaces[i]);
            }
            test.addSuperInterface(DeviceKitUtilities.stripPackage(interfaces[i]));
            ++i;
        }
        return test;
    }

    public void generate() throws Exception {
        this.fTest = this.getTestElement();
        this.setMainTagElement(this.fTest);
        this.initialize();
        if (this.isAbstract()) {
            this.generateOtherFiles();
            return;
        }
        super.generate();
    }

    protected void generateBundleActivatorClass() throws Exception {
    }

    protected void generateSpecificClass() throws JavaModelException {
        try {
            IType test = this.createTestType();
            this.codeConstructors(test);
            this.codeFields(test);
            this.codeMethods(test);
            this.generateCustomMainItems();
        }
        catch (Exception e) {
            throw new JavaModelException(e.getMessage());
        }
        this.cleanup();
    }

    protected String getBAActivateContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("if (testCase != null)\n");
        buffer.append("\ttestCase.start();\n");
        return buffer.toString();
    }

    protected String getBAGetInterestServiceNameContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return " + this.getModelServiceName() + ".SERVICE_NAME;\n");
        return buffer.toString();
    }

    protected String getBundleActivatorComment() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    public int getBundleType() {
        return this.bundleType;
    }

    protected String getCommonClassComment() {
        StringBuffer buffer = new StringBuffer(128);
        String importedServices = this.getImportedServiceComment();
        buffer.append(importedServices);
        if (importedServices.length() > 0) {
            buffer.append(" \n");
        }
        String exportedServices = this.getExportedServiceComment();
        buffer.append(exportedServices);
        if (exportedServices.length() > 0) {
            buffer.append(" \n");
        }
        buffer.append(super.getCommonClassComment());
        return buffer.toString();
    }

    protected String getErrorOccurredContents(String header, String argument) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("\tStringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("\tbuffer.append(\"" + header + ": \");\n");
        buffer.append("\tbuffer.append(" + argument + ");\n");
        buffer.append("\tbuffer.append(\"\\r\\n\terror: \");\n");
        buffer.append("\tbuffer.append(data);\n");
        buffer.append("\tbuffer.append(\" at: \");\n");
        buffer.append("\tbuffer.append(timestamp);\n");
        buffer.append("\tbuffer.append('.');\n");
        buffer.append("\tlog(");
        buffer.append(String.valueOf(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE)) + ".LOG_ERROR");
        buffer.append(", ");
        buffer.append("buffer.toString());\n");
        return buffer.toString();
    }

    protected String getExportedServiceComment() {
        StringBuffer buffer = new StringBuffer(32);
        List exports = this.getExportedServices();
        if (exports.size() > 0) {
            buffer.append("<p>The list of exported services:\n");
            int i = 0;
            while (i < exports.size()) {
                buffer.append("@see " + exports.get(i) + "\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    protected List getExportedServices() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getServiceFqn());
        return result;
    }

    protected abstract String[] getImplementedInterfaces();

    protected String getImportedServiceComment() {
        StringBuffer buffer = new StringBuffer(32);
        List imports = this.getImportedServices();
        if (imports.size() > 0) {
            buffer.append("<p>The list of imported services:\n");
            int i = 0;
            while (i < imports.size()) {
                buffer.append("@see " + imports.get(i) + "\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    protected List getImportedServices() {
        ArrayList<String> result = new ArrayList<String>();
        List children = this.fTest.getAllChildrenWithTagCodes(new int[]{8, 9, 97, 15});
        int i = 0;
        while (i < children.size()) {
            String service = ((TagElement)children.get(i)).getAttribute("service");
            if (service != null) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                result.add(service);
            } else {
                String bundle = ((TagElement)children.get(i)).getAttribute("bundle");
                if (bundle != null) {
                    if (!bundle.endsWith("Service")) {
                        bundle = String.valueOf(bundle) + "Service";
                    }
                    if (bundle.indexOf(46) == -1) {
                        String pack = DeviceKitUtilities.getPackageFromClassName(bundle, this.getPackageBase());
                        bundle = String.valueOf(pack) + '.' + bundle;
                    }
                    result.add(bundle);
                }
            }
            ++i;
        }
        return result;
    }

    protected abstract String getIsActiveContents();

    protected abstract String getMainClassComment();

    protected abstract String getMainContents();

    public JavaFileModel getMainModel() {
        return this.fTestModel;
    }

    protected String[] getManifestCategories() {
        return new String[]{"device", "testing", "example"};
    }

    protected List getManifestExportPackages() {
        IPackageFragment packageFragment;
        List vector = super.getManifestExportPackages();
        String mainPackage = this.getMainPackage();
        vector.add(mainPackage);
        String baPackage = this.getBundleActivatorPackage();
        IJavaProject javaProject = CoreUtility.getJavaProject(this.getSourceFolderName());
        if (javaProject != null && (packageFragment = CoreUtility.getPackageInProject(javaProject, baPackage)) != null) {
            try {
                if (packageFragment.exists()) {
                    packageFragment.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (org.eclipse.jdt.core.JavaModelException e) {
                e.printStackTrace();
            }
        }
        vector.add(this.getServicePackage());
        return vector;
    }

    protected List getManifestExportServices() {
        ArrayList<String> vector = new ArrayList<String>();
        List list = this.getMainElement().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < list.size()) {
            String service = ((TagElement)list.get(i)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.add(service);
            }
            ++i;
        }
        vector.add(this.getServiceFqn());
        return vector;
    }

    protected List getManifestImportPackages() {
        String baseBundleActivatorPack;
        List vector = super.getManifestImportPackages();
        String[] imports = this.fTestModel.getImports();
        int i = 0;
        while (i < imports.length) {
            if (!this.inThisBundle(imports[i])) {
                vector.add(DeviceKitUtilities.extractPackage(imports[i]));
            }
            ++i;
        }
        imports = this.fServiceModel.getImports();
        i = 0;
        while (i < imports.length) {
            if (!this.inThisBundle(imports[i])) {
                vector.add(DeviceKitUtilities.extractPackage(imports[i]));
            }
            ++i;
        }
        if (this.fBundleActivatorModel != null) {
            imports = this.fBundleActivatorModel.getImports();
            i = 0;
            while (i < imports.length) {
                if (!this.inThisBundle(imports[i])) {
                    vector.add(DeviceKitUtilities.extractPackage(imports[i]));
                }
                ++i;
            }
        }
        vector.add(DeviceKitUtilities.extractPackage(this.getModelServiceName()));
        vector.add(DeviceKitUtilities.extractPackage(this.getModelName()));
        vector.add(DeviceKitGenerationConstants.PACKAGE_CONNECTION_BUNDLE);
        String corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT);
        if (!vector.contains(corePack)) {
            vector.add(corePack);
        }
        if (!vector.contains(baseBundleActivatorPack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_SAT_BUNDLE_ACTIVATOR))) {
            vector.add(baseBundleActivatorPack);
        }
        return vector;
    }

    protected List getManifestImportServices() {
        List vector = super.getManifestImportServices();
        vector.add(this.getModelServiceName());
        return vector;
    }

    public List getManifestRequiredBundles() {
        List result = super.getManifestRequiredBundles();
        String targetId = this.getMainElement().getProjectId();
        boolean isConnection = targetId.endsWith(".connection");
        switch (this.bundleType) {
            case 1: {
                if (isConnection) break;
                result.add(String.valueOf(targetId) + ".bundle");
                break;
            }
            case 2: {
                result.add(String.valueOf(targetId) + ".managed");
                break;
            }
            case 3: {
                result.add(String.valueOf(targetId) + ".factory");
            }
        }
        List required = this.getMainElement().getRequiredBundles();
        int i = 0;
        while (i < required.size()) {
            TagElement element = (TagElement)required.get(i);
            String bundleId = element.getProjectId();
            if (bundleId != null && bundleId.length() > 0) {
                String id = bundleId;
                result.add(id);
                isConnection = id.endsWith(".connection");
                switch (this.bundleType) {
                    case 1: {
                        if (isConnection) break;
                        result.add(String.valueOf(id) + ".bundle");
                        break;
                    }
                    case 2: {
                        result.add(String.valueOf(id) + ".managed");
                        break;
                    }
                    case 3: {
                        result.add(String.valueOf(id) + ".factory");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    protected String getMetaDataProperties() {
        FactoryMetaDataBuilder builder = new FactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataPropertiesContents();
    }

    protected abstract String getModelName();

    protected abstract String getModelServiceName();

    protected String getNonTestClass() {
        String mainClass = this.getMainClassName();
        if (mainClass.endsWith("Test")) {
            mainClass = mainClass.substring(0, mainClass.length() - 4);
        }
        return mainClass;
    }

    protected abstract String getRunContents();

    protected String getServiceFileComment() {
        StringBuffer buffer = new StringBuffer(32);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(this.getImportedServiceComment());
        buffer.append(super.getCommonClassComment());
        return buffer.toString();
    }

    protected String[] getServiceInterfaces() {
        return new String[0];
    }

    protected List getServices() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.fTest != null) {
            String service = this.fTest.getAttribute("service");
            if (service != null) {
                result.add(service);
            } else {
                String bundle = this.fTest.getAttribute("bundle");
                if (bundle != null) {
                    if (!bundle.endsWith("Service")) {
                        bundle = String.valueOf(bundle) + "Service";
                    }
                    result.add(bundle);
                }
            }
        }
        return result;
    }

    protected abstract String getStartContents();

    protected abstract String getStopContents();

    protected abstract String getTargetType();

    protected String getTestContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("if (getThread() == null) {\n");
        buffer.append("\tsetThread(new Thread(this, ");
        buffer.append(this.quote(this.getUserName(this.fTest)));
        buffer.append("));\n");
        buffer.append("\tgetThread().setPriority(");
        buffer.append(this.getConfInt(this.fTest, "priority", "Thread.NORM_PRIORITY - 2"));
        buffer.append(");\n");
        buffer.append("\tgetThread().start();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected TestElement getTestElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (10 == ((TagElement)children.get(i)).getTagCode()) {
                return (TestElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void initialize() {
        String className = DeviceKitUtilities.getClassNameFromTagElement(this.fTest);
        this.setMainClassName(className);
        this.setPackageBase(this.fTest.getPackageBase());
        this.pack = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
        this.setMainPackage(this.pack);
        super.initialize();
    }

    protected List save(IProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        this.fTestModel.setSaver(this.getSaver());
        this.fTestModel.setSortOrder(3L);
        Object test = this.fTestModel.save(progressMonitor);
        if (test != null) {
            result.add(test);
        }
        List supersResult = super.save(progressMonitor);
        return DeviceKitUtilities.mergeLists(result, supersResult);
    }

    public void setBundleType(int bundleType) {
        this.bundleType = bundleType;
    }

    protected void setTestElement(TestElement element) {
        this.fTest = element;
    }
}

