/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util;

import java.io.ByteArrayOutputStream;

public class BinaryOuputStream
extends ByteArrayOutputStream {
    private int extraLength = 0;

    public BinaryOuputStream() {
    }

    public BinaryOuputStream(int p1) {
        super(p1);
    }

    public static void main(String[] args) {
        BinaryOuputStream binaryOutputStream = new BinaryOuputStream();
        int i = 0;
        while (i < 12) {
            binaryOutputStream.writeBinary(i % 2);
            ++i;
        }
        binaryOutputStream.write(254);
        i = 1;
        while (i < 16) {
            binaryOutputStream.writeNibble(i);
            ++i;
        }
        byte[] bytes = binaryOutputStream.toByteArray();
        int i2 = 0;
        while (i2 < bytes.length) {
            System.out.println(Integer.toHexString(bytes[i2] & 0xFF));
            ++i2;
        }
        System.out.println(Integer.toHexString(binaryOutputStream.getExtra()));
        System.out.println(binaryOutputStream.getLength());
    }

    public int getExtra() {
        return this.buf[this.count - 1];
    }

    public int getLength() {
        return this.size() * 8 + this.extraLength;
    }

    public synchronized void write(int oneByte) {
        this.writeNibble(oneByte >> 4 & 0xF);
        this.writeNibble(oneByte & 0xF);
    }

    public void writeBinary(int binary) {
        switch (this.extraLength) {
            case 0: {
                super.write(binary << 7);
                this.extraLength = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int delta = 7 - this.extraLength;
                this.buf[this.count - 1] = (byte)(this.buf[this.count - 1] | binary << delta);
                ++this.extraLength;
                break;
            }
            case 7: {
                this.buf[this.count - 1] = (byte)(this.buf[this.count - 1] | binary & 1);
                this.extraLength = 0;
            }
        }
    }

    public void writeNibble(int nibble) {
        switch (this.extraLength) {
            case 0: {
                super.write(nibble << 4);
                this.extraLength = 4;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int delta = 4 - this.extraLength;
                this.buf[this.count] = (byte)(this.buf[this.count - 1] | nibble << delta);
                this.extraLength += 4;
                break;
            }
            case 4: {
                this.buf[this.count - 1] = (byte)(this.buf[this.count - 1] & 0xF0 | nibble & 0xF);
                this.extraLength = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                int delta = 8 - this.extraLength;
                this.buf[this.count - 1] = (byte)(this.buf[this.count - 1] | nibble >> delta);
                delta = this.extraLength - 4;
                super.write(nibble << delta);
                this.extraLength -= 4;
            }
        }
    }
}

