/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.viewsupport.ViewHistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.model.ITestRunSessionListener;
import org.eclipse.soda.devicekit.ui.testmanager.model.ITestSessionListener;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestModel;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestResultEnum;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestRunSession;
import org.eclipse.soda.devicekit.ui.testmanager.util.ExceptionHandler;
import org.eclipse.soda.devicekit.ui.testmanager.util.TestManagerImages;
import org.eclipse.soda.devicekit.ui.testmanager.view.CopyAction;
import org.eclipse.soda.devicekit.ui.testmanager.view.CounterPanel;
import org.eclipse.soda.devicekit.ui.testmanager.view.FailureTrace;
import org.eclipse.soda.devicekit.ui.testmanager.view.ProgressBar;
import org.eclipse.soda.devicekit.ui.testmanager.view.ProgressImages;
import org.eclipse.soda.devicekit.ui.testmanager.view.ScrollLockAction;
import org.eclipse.soda.devicekit.ui.testmanager.view.ShowNextFailureAction;
import org.eclipse.soda.devicekit.ui.testmanager.view.ShowPreviousFailureAction;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;

public class TestRunnerViewPart
extends ViewPart {
    public static final String NAME = "org.eclipse.soda.devicekit.ui.testmanager.view.TestRunnerView";
    static final int REFRESH_INTERVAL = 200;
    static final String TAG_PAGE = "page";
    static final String TAG_RATIO = "ratio";
    static final String TAG_TRACEFILTER = "tracefilter";
    static final String TAG_ORIENTATION = "orientation";
    static final String TAG_SCROLL = "scroll";
    static final String TAG_FAILURES_ONLY = "failuresOnly";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    public static final Object FAMILY_JUNIT_RUN = new Object();
    protected boolean fAutoScroll = true;
    int fOrientation = 2;
    private int fCurrentOrientation;
    protected ProgressBar fProgressBar;
    protected ProgressImages fProgressImages;
    protected Image fViewImage;
    protected CounterPanel fCounterPanel;
    protected boolean fShowOnErrorOnly = false;
    protected Clipboard fClipboard;
    protected volatile String fInfoMessage;
    FailureTrace fFailureTrace;
    TestViewer fTestViewer;
    private boolean fIsDisposed = false;
    private Action fNextAction;
    private Action fPreviousAction;
    StopAction fStopAction;
    private CopyAction fCopyAction;
    Action fRerunLastTestAction;
    private Action fFailuresOnlyFilterAction;
    private ScrollLockAction fScrollLockAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    ActivateOnErrorAction fActivateOnErrorAction;
    private IMenuListener fViewMenuListener;
    TestRunSession fTestRunSession;
    private TestSessionListener fTestSessionListener;
    RunnerViewHistory fViewHistory;
    private ITestRunSessionListener fTestRunSessionListener;
    final Image fStackViewIcon = TestRunnerViewPart.createImage("eview16/", "stackframe.gif");
    final Image fTestRunOKIcon = TestRunnerViewPart.createImage("eview16/", "vtestsucc.gif");
    final Image fTestRunFailIcon = TestRunnerViewPart.createImage("eview16/", "vtesterr.gif");
    final ImageDescriptor fScriptIconDescriptor = TestManagerImages.createImageDescriptor("obj16/", "tscript.gif");
    final ImageDescriptor fScriptOkIconDescriptor = TestManagerImages.createImageDescriptor("obj16/", "tscriptok.gif");
    final ImageDescriptor fScriptErrorIconDescriptor = TestManagerImages.createImageDescriptor("obj16/", "tscripterror.gif");
    final ImageDescriptor fScriptFailIconDescriptor = TestManagerImages.createImageDescriptor("obj16/", "tscriptfail.gif");
    final ImageDescriptor fScriptRunningIconDescriptor = TestManagerImages.createImageDescriptor("obj16/", "tscriptrun.gif");
    private IMemento fMemento;
    Image fOriginalViewImage;
    private SashForm fSashForm;
    private Composite fCounterComposite;
    Composite fParent;
    private UpdateUIJob fUpdateJob;
    private TestIsRunningJob fTestIsRunningJob;
    ILock fTestIsRunningLock;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.fPartIsVisible = true;
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.fPartIsVisible = false;
            }
        }
    };
    protected boolean fPartIsVisible = false;
    static /* synthetic */ Class class$0;

    public static Image createImage(String prefix, String name) {
        return TestManagerImages.createImageDescriptor(prefix, name).createImage();
    }

    static boolean getShowOnErrorOnly() {
        IPreferenceStore store = TestManagerPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.soda.devicekit.ui.testmanager.show_on_error");
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TestRunnerViewPart.this.computeOrientation();
            }
        });
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    void computeOrientation() {
        if (this.fOrientation != 2) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fNextAction = new ShowNextFailureAction(this);
        this.fNextAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        this.fPreviousAction = new ShowPreviousFailureAction(this);
        this.fPreviousAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAction);
        this.fStopAction = new StopAction();
        this.fStopAction.setEnabled(false);
        this.fRerunLastTestAction = new RerunLastAction();
        this.fFailuresOnlyFilterAction = new FailuresOnlyFilterAction();
        this.fScrollLockAction = new ScrollLockAction(this);
        this.fScrollLockAction.setChecked(!this.fAutoScroll);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(0), new ToggleOrientationAction(1), new ToggleOrientationAction(2)};
        toolBar.add((IAction)this.fNextAction);
        toolBar.add((IAction)this.fPreviousAction);
        toolBar.add((IAction)this.fFailuresOnlyFilterAction);
        toolBar.add((IAction)this.fScrollLockAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fRerunLastTestAction);
        toolBar.add((IAction)this.fStopAction);
        toolBar.add(this.fViewHistory.createHistoryDropDownAction());
        MenuManager layoutSubMenu = new MenuManager(TestManagerMessages.TestRunnerViewPart_layout_menu);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.fToggleOrientationActions[i]);
            ++i;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.fFailuresOnlyFilterAction);
        this.fActivateOnErrorAction = new ActivateOnErrorAction();
        viewMenu.add((IAction)this.fActivateOnErrorAction);
        this.fViewMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestRunnerViewPart.this.fActivateOnErrorAction.update();
            }
        };
        viewMenu.addMenuListener(this.fViewMenuListener);
        actionBars.updateActionBars();
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        this.fClipboard = new Clipboard(parent.getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.fViewHistory = new RunnerViewHistory();
        this.configureToolBar();
        this.fCounterComposite = this.createProgressCountPanel(parent);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fCopyAction = new CopyAction(this.fFailureTrace, this.fClipboard);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        this.fOriginalViewImage = this.getTitleImage();
        this.fProgressImages = new ProgressImages();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.soda.devicekit.ui.testmanager.results_view_context");
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.setFilterAndLayout(false);
        if (this.fMemento != null) {
            this.restoreLayoutState(this.fMemento);
        }
        this.fMemento = null;
        this.fTestRunSessionListener = new TestRunSessionListener();
        TestManagerPlugin.getModel().addTestRunSessionListener(this.fTestRunSessionListener);
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setCounterColumns(layout);
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new ProgressBar(composite);
        this.fProgressBar.setLayoutData(new GridData(768));
        return composite;
    }

    private SashForm createSashForm(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.fSashForm, 0);
        Composite empty = new Composite((Composite)top, 0);
        empty.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        });
        top.setTopLeft((Control)empty);
        this.fTestViewer = new TestViewer((Composite)top, this.fClipboard, this);
        top.setContent(this.fTestViewer.getTestViewerControl());
        ViewForm bottom = new ViewForm((Composite)this.fSashForm, 0);
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText(TestManagerMessages.TestRunnerViewPart_label_failure);
        label.setImage(this.fStackViewIcon);
        bottom.setTopLeft((Control)label);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fFailureTrace = new FailureTrace((Composite)bottom, this, failureToolBar);
        bottom.setContent((Control)this.fFailureTrace.getComposite());
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        if (this.fTestRunSessionListener != null) {
            TestManagerPlugin.getModel().removeTestRunSessionListener(this.fTestRunSessionListener);
        }
        this.setActiveTestRunSession(null);
        if (this.fProgressImages != null) {
            this.fProgressImages.dispose();
        }
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        this.disposeImages();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        if (this.fViewMenuListener != null) {
            this.getViewSite().getActionBars().getMenuManager().removeMenuListener(this.fViewMenuListener);
        }
    }

    private void disposeImages() {
        this.fTestRunOKIcon.dispose();
        this.fTestRunFailIcon.dispose();
        this.fStackViewIcon.dispose();
    }

    protected void doShowInfoMessage() {
        if (this.fInfoMessage != null) {
            this.setContentDescription(this.fInfoMessage);
            this.fInfoMessage = null;
        }
    }

    String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    public Element[] getAllFailures() {
        return this.fTestRunSession.getAllFailedTestElements();
    }

    public IAction getCopyAction() {
        return this.fCopyAction;
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public String getElementDescription(Element element) {
        return TestModel.getElementDescription(element);
    }

    int getErrorsPlusFailures() {
        if (this.fTestRunSession == null) {
            return 0;
        }
        return this.fTestRunSession.getErrorCount() + this.fTestRunSession.getFailureCount();
    }

    public FailureTrace getFailureTrace() {
        return this.fFailureTrace;
    }

    public IJavaProject getLaunchedProject() {
        return this.fTestRunSession == null ? null : this.fTestRunSession.getLaunchedProject();
    }

    private IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    public Image getTitleImage() {
        if (this.fOriginalViewImage == null) {
            this.fOriginalViewImage = super.getTitleImage();
        }
        if (this.fViewImage == null) {
            return super.getTitleImage();
        }
        return this.fViewImage;
    }

    void handleStopped() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.resetViewIcon();
                TestRunnerViewPart.this.fStopAction.setEnabled(false);
            }
        });
        this.stopUpdateJobs();
    }

    public void handleTestSelected(Element test) {
        this.showFailure(test);
        this.fCopyAction.handleTestSelected(this.getElementDescription(test));
    }

    boolean hasErrorsOrFailures() {
        return this.getErrorsPlusFailures() > 0;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(FAMILY_JUNIT_RUN);
        }
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public boolean isCreated() {
        return this.fCounterPanel != null;
    }

    boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    protected void postShowTestResultsView() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.showTestResultsView();
            }
        });
    }

    private void postSyncProcessChanges() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                TestRunnerViewPart.this.processChangesInUI();
            }
        });
    }

    void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    void processChangesInUI() {
        if (this.fSashForm.isDisposed()) {
            return;
        }
        this.doShowInfoMessage();
        this.refreshCounters();
        if (!this.fPartIsVisible) {
            this.updateViewTitleProgress();
        } else {
            this.updateViewIcon();
        }
        boolean hasErrorsOrFailures = this.hasErrorsOrFailures();
        this.fNextAction.setEnabled(hasErrorsOrFailures);
        this.fPreviousAction.setEnabled(hasErrorsOrFailures);
        this.fTestViewer.processChangesInUI();
    }

    private void refreshCounters() {
        boolean stopped;
        boolean hasErrorsOrFailures;
        int failureCount;
        int errorCount;
        int totalCount;
        int startedCount;
        if (this.fTestRunSession != null) {
            startedCount = this.fTestRunSession.getStartedCount();
            totalCount = this.fTestRunSession.getTotalCount();
            errorCount = this.fTestRunSession.getErrorCount();
            hasErrorsOrFailures = errorCount + (failureCount = this.fTestRunSession.getFailureCount()) > 0;
            stopped = this.fTestRunSession.isStopped();
        } else {
            startedCount = 0;
            totalCount = 0;
            errorCount = 0;
            failureCount = 0;
            hasErrorsOrFailures = false;
            stopped = false;
        }
        this.fCounterPanel.setTotal(totalCount);
        this.fCounterPanel.setRunValue(startedCount);
        this.fCounterPanel.setErrorValue(errorCount);
        this.fCounterPanel.setFailureValue(failureCount);
        this.fProgressBar.reset(hasErrorsOrFailures, stopped, startedCount, totalCount);
    }

    protected void registerInfoMessage(String message) {
        this.fInfoMessage = message;
    }

    public void rerunTestRun() {
        if (this.fTestRunSession == null) {
            return;
        }
        this.fRerunLastTestAction.setEnabled(false);
        this.fTestRunSession.runTest();
    }

    void resetViewIcon() {
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    private void restoreLayoutState(IMemento memento) {
        Integer orientation;
        Integer ratio = memento.getInteger(TAG_RATIO);
        if (ratio != null) {
            this.fSashForm.setWeights(new int[]{ratio, 1000 - ratio});
        }
        if ((orientation = memento.getInteger(TAG_ORIENTATION)) != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
        String scrollLock = memento.getString(TAG_SCROLL);
        if (scrollLock != null) {
            this.fScrollLockAction.setChecked(scrollLock.equals("true"));
            this.setAutoScroll(!this.fScrollLockAction.isChecked());
        }
        String failuresOnly = memento.getString(TAG_FAILURES_ONLY);
        boolean showFailuresOnly = false;
        if (failuresOnly != null) {
            showFailuresOnly = failuresOnly.equals("true");
        }
        this.setFilterAndLayout(showFailuresOnly);
    }

    public void saveState(IMemento memento) {
        if (this.fSashForm == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        memento.putString(TAG_SCROLL, this.fScrollLockAction.isChecked() ? "true" : "false");
        int[] weigths = this.fSashForm.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(TAG_RATIO, ratio);
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
        memento.putString(TAG_FAILURES_ONLY, this.fFailuresOnlyFilterAction.isChecked() ? "true" : "false");
    }

    protected void selectFirstFailure() {
        this.fTestViewer.selectFirstFailure();
    }

    public void selectNextFailure() {
        this.fTestViewer.selectFailure(true);
    }

    public void selectPreviousFailure() {
        this.fTestViewer.selectFailure(false);
    }

    TestRunSession setActiveTestRunSession(TestRunSession testRunSession) {
        if (this.fTestRunSession == testRunSession) {
            return null;
        }
        if (this.fTestRunSession != null && this.fTestSessionListener != null) {
            this.fTestRunSession.removeTestSessionListener(this.fTestSessionListener);
            this.fTestSessionListener = null;
        }
        TestRunSession deactivatedSession = this.fTestRunSession;
        this.fTestRunSession = testRunSession;
        this.fTestViewer.registerActiveSession(testRunSession);
        if (this.fSashForm.isDisposed()) {
            this.stopUpdateJobs();
            return deactivatedSession;
        }
        if (testRunSession == null) {
            this.setTitleToolTip(null);
            this.resetViewIcon();
            this.clearStatus();
            this.fFailureTrace.clear();
            this.registerInfoMessage(" ");
            this.stopUpdateJobs();
            this.fStopAction.setEnabled(false);
            this.fRerunLastTestAction.setEnabled(false);
        } else {
            this.fTestSessionListener = new TestSessionListener();
            this.fTestRunSession.addTestSessionListener(this.fTestSessionListener);
            this.setTitleToolTip();
            this.clearStatus();
            this.fFailureTrace.clear();
            this.registerInfoMessage(this.fTestRunSession.getTestRunName());
            if (this.fTestRunSession.isRunning()) {
                this.fRerunLastTestAction.setEnabled(false);
                this.startUpdateJobs();
                this.fStopAction.setEnabled(true);
            } else {
                this.stopUpdateJobs();
                this.fStopAction.setEnabled(false);
                this.fRerunLastTestAction.setEnabled(true);
                this.fTestViewer.expandFirstLevel();
            }
        }
        return deactivatedSession;
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == 1 ? 2 : 1;
    }

    private void setFilterAndLayout(boolean failuresOnly) {
        this.fFailuresOnlyFilterAction.setChecked(failuresOnly);
        this.fTestViewer.setShowFailuresOnly(failuresOnly);
    }

    public void setFocus() {
        if (this.fTestViewer != null) {
            this.fTestViewer.getTestViewerControl().setFocus();
        }
    }

    private void setOrientation(int orientation) {
        if (this.fSashForm == null || this.fSashForm.isDisposed()) {
            return;
        }
        boolean horizontal = orientation == 1;
        this.fSashForm.setOrientation(horizontal ? 256 : 512);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.fCounterComposite.getLayout();
        this.setCounterColumns(layout);
        this.fParent.layout();
    }

    void setShowFailuresOnly(boolean failuresOnly) {
        this.setFilterAndLayout(failuresOnly);
    }

    private void setTitleToolTip() {
        this.setTitleToolTip(this.fTestRunSession.getTestRunName());
    }

    private void showFailure(final Element test) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestRunnerViewPart.this.isDisposed()) {
                    TestRunnerViewPart.this.fFailureTrace.showFailure(test);
                }
            }
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        TestRunnerViewPart testRunner = null;
        if (page != null) {
            try {
                testRunner = (TestRunnerViewPart)page.findView(NAME);
                if (testRunner == null) {
                    IWorkbenchPart activePart = page.getActivePart();
                    testRunner = (TestRunnerViewPart)page.showView(NAME);
                    page.activate(activePart);
                } else {
                    page.bringToTop((IWorkbenchPart)testRunner);
                }
            }
            catch (PartInitException pie) {
                ExceptionHandler.handle((CoreException)((Object)pie), window.getShell(), TestManagerMessages.TestModel_OpenView_error_title, pie.getStatus().getMessage());
            }
        }
    }

    void startUpdateJobs() {
        this.postSyncProcessChanges();
        if (this.fUpdateJob != null) {
            return;
        }
        this.fTestIsRunningJob = new TestIsRunningJob(TestManagerMessages.TestRunnerViewPart_wrapperJobName);
        this.fTestIsRunningLock = Job.getJobManager().newLock();
        this.fTestIsRunningLock.acquire();
        this.getProgressService().schedule((Job)this.fTestIsRunningJob);
        this.fUpdateJob = new UpdateUIJob(TestManagerMessages.TestRunnerViewPart_jobName);
        this.fUpdateJob.schedule(200L);
    }

    public void stopTest() {
        if (this.fTestRunSession != null) {
            if (this.fTestRunSession.isRunning()) {
                this.setContentDescription(TestManagerMessages.TestRunnerViewPart_message_stopping);
            }
            this.fTestRunSession.stopTestRun();
        }
    }

    void stopUpdateJobs() {
        if (this.fUpdateJob != null) {
            this.fUpdateJob.stop();
            this.fUpdateJob = null;
        }
        if (this.fTestIsRunningJob != null && this.fTestIsRunningLock != null) {
            this.fTestIsRunningLock.release();
            this.fTestIsRunningJob = null;
        }
        this.postSyncProcessChanges();
    }

    private void updateViewIcon() {
        this.fViewImage = this.fTestRunSession == null || this.fTestRunSession.isStopped() || this.fTestRunSession.isRunning() || this.fTestRunSession.getStartedCount() == 0 ? this.fOriginalViewImage : (this.hasErrorsOrFailures() ? this.fTestRunFailIcon : this.fTestRunOKIcon);
        this.firePropertyChange(1);
    }

    private void updateViewTitleProgress() {
        if (this.fTestRunSession != null) {
            if (this.fTestRunSession.isRunning()) {
                Image progress = this.fProgressImages.getImage(this.fTestRunSession.getStartedCount(), this.fTestRunSession.getTotalCount(), this.fTestRunSession.getErrorCount(), this.fTestRunSession.getFailureCount());
                if (progress != this.fViewImage) {
                    this.fViewImage = progress;
                    this.firePropertyChange(1);
                }
            } else {
                this.updateViewIcon();
            }
        } else {
            this.resetViewIcon();
        }
    }

    public void warnOfContentChange() {
        IWorkbenchSiteProgressService service = this.getProgressService();
        if (service != null) {
            service.warnOfContentChange();
        }
    }

    private class ActivateOnErrorAction
    extends Action {
        public ActivateOnErrorAction() {
            super(TestManagerMessages.TestRunnerViewPart_activate_on_failure_only, 2);
            this.update();
        }

        public void run() {
            boolean checked;
            TestRunnerViewPart.this.fShowOnErrorOnly = checked = this.isChecked();
            IPreferenceStore store = TestManagerPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.soda.devicekit.ui.testmanager.show_on_error", checked);
        }

        public void update() {
            this.setChecked(TestRunnerViewPart.getShowOnErrorOnly());
        }
    }

    private class ClearAction
    extends Action {
        public ClearAction() {
            this.setText(TestManagerMessages.TestRunnerViewPart_clear_history_label);
            boolean enabled = false;
            List testRunSessions = TestManagerPlugin.getModel().getTestRunSessions();
            Iterator iter = testRunSessions.iterator();
            while (iter.hasNext()) {
                TestRunSession testRunSession = (TestRunSession)iter.next();
                if (testRunSession.isRunning() || testRunSession.isStarting()) continue;
                enabled = true;
                break;
            }
            this.setEnabled(enabled);
        }

        private List getRunningSessions() {
            List testRunSessions = TestManagerPlugin.getModel().getTestRunSessions();
            Iterator iter = testRunSessions.iterator();
            while (iter.hasNext()) {
                TestRunSession testRunSession = (TestRunSession)iter.next();
                if (testRunSession.isRunning() || testRunSession.isStarting()) continue;
                iter.remove();
            }
            return testRunSessions;
        }

        public void run() {
            List testRunSessions = this.getRunningSessions();
            Object first = testRunSessions.isEmpty() ? null : testRunSessions.get(0);
            TestRunnerViewPart.this.fViewHistory.setHistoryEntries(testRunSessions, first);
        }
    }

    private static class ExportTestRunSessionAction
    extends Action {
        private final TestRunSession fTestRunSession;
        private final Shell fShell;

        public ExportTestRunSessionAction(Shell shell, TestRunSession testRunSession) {
            super(TestManagerMessages.TestRunnerViewPart_ExportTestRunSessionAction_name);
            this.fShell = shell;
            this.fTestRunSession = testRunSession;
        }

        private String getFileName() {
            String testRunName = this.fTestRunSession.getTestRunName();
            long startTime = this.fTestRunSession.getStartTime();
            if (startTime == 0L) {
                return testRunName;
            }
            String isoTime = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(startTime));
            return String.valueOf(testRunName) + ' ' + isoTime + ".xml";
        }

        public void run() {
            FileDialog exportDialog = new FileDialog(this.fShell, 8192);
            exportDialog.setText(TestManagerMessages.TestRunnerViewPart_ExportTestRunSessionAction_title);
            exportDialog.setFileName(this.getFileName());
            exportDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
            String path = exportDialog.open();
            if (path == null) {
                return;
            }
            File file = new File(path);
            try {
                TestModel.exportTestRunSession(this.fTestRunSession, file);
            }
            catch (Exception e) {
                TestManagerPlugin.log(e);
                Status status = new Status(4, "org.eclipse.soda.devicekit.ui.testmanager", 4, "", (Throwable)e);
                ErrorDialog.openError((Shell)this.fShell, (String)TestManagerMessages.TestRunnerViewPart_ExportTestRunSessionAction_error_title, (String)status.getMessage(), (IStatus)status);
            }
        }
    }

    private class FailuresOnlyFilterAction
    extends Action {
        public FailuresOnlyFilterAction() {
            super(TestManagerMessages.TestRunnerViewPart_show_failures_only, 2);
            this.setToolTipText(TestManagerMessages.TestRunnerViewPart_show_failures_only);
            this.setImageDescriptor(TestManagerImages.createImageDescriptor("obj16/", "failures.gif"));
        }

        public void run() {
            TestRunnerViewPart.this.setShowFailuresOnly(this.isChecked());
        }
    }

    private static class ImportTestRunSessionAction
    extends Action {
        private final Shell fShell;

        public ImportTestRunSessionAction(Shell shell) {
            super(TestManagerMessages.TestRunnerViewPart_ImportTestRunSessionAction_name);
            this.fShell = shell;
        }

        public void run() {
            FileDialog importDialog = new FileDialog(this.fShell, 4096);
            importDialog.setText(TestManagerMessages.TestRunnerViewPart_ImportTestRunSessionAction_title);
            importDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
            String path = importDialog.open();
            if (path == null) {
                return;
            }
            File file = new File(path);
            try {
                TestModel.importTestRunSession(file);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.fShell, TestManagerMessages.TestRunnerViewPart_ImportTestRunSessionAction_error_title, e.getStatus().getMessage());
            }
        }
    }

    private class RerunLastAction
    extends Action {
        public RerunLastAction() {
            this.setText(TestManagerMessages.TestRunnerViewPart_rerunaction_label);
            this.setToolTipText(TestManagerMessages.TestRunnerViewPart_rerunaction_tooltip);
            TestManagerImages.setLocalImageDescriptors((IAction)this, "relaunch.gif");
            this.setEnabled(false);
        }

        public void run() {
            TestRunnerViewPart.this.rerunTestRun();
        }
    }

    private class RunnerViewHistory
    extends ViewHistory {
        public void addMenuEntries(MenuManager manager) {
            manager.add((IContributionItem)new Separator("additions"));
            if (TestRunnerViewPart.this.fTestRunSession != null) {
                manager.appendToGroup("additions", (IAction)new SaveTestRunSessionAction(TestRunnerViewPart.this.fParent.getShell(), TestRunnerViewPart.this.fTestRunSession));
            }
            manager.add((IContributionItem)new Separator("save.group"));
            manager.appendToGroup("save.group", (IAction)new ImportTestRunSessionAction(TestRunnerViewPart.this.fParent.getShell()));
            if (TestRunnerViewPart.this.fTestRunSession != null) {
                manager.appendToGroup("save.group", (IAction)new ExportTestRunSessionAction(TestRunnerViewPart.this.fParent.getShell(), TestRunnerViewPart.this.fTestRunSession));
            }
        }

        public void configureHistoryDropDownAction(IAction action) {
            action.setToolTipText(TestManagerMessages.TestRunnerViewPart_test_run_history);
            TestManagerImages.setLocalImageDescriptors(action, "history_list.gif");
        }

        public void configureHistoryListAction(IAction action) {
            action.setText(TestManagerMessages.TestRunnerViewPart_history);
        }

        public Action getClearAction() {
            return new ClearAction();
        }

        public Object getCurrentEntry() {
            return TestRunnerViewPart.this.fTestRunSession;
        }

        public List getHistoryEntries() {
            return TestManagerPlugin.getModel().getTestRunSessions();
        }

        public String getHistoryListDialogMessage() {
            return TestManagerMessages.TestRunnerViewPart_select_test_run;
        }

        public String getHistoryListDialogTitle() {
            return TestManagerMessages.TestRunnerViewPart_test_runs;
        }

        public ImageDescriptor getImageDescriptor(Object element) {
            TestRunSession session = (TestRunSession)element;
            if (session.isStopped()) {
                return TestRunnerViewPart.this.fScriptIconDescriptor;
            }
            if (session.isRunning()) {
                return TestRunnerViewPart.this.fScriptRunningIconDescriptor;
            }
            TestResultEnum result = session.getTestResult();
            if (result == TestResultEnum.OK) {
                return TestRunnerViewPart.this.fScriptOkIconDescriptor;
            }
            if (result == TestResultEnum.ERROR) {
                return TestRunnerViewPart.this.fScriptErrorIconDescriptor;
            }
            if (result == TestResultEnum.FAILURE) {
                return TestRunnerViewPart.this.fScriptFailIconDescriptor;
            }
            return TestRunnerViewPart.this.fScriptIconDescriptor;
        }

        public int getMaxEntries() {
            IPreferenceStore store = TestManagerPlugin.getDefault().getPreferenceStore();
            return store.getInt("org.eclipse.soda.devicekit.ui.testmanager.max_test_runs");
        }

        public String getMaxEntriesMessage() {
            return TestManagerMessages.TestRunnerViewPart_max_remembered;
        }

        public Shell getShell() {
            return TestRunnerViewPart.this.fParent.getShell();
        }

        public String getText(Object element) {
            TestRunSession session = (TestRunSession)element;
            if (session.getStartTime() == 0L) {
                return session.getTestRunName();
            }
            String startTime = DateFormat.getDateTimeInstance().format(new Date(session.getStartTime()));
            return TestManagerMessages.format(TestManagerMessages.TestRunnerViewPart_testName_startTime, new Object[]{session.getTestRunName(), startTime});
        }

        public void setActiveEntry(Object entry) {
            TestRunnerViewPart.this.setActiveTestRunSession((TestRunSession)entry);
        }

        public void setHistoryEntries(List remainingEntries, Object activeEntry) {
            TestRunnerViewPart.this.setActiveTestRunSession((TestRunSession)activeEntry);
            List testRunSessions = TestManagerPlugin.getModel().getTestRunSessions();
            testRunSessions.removeAll(remainingEntries);
            Iterator iter = testRunSessions.iterator();
            while (iter.hasNext()) {
                TestManagerPlugin.getModel().removeTestRunSession((TestRunSession)iter.next());
            }
        }

        public void setMaxEntries(int maxEntries) {
            IPreferenceStore store = TestManagerPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.soda.devicekit.ui.testmanager.max_test_runs", maxEntries);
        }
    }

    private static class SaveTestRunSessionAction
    extends Action {
        private final TestRunSession fTestRunSession;
        private final Shell fShell;

        public SaveTestRunSessionAction(Shell shell, TestRunSession testRunSession) {
            super(TestManagerMessages.TestRunnerViewPart_SaveTestRunSessionAction_name);
            this.fShell = shell;
            this.fTestRunSession = testRunSession;
        }

        private String getFileName() {
            String testRunName = this.fTestRunSession.getTestRunName();
            long startTime = this.fTestRunSession.getStartTime();
            if (startTime == 0L) {
                return testRunName;
            }
            String isoTime = this.fTestRunSession.getIsoStartTime();
            return String.valueOf(testRunName) + ' ' + isoTime + ".xml";
        }

        public void run() {
            SaveAsDialog dialog = new SaveAsDialog(this.fShell);
            dialog.setTitle(TestManagerMessages.TestRunnerViewPart_SaveTestRunSessionAction_title);
            dialog.setTitleImage(TestManagerPlugin.getImageDescriptorRegistry().get(TestManagerImages.fgValidationTestViewImageDescriptor));
            dialog.setOriginalName(this.getFileName());
            dialog.create();
            if (dialog.open() == 1) {
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(filePath);
            try {
                TestModel.exportTestRunSession(this.fTestRunSession, file);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.fShell, TestManagerMessages.TestRunnerViewPart_ExportTestRunSessionAction_error_title, e.getStatus().getMessage());
            }
        }
    }

    private class StopAction
    extends Action {
        public StopAction() {
            this.setText(TestManagerMessages.TestRunnerViewPart_stopaction_text);
            this.setToolTipText(TestManagerMessages.TestRunnerViewPart_stopaction_tooltip);
            TestManagerImages.setLocalImageDescriptors((IAction)this, "stop.gif");
        }

        public void run() {
            TestRunnerViewPart.this.stopTest();
            this.setEnabled(false);
        }
    }

    private class TestIsRunningJob
    extends Job {
        public TestIsRunningJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_JUNIT_RUN;
        }

        public IStatus run(IProgressMonitor monitor) {
            TestRunnerViewPart.this.fTestIsRunningLock.acquire();
            return Status.OK_STATUS;
        }
    }

    private class TestRunSessionListener
    implements ITestRunSessionListener {
        public void sessionAdded(TestRunSession testRunSession) {
            if (TestRunnerViewPart.this.getSite().getWorkbenchWindow() == TestManagerPlugin.getActiveWorkbenchWindow()) {
                TestRunnerViewPart.this.setActiveTestRunSession(testRunSession);
                String testRunName = TestRunnerViewPart.this.fTestRunSession.getTestRunName();
                TestRunnerViewPart.this.setContentDescription(testRunName);
            }
        }

        public void sessionRemoved(TestRunSession testRunSession) {
            if (testRunSession.equals(TestRunnerViewPart.this.fTestRunSession)) {
                List testRunSessions = TestManagerPlugin.getModel().getTestRunSessions();
                if (!testRunSessions.isEmpty()) {
                    TestRunnerViewPart.this.setActiveTestRunSession((TestRunSession)testRunSessions.get(0));
                } else {
                    TestRunnerViewPart.this.setActiveTestRunSession(null);
                }
            }
        }
    }

    private class TestSessionListener
    implements ITestSessionListener {
        public void activityEnded(Element testCaseElement) {
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testCaseElement);
        }

        public void activityFailed(Element testElement) {
            if (TestRunnerViewPart.this.isAutoScroll()) {
                TestRunnerViewPart.this.fTestViewer.registerFailedForAutoScroll(testElement);
            }
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testElement);
            if (TestRunnerViewPart.this.fShowOnErrorOnly && TestRunnerViewPart.this.getErrorsPlusFailures() == 1) {
                TestRunnerViewPart.this.postShowTestResultsView();
            }
        }

        public void activityStarted(Element activityElement) {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(activityElement);
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(activityElement);
        }

        public void sessionEnded(long elapsedTime) {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(null);
            Object[] keys = new String[]{TestRunnerViewPart.this.fTestRunSession.getTestRunName(), TestRunnerViewPart.this.elapsedTimeAsString(elapsedTime)};
            String msg = TestManagerMessages.format(TestManagerMessages.TestRunnerViewPart_message_finish, keys);
            TestRunnerViewPart.this.registerInfoMessage(msg);
            TestRunnerViewPart.this.postSyncRunnable(new Runnable(this){
                final /* synthetic */ TestSessionListener this$1;
                {
                    this.this$1 = testSessionListener;
                }

                public void run() {
                    if (TestSessionListener.access$0(this.this$1).isDisposed()) {
                        return;
                    }
                    TestSessionListener.access$0((TestSessionListener)this.this$1).fStopAction.setEnabled(false);
                    TestSessionListener.access$0((TestSessionListener)this.this$1).fRerunLastTestAction.setEnabled(true);
                    TestSessionListener.access$0(this.this$1).processChangesInUI();
                    if (TestSessionListener.access$0(this.this$1).hasErrorsOrFailures()) {
                        TestSessionListener.access$0(this.this$1).selectFirstFailure();
                    }
                    TestSessionListener.access$0(this.this$1).warnOfContentChange();
                }
            });
            TestRunnerViewPart.this.stopUpdateJobs();
        }

        public void sessionStarted() {
            TestRunnerViewPart.this.fTestViewer.registerViewersRefresh();
            TestRunnerViewPart.this.fShowOnErrorOnly = TestRunnerViewPart.getShowOnErrorOnly();
            TestRunnerViewPart.this.startUpdateJobs();
            TestRunnerViewPart.this.fStopAction.setEnabled(true);
            if (!TestRunnerViewPart.this.fShowOnErrorOnly) {
                TestRunnerViewPart.this.postShowTestResultsView();
            }
        }

        public void sessionStopped(long elapsedTime) {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(null);
            TestRunnerViewPart.this.registerInfoMessage(TestManagerMessages.TestRunnerViewPart_message_stopped);
            TestRunnerViewPart.this.handleStopped();
        }

        public void sessionTerminated() {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(null);
            TestRunnerViewPart.this.registerInfoMessage(TestManagerMessages.TestRunnerViewPart_message_terminated);
            TestRunnerViewPart.this.handleStopped();
        }

        static /* synthetic */ TestRunnerViewPart access$0(TestSessionListener testSessionListener) {
            return testSessionListener.TestRunnerViewPart.this;
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int fActionOrientation;

        public ToggleOrientationAction(int orientation) {
            super("", 8);
            if (orientation == 1) {
                this.setText(TestManagerMessages.TestRunnerViewPart_toggle_horizontal_label);
                this.setImageDescriptor(TestManagerImages.createImageDescriptor("elcl16/", "th_horizontal.gif"));
            } else if (orientation == 0) {
                this.setText(TestManagerMessages.TestRunnerViewPart_toggle_vertical_label);
                this.setImageDescriptor(TestManagerImages.createImageDescriptor("elcl16/", "th_vertical.gif"));
            } else if (orientation == 2) {
                this.setText(TestManagerMessages.TestRunnerViewPart_toggle_automatic_label);
                this.setImageDescriptor(TestManagerImages.createImageDescriptor("elcl16/", "th_automatic.gif"));
            }
            this.fActionOrientation = orientation;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.soda.devicekit.ui.testmanager.results_view_toggle_call_mode_action_context");
        }

        public int getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestRunnerViewPart.this.fOrientation = this.fActionOrientation;
                TestRunnerViewPart.this.computeOrientation();
            }
        }
    }

    private class UpdateUIJob
    extends UIJob {
        private boolean fRunning = true;

        public UpdateUIJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TestRunnerViewPart.this.isDisposed()) {
                TestRunnerViewPart.this.processChangesInUI();
            }
            this.schedule(200L);
            return Status.OK_STATUS;
        }

        public boolean shouldSchedule() {
            return this.fRunning;
        }

        public void stop() {
            this.fRunning = false;
        }
    }
}

