/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.soda.devicekit.generator.util.JREPreferenceUtil;
import org.eclipse.soda.devicekit.preference.jre.DeviceKitJREConstants;
import org.eclipse.soda.devicekit.ui.preference.PreferenceMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class JREinClasspathControl {
    private Button workspaceDefaultJREButton;
    private Button executionEnvironmentsButton;
    private Combo jreInClasspathCombo;
    private Button environmentsButton;
    private DialogPage parentPage;
    private String initSelection;
    private String resultSelection;

    public JREinClasspathControl(DialogPage parentPage, String initSelection) {
        this.parentPage = parentPage;
        this.initSelection = initSelection;
        this.resultSelection = initSelection;
    }

    private void addListeners() {
        this.getEnvironmentsButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)JREinClasspathControl.this.getParentDialogPage().getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", null, null).open();
            }
        });
        this.getWorkspaceDefaultJREButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREinClasspathControl.this.setResult(DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE);
                JREinClasspathControl.this.enableEEControls(false);
            }
        });
        this.getJreInClasspathCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREinClasspathControl.this.setResult(JREinClasspathControl.this.getJreInClasspathCombo().getText());
            }
        });
        this.getExecutionEnvironmentsButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREinClasspathControl.this.enableEEControls(true);
            }
        });
    }

    private void createContent(Composite parent) {
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 3;
        Group group = new Group(parent, 32);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setText(PreferenceMessages.getString("cpLabel"));
        this.workspaceDefaultJREButton = new Button((Composite)group, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.workspaceDefaultJREButton.setText("Workspace de&fault JRE");
        this.workspaceDefaultJREButton.setLayoutData((Object)gridData);
        this.executionEnvironmentsButton = new Button((Composite)group, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.executionEnvironmentsButton.setText("Ex&ecution Environments:");
        this.executionEnvironmentsButton.setLayoutData((Object)gridData);
        GridData contentGridData = new GridData(770);
        contentGridData.horizontalSpan = 1;
        this.jreInClasspathCombo = new Combo((Composite)group, 12);
        this.jreInClasspathCombo.setFont(parent.getFont());
        this.jreInClasspathCombo.setLayoutData((Object)contentGridData);
        this.jreInClasspathCombo.setItems(JREPreferenceUtil.getAllExecutionEnvironments());
        this.jreInClasspathCombo.setVisibleItemCount(Math.min(JREPreferenceUtil.getAllExecutionEnvironments().length, 20));
        this.jreInClasspathCombo.select(this.jreInClasspathCombo.indexOf(this.initSelection));
        GridData buttonGridData = new GridData();
        buttonGridData.verticalAlignment = 128;
        buttonGridData.horizontalSpan = 1;
        this.environmentsButton = new Button((Composite)group, 8);
        this.environmentsButton.setText("Envir&onments...");
        this.environmentsButton.setLayoutData((Object)buttonGridData);
    }

    public Combo createControl(Composite parent) {
        this.createContent(parent);
        this.initControls();
        this.addListeners();
        return this.jreInClasspathCombo;
    }

    public void enableEEControls(boolean enabled) {
        this.jreInClasspathCombo.setEnabled(enabled);
        this.environmentsButton.setEnabled(enabled);
        if (enabled) {
            if (this.jreInClasspathCombo.getText().equals("")) {
                this.jreInClasspathCombo.select(0);
            }
            this.setResult(this.jreInClasspathCombo.getText());
        }
        this.executionEnvironmentsButton.setSelection(enabled);
    }

    public Button getEnvironmentsButton() {
        return this.environmentsButton;
    }

    public Button getExecutionEnvironmentsButton() {
        return this.executionEnvironmentsButton;
    }

    public Combo getJreInClasspathCombo() {
        return this.jreInClasspathCombo;
    }

    public DialogPage getParentDialogPage() {
        return this.parentPage;
    }

    public String getResult() {
        return this.resultSelection;
    }

    public Button getWorkspaceDefaultJREButton() {
        return this.workspaceDefaultJREButton;
    }

    private void initControls() {
        if (DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE.equals(this.initSelection)) {
            this.enableEEControls(false);
            this.jreInClasspathCombo.setText("");
            this.workspaceDefaultJREButton.setSelection(true);
        } else {
            this.enableEEControls(true);
            this.workspaceDefaultJREButton.setSelection(false);
        }
    }

    public void setInput(String value) {
        if (DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE.equals(value)) {
            this.setResult(DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE);
            this.enableEEControls(false);
        } else {
            this.getJreInClasspathCombo().setText(value);
            this.setResult(value);
            this.enableEEControls(true);
        }
    }

    public void setResult(String resultSelection) {
        this.resultSelection = resultSelection;
    }
}

