/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testagent.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;

public class ProfileTestAgentMessages
implements IWizardMessages {
    private static final String BUNDLE_NAME = "org.eclipse.soda.devicekit.ui.testagent.wizard.profileTestAgentMessages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.eclipse.soda.devicekit.ui.testagent.wizard.profileTestAgentMessages");
    private static final String PROFILE_XML = "dk/profile.xml";
    public static String KEY_REF = "ref";
    public static String KEY_ALLPROFILES = "all.profiles";
    private static ProfileTestAgentMessages instance = null;
    private Map targetProfiles = new HashMap();
    private List profilesList = new ArrayList();

    public ProfileTestAgentMessages() {
        this.targetProfiles.put(KEY_ALLPROFILES, this.profilesList);
        try {
            this.initProfileInWorkspace();
        }
        catch (Exception e) {
            System.out.println("Fail to initialize the ProfileTestAgentMessages: " + e);
        }
    }

    public static IWizardMessages getInstance() {
        if (instance == null) {
            instance = new ProfileTestAgentMessages();
        }
        return instance;
    }

    public String getString(String key) {
        String value = (String)this.targetProfiles.get(key);
        if (value == null) {
            try {
                return RESOURCE_BUNDLE.getString(key);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return value;
    }

    public String[] getStringAsArray(String key) {
        if (key.equals(KEY_ALLPROFILES)) {
            return this.getTargetProfiles();
        }
        return new String[0];
    }

    private String[] getTargetProfiles() {
        String[] allProfiles = new String[this.profilesList.size()];
        int i = 0;
        while (i < this.profilesList.size()) {
            allProfiles[i] = (String)this.profilesList.get(i);
            ++i;
        }
        return allProfiles;
    }

    private void initProfileInWorkspace() throws Exception {
        String workspaceLoc = Platform.getLocation().toString();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IFile profileXml = projects[i].getFile(PROFILE_XML);
            if (profileXml.exists()) {
                String projectName = projects[i].getName();
                String profileXmlPath = String.valueOf(projectName) + '/' + PROFILE_XML;
                List references = new DkmlReferenceResolver(profileXml).getReferences();
                DeviceKitTagModel profileModel = new DeviceKitTagModel(new File(String.valueOf(workspaceLoc) + '/' + profileXmlPath), references);
                profileModel.build();
                String profileId = profileModel.getMainElement().getId();
                this.profilesList.add(profileId);
                this.targetProfiles.put(profileId, profileId);
                this.targetProfiles.put(String.valueOf(profileId) + ".hint", "Create " + profileId + " test agent.");
                this.targetProfiles.put(String.valueOf(profileId) + '.' + KEY_REF, profileXmlPath);
            }
            ++i;
        }
    }
}

