/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.wizard;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.model.java.JavaKeywords;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.ui.wizard.WizardMessages;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.soda.devicekit.util.VersionValidator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class DeviceKitBasePage
extends DeviceKitPage {
    private static IWizardMessages messages = WizardMessages.getInstance();
    protected String[] validNameChoices = null;
    protected String[] supportChoices = null;

    protected DeviceKitBasePage(String pageName) {
        super(pageName);
    }

    protected DeviceKitBasePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createAnyImplementation(Composite composite) {
    }

    protected void createCommonControl(Composite composite) {
        String[] keys = this.getCommonTextKeys();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (i == 0) {
                Text text;
                String[] nameChoices = this.getValidNameChoices();
                if (nameChoices.length == 0) {
                    text = this.createTextControl(composite, key);
                    text.setFocus();
                } else {
                    text = this.createComboControl(composite, key, nameChoices, 2048);
                    text.setFocus();
                }
                this.createAnyImplementation(composite);
            } else {
                String[] choices = this.getChoices(key);
                if (choices.length == 0) {
                    this.createTextControl(composite, key);
                } else {
                    this.createComboControl(composite, key, choices, 2048);
                }
            }
            ++i;
        }
    }

    protected void createCommonOptions(Composite composite) {
        String labelString = this.getString("options");
        this.createCheckBoxControl(composite, "incubation", labelString);
        this.createCheckBoxControl(composite, "multiplex");
        this.createCheckBoxControl(composite, "generateold");
        final Button button = this.createCheckBoxControl(composite, "abstract");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean state = button.getSelection();
                ((Button)DeviceKitBasePage.this.getWidget("create.bundle")).setSelection(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.managed.bundle")).setSelection(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.managed.factory.bundle")).setSelection(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.bundle")).setEnabled(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.managed.bundle")).setEnabled(!state);
                ((Button)DeviceKitBasePage.this.getWidget("create.managed.factory.bundle")).setEnabled(!state);
            }
        });
        String testlabelString = this.getString("testoptions");
        if (this.isDisplayTest()) {
            this.createCheckBoxControl(composite, "create.test", testlabelString);
            this.createCheckBoxControl(composite, "create.testcase");
        } else {
            this.createCheckBoxControl(composite, "create.testcase", testlabelString);
        }
        String bundlelabelString = this.getString("bundleoptions");
        this.createCheckBoxControl(composite, "create.bundle", bundlelabelString);
        this.createCheckBoxControl(composite, "create.managed.bundle");
        this.createCheckBoxControl(composite, "create.managed.factory.bundle");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setMessage(this.getDefaultMessage());
        Composite composite = new Composite(parent, 0);
        Dialog.applyDialogFont((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createCommonControl(composite);
        this.createCustomControl(composite);
        this.updatePageCompletion();
        Dialog.applyDialogFont((Control)composite);
        composite.layout(true);
        this.setControl((Control)composite);
        parent.layout(true);
        parent.redraw();
    }

    protected abstract void createCustomControl(Composite var1);

    public void createSuperClassControl(Composite composite) {
        if (this.isTest()) {
            String[] superClasses = this.getSuperClassesTest();
            if (superClasses.length > 0) {
                this.createComboControl(composite, "superclass.test", this.getSuperClassesTest(), 2052);
            } else {
                this.createTextControl(composite, "superclass.test");
            }
        } else {
            String[] superClasses = this.getSuperClasses();
            if (superClasses.length > 0) {
                this.createComboControl(composite, "device.superclass", this.getSuperClasses(), 2052);
            } else {
                this.createTextControl(composite, "device.superclass");
            }
        }
    }

    public String[] createSupportChoices() {
        return null;
    }

    public String[] getChoices(String key) {
        int size;
        String defaultValue;
        String string;
        SortedSet set = new SortedSet();
        String lastValue = DeviceKitPreferenceInitializer.getPreferenceString((String)("lastused." + key));
        if (lastValue != null && lastValue.length() > 0) {
            set.add((Object)lastValue);
        }
        if ((string = DeviceKitPreferenceInitializer.getPreferenceString((String)key)) != null && string.length() > 0) {
            set.add((Object)string);
        }
        if ((defaultValue = DeviceKitPreferenceInitializer.getPreferenceDefaultString((String)key)) != null && defaultValue.length() > 0) {
            set.add((Object)defaultValue);
        }
        if ((size = set.size()) == 0) {
            return new String[0];
        }
        Object[] result = new String[size];
        result = (String[])set.toArray(result);
        return result;
    }

    public String[] getChoices(String[] choices, String[] exists) {
        if (exists.length > 0) {
            String[] validChoices = new String[]{};
            int i = 0;
            while (i < choices.length) {
                if (Arrays.binarySearch(exists, choices[i]) < 0) {
                    String[] newChoices = new String[validChoices.length + 1];
                    System.arraycopy(validChoices, 0, newChoices, 0, validChoices.length);
                    newChoices[validChoices.length] = choices[i];
                    validChoices = newChoices;
                }
                ++i;
            }
            return validChoices;
        }
        return choices;
    }

    protected String[] getCommonTextKeys() {
        return DeviceKitPage.COMMON_TEXT_KEYS;
    }

    protected String getDefaultMessage() {
        String unformattedMessage = this.getString("default.message");
        String name = this.getWidgetText("name");
        String message = "";
        String type = this.getString(this.getKey());
        name = String.valueOf(name) + type;
        name = this.transformToNewName(name);
        message = Nls.format((String)unformattedMessage, (Object[])new String[]{type, name});
        if (this.canFlipToNextPage()) {
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append(message);
            buffer.append("\r\n");
            buffer.append(this.getString("next.page"));
            return buffer.toString();
        }
        return message;
    }

    public String[] getNameChoices() {
        return new String[0];
    }

    public String[] getNameShortAdapter() {
        return this.getNamesShort("Adapter");
    }

    public String[] getNameShortAdapterChoices() {
        return this.getChoices(this.getNameShortDevice(), this.getNameShortAdapter());
    }

    public String[] getNameShortAdapterTest() {
        return this.getNamesShort("AdapterTest", "adapter_test");
    }

    public String[] getNameShortAdapterTestChoices() {
        return this.getChoices(this.getNameShortAdapter(), this.getNameShortAdapterTest());
    }

    public String[] getNameShortAgent() {
        return this.getNamesShort("Agent");
    }

    public String[] getNameShortAgentChoices() {
        return new String[0];
    }

    public String[] getNameShortAgentTest() {
        return this.getNamesShort("AgentTest", "agent_test");
    }

    public String[] getNameShortAgentTestChoices() {
        return this.getChoices(this.getNameShortAgent(), this.getNameShortAgentTest());
    }

    public String[] getNameShortConcrete() {
        return this.getNamesShort("Concrete");
    }

    public String[] getNameShortConcreteChoices() {
        return this.getChoices(this.getNameShortReceiver(), this.getNameShortConcrete());
    }

    public String[] getNameShortConcreteTest() {
        return this.getNamesShort("ConcreteTest", "concrete_test");
    }

    public String[] getNameShortConcreteTestChoices() {
        return this.getChoices(this.getNameShortConcrete(), this.getNameShortConcreteTest());
    }

    public String[] getNameShortConnection() {
        return this.getNamesShort("Connection");
    }

    public String[] getNameShortConnectionChoices() {
        return new String[0];
    }

    public String[] getNameShortConnectionTest() {
        return this.getNamesShort("ConnectionTest", "connection_test");
    }

    public String[] getNameShortConnectionTestChoices() {
        return this.getChoices(this.getNameShortConnection(), this.getNameShortConnectionTest());
    }

    public String[] getNameShortDevice() {
        return this.getNamesShort("Device");
    }

    public String[] getNameShortDeviceChoices() {
        return this.getChoices(this.getNameShortTransport(), this.getNameShortDevice());
    }

    public String[] getNameShortDeviceTest() {
        return this.getNamesShort("DeviceTest", "device_test");
    }

    public String[] getNameShortDeviceTestChoices() {
        return this.getChoices(this.getNameShortDevice(), this.getNameShortDeviceTest());
    }

    public String[] getNameShortProfile() {
        return this.getNamesShort("Profile");
    }

    public String[] getNameShortProfileTest() {
        return this.getNamesShort("ProfileTest", "profile_test");
    }

    public String[] getNameShortProfileTestChoices() {
        return this.getChoices(this.getNameShortProfile(), this.getNameShortProfileTest());
    }

    public String[] getNameShortReceiver() {
        return this.getNamesShort("Receiver");
    }

    public String[] getNameShortReceiverTest() {
        return this.getNamesShort("ReceiverTest", "receiver_test");
    }

    public String[] getNameShortReceiverTestChoices() {
        return this.getChoices(this.getNameShortReceiver(), this.getNameShortReceiverTest());
    }

    public String[] getNameShortTransport() {
        return this.getNamesShort("Transport");
    }

    public String[] getNameShortTransportTest() {
        return this.getNamesShort("TransportTest", "transport_test");
    }

    public String[] getNameShortTransportTestChoices() {
        return this.getChoices(this.getNameShortTransport(), this.getNameShortTransportTest());
    }

    public String[] getNamesShort(String type) {
        return this.getNamesShort(type, type.toLowerCase());
    }

    public String[] getNamesShort(String type, String filename) {
        try {
            DkmlFileFinder finder = this.getFinder();
            String[] names = finder.getNames(filename);
            Object[] shortNames = new String[names.length];
            int i = 0;
            while (i < names.length) {
                shortNames[i] = names[i].endsWith(type) ? names[i].substring(0, names[i].length() - type.length()) : names[i];
                ++i;
            }
            Arrays.sort(shortNames);
            return shortNames;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    protected String getPackageBase() {
        return this.getWidgetText("packagebase");
    }

    public String getString(String key) {
        return messages.getString(key);
    }

    public String[] getSuperClasses() {
        return new String[0];
    }

    public String[] getSuperClassesTest() {
        return new String[0];
    }

    public String[] getSupportChoices() {
        if (this.supportChoices == null) {
            this.supportChoices = this.createSupportChoices();
        }
        return this.supportChoices;
    }

    public String[] getValidNameChoices() {
        if (this.validNameChoices == null) {
            this.validNameChoices = this.getNameChoices();
        }
        return this.validNameChoices;
    }

    public boolean isDisplayTest() {
        return !this.isTest();
    }

    protected boolean isJavaKeyword(String segment) {
        String[] keywords = JavaKeywords.keywords;
        int i = 0;
        while (i < keywords.length) {
            if (segment.equalsIgnoreCase(keywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean nameOk() {
        String value = this.getWidgetText("name");
        return this.nameOk(value, true);
    }

    protected boolean nameOk(String value, boolean output) {
        String projectName;
        String typeName = this.getTypeName();
        if (value.length() == 0) {
            String message = this.getString("name.empty");
            this.update(false, false, null, message);
            return false;
        }
        if (value.indexOf(46) > 0) {
            String errorMessage = this.getString("name.error");
            this.update(false, false, errorMessage, null);
            return false;
        }
        if (value.endsWith(typeName)) {
            String errorMessage = this.getString("name.end");
            this.update(false, false, errorMessage, null);
            return false;
        }
        if (!this.validName(value)) {
            return false;
        }
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(value);
        buffer.append(typeName);
        if (this.isTest()) {
            buffer.append("Test");
        }
        if (this.projectExists(projectName = this.transformToNewName(buffer.toString()))) {
            if (output) {
                String errorMessageUnformatted = this.getString("project.already.exists");
                String errorMessage = Nls.format((String)errorMessageUnformatted, (Object[])new String[]{projectName});
                this.update(false, false, errorMessage, null);
            }
            return false;
        }
        return true;
    }

    public boolean otherErrorsOk() {
        String name = this.getWidgetText("name");
        if (this.isTest()) {
            String[] names = this.getValidNameChoices();
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    return true;
                }
                ++i;
            }
            String errorMessage = this.getString("test.target.notfound");
            this.update(true, true, errorMessage, errorMessage);
            return false;
        }
        String[] names = this.getSupportChoices();
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    return true;
                }
                ++i;
            }
            String errorMessage = this.getString("support.notfound");
            this.update(true, true, errorMessage, errorMessage);
            return false;
        }
        return true;
    }

    protected boolean packageBaseOk() {
        String packageBase = this.getPackageBase();
        if (packageBase.trim().length() > 0) {
            IStatus status;
            boolean valid;
            if (DeviceKitPlugin.getDefault() != null && !(valid = (status = JavaConventions.validatePackageName((String)packageBase, (String)"1.4", (String)"1.4")).isOK())) {
                String errorMessage = status.getMessage();
                this.update(false, false, errorMessage, null);
                return false;
            }
        } else {
            String errorMessage = this.getString("packagebase.empty");
            this.update(false, false, null, errorMessage);
            return false;
        }
        return true;
    }

    public void setSupportChoices(String[] supportChoices) {
        this.supportChoices = supportChoices;
    }

    public void setValidNameChoices(String[] validNameChoices) {
        this.validNameChoices = validNameChoices;
    }

    protected String transformToNewName(String oldName) {
        String packageBase = this.getPackageBase();
        return DeviceKitUtilities.getPackageFromClassName((String)oldName, (String)packageBase);
    }

    protected boolean updatePageErrors() {
        if (!this.nameOk()) {
            return false;
        }
        if (!this.packageBaseOk()) {
            return false;
        }
        if (!this.versionOk()) {
            return false;
        }
        if (!this.otherErrorsOk()) {
            return false;
        }
        this.update(true, this.getNextPage() != null, null, null);
        return true;
    }

    protected boolean validName(String name) {
        int length = name.length();
        if (length > 0) {
            if (this.isJavaKeyword(name)) {
                String unformattedErrorMessage = this.getString("java.keyword");
                String errorMessage = Nls.format((String)unformattedErrorMessage, (Object)name);
                this.update(false, false, errorMessage, null);
                return false;
            }
            if (!Character.isUpperCase(name.charAt(0))) {
                String unformattedErrorMessage = this.getString("invalid.start");
                String errorMessage = Nls.format((String)unformattedErrorMessage, (Object)name);
                this.update(false, false, errorMessage, null);
                return false;
            }
            StringBuffer buffer = new StringBuffer(name.length());
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if (i == name.length() - 1 && Character.isLowerCase(c)) {
                    buffer.append(c);
                }
                if (Character.isUpperCase(c) && i != 0 || i == name.length() - 1) {
                    if (this.isJavaKeyword(buffer.toString())) {
                        String unformattedErrorMessage = this.getString("java.keyword");
                        String errorMessage = Nls.format((String)unformattedErrorMessage, (Object)buffer.toString());
                        this.update(false, false, errorMessage, null);
                        return false;
                    }
                    buffer = new StringBuffer(name.length());
                }
                buffer.append(c);
                boolean invalidCharacter = c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z';
                invalidCharacter = false;
                if (invalidCharacter) {
                    String unformattedErrorMessage = this.getString("invalid.char");
                    String errorMessage = Nls.format((String)unformattedErrorMessage, (Object)new Character(c));
                    this.update(false, false, errorMessage, null);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean versionOk() {
        String version = this.getWidgetText("version");
        if (version.trim().length() > 0) {
            boolean valid = VersionValidator.isValidVersion((String)version);
            if (!valid) {
                String errorMessage = this.getString("version.invalid");
                this.update(false, false, errorMessage, null);
                return false;
            }
        } else {
            String errorMessage = this.getString("version.empty");
            this.update(false, false, null, errorMessage);
            return false;
        }
        return true;
    }
}

