/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.utility.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.html.PackageHtmlGenerator;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.generator.manifest.ManifestPrinter;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.utilty.xml.XmlParserFormatDoc;
import org.eclipse.soda.devicekit.generator.visitor.JavadocVisitor;
import org.eclipse.soda.devicekit.generator.visitor.Visitor;
import org.eclipse.soda.devicekit.ui.utility.operation.SourceOperation;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class FixSourceOperation
extends SourceOperation
implements Comparator {
    static final String[] SPECIAL_KEYS = new String[]{"Bundle-Category", "Bundle-Copyright", "Bundle-Description", "Bundle-Name", "Bundle-Vendor"};

    public FixSourceOperation() {
    }

    public FixSourceOperation(Map map) {
        this.getProperties().putAll((Map<?, ?>)map);
    }

    public static int getCreateYear(IFile file) {
        block27: {
            IFileHistoryProvider fileHistoryProvider;
            RepositoryProvider repositoryProvider;
            int currentYear = Calendar.getInstance().get(1);
            try {
                InputStream is = file.getContents();
                String data = new String(FixSourceOperation.readData(is));
                int createYear = FixSourceOperation.containsCopyright(data);
                if (createYear > 1970 && createYear != currentYear) {
                    return createYear;
                }
            }
            catch (Exception exception) {}
            try {
                IFileState[] fileStates = file.getHistory((IProgressMonitor)new NullProgressMonitor());
                int i = fileStates.length - 1;
                while (i >= 0) {
                    try {
                        InputStream is2 = fileStates[i].getContents();
                        String data2 = new String(FixSourceOperation.readData(is2));
                        int createYear = FixSourceOperation.containsCopyright(data2);
                        if (createYear > 1970 && createYear < currentYear) {
                            return createYear;
                        }
                        is2.close();
                    }
                    catch (Exception exception) {}
                    --i;
                }
            }
            catch (Exception exception) {}
            IProject project = file.getProject();
            boolean isShared = RepositoryProvider.isShared((IProject)project);
            if (isShared && (repositoryProvider = RepositoryProvider.getProvider((IProject)project)) != null && (fileHistoryProvider = repositoryProvider.getFileHistoryProvider()) instanceof CVSFileHistoryProvider) {
                try {
                    IFileRevision[] fileRevisions;
                    IFileHistory fileHistory;
                    block26: {
                        Subscriber subscriber = repositoryProvider.getSubscriber();
                        SyncInfo syncInfo = subscriber.getSyncInfo((IResource)file);
                        IResourceVariant remote = syncInfo.getRemote();
                        if (remote instanceof RemoteFile) {
                            RemoteFile remoteFile = (RemoteFile)remote;
                            ICVSFolder remoteParent = remoteFile.getParent();
                            try {
                                CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(remoteParent, 1);
                                if (tags == null) break block26;
                                int i = 0;
                                while (i < tags.length) {
                                    ICVSRemoteResource remoteFileBranch = remoteFile.forTag(tags[i]);
                                    if (remoteFileBranch instanceof RemoteFile) {
                                        RemoteFile file3 = (RemoteFile)remoteFileBranch;
                                        InputStream is3 = file3.getContents();
                                        String data3 = new String(FixSourceOperation.readData(is3));
                                        try {
                                            is3.close();
                                        }
                                        catch (Exception exception) {}
                                        int createYear = FixSourceOperation.containsCopyright(data3);
                                        if (createYear > 1970 && createYear < currentYear) {
                                            return createYear;
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    if ((fileHistory = fileHistoryProvider.getFileHistoryFor((IResource)file, 0, (IProgressMonitor)new NullProgressMonitor())) == null || (fileRevisions = fileHistory.getFileRevisions()) == null) break block27;
                    int i = 0;
                    while (i < fileRevisions.length) {
                        try {
                            IStorage storage = fileRevisions[i].getStorage((IProgressMonitor)new NullProgressMonitor());
                            InputStream is4 = storage.getContents();
                            String data4 = new String(FixSourceOperation.readData(is4));
                            try {
                                is4.close();
                            }
                            catch (Exception exception) {}
                            int createYear = FixSourceOperation.containsCopyright(data4);
                            if (createYear > 1970 && createYear < currentYear) {
                                return createYear;
                            }
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return -1;
    }

    public int compare(Object arg0, Object arg1) {
        String name0 = String.valueOf(arg0);
        if (name0.startsWith("Manifest-")) {
            return -1;
        }
        String name1 = String.valueOf(arg1);
        if (name1.startsWith("Manifest-")) {
            return 1;
        }
        return name0.compareTo(name1);
    }

    public String compilationUnit(ICompilationUnit compilationUnit, String[] references) throws Exception {
        String source = compilationUnit.getSource();
        String formatString = this.format(source);
        if (!formatString.equals(source)) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(formatString.getBytes());
            ((IFile)compilationUnit.getResource()).setContents((InputStream)sourceStream, true, true, this.getProgressMonitor());
        }
        Visitor visitor = this.getVisitor();
        visitor.setCompilationUnit(compilationUnit);
        visitor.setPseudo(false);
        visitor.setSource(compilationUnit.getSource());
        visitor.setReferences(references);
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(compilationUnit);
            parser.setResolveBindings(true);
            ASTNode node = parser.createAST(this.getProgressMonitor());
            node.accept((ASTVisitor)visitor);
        }
        catch (Exception exception) {
            this.logException(exception);
        }
        return visitor.toString();
    }

    protected Visitor getVisitor() {
        return new JavadocVisitor();
    }

    public void outputTo(ManifestModel manifestModel, IFile file) throws Exception {
        ManifestPrinter manifestPrinter = new ManifestPrinter(manifestModel);
        String data = manifestPrinter.getContents();
        IProject project = file.getProject();
        IFile propertiesFile = project.getFile("OSGI-INF/l10n/bundle.properties");
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            FileInputStream lfis = new FileInputStream(propertiesFile.getRawLocation().toFile());
            BufferedInputStream inStream = new BufferedInputStream(lfis, 4096);
            properties.load(inStream);
        }
        int i = 0;
        while (i < SPECIAL_KEYS.length) {
            String key = SPECIAL_KEYS[i];
            String[] values = manifestModel.getKeyValue(key);
            if (values != null && values.length > 0) {
                String value = values[0];
                properties.put(key.toLowerCase().replace('-', '.'), value);
            }
            ++i;
        }
        this.save(file, data);
        this.saveAllDirectory("OSGI-INF/l10n/bundle.properties", project);
        this.processPropertiesFile(propertiesFile, properties, true);
        IFile propertiesFileEn = project.getFile("OSGI-INF/l10n/bundle_en.properties");
        this.processPropertiesFile(propertiesFileEn, properties, true);
    }

    public void outputTo(OutputStream s, String key, String value) throws Exception {
        String output = value.trim();
        if (output.length() > 0) {
            s.write(key.getBytes());
            s.write(": ".getBytes());
            if (output.length() + 1 < 70) {
                s.write(output.getBytes());
                s.write(13);
                s.write(10);
            } else {
                int i = 0;
                while (i < output.length()) {
                    if (output.charAt(i) == '\n') {
                        s.write(13);
                        s.write(10);
                        s.write(32);
                    } else if (output.charAt(i) != '\r') {
                        s.write(output.charAt(i));
                        if (output.charAt(i) == ',') {
                            s.write(13);
                            s.write(10);
                            s.write(32);
                        }
                    }
                    ++i;
                }
                s.write(13);
                s.write(10);
            }
        }
    }

    public void processCodeFile(IFile file) {
        try {
            StringBuffer buffer = new StringBuffer(4096);
            StringBuffer copyrightBuffer = new StringBuffer(4096);
            InputStream is = file.getContents();
            String data = new String(FixSourceOperation.readData(is));
            boolean found = false;
            StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String trimToken = token.trim();
                if (!found) {
                    if (trimToken.startsWith("*") || trimToken.startsWith("/*") || trimToken.startsWith("//")) {
                        copyrightBuffer.append(token);
                        copyrightBuffer.append("\r\n");
                        continue;
                    }
                    if (copyrightBuffer.length() > 0) {
                        int createYear = FixSourceOperation.getCreateYear(file);
                        buffer.append(this.getCopyrightStringCode(createYear));
                        found = true;
                    }
                    buffer.append(token);
                    buffer.append("\r\n");
                    continue;
                }
                buffer.append(token);
                buffer.append("\r\n");
            }
            String newData = buffer.toString();
            if (!data.equals(newData)) {
                byte[] dataBytes = newData.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                file.setContents((InputStream)source, true, true, this.getProgressMonitor());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processCompilationUnit(ICompilationUnit compilationUnit, boolean refresh) {
        try {
            if (this.isJava()) {
                String oldString = compilationUnit.getSource();
                String data = oldString;
                if (data != null) {
                    String packageName = compilationUnit.getParent().getElementName();
                    data = this.compilationUnit(compilationUnit, new String[0]);
                    packageName = packageName.replace('.', '/');
                    if (!(data = this.format(data)).equals(oldString)) {
                        ByteArrayInputStream source = new ByteArrayInputStream(data.getBytes());
                        ((IFile)compilationUnit.getResource()).setContents((InputStream)source, true, true, this.getProgressMonitor());
                    }
                }
                compilationUnit.close();
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    protected void processCopyrightFile(IFile file) {
        try {
            InputStream is = file.getContents();
            String data = new String(FixSourceOperation.readData(is));
            int createYear = FixSourceOperation.getCreateYear(file);
            String copyright = GeneratorTemplates.getCopyright((int)createYear);
            if (!data.equals(copyright)) {
                byte[] dataBytes = copyright.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                file.setContents((InputStream)source, true, true, this.getProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean processFile(IFile file, boolean b) {
        if (file.exists()) {
            String name = file.getName();
            if ("copyright.txt".equals(name)) {
                if (this.isTxt()) {
                    this.processCopyrightFile(file);
                }
            } else if (String.valueOf(file.getFileExtension()).endsWith("properties")) {
                if (this.isProperties()) {
                    this.processPropertiesFile(file);
                }
            } else if ("MANIFEST.MF".equals(name)) {
                if (this.isManifest()) {
                    this.processManifest(file);
                }
            } else if (name.endsWith(".c")) {
                if (this.isC()) {
                    this.processCodeFile(file);
                }
            } else if (name.endsWith(".h")) {
                if (this.isH()) {
                    this.processCodeFile(file);
                }
            } else if (name.endsWith(".xml") || name.endsWith(".xsd")) {
                if (this.isXml()) {
                    this.processXmlFile(file);
                }
            } else if (name.endsWith(".html")) {
                if (this.isHtml()) {
                    this.processXmlFile(file);
                }
            } else if ((name.endsWith("makefile") || name.startsWith("makefile")) && this.isMakefiles()) {
                this.processMakefileFile(file);
            }
        }
        return true;
    }

    public void processJavaPackage(IPackageFragment javaPackage, boolean refresh, IProgressMonitor progressMonitor) {
        try {
            if (this.isPackage() && javaPackage.exists() && javaPackage.getKind() == 1 && javaPackage.containsJavaResources()) {
                PackageHtmlGenerator packageHtmlGenerator = new PackageHtmlGenerator(javaPackage);
                packageHtmlGenerator.generate(progressMonitor);
            }
        }
        catch (JavaModelException exception) {
            exception.printStackTrace();
        }
        super.processJavaPackage(javaPackage, refresh, progressMonitor);
    }

    public void processJavaProject(IJavaProject javaProject, boolean refresh) {
        super.processJavaProject(javaProject, refresh);
        if (this.isProject()) {
            IProject project = javaProject.getProject();
            try {
                CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)this.getProgressMonitor());
                CoreUtility.createCopyrightFile((IContainer)project, (IProgressMonitor)this.getProgressMonitor());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void processMakefileFile(IFile file) {
        try {
            StringBuffer buffer = new StringBuffer(4096);
            StringBuffer copyrightBuffer = new StringBuffer(4096);
            InputStream is = file.getContents();
            String data = new String(FixSourceOperation.readData(is));
            boolean found = false;
            StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String trimToken = token.trim();
                if (!found) {
                    if (trimToken.startsWith("#")) {
                        copyrightBuffer.append(token);
                        copyrightBuffer.append("\r\n");
                        continue;
                    }
                    if (copyrightBuffer.length() > 0) {
                        int createYear = FixSourceOperation.getCreateYear(file);
                        buffer.append(this.getCopyrightStringProperties(createYear));
                        found = true;
                    }
                    buffer.append(token);
                    buffer.append("\r\n");
                    continue;
                }
                buffer.append(token);
                buffer.append("\r\n");
            }
            String newData = buffer.toString();
            if (!data.equals(newData)) {
                byte[] dataBytes = newData.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                file.setContents((InputStream)source, true, true, this.getProgressMonitor());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processManifest(IFile file) {
        block58: {
            try {
                String betterName;
                String value;
                if (!this.isManifest()) break block58;
                int currentYear = Calendar.getInstance().get(1);
                ManifestModel manifestModel = new ManifestModel();
                int betterCreateYear = -1;
                FileInputStream fis = new FileInputStream(file.getRawLocation().toFile());
                BufferedInputStream is = new BufferedInputStream(fis, 4096);
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                Set<Object> keys = attributes.keySet();
                Object[] objects = keys.toArray();
                Properties properties = new Properties();
                if (objects == null) break block58;
                String bvalue = attributes.getValue("Bundle-Version");
                if (bvalue == null) {
                    manifestModel.setVersion(String.valueOf(this.getVersion()) + ".qualifier");
                } else {
                    manifestModel.setVersion(String.valueOf(this.getVersion()) + ".qualifier");
                }
                int i = 0;
                while (i < objects.length) {
                    int index;
                    String token;
                    int count;
                    StringTokenizer tokenizer;
                    StringBuffer buffer;
                    Attributes.Name name = (Attributes.Name)objects[i];
                    value = attributes.getValue(name);
                    String key = name.toString();
                    if ("Export-Package".equals(key)) {
                        buffer = new StringBuffer(256);
                        tokenizer = new StringTokenizer(value, ",");
                        count = 0;
                        while (tokenizer.hasMoreTokens()) {
                            if (count > 0) {
                                buffer.append(',');
                            }
                            ++count;
                            token = tokenizer.nextToken();
                            index = token.indexOf(59);
                            if (index < 0) {
                                manifestModel.addExportedPackage(token.trim());
                                continue;
                            }
                            manifestModel.addExportedPackage(token.substring(0, index).trim());
                        }
                    } else if ("Import-Package".equals(key)) {
                        buffer = new StringBuffer(256);
                        tokenizer = new StringTokenizer(value, ",");
                        count = 0;
                        while (tokenizer.hasMoreTokens()) {
                            if (count > 0) {
                                buffer.append(',');
                            }
                            ++count;
                            token = tokenizer.nextToken();
                            index = token.indexOf(59);
                            if (index < 0) {
                                manifestModel.addImportPackage(token.trim());
                                continue;
                            }
                            manifestModel.addImportPackage(token.substring(0, index).trim());
                        }
                    } else if ("Require-Bundle".equals(key)) {
                        buffer = new StringBuffer(256);
                        tokenizer = new StringTokenizer(value, ",");
                        count = 0;
                        while (tokenizer.hasMoreTokens()) {
                            if (count > 0) {
                                buffer.append(',');
                            }
                            ++count;
                            token = tokenizer.nextToken();
                            index = token.indexOf(59);
                            if (index < 0) {
                                manifestModel.addRequiredBundle(token.trim());
                                continue;
                            }
                            String id = token.substring(0, index).trim();
                            String options = token.substring(index + 1).trim();
                            if (options.equals("resolution:=optional")) {
                                manifestModel.addRequiredBundle(id);
                                continue;
                            }
                            manifestModel.addRequiredBundle(id, options);
                        }
                    } else if (!"Manifest-Version".equals(key)) {
                        manifestModel.setKeyValue(key, value);
                    }
                    ++i;
                }
                IProject project = file.getProject();
                String key = "Bundle-Localization";
                value = attributes.getValue(key);
                boolean delete = false;
                if (value == null) {
                    value = "OSGI-INF/l10n/bundle.properties";
                    manifestModel.setKeyValue(key, "OSGI-INF/l10n/bundle");
                } else if (!value.equals("OSGI-INF/l10n/bundle")) {
                    value = String.valueOf(value) + ".properties";
                    manifestModel.setKeyValue(key, "OSGI-INF/l10n/bundle");
                    delete = true;
                }
                if (value != null) {
                    IFile locFile;
                    if (!value.endsWith(".properties")) {
                        value = String.valueOf(value) + ".properties";
                    }
                    if ((locFile = project.getFile(value)).exists()) {
                        FileInputStream lfis = new FileInputStream(locFile.getRawLocation().toFile());
                        BufferedInputStream inStream = new BufferedInputStream(lfis, 4096);
                        properties.load(inStream);
                        inStream.close();
                        FileInputStream lfis2 = new FileInputStream(locFile.getRawLocation().toFile());
                        BufferedInputStream inStream2 = new BufferedInputStream(lfis2, 4096);
                        betterCreateYear = FixSourceOperation.getCreateYear(locFile);
                        inStream2.close();
                        if (locFile.exists() && delete) {
                            try {
                                locFile.delete(true, this.getProgressMonitor());
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                if ((value = attributes.getValue(key = "Bundle-Version")) == null) {
                    manifestModel.setKeyValue(key, String.valueOf(this.getVersion()) + ".qualifier");
                } else if (!(String.valueOf(this.getVersion()) + ".qualifier").equals(value)) {
                    manifestModel.setKeyValue(key, String.valueOf(this.getVersion()) + ".qualifier");
                }
                key = "Bundle-Copyright";
                value = attributes.getValue(key);
                if (value == null) {
                    manifestModel.setKeyValue(key, this.getCopyrightLine());
                } else {
                    String mergedCopyright;
                    int createYear;
                    if (value.startsWith("%")) {
                        if ((value = properties.getProperty(value.substring(1))) == null) {
                            value = attributes.getValue(key);
                            manifestModel.setKeyValue(key, this.getCopyrightLine());
                        } else {
                            manifestModel.setKeyValue(key, value);
                        }
                    }
                    if ((createYear = FixSourceOperation.containsCopyright(value)) < 1970 || createYear == currentYear) {
                        if (betterCreateYear == -1) {
                            betterCreateYear = FixSourceOperation.getCreateYear(file);
                        }
                        createYear = betterCreateYear;
                    }
                    if (!(mergedCopyright = GeneratorTemplates.getCopyrightLine((Map)GeneratorTemplates.getTemplateVariables((int)createYear))).equals(value)) {
                        manifestModel.setKeyValue(key, mergedCopyright);
                    }
                }
                key = "Bundle-Vendor";
                value = attributes.getValue(key);
                if (value == null) {
                    manifestModel.setKeyValue(key, this.getProvider());
                } else if (!this.getProvider().equals(value)) {
                    manifestModel.setKeyValue(key, this.getProvider());
                }
                key = "Bundle-Name";
                value = attributes.getValue(key);
                if (value == null) {
                    betterName = CodeUtilities.betterNameFromProjectName((String)project.getName(), (String)this.getPackageBase());
                    if (DeviceKitPlugin.isIncubation()) {
                        betterName = String.valueOf(betterName) + " (Incubation)";
                    }
                    manifestModel.setKeyValue(key, betterName);
                } else {
                    if (value.startsWith("%")) {
                        if ((value = properties.getProperty(value.substring(1))) == null) {
                            value = attributes.getValue(key);
                            manifestModel.setKeyValue(key, value);
                        }
                        manifestModel.setKeyValue(key, value);
                    }
                    betterName = CodeUtilities.betterNameFromProjectName((String)project.getName(), (String)this.getPackageBase());
                    if (DeviceKitPlugin.isIncubation()) {
                        betterName = String.valueOf(betterName) + " (Incubation)";
                    }
                    manifestModel.setKeyValue(key, betterName);
                }
                key = "Bundle-Description";
                value = attributes.getValue(key);
                if (value == null) {
                    betterName = CodeUtilities.betterDescriptionFromProjectName((String)project.getName(), (String)this.getPackageBase());
                    manifestModel.setKeyValue(key, betterName);
                } else {
                    if (value.startsWith("%") && (value = properties.getProperty(value.substring(1))) == null) {
                        value = attributes.getValue(key);
                    }
                    betterName = CodeUtilities.betterDescriptionFromProjectName((String)project.getName(), (String)this.getPackageBase());
                    manifestModel.setKeyValue(key, betterName);
                }
                key = "Bundle-Category";
                value = attributes.getValue(key);
                if (value != null && value.startsWith("%")) {
                    if ((value = properties.getProperty(value.substring(1))) == null) {
                        value = attributes.getValue(key);
                    }
                    manifestModel.setKeyValue(key, value);
                }
                if ((value = attributes.getValue(key = "Export-Service")) != null) {
                    attributes.remove(key);
                }
                if ((value = attributes.getValue(key = "Import-Service")) != null) {
                    attributes.remove(key);
                }
                is.close();
                this.outputTo(manifestModel, file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void processPropertiesFile(IFile file) {
        try {
            if (this.isProperties()) {
                String name = file.getName();
                IProject project = file.getProject();
                InputStream is = file.getContents();
                String data = new String(FixSourceOperation.readData(is));
                int createYear = FixSourceOperation.getCreateYear(file);
                String copyright = GeneratorTemplates.getCopyrightPropertyString((Map)GeneratorTemplates.getTemplateVariables((int)createYear));
                StringBuffer buffer = new StringBuffer(4096);
                buffer.append(copyright);
                Properties properties = new Properties();
                InputStream inStream = file.getContents();
                properties.load(inStream);
                if (name.equals("build.properties")) {
                    String binIncludes = properties.getProperty("bin.includes", ".,META-INF/,OSGI-INF/,OSGI-INF/l10n/,copyright.txt,about.html");
                    if (project.getFolder("OSGI-INF").exists() && binIncludes.indexOf("OSGI-INF/") < 0) {
                        CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)this.getProgressMonitor());
                        binIncludes = String.valueOf(binIncludes) + ",OSGI-INF/";
                    }
                    if (project.getFolder("OSGI-INF/l10n").exists() && binIncludes.indexOf("OSGI-INF/l10n/") < 0) {
                        CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)this.getProgressMonitor());
                        binIncludes = String.valueOf(binIncludes) + ",OSGI-INF/l10n/";
                    }
                    if (project.getFolder("META-INF").exists() && binIncludes.indexOf("META-INF/") < 0) {
                        CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)this.getProgressMonitor());
                        binIncludes = String.valueOf(binIncludes) + ",META-INF/";
                    }
                    if (binIncludes.indexOf("copyright.txt") < 0) {
                        CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)this.getProgressMonitor());
                        binIncludes = String.valueOf(binIncludes) + ",copyright.txt";
                    }
                    if (binIncludes.indexOf("about.html") < 0) {
                        CoreUtility.createAboutFile((IContainer)project, (IProgressMonitor)this.getProgressMonitor());
                        binIncludes = String.valueOf(binIncludes) + ",about.html";
                    }
                    properties.put("bin.includes", binIncludes);
                }
                FixSourceOperation.outputPropertiesTo(buffer, properties);
                String newData = buffer.toString();
                if (!data.equals(newData)) {
                    byte[] dataBytes = newData.getBytes();
                    ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                    file.setContents((InputStream)source, true, true, this.getProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processPropertiesFile(IFile file, Properties properties) {
        this.processPropertiesFile(file, properties, this.isProperties());
    }

    protected void processPropertiesFile(IFile file, Properties properties, boolean process) {
        try {
            String name;
            if (process && (name = file.getName()).toLowerCase().equals(name)) {
                if (file.exists()) {
                    InputStream is = file.getContents(true);
                    String data = new String(FixSourceOperation.readData(is));
                    int createYear = FixSourceOperation.getCreateYear(file);
                    String copyright = GeneratorTemplates.getCopyrightPropertyString((Map)GeneratorTemplates.getTemplateVariables((int)createYear));
                    StringBuffer buffer = new StringBuffer(4096);
                    buffer.append(copyright);
                    FixSourceOperation.outputPropertiesTo(buffer, properties);
                    String newData = buffer.toString();
                    if (!data.equals(newData)) {
                        byte[] dataBytes = newData.getBytes();
                        ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                        file.setContents((InputStream)source, true, true, this.getProgressMonitor());
                    }
                } else {
                    String copyright = GeneratorTemplates.getCopyrightPropertyString((Map)GeneratorTemplates.getTemplateVariables((int)-1));
                    StringBuffer buffer = new StringBuffer(4096);
                    buffer.append(copyright);
                    FixSourceOperation.outputPropertiesTo(buffer, properties);
                    String newData = buffer.toString();
                    byte[] dataBytes = newData.getBytes();
                    ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                    file.create((InputStream)source, true, this.getProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processXmlFile(IFile file) {
        try {
            boolean devicekit = file.getParent().getName().equals("dk");
            StringBuffer buffer = new StringBuffer(4096);
            StringBuffer copyrightBuffer = new StringBuffer(4096);
            InputStream is = file.getContents();
            String data = new String(FixSourceOperation.readData(is));
            boolean found = false;
            StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
            boolean providerFound = false;
            int vendorCount = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String trimToken = token.trim();
                if (!found) {
                    if (trimToken.startsWith("<!--")) {
                        copyrightBuffer.append(token);
                        copyrightBuffer.append("\r\n");
                        continue;
                    }
                    if (copyrightBuffer.length() > 0) {
                        String oldCopyright = copyrightBuffer.toString();
                        int createYear = FixSourceOperation.getCreateYear(file);
                        buffer.append(this.getCopyrightXmlString(createYear));
                        if (devicekit || oldCopyright.indexOf("WARNING") >= 0) {
                            buffer.append(GeneratorTemplates.getXmlWarning((Map)GeneratorTemplates.getTemplateVariables((int)createYear)));
                        }
                        found = true;
                    }
                    buffer.append(token);
                    buffer.append("\r\n");
                    continue;
                }
                boolean print = true;
                if (!trimToken.startsWith("<!")) {
                    String element = "";
                    if (trimToken.length() > 0) {
                        StringTokenizer tokenizerLine = new StringTokenizer(trimToken, "\n\r\t ");
                        element = tokenizerLine.nextToken();
                    }
                    if (element.startsWith("<provider")) {
                        buffer.append("\t\t<provider>");
                        buffer.append(this.getProvider());
                        buffer.append("</provider>\r\n");
                        providerFound = true;
                        print = false;
                    } else if (element.startsWith("<vendor")) {
                        if (vendorCount == 0) {
                            buffer.append("\t\t<vendor>");
                            buffer.append(this.getVendor());
                            buffer.append("</vendor>\r\n");
                            print = false;
                        }
                        ++vendorCount;
                    } else if (element.startsWith("<version")) {
                        if (!providerFound) {
                            buffer.append("\t\t<provider>");
                            buffer.append(this.getProvider());
                            buffer.append("</provider>\r\n");
                        }
                        buffer.append("\t\t<version>");
                        buffer.append(this.getVersion());
                        buffer.append("</version>\r\n");
                        print = false;
                    }
                }
                if (!print) continue;
                buffer.append(token);
                buffer.append("\r\n");
            }
            String newData = buffer.toString();
            if (!data.equals(newData)) {
                byte[] dataBytes = newData.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                file.setContents((InputStream)source, true, true, this.getProgressMonitor());
                XmlParserFormatDoc xmlParserFormatDoc = new XmlParserFormatDoc();
                String dataFormat = xmlParserFormatDoc.parse(newData, 0, true);
                byte[] dataBytesFormat = dataFormat.getBytes();
                ByteArrayInputStream sourceFormat = new ByteArrayInputStream(dataBytesFormat);
                if (!sourceFormat.equals(newData)) {
                    file.setContents((InputStream)sourceFormat, true, true, this.getProgressMonitor());
                }
            } else {
                XmlParserFormatDoc xmlParserFormatDoc = new XmlParserFormatDoc();
                String dataFormat = xmlParserFormatDoc.parse(newData, 0, true);
                byte[] dataBytesFormat = dataFormat.getBytes();
                ByteArrayInputStream sourceFormat = new ByteArrayInputStream(dataBytesFormat);
                if (!sourceFormat.equals(newData)) {
                    file.setContents((InputStream)sourceFormat, true, true, this.getProgressMonitor());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

