/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.wizard;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.DeviceKitUiPlugin;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class DeviceKitPage
extends WizardPage
implements Listener {
    private static final String VENDOR = DeviceKitPage.getPreferenceString("vendor", "IBM");
    private static final String VERSION = DeviceKitPage.getPreferenceString("version", "1.1.0");
    private static final String PROVIDER = DeviceKitPage.getPreferenceString("provider", "Eclipse.org");
    public static final TemplateStore templateStore = DeviceKitPage.creaateTemplateStore();
    public static final String[] COMMON_TEXT_KEYS = new String[]{"name", "packagebase", "provider", "version", "vendor", "vendortwo", "description"};
    public static final int COMPOSITE_COL_NUMBER = 3;
    private boolean canFinish;
    private boolean next;
    private Map widgets;
    private boolean test = false;
    private DkmlFileFinder finder;

    protected DeviceKitPage(String pageName) {
        super(pageName);
        this.widgets = new HashMap();
    }

    protected DeviceKitPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private static TemplateStore creaateTemplateStore() {
        if (GeneratorPlugin.getDefault() != null) {
            return GeneratorPlugin.getDefault().getTemplateStore();
        }
        return null;
    }

    public static String getPreferenceString(String key, String defaultValue) {
        if (DeviceKitPlugin.getDefault() != null) {
            return DeviceKitPreferenceInitializer.getPreferenceString((String)key);
        }
        return defaultValue;
    }

    public boolean canFlipToNextPage() {
        return this.next;
    }

    protected Button createCheckBoxControl(Composite composite, String key) {
        return this.createCheckBoxControl(composite, key, "");
    }

    protected Button createCheckBoxControl(Composite composite, String key, String labelString) {
        String buttonString = this.getString(key);
        if (buttonString.length() > 0) {
            Label label = new Label(composite, 16384);
            if (labelString.length() > 0) {
                label.setText(labelString);
            }
            Button button = new Button(composite, 32);
            button.setText(buttonString);
            GridData data = new GridData(4);
            data.horizontalSpan = 2;
            data.verticalSpan = 1;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = false;
            button.setLayoutData((Object)data);
            String hint = this.getString(String.valueOf(key) + ".hint");
            if (hint != null && hint.length() > 0) {
                button.setToolTipText(hint);
            }
            button.addListener(13, (Listener)this);
            boolean defaultValue = DeviceKitPreferenceInitializer.getPreferenceBoolean((String)key);
            button.setSelection(defaultValue);
            this.putWidget(key, (Widget)button);
            return button;
        }
        return null;
    }

    protected Combo createComboControl(Composite composite, String key, String[] comboItems, int style) {
        Label label = new Label(composite, 16384);
        String labelText = this.getString(key);
        label.setText(labelText);
        String hint = this.getString(String.valueOf(key) + ".hint");
        label.setToolTipText(hint);
        Combo combo = new Combo(composite, style);
        GridData data = new GridData(4);
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        combo.setLayoutData((Object)data);
        combo.setToolTipText(hint);
        combo.addListener(24, (Listener)this);
        combo.setItems(comboItems);
        if (key.indexOf("superclass") < 0) {
            String defaultValue = this.getDefaultStringValue(key);
            if (defaultValue != null && defaultValue.length() > 0) {
                combo.setText(defaultValue);
            } else {
                combo.setText("");
            }
        }
        this.putWidget(key, (Widget)combo);
        return combo;
    }

    protected Combo createComboControl(Composite composite, String key, String[] comboItems, IWizardMessages messages) {
        return this.createComboControl(composite, key, comboItems, 2052);
    }

    public void createControl(Composite arg0) {
    }

    protected Text createTextControl(Composite composite, String key) {
        String hint;
        Label label = new Label(composite, 16384);
        label.setText(this.getString(key));
        if ("name".equals(key)) {
            label.setFont(this.getFont());
        }
        if ((hint = this.getString(String.valueOf(key) + ".hint")) != null && hint.length() > 0) {
            label.setToolTipText(hint);
        }
        Text text = new Text(composite, 2052);
        GridData data = new GridData(4);
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        text.setToolTipText(hint);
        text.addListener(24, (Listener)this);
        String defaultValue = this.getDefaultStringValue(key);
        if (defaultValue != null) {
            text.setText(defaultValue);
        }
        this.putWidget(key, (Widget)text);
        return text;
    }

    protected Text createTextControl(Composite composite, String key, String niceName, String hint) {
        Label label = new Label(composite, 16384);
        label.setText(niceName);
        if ("name".equals(key)) {
            label.setFont(this.getFont());
        }
        if (hint != null && hint.length() > 0) {
            label.setToolTipText(hint);
        }
        Text text = new Text(composite, 2052);
        GridData data = new GridData(4);
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        text.setToolTipText(hint);
        text.addListener(24, (Listener)this);
        String defaultValue = this.getDefaultStringValue(key);
        if (defaultValue != null) {
            text.setText(defaultValue);
        }
        this.putWidget(key, (Widget)text);
        return text;
    }

    protected boolean doesNextPageExist() {
        return this.getNextPage() != null;
    }

    public boolean getDefaultBooleanValue(String key) {
        boolean lastValue = DeviceKitPreferenceInitializer.getPreferenceBoolean((String)("lastused." + key));
        return lastValue;
    }

    protected String getDefaultMessage() {
        return "";
    }

    public String getDefaultStringValue(String key) {
        String lastValue = DeviceKitPreferenceInitializer.getPreferenceString((String)("lastused." + key));
        if (lastValue != null && lastValue.length() > 0 && lastValue.indexOf(44) < 0) {
            return lastValue;
        }
        String value = DeviceKitPreferenceInitializer.getPreferenceString((String)key);
        if (value != null && value.length() > 0 && value.indexOf(44) < 0) {
            return value;
        }
        String variableValue = (String)this.getVariables().get(key);
        if (variableValue != null && variableValue.length() > 0) {
            return variableValue;
        }
        return "";
    }

    public DkmlFileFinder getFinder() {
        if (this.finder == null) {
            this.finder = new DkmlFileFinder();
        }
        return this.finder;
    }

    protected abstract String getKey();

    public abstract String getString(String var1);

    protected String getTypeName() {
        return this.getString(this.getKey());
    }

    public Map getVariables() {
        IWizardPage nextPage;
        HashMap<String, String> variables = new HashMap<String, String>();
        if (DeviceKitPlugin.getDefault() == null) {
            variables.putAll(DeviceKitPreferenceInitializer.getDefaultPreferencesMap());
        }
        if ((nextPage = this.getNextPage()) instanceof DeviceKitPage) {
            DeviceKitPage nextVariablePage = (DeviceKitPage)nextPage;
            variables.putAll(nextVariablePage.getVariables());
        }
        Iterator keys = this.widgets.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Widget element = this.getWidget(key);
            if (element instanceof Text) {
                Text text = (Text)element;
                variables.put(key, text.getText().trim());
                continue;
            }
            if (element instanceof Button) {
                Button button = (Button)element;
                boolean value = button.getSelection();
                variables.put(key, value ? "true" : "false");
                continue;
            }
            if (!(element instanceof Combo)) continue;
            Combo combo = (Combo)element;
            String value = combo.getText();
            variables.put(key, value);
        }
        if (variables.get("year") == null) {
            int currentYear = Calendar.getInstance().get(1);
            variables.put("year", String.valueOf(currentYear));
            variables.put("years", String.valueOf(currentYear));
        }
        if (variables.get("years") == null) {
            int currentYear = Calendar.getInstance().get(1);
            variables.put("years", String.valueOf(currentYear));
        }
        if (variables.get("provider") == null) {
            variables.put("provider", PROVIDER);
        }
        if (variables.get("vendor") == null) {
            variables.put("vendor", VENDOR);
            variables.put("vendors", VENDOR);
        } else {
            variables.put("vendors", (String)variables.get("vendor"));
        }
        if (variables.get("version") == null) {
            variables.put("version", VERSION);
        }
        return variables;
    }

    protected Widget getWidget(String key) {
        return (Widget)this.widgets.get(key);
    }

    public String getWidgetText(String id) {
        Widget widget = this.getWidget(id);
        if (widget instanceof Text) {
            return ((Text)widget).getText();
        }
        if (widget instanceof Combo) {
            return ((Combo)widget).getText();
        }
        return "";
    }

    public void handleEvent(Event e) {
        if (this.getControl() == null) {
            return;
        }
        if (e.type == 24 || e.type == 13) {
            this.updatePageCompletion();
        }
    }

    protected boolean isNumberTextEntry(String textKey, boolean allowEmpty) {
        String value = this.getWidgetText(textKey);
        if (allowEmpty && value.trim().length() == 0) {
            return true;
        }
        if (!allowEmpty && value.trim().length() == 0) {
            String message = this.getString(String.valueOf(textKey) + ".empty");
            this.update(false, false, null, message);
            return false;
        }
        try {
            new Integer(value);
        }
        catch (NumberFormatException numberFormatException) {
            String errorMessage = this.getString(String.valueOf(textKey) + ".validnumber");
            this.update(false, false, errorMessage, null);
            return false;
        }
        return true;
    }

    public boolean isPageComplete() {
        return this.canFinish;
    }

    public boolean isTest() {
        return this.test;
    }

    protected boolean projectExists(String projectName) {
        if (DeviceKitUiPlugin.getDefault() != null) {
            IProject project = DeviceKitUiPlugin.getWorkspace().getRoot().getProject(projectName);
            return project != null && project.exists();
        }
        return false;
    }

    protected void putWidget(String key, Widget widget) {
        this.widgets.put(key, widget);
    }

    public void setFinder(DkmlFileFinder finder) {
        this.finder = finder;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updatePageCompletion();
        }
    }

    public void update(boolean finishEnabled, boolean nextEnabled, String errorMessage, String message) {
        this.canFinish = finishEnabled;
        boolean bl = this.next = nextEnabled && this.doesNextPageExist();
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(this.getDefaultMessage());
        }
        this.setErrorMessage(errorMessage);
        if (((WizardDialog)this.getWizard().getContainer()).getCurrentPage() != null) {
            ((WizardDialog)this.getWizard().getContainer()).updateButtons();
        }
    }

    public void updatePageCompletion() {
        this.setMessage(null);
        boolean complete = this.updatePageErrors();
        this.setPageComplete(complete);
        if (((WizardDialog)this.getWizard().getContainer()).getCurrentPage() != null) {
            ((WizardDialog)this.getWizard().getContainer()).updateButtons();
        }
    }

    protected abstract boolean updatePageErrors();
}

